/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal.json;

import com.apollographql.apollo.api.internal.json.JsonReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\t\u0010\u0010\u001a\u00020\u0006H\u0086\u0002J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0012J,\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0015\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017J\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ)\u0010\u001d\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001f\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0014J\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010%J\u0006\u0010&\u001a\u00020\u000eJ\u0016\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010%R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader;", "", "jsonReader", "Lcom/apollographql/apollo/api/internal/json/JsonReader;", "(Lcom/apollographql/apollo/api/internal/json/JsonReader;)V", "isNextBoolean", "", "()Z", "isNextList", "isNextLong", "isNextNull", "isNextNumber", "isNextObject", "checkNextValue", "", "optional", "hasNext", "nextBoolean", "(Z)Ljava/lang/Boolean;", "nextList", "", "T", "listReader", "Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader$ListReader;", "nextLong", "", "(Z)Ljava/lang/Long;", "nextName", "", "nextObject", "objectReader", "Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader$ObjectReader;", "(ZLcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader$ObjectReader;)Ljava/lang/Object;", "nextScalar", "nextString", "readList", "readObject", "", "skipNext", "toMap", "ListReader", "ObjectReader", "apollo-api"})
public class ResponseJsonStreamReader {
    @NotNull
    private final JsonReader jsonReader;

    public ResponseJsonStreamReader(@NotNull JsonReader jsonReader) {
        Intrinsics.checkParameterIsNotNull(jsonReader, "jsonReader");
        this.jsonReader = jsonReader;
    }

    public final boolean hasNext() throws IOException {
        return this.jsonReader.hasNext();
    }

    @NotNull
    public final String nextName() throws IOException {
        return this.jsonReader.nextName();
    }

    public final void skipNext() throws IOException {
        this.jsonReader.skipValue();
    }

    @Nullable
    public final Long nextLong(boolean optional) throws IOException {
        this.checkNextValue(optional);
        return this.jsonReader.peek() == JsonReader.Token.NULL ? (Long)this.jsonReader.nextNull() : Long.valueOf(this.jsonReader.nextLong());
    }

    @Nullable
    public final String nextString(boolean optional) throws IOException {
        this.checkNextValue(optional);
        return this.jsonReader.peek() == JsonReader.Token.NULL ? (String)this.jsonReader.nextNull() : this.jsonReader.nextString();
    }

    @Nullable
    public final Boolean nextBoolean(boolean optional) throws IOException {
        this.checkNextValue(optional);
        return this.jsonReader.peek() == JsonReader.Token.NULL ? (Boolean)this.jsonReader.nextNull() : Boolean.valueOf(this.jsonReader.nextBoolean());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T nextObject(boolean optional, @NotNull ObjectReader<T> objectReader) throws IOException {
        Object t;
        Intrinsics.checkParameterIsNotNull(objectReader, "objectReader");
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            t = this.jsonReader.nextNull();
        } else {
            void var3_3;
            this.jsonReader.beginObject();
            T result = objectReader.read(this);
            this.jsonReader.endObject();
            t = var3_3;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> List<T> nextList(boolean optional, @NotNull ListReader<T> listReader) throws IOException {
        List list;
        Intrinsics.checkParameterIsNotNull(listReader, "listReader");
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            list = (List)this.jsonReader.nextNull();
        } else {
            void var3_3;
            this.jsonReader.beginArray();
            ArrayList<T> result = new ArrayList<T>();
            while (this.jsonReader.hasNext()) {
                result.add(listReader.read(this));
            }
            this.jsonReader.endArray();
            list = (List)var3_3;
        }
        return list;
    }

    @Nullable
    public Object nextScalar(boolean optional) throws IOException {
        Object object;
        this.checkNextValue(optional);
        if (this.isNextNull()) {
            this.skipNext();
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            object = null;
        } else if (this.isNextBoolean()) {
            object = this.nextBoolean(false);
        } else if (this.isNextLong()) {
            Long l = this.nextLong(false);
            if (l == null) {
                Intrinsics.throwNpe();
            }
            BigDecimal bigDecimal = new BigDecimal(l);
            object = bigDecimal;
        } else if (this.isNextNumber()) {
            String string = this.nextString(false);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            BigDecimal bigDecimal = new BigDecimal(string);
            object = bigDecimal;
        } else {
            object = this.nextString(false);
        }
        return object;
    }

    @Nullable
    public final Map<String, Object> readObject() throws IOException {
        return (Map)this.nextObject(false, new ObjectReader<Map<String, ? extends Object>>(){

            @Nullable
            public Map<String, Object> read(@NotNull ResponseJsonStreamReader reader) throws IOException {
                Intrinsics.checkParameterIsNotNull(reader, "reader");
                return reader.toMap();
            }
        });
    }

    @Nullable
    public final List<Object> readList() throws IOException {
        return this.nextList(false, new ListReader<Object>(this){
            final /* synthetic */ ResponseJsonStreamReader this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Object read(@NotNull ResponseJsonStreamReader reader) throws IOException {
                Intrinsics.checkParameterIsNotNull(reader, "reader");
                return this.this$0.isNextList() ? this.this$0.readList() : (this.this$0.isNextObject() ? this.this$0.readObject() : reader.nextScalar(true));
            }
        });
    }

    @Nullable
    public final Map<String, Object> toMap() throws IOException {
        if (this.isNextObject()) {
            return this.readObject();
        }
        LinkedHashMap result = new LinkedHashMap();
        while (this.hasNext()) {
            boolean bl;
            Object object;
            String name = this.nextName();
            if (this.isNextNull()) {
                this.skipNext();
                object = Unit.INSTANCE;
                boolean bl2 = false;
                bl = false;
                Object it = object;
                boolean bl3 = false;
                Map map = result;
                Object v = null;
                boolean bl4 = false;
                map.put(name, v);
                continue;
            }
            if (this.isNextObject()) {
                object = result;
                Map<String, Object> map = this.readObject();
                bl = false;
                object.put(name, map);
                continue;
            }
            if (this.isNextList()) {
                object = result;
                List<Object> list = this.readList();
                bl = false;
                object.put(name, list);
                continue;
            }
            object = result;
            Object object2 = this.nextScalar(true);
            bl = false;
            object.put(name, object2);
        }
        return result;
    }

    public final boolean isNextObject() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.BEGIN_OBJECT;
    }

    public final boolean isNextList() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.BEGIN_ARRAY;
    }

    private final boolean isNextNull() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.NULL;
    }

    private final boolean isNextBoolean() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.BOOLEAN;
    }

    private final boolean isNextNumber() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.NUMBER;
    }

    private final boolean isNextLong() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.LONG;
    }

    private final void checkNextValue(boolean optional) throws IOException {
        if (!optional && this.jsonReader.peek() == JsonReader.Token.NULL) {
            throw new NullPointerException("corrupted response reader, expected non null value");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader$ObjectReader;", "T", "", "read", "reader", "Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader;", "(Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader;)Ljava/lang/Object;", "apollo-api"})
    public static interface ObjectReader<T> {
        public T read(@NotNull ResponseJsonStreamReader var1) throws IOException;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader$ListReader;", "T", "", "read", "reader", "Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader;", "(Lcom/apollographql/apollo/api/internal/json/ResponseJsonStreamReader;)Ljava/lang/Object;", "apollo-api"})
    public static interface ListReader<T> {
        @Nullable
        public T read(@NotNull ResponseJsonStreamReader var1) throws IOException;
    }
}

