/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.utils;

import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbValidationFailedException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.runtime.Struct;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;

public enum ValidatorFiller {
    INSTANCE;


    public <T> void fillObject(T filler, Map map, ConsumerMap<T> consumerMap) {
        this.fillObject(filler, map, consumerMap, false, "");
    }

    public <T> void fillObject(T filler, Map map, ConsumerMap<T> consumerMap, String apiName) {
        this.fillObject(filler, map, consumerMap, false, apiName);
    }

    public <T> void fillObject(T filler, Map map, ConsumerMap<T> consumerMap, boolean skipUnknown, String apiName) {
        if (Objects.isNull(map)) {
            return;
        }
        if (!skipUnknown) {
            Set inputKeys = map.keySet();
            StringJoiner unknownKeys = null;
            boolean greaterThanOne = false;
            for (String inputKey : inputKeys) {
                if (consumerMap.get((Object)inputKey) != null) continue;
                if (unknownKeys == null) {
                    unknownKeys = new StringJoiner(", ");
                } else {
                    greaterThanOne = true;
                }
                unknownKeys.add(inputKey);
            }
            if (unknownKeys != null) {
                throw new FieldValidationFailedException((greaterThanOne ? "Unknown Fields : " : "Unknown Field : ") + unknownKeys.toString());
            }
        }
        consumerMap.entrySet().forEach(entry -> {
            ConsumerValidator consumerValidator = (ConsumerValidator)entry.getValue();
            Object value = map.get(entry.getKey());
            if (consumerValidator != null) {
                BiConsumer biConsumer;
                List validators = consumerValidator.getValidators();
                if (validators != null) {
                    validators.forEach(validator -> {
                        if (!validator.validate(value)) {
                            throw new CFDynamoDbValidationFailedException(entry.getKey().toString(), value, apiName);
                        }
                    });
                }
                if ((biConsumer = consumerValidator.getBiConsumer()) != null && (map instanceof Struct && ((Struct)map).keyExists(entry.getKey()) || map.containsKey(entry.getKey()))) {
                    biConsumer.accept(filler, value);
                }
            }
        });
    }
}

