/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.querycaching;

import coldfusion.cloud.aws.dynamodb.attributes.CFDynamoDbAttributes;
import coldfusion.cloud.aws.dynamodb.querycaching.CFDynamoDbCachedQuery;
import coldfusion.cloud.aws.dynamodb.querycaching.CFDynamoLRUCache;
import coldfusion.cloud.aws.dynamodb.querycaching.CFDynamoQueryDetails;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Struct;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CFDynamoDbQueryCaching {
    private static Set<String> cacheRegions = new HashSet<String>();

    public static GenericCache getCache() {
        return GenericCacheFactory.getCache();
    }

    public static Map getCache(CFDynamoQueryDetails cacheKey, String dynamoOperation) {
        CacheTO cacheTO = CFDynamoDbAttributes.CACHE_ID != null ? new CacheTO(CFDynamoDbQueryCaching.getAppName(), dynamoOperation, (Object)CFDynamoDbAttributes.CACHE_ID, null, CFDynamoDbAttributes.CACHED_WITHIN, -1L, CFDynamoDbAttributes.CACHE_REGION, false, null) : new CacheTO(CFDynamoDbQueryCaching.getAppName(), dynamoOperation, (Object)cacheKey, null, CFDynamoDbAttributes.CACHED_WITHIN, -1L, CFDynamoDbAttributes.CACHE_REGION, false, null);
        CFDynamoDbCachedQuery cacheValue = (CFDynamoDbCachedQuery)CFDynamoDbQueryCaching.getCache().get(cacheTO, false);
        Map responseMap = null;
        if (cacheValue != null) {
            responseMap = cacheValue.getQueryResponseMap();
        }
        return responseMap;
    }

    public static void putCache(CFDynamoQueryDetails cacheKey, CFDynamoDbCachedQuery cacheValue, String dynamoOperation) {
        boolean cacheData = false;
        boolean cacheEternal = false;
        if (CFDynamoDbAttributes.CACHED_AFTER == null && CFDynamoDbAttributes.CACHED_WITHIN < 0L) {
            cacheData = true;
            cacheEternal = true;
        } else if (CFDynamoDbAttributes.CACHED_AFTER == null && CFDynamoDbAttributes.CACHED_WITHIN > 0L) {
            cacheData = true;
            cacheEternal = false;
        } else if (System.currentTimeMillis() > CFDynamoDbAttributes.CACHED_AFTER.getTime()) {
            cacheData = true;
            cacheEternal = true;
        } else if (System.currentTimeMillis() < CFDynamoDbAttributes.CACHED_AFTER.getTime() && CFDynamoDbAttributes.CACHED_WITHIN < 0L) {
            cacheData = false;
            cacheEternal = false;
        } else if (System.currentTimeMillis() < CFDynamoDbAttributes.CACHED_AFTER.getTime() && CFDynamoDbAttributes.CACHED_WITHIN > 0L) {
            cacheData = true;
            cacheEternal = false;
        } else {
            cacheData = false;
            cacheEternal = false;
            return;
        }
        if (cacheData) {
            CacheTO cacheTO = CFDynamoDbAttributes.CACHE_ID != null ? new CacheTO(CFDynamoDbQueryCaching.getAppName(), dynamoOperation, (Object)CFDynamoDbAttributes.CACHE_ID, (Object)cacheValue, CFDynamoDbAttributes.CACHED_WITHIN, -1L, CFDynamoDbAttributes.CACHE_REGION, false, null) : new CacheTO(CFDynamoDbQueryCaching.getAppName(), dynamoOperation, (Object)cacheKey, (Object)cacheValue, CFDynamoDbAttributes.CACHED_WITHIN, -1L, CFDynamoDbAttributes.CACHE_REGION, false, null);
            if (cacheEternal) {
                cacheTO.eternal = true;
            }
            CFDynamoDbQueryCaching.getCache().put(cacheTO, false);
        }
    }

    public static Map handleCacheQuery(CFDynamoQueryDetails cacheKey, String dynamoOperation) {
        Map responseMap = null;
        if (CFDynamoDbQueryCaching.useInternalCache()) {
            CFDynamoDbCachedQuery cachedData = CFDynamoDbQueryCaching.getFromInternalCache(cacheKey);
            if (cachedData == null) {
                return null;
            }
            responseMap = cachedData.getQueryResponseMap();
            CFDynamoDbQueryCaching.addCacheHitInfo(responseMap, true);
            return responseMap;
        }
        responseMap = CFDynamoDbQueryCaching.getCache(cacheKey, dynamoOperation);
        if (responseMap == null) {
            return null;
        }
        CFDynamoDbQueryCaching.addCacheHitInfo(responseMap, false);
        return responseMap;
    }

    public static void handleCaching(Map responseMap, CFDynamoQueryDetails cacheKey, String dynamoOperation) {
        if (CFDynamoDbAttributes.CACHE_QUERY_RESULTS) {
            Map responseMapDeepCopy = CFDynamoDbQueryCaching.createDeepCopy(responseMap);
            CFDynamoDbCachedQuery cacheValue = new CFDynamoDbCachedQuery(cacheKey, responseMapDeepCopy, dynamoOperation);
            if (CFDynamoDbQueryCaching.useInternalCache()) {
                CFDynamoDbQueryCaching.putInInternalCache(cacheKey, cacheValue);
                CFDynamoDbQueryCaching.addCachingInfo(responseMap, true);
            } else {
                CFDynamoDbQueryCaching.putCache(cacheKey, cacheValue, dynamoOperation);
                CFDynamoDbQueryCaching.addCachingInfo(responseMap, false);
            }
        }
    }

    public static void putInInternalCache(CFDynamoQueryDetails cacheKey, CFDynamoDbCachedQuery cacheValue) {
        CFDynamoLRUCache<CFDynamoQueryDetails, CFDynamoDbCachedQuery> LRUCache = CFDynamoLRUCache.getInstance(CFDynamoDbAttributes.DEFAULT_LRU_CACHE_SIZE);
        LRUCache.put(cacheKey, cacheValue);
    }

    public static CFDynamoDbCachedQuery getFromInternalCache(CFDynamoQueryDetails cacheKey) {
        CFDynamoLRUCache LRUCache = CFDynamoLRUCache.getInstance(CFDynamoDbAttributes.DEFAULT_LRU_CACHE_SIZE);
        return (CFDynamoDbCachedQuery)LRUCache.get(cacheKey);
    }

    public static String getAppName() {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        return appName;
    }

    public static boolean useInternalCache() {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        ApplicationScope appScope = null;
        if (appName != null) {
            appScope = ApplicationScopeTracker.getApplicationScope((String)appName);
        }
        return AppHelper.useInternalQueryCache(appScope);
    }

    public static void addCachingInfo(Map responseMap, boolean cacheType) {
        if (cacheType) {
            responseMap.put("CacheTypeUsed", "InternalCache");
        } else {
            responseMap.put("CacheTypeUsed", "ExternalCache");
        }
        responseMap.put("ReturnedDataFromCache", false);
    }

    public static void addCacheHitInfo(Map responseMap, boolean cacheReturnFrom) {
        responseMap.put("ReturnedDataFromCache", true);
        if (cacheReturnFrom) {
            responseMap.put("CacheTypeUsed", "InternalCache");
        } else {
            responseMap.put("CacheTypeUsed", "ExternalCache");
        }
    }

    public static void setAttributes(Map options) {
        if (options.containsKey("cacheID") || options.containsKey("cacheRegion") || options.containsKey("cachedWithin") || options.containsKey("cachedAfter")) {
            Date cachedAfter;
            long cachedwithin;
            CFDynamoDbAttributes.CACHE_QUERY_RESULTS = true;
            CFDynamoDbAttributes.CACHE_ID = options.containsKey("cacheID") ? (String)options.get("cacheID") : null;
            if (options.containsKey("cacheRegion")) {
                CFDynamoDbAttributes.CACHE_REGION = (String)options.get("cacheRegion");
                cacheRegions.add(CFDynamoDbAttributes.CACHE_REGION);
            } else {
                CFDynamoDbAttributes.CACHE_REGION = "DynamoDb";
            }
            CFDynamoDbAttributes.CACHED_WITHIN = options.containsKey("cachedWithin") ? (cachedwithin = (long)((Double)options.get("cachedWithin") * 86400.0)) : -1L;
            CFDynamoDbAttributes.CACHED_AFTER = options.containsKey("cachedAfter") ? (cachedAfter = (Date)options.get("cachedAfter")) : null;
        } else {
            CFDynamoDbAttributes.CACHE_QUERY_RESULTS = false;
        }
    }

    public static void purgeAllCachedQueryResponses() {
        CFDynamoDbQueryCaching.getCache().clearCache("DynamoDb");
        Iterator<String> itr = cacheRegions.iterator();
        while (itr.hasNext()) {
            CFDynamoDbQueryCaching.getCache().clearCache(itr.next());
        }
        CFDynamoLRUCache LRUCache = CFDynamoLRUCache.getInstance(CFDynamoDbAttributes.DEFAULT_LRU_CACHE_SIZE);
        LRUCache.clear();
    }

    public static Map createDeepCopy(Map responseMap) {
        Map responseMapDeepCopy = null;
        try {
            responseMapDeepCopy = responseMap instanceof CaseSensitiveStruct ? ((CaseSensitiveStruct)responseMap).duplicate() : ((Struct)responseMap).duplicate();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return responseMapDeepCopy;
    }
}

