/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.syndication;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.Array;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructUtils;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.AtomParser;
import coldfusion.syndication.FeedSyndicationException;
import coldfusion.syndication.RSSParser;
import coldfusion.tagext.io.feed.FeedTag;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.wddx.Base64Encoder;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.feed.rss.Channel;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.WireFeedInput;
import com.rometools.rome.io.WireFeedOutput;
import com.rometools.rome.io.XmlReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class FeedReader {
    FeedTag feedTag;
    String source;
    private String userAgent;
    Struct feedStruct = null;
    WireFeed feed = null;
    Struct feedMetadata = null;
    QueryTable feedQuery = null;
    String feedXML = null;
    private static String tagName;
    private static Logger feedReadLog;

    public FeedReader(FeedTag feedTag, String tagName) {
        this.feedTag = feedTag;
        FeedReader.tagName = tagName;
        this.source = feedTag.getSource();
        this.userAgent = feedTag.getUserAgent() == null ? "ColdFusion" : feedTag.getUserAgent();
        this.readFeed();
    }

    public WireFeed readFeed() {
        block12: {
            WireFeedInput input = new WireFeedInput();
            if (this.feed == null) {
                long startTime = System.currentTimeMillis();
                try {
                    if (this.source.startsWith("http://") || this.source.startsWith("https://")) {
                        try {
                            feedReadLog.info((Object)("Reading FEED {source='" + this.source + "'}"));
                            InputStream is = this.getInputStream(this.source);
                            String cType = this.getContentType(this.source, is);
                            XmlReader xmlreader = new XmlReader(is, cType);
                            this.feed = input.build((Reader)xmlreader);
                            this.feed.setEncoding(xmlreader.getEncoding());
                            feedReadLog.info((Object)("FEED reading completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
                            break block12;
                        }
                        catch (IOException e) {
                            feedReadLog.info((Object)("FEED reading completed with error {Error message= " + e.getMessage() + "}"));
                            throw new UnableToReadSourceURLException(e.getMessage());
                        }
                    }
                    if (VFSFileFactory.checkIfVFile((String)this.source)) {
                        try {
                            feedReadLog.info((Object)("Reading FEED {source='" + this.source + "'}"));
                            InputStream is = VFSFileFactory.getInputStream((String)this.source);
                            String cType = this.getContentType(this.source, is);
                            XmlReader xmlreader = new XmlReader(is, cType);
                            this.feed = input.build((Reader)xmlreader);
                            this.feed.setEncoding(xmlreader.getEncoding());
                            feedReadLog.info((Object)("FEED reading completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
                            break block12;
                        }
                        catch (IOException e) {
                            feedReadLog.info((Object)("FEED reading completed with error {Error message= " + e.getMessage() + "}"));
                            throw new UnableToReadSourceURLException(e.getMessage());
                        }
                    }
                    File feedFile = VFSFileFactory.getFileObject((String)this.source);
                    try {
                        feedReadLog.info((Object)("Reading FEED {source='" + this.source + "'}"));
                        XmlReader xmlreader = new XmlReader(feedFile);
                        this.feed = input.build((Reader)xmlreader);
                        this.feed.setEncoding(xmlreader.getEncoding());
                        feedReadLog.info((Object)("FEED reading completed {Time taken=" + (System.currentTimeMillis() - startTime) + " ms}"));
                    }
                    catch (IOException e) {
                        feedReadLog.info((Object)("FEED reading completed with error {Error message= " + e.getMessage() + "}"));
                        throw new UnableToReadSourceFileException(feedFile.getAbsolutePath());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new FeedParseException(e.getMessage());
                }
                catch (FeedException e) {
                    throw new FeedParseSourceException(e.getMessage());
                }
            }
        }
        FeedReader.checkTimeout();
        return this.feed;
    }

    public Struct getFeedStruct() {
        if (this.feedStruct == null) {
            if (this.feedMetadata == null) {
                this.feedMetadata = this.getFeedMetadataStruct();
            }
            Array feedEntries = null;
            if (this.feed.getFeedType().toLowerCase().startsWith("rss")) {
                feedEntries = RSSParser.getItemsAsArray((Channel)this.feed);
            } else if (this.feed.getFeedType().toLowerCase().startsWith("atom")) {
                feedEntries = AtomParser.getItemsAsArray((Feed)this.feed);
            }
            this.feedStruct = (Struct)this.feedMetadata.clone();
            if (this.feed.getFeedType().toLowerCase().startsWith("rss")) {
                StructUtils.StructInsert((Map)this.feedStruct, (String)"item", (Object)feedEntries, (boolean)false);
            } else if (this.feed.getFeedType().toLowerCase().startsWith("atom")) {
                StructUtils.StructInsert((Map)this.feedStruct, (String)"entry", (Object)feedEntries, (boolean)false);
            }
        }
        return this.feedStruct;
    }

    public Struct getFeedMetadataStruct() {
        if (this.feedMetadata == null) {
            if (this.feed.getFeedType().toLowerCase().startsWith("rss")) {
                this.feedMetadata = RSSParser.getMetadataAsStruct((Channel)this.feed);
            } else if (this.feed.getFeedType().toLowerCase().startsWith("atom")) {
                this.feedMetadata = AtomParser.getMetadataAsStruct((Feed)this.feed);
            }
        }
        return this.feedMetadata;
    }

    public QueryTable getFeedEntriesQuery() {
        if (this.feedQuery == null) {
            if (this.feed.getFeedType().toLowerCase().startsWith("rss")) {
                this.feedQuery = RSSParser.getItemsAsQuery((Channel)this.feed);
            } else if (this.feed.getFeedType().toLowerCase().startsWith("atom")) {
                this.feedQuery = AtomParser.getItemsAsQuery((Feed)this.feed);
            }
        }
        return this.feedQuery;
    }

    public String getFeedXML() {
        if (this.feed != null) {
            WireFeedOutput wfo = new WireFeedOutput();
            try {
                this.feedXML = wfo.outputString(this.feed);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidFeedException(e.getMessage());
            }
            catch (FeedException e) {
                throw new InvalidFeedException(e.getMessage());
            }
        }
        return this.feedXML;
    }

    public void saveEnclosures(String enclosureDir, boolean overwriteEnclosure, boolean ignoreEnclosureError) {
        File enclosureDirectory = VFSFileFactory.getFileObject((String)enclosureDir);
        if (!enclosureDirectory.exists()) {
            throw new EnclosureDirectoryDoesNotExistException(enclosureDirectory.getAbsolutePath());
        }
        if (!enclosureDirectory.canWrite()) {
            throw new NoWritePermissionEnclosureDirectoryException(enclosureDirectory.getAbsolutePath());
        }
        if (this.feed != null) {
            if (this.feed.getFeedType().toLowerCase().startsWith("rss")) {
                RSSParser.saveEnclosures((Channel)this.feed, enclosureDir, overwriteEnclosure, ignoreEnclosureError, this.userAgent);
            } else if (this.feed.getFeedType().toLowerCase().startsWith("atom")) {
                AtomParser.saveEnclosures((Feed)this.feed, enclosureDir, overwriteEnclosure, ignoreEnclosureError, this.userAgent);
            }
        }
    }

    protected static void getUrlContents(URL url, String path, long length, String file, boolean overwrite, boolean ignoreEnclosureError, String userAgent) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", userAgent);
        BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
        File enclosureFile = VFSFileFactory.getFileObject((String)path, (String)file);
        if (enclosureFile.exists() && !overwrite) {
            if (ignoreEnclosureError) {
                CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new EnclosureFileAlreadyExistsException(enclosureFile.getAbsolutePath())));
                return;
            }
            throw new EnclosureFileAlreadyExistsException(enclosureFile.getAbsolutePath());
        }
        BufferedOutputStream out = new BufferedOutputStream(VFSFileFactory.getOutputStream((File)enclosureFile));
        if (length == -1L) {
            int num;
            byte[] buffer = new byte[4096];
            while ((num = in.read(buffer, 0, 4096)) != -1) {
                FeedReader.checkTimeout();
                out.write(buffer, 0, num);
            }
            in.close();
            out.flush();
            out.close();
        } else {
            int num;
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((num = in.read(buffer, 0, 4096)) != -1 && (long)count <= length) {
                count += num;
                FeedReader.checkTimeout();
                out.write(buffer, 0, num);
            }
            in.close();
            out.flush();
            out.close();
        }
    }

    private InputStream getInputStream(String source) throws IOException {
        try {
            new URL(source);
        }
        catch (MalformedURLException e) {
            throw new InvalidURLException();
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        int timeout = this.feedTag.getTimeout();
        if (timeout > 0) {
            requestBuilder.setSocketTimeout(timeout);
        }
        FeedReader.checkTimeout();
        HashMap<String, Object> headersMap = new HashMap<String, Object>(2);
        if (this.feedTag.getProxyserver() != null) {
            HttpHost proxy = new HttpHost(this.feedTag.getProxyserver(), this.feedTag.getProxyport());
            requestBuilder.setProxy(proxy);
            if (this.feedTag.getProxyUser() != null) {
                String auth = this.feedTag.getProxyPassword() == null ? this.feedTag.getProxyUser() : this.feedTag.getProxyUser() + ":" + this.feedTag.getProxyPassword();
                headersMap.put("Proxy-Authorization", "Basic " + Base64Encoder.encode((byte[])auth.getBytes()));
            }
        }
        headersMap.put("User-Agent", this.userAgent);
        headersMap.put("Accept-Encoding", "deflate;q=0");
        headersMap.put("TE", "deflate;q=0");
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet(source);
            for (String key : headersMap.keySet()) {
                String value = (String)headersMap.get(key);
                httpget.addHeader(key, value);
            }
            CloseableHttpClient httpClient = clientBuilder.setDefaultRequestConfig(requestBuilder.build()).build();
            response = httpClient.execute((HttpUriRequest)httpget);
            this.checkResponseStatus((HttpResponse)response);
            return response.getEntity().getContent();
        }
        catch (InterruptedIOException ioe) {
            throw new FeedReadTimeoutException();
        }
        catch (ConnectException ioe) {
            throw new ConnectionRefusedException();
        }
    }

    private void checkResponseStatus(HttpResponse con) throws IOException {
        try {
            int statusCode = con.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 401: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 300: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 301: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 302: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 303: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 304: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 305: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 400: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 402: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 403: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 404: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 406: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 407: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 409: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 410: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 411: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 412: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 413: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 414: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 415: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 500: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 501: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 502: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 503: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
                case 505: {
                    throw new IOException(RB.getString((Object)this, (String)"FeedTag.readStatus.message", (Object)new Integer(statusCode)));
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private String getContentType(String name, InputStream is) {
        String cType = MimeTypeUtils.guessMimeType((String)name);
        if (cType == null) {
            try {
                cType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cType;
    }

    public static void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(tagName);
        }
    }

    static {
        feedReadLog = ServiceFactory.getLoggingService().getLogger("coldfusion.feed");
    }

    public class UnableToReadSourceURLException
    extends FeedSyndicationException {
        public String message;

        public UnableToReadSourceURLException(String message) {
            this.message = message;
        }
    }

    public static class UnableToReadSourceFileException
    extends FeedSyndicationException {
        public String file;

        public UnableToReadSourceFileException(String file) {
            this.file = file;
        }
    }

    public class FeedParseException
    extends FeedSyndicationException {
        public String msg;

        public FeedParseException(String msg) {
            this.msg = msg;
        }
    }

    public class FeedParseSourceException
    extends FeedSyndicationException {
        public String msg;

        public FeedParseSourceException(String msg) {
            this.msg = msg;
        }
    }

    public static class InvalidFeedException
    extends FeedSyndicationException {
        public String message;

        public InvalidFeedException(String message) {
            this.message = message;
        }
    }

    public static class EnclosureDirectoryDoesNotExistException
    extends FeedSyndicationException {
        public String dir;

        public EnclosureDirectoryDoesNotExistException(String dir) {
            this.dir = dir;
        }
    }

    public static class NoWritePermissionEnclosureDirectoryException
    extends FeedSyndicationException {
        public String dir;

        public NoWritePermissionEnclosureDirectoryException(String dir) {
            this.dir = dir;
        }
    }

    public static class EnclosureFileAlreadyExistsException
    extends FeedSyndicationException {
        public String file;

        public EnclosureFileAlreadyExistsException(String file) {
            this.file = file;
        }
    }

    public class InvalidURLException
    extends FeedSyndicationException {
    }

    public static class FeedReadTimeoutException
    extends FeedSyndicationException {
    }

    public static class ConnectionRefusedException
    extends FeedSyndicationException {
    }

    public static class UnableToSaveEnclosureException
    extends FeedSyndicationException {
        public String url;
        public String message;

        public UnableToSaveEnclosureException(String url, String message) {
            this.url = url;
            this.message = message;
        }
    }

    public static class EnclosureFileNotFoundException
    extends FeedSyndicationException {
        public String url;

        public EnclosureFileNotFoundException(String url) {
            this.url = url;
        }
    }

    public static class UnableToDetermineEnclosureFileNameException
    extends FeedSyndicationException {
        public String url;

        public UnableToDetermineEnclosureFileNameException(String url) {
            this.url = url;
        }
    }

    public static class InvalidURLEnclosureException
    extends FeedSyndicationException {
        public String url;

        public InvalidURLEnclosureException(String url) {
            this.url = url;
        }
    }
}

