/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.syndication;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructUtils;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.FeedReader;
import coldfusion.syndication.FeedTable;
import com.rometools.rome.feed.atom.Category;
import com.rometools.rome.feed.atom.Content;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.feed.atom.Generator;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.atom.Person;
import com.rometools.rome.io.impl.DateParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AtomParser {
    public static Struct getMetadataAsStruct(Feed feed) {
        Content subtitle;
        Content title;
        Struct atomMetadataStruct = new Struct();
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "version", feed.getFeedType());
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "encoding", feed.getEncoding());
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "id", feed.getId());
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "xmlbase", feed.getXmlBase());
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "icon", feed.getIcon());
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "logo", feed.getLogo());
        if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "copyright", feed.getRights());
        } else {
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "rights", feed.getRights());
        }
        Generator gen = feed.getGenerator();
        if (gen != null) {
            Struct generatorStruct = new Struct();
            if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(generatorStruct, "url", gen.getUrl());
            } else {
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(generatorStruct, "uri", gen.getUrl());
            }
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(generatorStruct, "version", gen.getVersion());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(generatorStruct, "value", gen.getValue());
            if (!generatorStruct.isEmpty()) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"generator", (Object)generatorStruct, (boolean)false);
            }
        }
        if ((title = feed.getTitleEx()) != null) {
            Struct titleStruct = new Struct();
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "type", title.getType());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "mode", title.getMode());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "src", title.getSrc());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "value", title.getValue());
            if (!titleStruct.isEmpty()) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"title", (Object)titleStruct, (boolean)false);
            }
        }
        AtomParser.insertNotNullAndNonZeroLengthValueInStruct(atomMetadataStruct, "language", feed.getLanguage());
        if (feed.getUpdated() != null) {
            if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"modified", (Object)DateParser.formatW3CDateTime((Date)feed.getModified(), (Locale)Locale.US), (boolean)false);
            } else {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"updated", (Object)DateParser.formatW3CDateTime((Date)feed.getUpdated(), (Locale)Locale.US), (boolean)false);
            }
        }
        Array categoriesArray = new Array();
        List categories = feed.getCategories();
        if (categories != null && categories.size() > 0) {
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                Struct categoryStruct = new Struct();
                Category atomCategory = (Category)it.next();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "term", atomCategory.getTerm());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "scheme", atomCategory.getScheme());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "label", atomCategory.getLabel());
                if (categoryStruct.isEmpty()) continue;
                categoriesArray.add((Object)categoryStruct);
            }
            if (categoriesArray.size() > 0) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"category", (Object)categoriesArray, (boolean)false);
            }
        }
        Array authorsArray = new Array();
        List authors = feed.getAuthors();
        if (authors != null && authors.size() > 0) {
            Iterator it = authors.iterator();
            while (it.hasNext()) {
                Struct authorStruct = new Struct();
                Person author = (Person)it.next();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "name", author.getName());
                if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "url", author.getUri());
                } else {
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "uri", author.getUri());
                }
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "email", author.getEmail());
                if (authorStruct.isEmpty()) continue;
                authorsArray.add((Object)authorStruct);
            }
            if (authorsArray.size() > 0) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"author", (Object)authorsArray, (boolean)false);
            }
        }
        Array contributorsArray = new Array();
        List contributors = feed.getContributors();
        if (contributors != null && contributors.size() > 0) {
            Iterator it = contributors.iterator();
            while (it.hasNext()) {
                Struct contributorStruct = new Struct();
                Person contributor = (Person)it.next();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "name", contributor.getName());
                if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "url", contributor.getUri());
                } else {
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "uri", contributor.getUri());
                }
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "email", contributor.getEmail());
                if (contributorStruct.isEmpty()) continue;
                contributorsArray.add((Object)contributorStruct);
            }
            if (contributorsArray.size() > 0) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"contributor", (Object)contributorsArray, (boolean)false);
            }
        }
        Array linksArray = new Array();
        List links = feed.getAlternateLinks();
        if (links != null && links.size() > 0) {
            Iterator it = links.iterator();
            while (it.hasNext()) {
                Struct linkStruct = new Struct();
                Link link = (Link)it.next();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "href", link.getHref());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "rel", link.getRel());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "type", link.getType());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "hreflang", link.getHreflang());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "title", link.getTitle());
                if (link.getLength() != null) {
                    StructUtils.StructInsert((Map)linkStruct, (String)"length", (Object)link.getLength(), (boolean)false);
                }
                if (linkStruct.isEmpty()) continue;
                linksArray.add((Object)linkStruct);
            }
        }
        Array olinksArray = new Array();
        List olinks = feed.getOtherLinks();
        if (olinks != null && olinks.size() > 0) {
            Iterator it = olinks.iterator();
            while (it.hasNext()) {
                Struct olinkStruct = new Struct();
                Link olink = (Link)it.next();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "href", olink.getHref());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "rel", olink.getRel());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "type", olink.getType());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "hreflang", olink.getHreflang());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "title", olink.getTitle());
                if (olink.getLength() != null) {
                    StructUtils.StructInsert((Map)olinkStruct, (String)"length", (Object)olink.getLength(), (boolean)false);
                }
                if (olinkStruct.isEmpty()) continue;
                olinksArray.add((Object)olinkStruct);
            }
        }
        if (olinksArray.size() > 0) {
            linksArray.addAll((Collection)olinksArray);
        }
        if (linksArray.size() > 0) {
            StructUtils.StructInsert((Map)atomMetadataStruct, (String)"link", (Object)linksArray, (boolean)false);
        }
        if (feed.getInfo() != null) {
            Content info = feed.getInfo();
            Struct infoStruct = new Struct();
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(infoStruct, "type", info.getType());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(infoStruct, "mode", info.getMode());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(infoStruct, "src", info.getSrc());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(infoStruct, "value", info.getValue());
            if (!infoStruct.isEmpty()) {
                StructUtils.StructInsert((Map)atomMetadataStruct, (String)"info", (Object)infoStruct, (boolean)false);
            }
        }
        if ((subtitle = feed.getSubtitle()) != null) {
            Struct subtitleStruct = new Struct();
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(subtitleStruct, "type", subtitle.getType());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(subtitleStruct, "mode", subtitle.getMode());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(subtitleStruct, "src", subtitle.getSrc());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(subtitleStruct, "value", subtitle.getValue());
            if (!subtitleStruct.isEmpty()) {
                if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
                    StructUtils.StructInsert((Map)atomMetadataStruct, (String)"tagline", (Object)subtitleStruct, (boolean)false);
                } else {
                    StructUtils.StructInsert((Map)atomMetadataStruct, (String)"subtitle", (Object)subtitleStruct, (boolean)false);
                }
            }
        }
        return atomMetadataStruct;
    }

    public static Array getItemsAsArray(Feed feed) {
        Array entriesArray = new Array();
        List entries = feed.getEntries();
        for (Entry entry : entries) {
            Struct entryStruct = new Struct();
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(entryStruct, "xmlbase", entry.getXmlBase());
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(entryStruct, "id", entry.getId());
            if (entry.getPublished() != null) {
                StructUtils.StructInsert((Map)entryStruct, (String)"published", (Object)DateParser.formatW3CDateTime((Date)entry.getPublished(), (Locale)Locale.US), (boolean)false);
            }
            AtomParser.insertNotNullAndNonZeroLengthValueInStruct(entryStruct, "rights", entry.getRights());
            Content entryTitle = entry.getTitleEx();
            if (entryTitle != null) {
                Struct titleStruct = new Struct();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "type", entryTitle.getType());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "mode", entryTitle.getMode());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "src", entryTitle.getSrc());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(titleStruct, "value", entryTitle.getValue());
                if (!titleStruct.isEmpty()) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"title", (Object)titleStruct, (boolean)false);
                }
            }
            if (entry.getUpdated() != null) {
                if (feed.getFeedType().equalsIgnoreCase("atom_0.3")) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"modified", (Object)DateParser.formatW3CDateTime((Date)entry.getModified(), (Locale)Locale.US), (boolean)false);
                } else {
                    StructUtils.StructInsert((Map)entryStruct, (String)"updated", (Object)DateParser.formatW3CDateTime((Date)entry.getUpdated(), (Locale)Locale.US), (boolean)false);
                }
            }
            if (entry.getCreated() != null) {
                StructUtils.StructInsert((Map)entryStruct, (String)"created", (Object)DateParser.formatW3CDateTime((Date)entry.getCreated(), (Locale)Locale.US), (boolean)false);
            }
            Array categoriesArray = new Array();
            List categories = entry.getCategories();
            if (categories != null && categories.size() > 0) {
                Iterator it1 = categories.iterator();
                while (it1.hasNext()) {
                    Struct categoryStruct = new Struct();
                    Category atomCategory = (Category)it1.next();
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "term", atomCategory.getTerm());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "scheme", atomCategory.getScheme());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "label", atomCategory.getLabel());
                    if (categoryStruct.isEmpty()) continue;
                    categoriesArray.add((Object)categoryStruct);
                }
                if (categoriesArray.size() > 0) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"category", (Object)categoriesArray, (boolean)false);
                }
            }
            Array authorsArray = new Array();
            List authors = entry.getAuthors();
            if (authors != null && authors.size() > 0) {
                Iterator it1 = authors.iterator();
                while (it1.hasNext()) {
                    Struct authorStruct = new Struct();
                    Person author = (Person)it1.next();
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "name", author.getName());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "uri", author.getUri());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(authorStruct, "email", author.getEmail());
                    if (authorStruct.isEmpty()) continue;
                    authorsArray.add((Object)authorStruct);
                }
                if (authorsArray.size() > 0) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"author", (Object)authorsArray, (boolean)false);
                }
            }
            Array contributorsArray = new Array();
            List contributors = entry.getContributors();
            if (contributors != null && contributors.size() > 0) {
                Iterator it1 = contributors.iterator();
                while (it1.hasNext()) {
                    Struct contributorStruct = new Struct();
                    Person contributor = (Person)it1.next();
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "name", contributor.getName());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "uri", contributor.getUri());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contributorStruct, "email", contributor.getEmail());
                    if (contributorStruct.isEmpty()) continue;
                    contributorsArray.add((Object)contributorStruct);
                }
                if (contributorsArray.size() > 0) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"contributor", (Object)contributorsArray, (boolean)false);
                }
            }
            Array linksArray = new Array();
            List links = entry.getAlternateLinks();
            if (links != null && links.size() > 0) {
                Iterator it1 = links.iterator();
                while (it1.hasNext()) {
                    Struct linkStruct = new Struct();
                    Link link = (Link)it1.next();
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "href", link.getHref());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "rel", link.getRel());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "type", link.getType());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "hreflang", link.getHreflang());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(linkStruct, "title", link.getTitle());
                    if (link.getLength() != null) {
                        StructUtils.StructInsert((Map)linkStruct, (String)"length", (Object)link.getLength(), (boolean)false);
                    }
                    if (linkStruct.isEmpty()) continue;
                    linksArray.add((Object)linkStruct);
                }
            }
            Array olinksArray = new Array();
            List olinks = entry.getOtherLinks();
            if (olinks != null && olinks.size() > 0) {
                Iterator it1 = olinks.iterator();
                while (it1.hasNext()) {
                    Struct olinkStruct = new Struct();
                    Link olink = (Link)it1.next();
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "href", olink.getHref());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "rel", olink.getRel());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "type", olink.getType());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "hreflang", olink.getHreflang());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(olinkStruct, "title", olink.getTitle());
                    if (olink.getLength() != null) {
                        StructUtils.StructInsert((Map)olinkStruct, (String)"length", (Object)olink.getLength(), (boolean)false);
                    }
                    if (olinkStruct.isEmpty()) continue;
                    olinksArray.add((Object)olinkStruct);
                }
            }
            if (olinksArray.size() > 0) {
                linksArray.addAll((Collection)olinksArray);
            }
            if (linksArray.size() > 0) {
                StructUtils.StructInsert((Map)entryStruct, (String)"link", (Object)linksArray, (boolean)false);
            }
            if (entry.getSummary() != null) {
                Content summary = entry.getSummary();
                Struct summaryStruct = new Struct();
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(summaryStruct, "type", summary.getType());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(summaryStruct, "mode", summary.getMode());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(summaryStruct, "src", summary.getSrc());
                AtomParser.insertNotNullAndNonZeroLengthValueInStruct(summaryStruct, "value", summary.getValue());
                if (!summaryStruct.isEmpty()) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"summary", (Object)summaryStruct, (boolean)false);
                }
            }
            Array contentsArray = new Array();
            List contents = entry.getContents();
            if (contents != null && contents.size() > 0) {
                for (Content content : contents) {
                    Struct contentStruct = new Struct();
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contentStruct, "type", content.getType());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contentStruct, "mode", content.getMode());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contentStruct, "src", content.getSrc());
                    AtomParser.insertNotNullAndNonZeroLengthValueInStruct(contentStruct, "value", content.getValue());
                    if (contentStruct.isEmpty()) continue;
                    contentsArray.add((Object)contentStruct);
                }
                if (contentsArray.size() > 0) {
                    StructUtils.StructInsert((Map)entryStruct, (String)"content", (Object)contentsArray, (boolean)false);
                }
            }
            entriesArray.add((Object)entryStruct);
        }
        return entriesArray;
    }

    public static QueryTable getItemsAsQuery(Feed atomFeed) {
        int separator_length = ",".length();
        QueryTable atomEntriesTable = new QueryTable(0, FeedTable.columnNames, FeedTable.columnTypes);
        List feedItems = atomFeed.getEntries();
        for (Entry entry : feedItems) {
            QueryFunction.QueryAddRow((Object)atomEntriesTable);
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"XMLBASE", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(entry.getXmlBase()));
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"ID", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(entry.getId()));
            if (entry.getPublished() != null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"PUBLISHEDDATE", (Object)DateParser.formatW3CDateTime((Date)entry.getPublished(), (Locale)Locale.US));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"PUBLISHEDDATE", null);
            }
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"RIGHTS", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(entry.getRights()));
            Content entry_title = entry.getTitleEx();
            if (entry_title != null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"TITLE", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(entry_title.getValue()));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"TITLETYPE", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(entry_title.getType()));
            }
            if (entry.getUpdated() != null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"UPDATEDDATE", (Object)DateParser.formatW3CDateTime((Date)entry.getUpdated(), (Locale)Locale.US));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"UPDATEDDATE", null);
            }
            if (entry.getCreated() != null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CREATEDDATE", (Object)DateParser.formatW3CDateTime((Date)entry.getCreated(), (Locale)Locale.US));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CREATEDDATE", null);
            }
            List categories = entry.getCategories();
            if (categories != null && categories.size() > 0) {
                Iterator it1 = categories.iterator();
                StringBuffer term = new StringBuffer();
                StringBuffer scheme = new StringBuffer();
                StringBuffer label = new StringBuffer();
                while (it1.hasNext()) {
                    Category atomCategory = (Category)it1.next();
                    term.append(AtomParser.checkNotNullAndZeroLengthGetBlank(atomCategory.getTerm()));
                    term.append(",");
                    scheme.append(AtomParser.checkNotNullAndZeroLengthGetBlank(atomCategory.getScheme()));
                    scheme.append(",");
                    label.append(AtomParser.checkNotNullAndZeroLengthGetBlank(atomCategory.getLabel()));
                    label.append(",");
                }
                term.deleteCharAt(term.length() - separator_length);
                scheme.deleteCharAt(scheme.length() - separator_length);
                label.deleteCharAt(label.length() - separator_length);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CATEGORYTERM", (Object)AtomParser.checkZeroLengthGetNull(term));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CATEGORYSCHEME", (Object)AtomParser.checkZeroLengthGetNull(scheme));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CATEGORYLABEL", (Object)AtomParser.checkZeroLengthGetNull(label));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CATEGORYTERM", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CATEGORYSCHEME", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CATEGORYLABEL", null);
            }
            List authors = entry.getAuthors();
            if (authors != null && authors.size() > 0) {
                Iterator it1 = authors.iterator();
                StringBuffer name = new StringBuffer();
                StringBuffer uri = new StringBuffer();
                StringBuffer email = new StringBuffer();
                while (it1.hasNext()) {
                    Person author = (Person)it1.next();
                    name.append(AtomParser.checkNotNullAndZeroLengthGetBlank(author.getName()));
                    name.append(",");
                    uri.append(AtomParser.checkNotNullAndZeroLengthGetBlank(author.getUri()));
                    uri.append(",");
                    email.append(AtomParser.checkNotNullAndZeroLengthGetBlank(author.getEmail()));
                    email.append(",");
                }
                name.deleteCharAt(name.length() - separator_length);
                uri.deleteCharAt(uri.length() - separator_length);
                email.deleteCharAt(email.length() - separator_length);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"AUTHORNAME", (Object)AtomParser.checkZeroLengthGetNull(name));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"AUTHORURI", (Object)AtomParser.checkZeroLengthGetNull(uri));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"AUTHOREMAIL", (Object)AtomParser.checkZeroLengthGetNull(email));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"AUTHORNAME", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"AUTHORURI", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"AUTHOREMAIL", null);
            }
            List contributors = entry.getContributors();
            if (contributors != null && contributors.size() > 0) {
                Iterator it1 = contributors.iterator();
                StringBuffer name = new StringBuffer();
                StringBuffer uri = new StringBuffer();
                StringBuffer email = new StringBuffer();
                while (it1.hasNext()) {
                    Person contributor = (Person)it1.next();
                    name.append(AtomParser.checkNotNullAndZeroLengthGetBlank(contributor.getName()));
                    name.append(",");
                    uri.append(AtomParser.checkNotNullAndZeroLengthGetBlank(contributor.getUri()));
                    uri.append(",");
                    email.append(AtomParser.checkNotNullAndZeroLengthGetBlank(contributor.getEmail()));
                    email.append(",");
                }
                name.deleteCharAt(name.length() - separator_length);
                uri.deleteCharAt(uri.length() - separator_length);
                email.deleteCharAt(email.length() - separator_length);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTRIBUTORNAME", (Object)AtomParser.checkZeroLengthGetNull(name));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTRIBUTORURI", (Object)AtomParser.checkZeroLengthGetNull(uri));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTRIBUTOREMAIL", (Object)AtomParser.checkZeroLengthGetNull(email));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTRIBUTORNAME", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTRIBUTORURI", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTRIBUTOREMAIL", null);
            }
            StringBuffer href = new StringBuffer();
            StringBuffer rel = new StringBuffer();
            StringBuffer type = new StringBuffer();
            StringBuffer hreflang = new StringBuffer();
            StringBuffer title = new StringBuffer();
            StringBuffer length = new StringBuffer();
            List links = entry.getAlternateLinks();
            if (links != null && links.size() > 0) {
                for (Link link : links) {
                    href.append(AtomParser.checkNotNullAndZeroLengthGetBlank(link.getHref()));
                    href.append(",");
                    rel.append(AtomParser.checkNotNullAndZeroLengthGetBlank(link.getRel()));
                    rel.append(",");
                    type.append(AtomParser.checkNotNullAndZeroLengthGetBlank(link.getType()));
                    type.append(",");
                    hreflang.append(AtomParser.checkNotNullAndZeroLengthGetBlank(link.getHreflang()));
                    hreflang.append(",");
                    title.append(AtomParser.checkNotNullAndZeroLengthGetBlank(link.getTitle()));
                    title.append(",");
                    if (link.getLength() != null) {
                        length.append(link.getLength());
                    } else {
                        length.append(" ");
                    }
                    length.append(",");
                }
                href.deleteCharAt(href.length() - separator_length);
                rel.deleteCharAt(rel.length() - separator_length);
                type.deleteCharAt(type.length() - separator_length);
                hreflang.deleteCharAt(hreflang.length() - separator_length);
                title.deleteCharAt(title.length() - separator_length);
                length.deleteCharAt(length.length() - separator_length);
                if (href.length() == 0) {
                    href = null;
                }
                if (rel.length() == 0) {
                    rel = null;
                }
                if (type.length() == 0) {
                    type = null;
                }
                if (hreflang.length() == 0) {
                    hreflang = null;
                }
                if (title.length() == 0) {
                    title = null;
                }
                if (length.length() == 0) {
                    length = null;
                }
            } else {
                href = null;
                rel = null;
                type = null;
                hreflang = null;
                title = null;
                length = null;
            }
            StringBuffer ohref = new StringBuffer();
            StringBuffer orel = new StringBuffer();
            StringBuffer otype = new StringBuffer();
            StringBuffer ohreflang = new StringBuffer();
            StringBuffer otitle = new StringBuffer();
            StringBuffer olength = new StringBuffer();
            List olinks = entry.getOtherLinks();
            if (olinks != null && olinks.size() > 0) {
                for (Link olink : olinks) {
                    ohref.append(AtomParser.checkNotNullAndZeroLengthGetBlank(olink.getHref()));
                    ohref.append(",");
                    orel.append(AtomParser.checkNotNullAndZeroLengthGetBlank(olink.getRel()));
                    orel.append(",");
                    otype.append(AtomParser.checkNotNullAndZeroLengthGetBlank(olink.getType()));
                    otype.append(",");
                    ohreflang.append(AtomParser.checkNotNullAndZeroLengthGetBlank(olink.getHreflang()));
                    ohreflang.append(",");
                    otitle.append(AtomParser.checkNotNullAndZeroLengthGetBlank(olink.getTitle()));
                    otitle.append(",");
                    if (olink.getLength() != null) {
                        olength.append(olink.getLength());
                    } else {
                        olength.append(" ");
                    }
                    olength.append(",");
                }
                ohref.deleteCharAt(ohref.length() - separator_length);
                orel.deleteCharAt(orel.length() - separator_length);
                otype.deleteCharAt(otype.length() - separator_length);
                ohreflang.deleteCharAt(ohreflang.length() - separator_length);
                otitle.deleteCharAt(otitle.length() - separator_length);
                olength.deleteCharAt(olength.length() - separator_length);
                if (ohref.length() == 0) {
                    ohref = null;
                }
                if (orel.length() == 0) {
                    orel = null;
                }
                if (otype.length() == 0) {
                    otype = null;
                }
                if (ohreflang.length() == 0) {
                    ohreflang = null;
                }
                if (otitle.length() == 0) {
                    otitle = null;
                }
                if (olength.length() == 0) {
                    olength = null;
                }
            } else {
                ohref = null;
                orel = null;
                otype = null;
                ohreflang = null;
                otitle = null;
                olength = null;
            }
            if (href == null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKHREF", (Object)AtomParser.checkZeroLengthGetNull(ohref));
            } else {
                if (ohref != null) {
                    href.append(",");
                    href.append(ohref);
                }
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKHREF", (Object)href.toString());
            }
            if (rel == null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKREL", (Object)AtomParser.checkZeroLengthGetNull(orel));
            } else {
                if (orel != null) {
                    rel.append(",");
                    rel.append(orel);
                }
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKREL", (Object)rel.toString());
            }
            if (type == null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKTYPE", (Object)AtomParser.checkZeroLengthGetNull(otype));
            } else {
                if (otype != null) {
                    type.append(",");
                    type.append(otype);
                }
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKTYPE", (Object)type.toString());
            }
            if (hreflang == null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKHREFLANG", (Object)AtomParser.checkZeroLengthGetNull(ohreflang));
            } else {
                if (ohreflang != null) {
                    hreflang.append(",");
                    hreflang.append(ohreflang);
                }
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKHREFLANG", (Object)hreflang.toString());
            }
            if (title == null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKTITLE", (Object)AtomParser.checkZeroLengthGetNull(otitle));
            } else {
                if (otitle != null) {
                    title.append(",");
                    title.append(otitle);
                }
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKTITLE", (Object)title.toString());
            }
            if (length == null) {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKLENGTH", (Object)AtomParser.checkZeroLengthGetNull(olength));
            } else {
                if (olength != null) {
                    length.append(",");
                    length.append(olength);
                }
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"LINKLENGTH", (Object)length.toString());
            }
            if (entry.getSummary() != null) {
                Content summary = entry.getSummary();
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARYTYPE", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(summary.getType()));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARYMODE", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(summary.getMode()));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARYSRC", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(summary.getSrc()));
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARY", (Object)AtomParser.checkNotNullAndZeroLengthGetNull(summary.getValue()));
            } else {
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARY", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARYTYPE", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARYMODE", null);
                QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"SUMMARYSRC", null);
            }
            List contents = entry.getContents();
            if (contents != null && contents.size() > 0) {
                StringBuffer ctype = new StringBuffer();
                StringBuffer mode = new StringBuffer();
                StringBuffer src = new StringBuffer();
                StringBuffer value = new StringBuffer();
                for (Content content : contents) {
                    ctype.append(AtomParser.checkNotNullAndZeroLengthGetBlank(content.getType()));
                    ctype.append(",");
                    mode.append(AtomParser.checkNotNullAndZeroLengthGetBlank(content.getMode()));
                    mode.append(",");
                    src.append(AtomParser.checkNotNullAndZeroLengthGetBlank(content.getSrc()));
                    src.append(",");
                    value.append(AtomParser.checkNotNullAndZeroLengthGetBlank(content.getValue()));
                    value.append(",");
                    ctype.deleteCharAt(ctype.length() - separator_length);
                    src.deleteCharAt(src.length() - separator_length);
                    mode.deleteCharAt(mode.length() - separator_length);
                    value.deleteCharAt(value.length() - separator_length);
                    QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENT", (Object)AtomParser.checkZeroLengthGetNull(value));
                    QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENTMODE", (Object)AtomParser.checkZeroLengthGetNull(mode));
                    QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENTSRC", (Object)AtomParser.checkZeroLengthGetNull(src));
                    QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENTTYPE", (Object)AtomParser.checkZeroLengthGetNull(ctype));
                }
                continue;
            }
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENT", null);
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENTMODE", null);
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENTSRC", null);
            QueryFunction.QuerySetCell((Object)atomEntriesTable, (String)"CONTENTTYPE", null);
        }
        return atomEntriesTable;
    }

    public static void saveEnclosures(Feed feed, String enclosureDir, boolean overwrite, boolean ignoreEnclosureError, String userAgent) {
        List links = feed.getOtherLinks();
        if (links != null && links.size() > 0) {
            for (Link atomLink : links) {
                if (!atomLink.getRel().equalsIgnoreCase("enclosure")) continue;
                String url = atomLink.getHref().replace("\\", "/");
                int idx = url.lastIndexOf(47);
                if (idx == -1) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.UnableToDetermineEnclosureFileNameException(url)));
                        continue;
                    }
                    throw new FeedReader.UnableToDetermineEnclosureFileNameException(url);
                }
                String file = url.substring(idx + 1);
                try {
                    if (url.contains("..")) {
                        throw new MalformedURLException();
                    }
                    URL enclosureURL = new URL(url);
                    long length = -1L;
                    if (atomLink.getLength() != null) {
                        length = atomLink.getLength();
                    }
                    FeedReader.getUrlContents(enclosureURL, enclosureDir, length, file, overwrite, ignoreEnclosureError, userAgent);
                }
                catch (MalformedURLException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.InvalidURLEnclosureException(url)));
                        continue;
                    }
                    throw new FeedReader.InvalidURLEnclosureException(url);
                }
                catch (FileNotFoundException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.EnclosureFileNotFoundException(url)));
                        continue;
                    }
                    throw new FeedReader.EnclosureFileNotFoundException(url);
                }
                catch (IOException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.UnableToSaveEnclosureException(url, e.getMessage())));
                        continue;
                    }
                    throw new FeedReader.UnableToSaveEnclosureException(url, e.getMessage());
                }
            }
        }
        List entries = feed.getEntries();
        for (Entry entry : entries) {
            links = entry.getOtherLinks();
            if (links == null || links.size() <= 0) continue;
            for (Link atomLink : links) {
                if (!atomLink.getRel().equalsIgnoreCase("enclosure")) continue;
                String url = atomLink.getHref();
                int idx = url.lastIndexOf(47);
                if (idx == -1) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.UnableToDetermineEnclosureFileNameException(url)));
                        continue;
                    }
                    throw new FeedReader.UnableToDetermineEnclosureFileNameException(url);
                }
                String file = url.substring(idx + 1);
                try {
                    URL enclosureURL = new URL(url);
                    long length = -1L;
                    if (atomLink.getLength() != null) {
                        length = atomLink.getLength();
                    }
                    FeedReader.getUrlContents(enclosureURL, enclosureDir, length, file, overwrite, ignoreEnclosureError, userAgent);
                }
                catch (MalformedURLException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.InvalidURLEnclosureException(url)));
                        continue;
                    }
                    throw new FeedReader.InvalidURLEnclosureException(url);
                }
                catch (FileNotFoundException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.EnclosureFileNotFoundException(url)));
                        continue;
                    }
                    throw new FeedReader.EnclosureFileNotFoundException(url);
                }
                catch (IOException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.UnableToSaveEnclosureException(url, e.getMessage())));
                        continue;
                    }
                    throw new FeedReader.UnableToSaveEnclosureException(url, e.getMessage());
                }
            }
        }
    }

    public static String checkNotNullAndZeroLengthGetBlank(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        return " ";
    }

    public static String checkNotNullAndZeroLengthGetNull(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        return null;
    }

    public static String checkZeroLengthGetNull(StringBuffer st) {
        if (st != null && st.length() != 0) {
            return st.toString();
        }
        return null;
    }

    public static void insertNotNullAndNonZeroLengthValueInStruct(Struct struct, String key, String value) {
        if (key != null && value != null && value.length() > 0) {
            StructUtils.StructInsert((Map)struct, (String)key, (Object)value, (boolean)false);
        }
    }
}

