/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import ice.debug.Debug;
import ice.util.Defs;
import java.net.URLStreamHandler;
import java.util.Hashtable;

public class URLStreamHandlerFactory
implements java.net.URLStreamHandlerFactory {
    private static final Hashtable handlers = new Hashtable();

    public static void init() {
    }

    public static void unload() {
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler result = null;
        String className = (String)handlers.get(protocol);
        if (className != null) {
            result = (URLStreamHandler)Defs.newClassInstance(className);
            if (Debug.trace && result == null) {
                Debug.trace("Error: can not find " + className + " to handle " + protocol);
            }
        }
        return result;
    }

    public static void addStreamHandler(String protocolName, String className) {
        handlers.put(protocolName, className);
    }

    public static void addStreamHandler(String protocolName, Class cl) {
        URLStreamHandlerFactory.addStreamHandler(protocolName, cl.getName());
    }

    public static void removeStreamHandler(String protocol) {
        handlers.remove(protocol);
    }

    static {
        URLStreamHandlerFactory.addStreamHandler("http", "ice.net.HttpURLStreamHandler");
        URLStreamHandlerFactory.addStreamHandler("https", "ice.https.HttpsURLStreamHandler");
        URLStreamHandlerFactory.addStreamHandler("mailto", "ice.net.mailto.Handler");
        URLStreamHandlerFactory.addStreamHandler("news", "ice.net.mailto.Handler");
        URLStreamHandlerFactory.addStreamHandler("dom", "ice.pilots.domviewer.Handler");
        URLStreamHandlerFactory.addStreamHandler("about", "ice.storm.AboutHandler");
        URLStreamHandlerFactory.addStreamHandler("doc", "ice.net.doc.Handler");
        Defs.setProperty("hotjava.file.iconwidth", "30");
        Defs.setProperty("hotjava.file.iconheight", "24");
    }
}

