/*
 * Decompiled with CFR 0.152.
 */
package ice.util.io;

import ice.util.Defs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class IOKit {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static byte[] readAll(InputStream is) throws IOException {
        return IOKit.readAll_r(is, 0, 4096);
    }

    public static byte[] readAll(InputStream is, int initialBufferSize) throws IOException {
        return IOKit.readAll_r(is, 0, initialBufferSize);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] readAll_r(InputStream is, int prevRead, int capacity) throws IOException {
        void var3_7;
        int cursor;
        byte[] buffer;
        block1: {
            byte[] result;
            int nread;
            buffer = new byte[capacity];
            cursor = 0;
            do {
                if ((nread = is.read(buffer, cursor, capacity - cursor)) >= 0) continue;
                int N = prevRead + cursor;
                result = N != 0 ? new byte[N] : Defs.EMPTY_BYTE_ARRAY;
                break block1;
            } while ((cursor += nread) != capacity);
            result = IOKit.readAll_r(is, prevRead + cursor, capacity * 2);
        }
        System.arraycopy(buffer, 0, var3_7, prevRead, cursor);
        return var3_7;
    }

    public static char[] readAll(Reader r, int initialBufferSize) throws IOException {
        return IOKit.readAll_r(r, 0, initialBufferSize);
    }

    public static String readAllStr(Reader r, int initialBufferSize) throws IOException {
        char[] array = IOKit.readAll_r(r, 0, initialBufferSize);
        return array.length == 0 ? "" : new String(array);
    }

    /*
     * WARNING - void declaration
     */
    private static char[] readAll_r(Reader r, int prevRead, int capacity) throws IOException {
        void var3_7;
        int cursor;
        char[] buffer;
        block1: {
            char[] result;
            int nread;
            buffer = new char[capacity];
            cursor = 0;
            do {
                if ((nread = r.read(buffer, cursor, capacity - cursor)) >= 0) continue;
                int N = prevRead + cursor;
                result = N != 0 ? new char[N] : Defs.EMPTY_CHAR_ARRAY;
                break block1;
            } while ((cursor += nread) != capacity);
            result = IOKit.readAll_r(r, prevRead + cursor, capacity * 2);
        }
        System.arraycopy(buffer, 0, var3_7, prevRead, cursor);
        return var3_7;
    }
}

