/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DElement;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.OutlinePainter;
import ice.pilots.html4.TableColBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class TableCellBox
extends BlockBox {
    TableColBox cellColBox;
    private FloatPainter floatPainter = new FloatPainter();
    int col = 0;
    int colspan = 1;
    int rowspan = 1;
    int vadd = 0;
    int tbc_height;

    TableCellBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        super(e, css, cssLayout, (byte)0);
        if (e != null) {
            String s = e.getAttribute(29);
            if (s != null) {
                this.colspan = CSSUtil.parseInt(s, -1);
                if (this.colspan < 1) {
                    this.colspan = 1;
                }
            }
            if ((s = e.getAttribute(93)) != null) {
                this.rowspan = CSSUtil.parseInt(s, -1);
                if (this.rowspan < 1) {
                    this.rowspan = 1;
                }
            }
        }
    }

    void dispose() {
        this.cellColBox = null;
        super.dispose();
        if (this.floatPainter != null) {
            this.floatPainter.clear();
            this.floatPainter = null;
        }
    }

    void setCellColBox(TableColBox b) {
        CSSBox t;
        int tmp;
        this.cellColBox = b;
        CSSBox rowBox = this.parentBox;
        CSSBox rowGroupBox = rowBox.parentBox;
        if (this.css.background_color == null) {
            if (rowBox.css.background_color != null) {
                this.css.background_color = rowBox.css.background_color;
            } else if (rowGroupBox.css.background_color != null) {
                this.css.background_color = rowGroupBox.css.background_color;
            } else if (this.cellColBox != null) {
                if (this.cellColBox.css.background_color != null) {
                    this.css.background_color = this.cellColBox.css.background_color;
                } else {
                    CSSBox t2 = this.cellColBox.parentBox;
                    if (t2 != null && t2.css.background_color != null) {
                        this.css.background_color = t2.css.background_color;
                    }
                }
            }
        }
        if (this.css.vertical_align_type == (tmp = 140)) {
            if (rowBox.css.vertical_align_type != tmp) {
                this.css.vertical_align_type = rowBox.css.vertical_align_type;
            } else if (rowGroupBox.css.vertical_align_type != tmp) {
                this.css.vertical_align_type = rowGroupBox.css.vertical_align_type;
            } else if (this.cellColBox != null) {
                if (this.cellColBox.css.vertical_align_type != tmp) {
                    this.css.vertical_align_type = this.cellColBox.css.vertical_align_type;
                } else {
                    t = this.cellColBox.parentBox;
                    if (t != null && t.css.vertical_align_type != tmp) {
                        this.css.vertical_align_type = t.css.vertical_align_type;
                    }
                }
            }
            if (this.css.vertical_align_type == tmp) {
                this.css.vertical_align_type = 144;
            }
        }
        if (this.css.text_align == (tmp = 15)) {
            if (rowBox.css.text_align != tmp) {
                this.css.text_align = rowBox.css.text_align;
            } else if (rowGroupBox.css.text_align != tmp) {
                this.css.text_align = rowGroupBox.css.text_align;
            } else if (this.cellColBox != null) {
                if (this.cellColBox.css.text_align != tmp) {
                    this.css.text_align = this.cellColBox.css.text_align;
                } else {
                    t = this.cellColBox.parentBox;
                    if (t != null && t.css.text_align != tmp) {
                        this.css.text_align = t.css.text_align;
                    }
                }
            }
        }
        if (this.css.width == (tmp = -123456) && this.cellColBox != null) {
            if (this.cellColBox.css.width != tmp) {
                this.css.width = this.cellColBox.css.width;
                this.css.percentage_flag |= this.cellColBox.css.percentage_flag & 0x100000;
            } else {
                t = this.cellColBox.parentBox;
                if (t != null && t.css.width != tmp) {
                    this.css.width = t.css.width;
                    this.css.percentage_flag |= t.css.percentage_flag & 0x100000;
                }
            }
        }
    }

    void findBoundingBox(Rectangle r) {
        Point p = new Point();
        p.x += this.ox;
        p.y += this.oy;
        if (this.css.position != 125 && this.css.position != 126 && this.css.position != 6 && this.parentBox != null) {
            this.parentBox.findAbsolutePosition_int(p);
        }
        r.x = p.x;
        r.y = p.y;
        r.width = this.width;
        r.height = this.height;
    }

    void findAbsolutePosition(Point p) {
        p.y += this.vadd;
        super.findAbsolutePosition(p);
    }

    void findBoundingBoxForPrinting(Point p) {
        super.findBoundingBoxForPrinting(p);
    }

    void recordBoundingBoxForInline(Rectangle r, int x, int w) {
        super.recordBoundingBoxForInline(r, x, w);
        if (r.width > 0) {
            r.y += this.vadd;
        }
    }

    void layout(int parentContentWidth, int parentContentHeight) {
        this.tbc_height = 0;
        this.floatPainter.clear();
        FloatManager m = new FloatManager(0, parentContentWidth);
        super.layout(parentContentWidth, parentContentHeight, m);
        this.height += m.skipTill(parentContentWidth);
        CSSBox b = m.getFirstFloater();
        if (b != null) {
            this.floatPainter.add(b);
        }
        if (parentContentWidth > this.width) {
            this.width = parentContentWidth;
        }
        if (this.first == null) {
            int tmp = this.css.height;
            if (tmp == -123456) {
                tmp = 1;
            }
            this.height = tmp;
        }
    }

    void calcRowHeights(int border_spacing_y) {
        block8: {
            int j;
            block7: {
                if (this.rowspan != 1) break block7;
                if ((this.css.percentage_flag & 8) != 0) break block7;
                if (this.height <= this.parentBox.height) break block8;
                this.parentBox.height = this.height;
                break block8;
            }
            int curHeight = 0;
            CSSBox b = this.parentBox;
            for (j = 0; j < this.rowspan && b != null; ++j) {
                curHeight += b.height;
                b = b.next;
            }
            int rowCount = j;
            int h = this.height - border_spacing_y * (rowCount - 1);
            if (curHeight < h) {
                if (curHeight > 0) {
                    int old_h;
                    b = this.parentBox;
                    for (j = 0; j < rowCount && b != null && curHeight > 0; curHeight -= old_h, ++j) {
                        old_h = b.height;
                        b.height += (h - curHeight) * b.height / curHeight;
                        h -= b.height;
                        b = b.next;
                    }
                } else if (rowCount > 0) {
                    h /= rowCount;
                    b = this.parentBox;
                    for (j = 0; j < rowCount && b != null; ++j) {
                        b.height += h;
                        b = b.next;
                    }
                }
            }
        }
    }

    void adjustHeight(int dh) {
        this.height += dh;
        if (this.css.vertical_align_type == 144) {
            this.vadd += dh / 2;
        } else if (this.css.vertical_align_type == 17) {
            this.vadd += dh;
        }
    }

    void calcCellHeight(int border_spacing_y) {
        int j = 0;
        int h = 0;
        CSSBox b = this.parentBox;
        for (j = 0; j < this.rowspan && b != null; ++j) {
            h += b.height + border_spacing_y;
            b = b.next;
        }
        if (h > 0) {
            h -= border_spacing_y;
        }
        this.vadd = 0;
        if (this.tbc_height == 0) {
            this.tbc_height = this.height;
        }
        if (this.tbc_height > 0 && this.tbc_height < h) {
            if (this.css.vertical_align_type == 144) {
                this.vadd = (h - this.tbc_height) / 2;
            } else if (this.css.vertical_align_type == 17) {
                this.vadd = h - this.tbc_height;
            }
        }
        this.height = h;
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        CSSBox b = this.floatPainter.getBoxAt(ex, ey - this.vadd, rv);
        if (b == null) {
            b = super.getBoxAt(ex, ey - this.vadd, rv);
        }
        return b;
    }

    public void paint(Graphics g) {
        Rectangle r = g.getClipBounds();
        if ((this.css.misc & 1) != 0) {
            this.paintBackground(g, r, 0, 0, this.width, this.height, this.vadd);
            this.paintBorders(g, r, 0, 0, this.width, this.height, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8, this.css.border_right_width > 0 && this.css.border_right_style != 8);
        }
        OutlinePainter outlinePainter = this.cssLayout.outlinePainter;
        if (this.vadd > 0) {
            outlinePainter.translate(g, 0, this.vadd);
            r.y -= this.vadd;
        }
        if (this.isPureBlock) {
            CSSBox bb = this.first;
            while (bb != null) {
                if (bb.css.position != 125 && bb.oy + bb.height >= r.y) {
                    if (bb.oy > r.y + r.height) break;
                    outlinePainter.drawBox(g, bb, bb.ox, bb.oy);
                }
                bb = bb.next;
            }
        } else {
            int sx = this.css.border_left_width + this.css.padding_left;
            int sy = this.css.border_top_width + this.css.padding_top;
            int lineIdx = 0;
            int lineBoxIdx = 0;
            while (lineIdx < this.sizeLines) {
                int x = this.lines[lineIdx + 0];
                int lineHeight = this.lines[lineIdx + 2];
                if (sy + lineHeight < r.y) {
                    sy += lineHeight;
                } else {
                    if (sy > r.y + r.height) break;
                    if (this.lines[lineIdx + 0 + 3] == x) {
                        sy += lineHeight;
                    } else {
                        outlinePainter.translate(g, sx - x + this.lines[lineIdx + 1], sy);
                        this.paintChildren(g, x, this.lines[lineIdx + 0 + 3] - x, this._lineBoxArray[lineBoxIdx]);
                        outlinePainter.translate(g, -sx + x - this.lines[lineIdx + 1], -sy);
                        sy += lineHeight;
                    }
                }
                lineIdx += 3;
                ++lineBoxIdx;
            }
        }
        this.floatPainter.paintNegativeZ_Indices(g);
        this.floatPainter.paintPositiveZ_Indices(g);
        if (this.vadd > 0) {
            outlinePainter.translate(g, 0, -this.vadd);
        }
    }

    public String toString() {
        return "tablecell " + super.toString();
    }
}

