/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DIFrameElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.IframeURLException;
import ice.pilots.html4.ImageObjectPainter;
import ice.pilots.html4.MarqueeObjectPainter;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.util.Defs;
import java.awt.Container;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.stream.Collectors;

class ObjectPool
implements ImageObserver {
    private ThePilot pilot;
    private Hashtable imageHash = new Hashtable();
    private Hashtable urlHash = new Hashtable();
    private Hashtable painterHash = new Hashtable();
    private Hashtable tiledImageCache = new Hashtable();
    private int imagesToLoad = 0;
    private Hashtable oldPainterHash = null;
    private static final String DEFAULT_ALLOWED_PROTOCOLS = "http, https";
    private static final String IFRAME_ALLOWED_PROTOCOLS = System.getProperty("coldfusion.iframe.allowedprotocols", "http, https");

    ObjectPool(ThePilot thePilot) {
        this.pilot = thePilot;
    }

    void dispose() {
        Image image;
        Enumeration enumeration = this.imageHash.elements();
        while (enumeration.hasMoreElements()) {
            image = (Image)enumeration.nextElement();
            this.pilot.sdata.imageCache.release(image);
        }
        this.imageHash.clear();
        enumeration = this.tiledImageCache.elements();
        while (enumeration.hasMoreElements()) {
            image = (Image)enumeration.nextElement();
            image.flush();
        }
        this.tiledImageCache.clear();
        this.urlHash.clear();
        enumeration = this.painterHash.elements();
        while (enumeration.hasMoreElements()) {
            ((ObjectPainter)enumeration.nextElement()).dispose();
        }
        this.painterHash.clear();
        this.pilot.sdata.imageCache.flushImages(false);
    }

    void stopImageLoading() {
        Enumeration enumeration = this.imageHash.elements();
        while (enumeration.hasMoreElements()) {
            Image image = (Image)enumeration.nextElement();
            this.pilot.sdata.imageCache.stopLoading(image);
        }
    }

    private void fireOutstandingImagesEvent(String string) {
        this.pilot.firePropertyChange("outstandingImages", string, "" + this.imagesToLoad);
    }

    void fireOutstandingImagesEvent() {
        this.fireOutstandingImagesEvent(null);
    }

    void beginCreating() {
        this.oldPainterHash = this.painterHash;
        this.painterHash = new Hashtable();
    }

    void endCreating() {
        Enumeration enumeration = this.oldPainterHash.elements();
        while (enumeration.hasMoreElements()) {
            ObjectPainter objectPainter = (ObjectPainter)enumeration.nextElement();
            objectPainter.dispose();
        }
        this.oldPainterHash.clear();
    }

    ObjectPainter getNodePainter(DNode dNode) {
        return (ObjectPainter)this.painterHash.get(dNode);
    }

    ObjectPainter createEmbeddedObjectPainter(DElement dElement, CSSBox cSSBox) {
        ObjectPainter objectPainter = (ObjectPainter)this.oldPainterHash.get(dElement);
        if (objectPainter != null) {
            if (objectPainter instanceof Container) {
                ((Container)((Object)objectPainter)).invalidate();
            }
            this.oldPainterHash.remove(dElement);
            this.painterHash.put(dElement, objectPainter);
            return objectPainter;
        }
        objectPainter = (ObjectPainter)this.painterHash.get(dElement);
        if (objectPainter != null) {
            return objectPainter;
        }
        if (dElement.isFormControl()) {
            if (dElement.tagId == 47 && "image".equalsIgnoreCase(dElement.getAttribute("type"))) {
                Image image;
                String string = dElement.getAttribute(102);
                if (string != null && (image = this.loadImage(dElement.doc.resolveUrl(string))) != null) {
                    objectPainter = new ImageObjectPainter(image);
                }
            } else {
                objectPainter = this.pilot.getCSSLayout().docPane.createFormControl(dElement);
            }
        } else if (dElement.tagId == 93) {
            objectPainter = new MarqueeObjectPainter(dElement.doc);
        } else if (dElement.tagId == 46) {
            String string = dElement.getAttribute(102);
            if (string == null || string.trim().equals("")) {
                objectPainter = new ImageObjectPainter(null);
            } else {
                Image image = this.loadImage(dElement.doc.resolveUrl(string));
                if (image != null) {
                    objectPainter = new ImageObjectPainter(image);
                }
            }
        } else if (dElement.tagId == 45) {
            for (DNode dNode = dElement.getParentDNode(); dNode != null && dNode.getNameId() != 13; dNode = dNode.getParentDNode()) {
                if (dNode.getNameId() != 60) continue;
                return null;
            }
            EmbeddedObject embeddedObject = new EmbeddedObject(this.pilot.getStorm(), dElement);
            embeddedObject.setFrameArrayMember();
            String string = dElement.getAttribute(119);
            String string2 = dElement.getAttribute(45);
            if (string != null && string2 != null) {
                int n = CSSUtil.parseLength(string);
                int n2 = CSSUtil.parseLength(string2);
                if (n >= 0 && n2 >= 0) {
                    embeddedObject.setDefaultSize(n, n2);
                }
            }
            objectPainter = embeddedObject;
            this.loadIFrame((DIFrameElement)dElement, embeddedObject, this.pilot.isFromHistory);
        } else if (dElement.tagId == 5) {
            int n;
            DAppletElement dAppletElement = (DAppletElement)dElement;
            if (!dAppletElement.isLoaded()) {
                return null;
            }
            Hashtable hashtable = this.getObjectParams(dElement);
            String string = (String)hashtable.get("code");
            if (string == null) {
                if (Debug.trace) {
                    Debug.trace("No applet code: elem=" + dElement);
                }
                return null;
            }
            if (".class".regionMatches(true, 0, string = string.replace('/', '.'), (n = string.length()) - 6, 6)) {
                string = string.substring(0, n - 6);
            } else if (".java".regionMatches(true, 0, string, n - 5, 5)) {
                string = string.substring(0, n - 5);
            }
            String string3 = "application/java";
            if (!this.pilot.getStorm().isMimeTypeEnabled(string3)) {
                return null;
            }
            objectPainter = this.loadSubview(dElement, string3, string, hashtable);
        } else if (dElement.tagId == 60) {
            Hashtable hashtable = this.getObjectParams(dElement);
            String string = (String)hashtable.get("data");
            String string4 = (String)hashtable.get("type");
            String string5 = (String)hashtable.get("classid");
            if (string5 != null) {
                if (string5.startsWith("clsid:")) {
                    string5 = string5.substring(6);
                }
                if (string5.equals("D27CDB6E-AE6D-11cf-96B8-444553540000")) {
                    string4 = "application/x-shockwave-flash";
                    string = (String)hashtable.get("movie");
                } else if (string5.equals("8AD9C840-044E-11D1-B3E9-00805F499D93") || string5.startsWith("CAFEEFAC") && string5.endsWith("ABCDEFFEDCBA")) {
                    string4 = "application/java";
                    string = (String)hashtable.get("code");
                    this.preProcessAppletParameters(dElement, hashtable);
                } else if (string5.startsWith("java:")) {
                    string = string5.substring(5);
                    string4 = "application/java";
                    this.preProcessAppletParameters(dElement, hashtable);
                } else if (string5.equals("02BF25D5-8C17-4B23-BC80-D3488ABDDC6B")) {
                    string = (String)hashtable.get("src");
                    string4 = "video/quicktime";
                } else {
                    String string6 = (String)hashtable.get("codetype");
                    if (string6 != null && string6.equals("application/java")) {
                        string = string5;
                        string4 = "application/java";
                        this.preProcessAppletParameters(dElement, hashtable);
                    }
                }
            } else if (string4 != null && string4.equals("application/x-weblet")) {
                string = (String)hashtable.get("weblet_codebase");
                if (string == null && (string = (String)hashtable.get("docbase")) == null) {
                    if (Debug.trace) {
                        Debug.trace("Bad weblet tag: elem=" + dElement);
                    }
                    return null;
                }
                this.addWebletsParams(dElement, hashtable);
            }
            if (string == null && string4 == null) {
                if (Debug.trace) {
                    Debug.trace("NO location and type: elem=" + dElement);
                }
                return null;
            }
            if (string4 != null && !this.pilot.getStorm().isMimeTypeEnabled(string4) && !string4.equals("application/x-ice-dom-extension")) {
                return null;
            }
            objectPainter = string4 != null && string4.equals("application/x-ice-dom-extension") ? this.loadDomExtension(dElement, hashtable) : this.loadSubview(dElement, string4, string, hashtable);
        } else if (cSSBox != null && cSSBox instanceof ScrollBox) {
            objectPainter = this.pilot.getCSSLayout().docPane.createScroller();
        }
        if (objectPainter != null) {
            this.painterHash.put(dElement, objectPainter);
        }
        return objectPainter;
    }

    private void preProcessAppletParameters(DElement dElement, Hashtable hashtable) {
        DAttr dAttr = dElement.getDAttr(25);
        if (dAttr != null) {
            hashtable.remove(dAttr.getName());
            hashtable.put("jpi_codebase", dAttr.getValue());
            DNode dNode = dElement.getFirstDChild();
            while (dNode != null) {
                String string;
                DAttr dAttr2;
                if (dNode.getNameId() == 65 && (dAttr2 = dNode.getDAttr(63)) != null && (string = dAttr2.getNodeValue()) != null && string.equalsIgnoreCase("codebase")) {
                    dAttr2 = dNode.getDAttr(114);
                    if (dAttr2 == null) break;
                    hashtable.put(string, dAttr2.getNodeValue());
                    break;
                }
                dNode = dNode.next;
            }
        }
    }

    void loadIFrame(DIFrameElement dIFrameElement, EmbeddedObject embeddedObject) {
        this.loadIFrame(dIFrameElement, embeddedObject, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadIFrame(DIFrameElement dIFrameElement, EmbeddedObject embeddedObject, boolean bl) {
        String string2;
        String string3 = null;
        String string4 = dIFrameElement.getAttribute(102);
        if (string4 == null && (string4 = dIFrameElement.getAttribute(24)) == null) {
            string4 = dIFrameElement.getAttribute(68);
        }
        if (string4 != null && string4.length() > 0) {
            string3 = dIFrameElement.doc.resolveUrl(string4);
        }
        if ((string2 = dIFrameElement.getAttribute(97)) != null) {
            embeddedObject.setProperty("scrolling", string2);
        }
        if ((string2 = dIFrameElement.getAttribute(58)) == null) {
            string2 = "0";
        }
        embeddedObject.setProperty("marginwidth", string2);
        string2 = dIFrameElement.getAttribute(57);
        if (string2 == null) {
            string2 = "0";
        }
        embeddedObject.setProperty("marginheight", string2);
        string2 = this.pilot.getEncoding();
        if (string2 != null) {
            embeddedObject.setProperty("encoding", string2);
        }
        dIFrameElement.setAsEmbeddedViewHolder(embeddedObject);
        String string5 = dIFrameElement.getAttribute(111);
        if (string3 != null) {
            Object object;
            String string6;
            Object object2;
            Hashtable hashtable = dIFrameElement.getAttributesAsHashtable();
            DNode dNode = dIFrameElement.getFirstDChild();
            while (dNode != null) {
                if (dNode.getNameId() == 65) {
                    object2 = (DElement)dNode;
                    string6 = ((DElement)object2).getAttribute(63);
                    object = ((DElement)object2).getAttribute(114);
                    if (string6 != null && object != null) {
                        hashtable.put(string6.toLowerCase(), object);
                    }
                }
                dNode = dNode.next;
            }
            try {
                object2 = new URL(string3);
                string6 = ((URL)object2).getProtocol();
                object = Arrays.stream((IFRAME_ALLOWED_PROTOCOLS + "," + DEFAULT_ALLOWED_PROTOCOLS).toLowerCase().split(",")).map(String::trim).filter(string -> !string.isEmpty()).collect(Collectors.toSet());
                if (object.contains(string6.toLowerCase())) {
                    ContentLoader contentLoader = this.pilot.getStorm().getContentLoaderFactory().createContentLoader(string3, string5);
                    contentLoader.setParams(hashtable);
                    contentLoader.setIframe(true);
                    if (bl) return;
                    this.pilot.getStorm().renderViewportContent(contentLoader, embeddedObject);
                    return;
                }
                this.clearViewportContent(string5, embeddedObject, bl);
                throw new IframeURLException("The cfdocument's iframe tag supports the specified protocols defined in " + object + ". Customize the allowed protocols using the JVM argument, coldfusion.iframe.allowedprotocols.");
            }
            catch (MalformedURLException malformedURLException) {
                throw new IframeURLException("The src attribute in the iframe tag contains an invalid URL; double-check and ensure its proper formattting.");
            }
        } else {
            this.clearViewportContent(string5, embeddedObject, bl);
        }
    }

    private void clearViewportContent(String string, EmbeddedObject embeddedObject, boolean bl) {
        if (string == null) {
            string = "text/html";
        }
        if (!bl) {
            this.pilot.getStorm().clearViewportContent(string, embeddedObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Image loadImage(String string) {
        Image image;
        String string2 = "image/jpeg";
        if (string.toLowerCase().endsWith(".gif")) {
            string2 = "image/gif";
        }
        if (!this.pilot.getStorm().isMimeTypeEnabled(string2) || !this.pilot.canLoadImages()) {
            return null;
        }
        if (string.indexOf(32) != -1 && (string.startsWith("http") || string.startsWith("HTTP")) && Defs.booleanProperty("ice.pilots.html4.encodeImageURL", false)) {
            string = ObjectPool.encodeWhiteSpace(string);
        }
        if ((image = (Image)this.imageHash.get(string)) == null) {
            boolean bl;
            image = this.pilot.sdata.imageCache.getImage(string, this.pilot);
            if (image == null) return image;
            this.imageHash.put(string, image);
            this.urlHash.put(image, string);
            int n = this.pilot.sdata.imageCache.getAwtToolkit().checkImage(image, -1, -1, this);
            boolean bl2 = bl = (n & 0xF0) != 0;
            if (bl) return image;
            ++this.imagesToLoad;
            this.fireOutstandingImagesEvent();
            ThePilot.prepareImage(image, this);
            return image;
        } else {
            ThePilot.prepareImage(image, null);
        }
        return image;
    }

    public Image getTiledImage(String string) {
        return (Image)this.tiledImageCache.get(string);
    }

    public void addTiledImageToCache(String string, Image image) {
        if (string == null || image == null) {
            throw new IllegalArgumentException("Arguments to tiledImageCache are invalid");
        }
        this.tiledImageCache.put(string, image);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Object object;
        boolean bl;
        boolean bl2 = bl = (n & 0xF0) != 0;
        if (!bl) {
            object = this.pilot;
            if (object != null) {
                if (!((ThePilot)object).canLoadImages()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            if ((n & 0x10) != 0) {
                this.pilot.sdata.imageCache.checkForAnimatedImagesBug();
            }
            --this.imagesToLoad;
            object = (String)this.urlHash.get(image);
            this.fireOutstandingImagesEvent((String)object);
            return false;
        }
        return true;
    }

    private ObjectPainter loadSubview(DElement dElement, String string, String string2, Hashtable hashtable) {
        if (string2 == null && string == null) {
            Debug.bug();
        }
        EmbeddedObject embeddedObject = new EmbeddedObject(this.pilot.getStorm(), dElement);
        String string3 = (String)hashtable.get("scrolling");
        if (string3 != null) {
            embeddedObject.setProperty("scrolling", string3);
        }
        if ((string3 = (String)hashtable.get("marginwidth")) != null) {
            embeddedObject.setProperty("marginwidth", string3);
        }
        if ((string3 = (String)hashtable.get("marginheight")) != null) {
            embeddedObject.setProperty("marginheight", string3);
        }
        if ((string3 = this.pilot.getEncoding()) != null) {
            embeddedObject.setProperty("encoding", string3);
        }
        if ((string3 = (String)hashtable.get("name")) != null) {
            embeddedObject.setProperty("name", string3);
        }
        if ((string3 = (String)hashtable.get("height")) != null) {
            embeddedObject.setProperty("height", string3);
        }
        if ((string3 = (String)hashtable.get("width")) != null) {
            embeddedObject.setProperty("width", string3);
        }
        String string4 = (String)hashtable.get("width");
        String string5 = (String)hashtable.get("height");
        if (string4 != null && string5 != null) {
            int n = CSSUtil.parseLength(string4);
            int n2 = CSSUtil.parseLength(string5);
            if (n >= 0 && n2 >= 0) {
                embeddedObject.setDefaultSize(n, n2);
            }
        }
        dElement.setAsEmbeddedViewHolder(embeddedObject);
        String string6 = string2 == null ? dElement.doc.getBaseUrl() : dElement.doc.resolveUrl(string2);
        StormBase stormBase = this.pilot.getStorm();
        ContentLoader contentLoader = stormBase.getContentLoaderFactory().createContentLoader(string6, string);
        contentLoader.setReferer(dElement.doc.getBaseUrl());
        contentLoader.setParams(hashtable);
        stormBase.renderViewportContent(contentLoader, embeddedObject);
        return embeddedObject;
    }

    private ObjectPainter loadDomExtension(DElement dElement, Hashtable hashtable) {
        return null;
    }

    private Hashtable getObjectParams(DElement dElement) {
        Object object;
        Hashtable<String, Object> hashtable = dElement.getAttributesAsHashtable();
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        DNode dNode = dElement.getFirstDChild();
        while (dNode != null) {
            if (dNode.getNameId() == 65) {
                object = (DElement)dNode;
                String string = ((DElement)object).getAttribute(63);
                String string2 = ((DElement)object).getAttribute(114);
                if (string != null && string2 != null) {
                    hashtable.put(string.toLowerCase(), string2);
                }
            }
            dNode = dNode.next;
        }
        object = dElement.doc.getBaseUrl();
        if (object != null) {
            hashtable.put("docbase", object);
        }
        return hashtable;
    }

    private void addWebletsParams(DElement dElement, Hashtable hashtable) {
        hashtable.put("ownerDocument", dElement.getOwnerDocument());
        hashtable.put("objectElement", dElement);
        hashtable.put("creatorViewportId", this.pilot.getViewportId());
        Properties properties = new Properties();
        DNode dNode = dElement.getFirstDChild();
        while (dNode != null) {
            if (dNode.getNameId() == 65) {
                DElement dElement2 = (DElement)dNode;
                String string = dElement2.getAttribute(63);
                String string2 = dElement2.getAttribute(114);
                if (string != null && string2 != null) {
                    properties.put(string, string2);
                }
            }
            dNode = dNode.next;
        }
        hashtable.put("elementProperties", properties);
    }

    private static String encodeWhiteSpace(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

