/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.FontProvider;
import ice.pilots.html4.JavaFontProvider;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FontCache {
    private static String defaultFontFamily = "Serif";
    private static int baseFontSize = 10;
    private static final int defaultFontStyle = 0;
    static int minFontSize = 4;
    private Font fallbackFont;
    private float DPI = 120.0f;
    private static final int MAX_ISO8859_1_CHAR = 255;
    private boolean messageShown;
    private int fontCreations;
    private int cacheFetches;
    private int localCacheResets;
    private final int[] fontMuls = new int[]{256, 307, 369, 442, 531, 637, 764, 850};
    private Hashtable fontMetricsCache = new Hashtable();
    private int LOCAL_FONT_CACHE_SIZE = 5;
    private Font[] localCache = new Font[this.LOCAL_FONT_CACHE_SIZE];
    private boolean traceFonts = Debug.trace && Defs.sysPropertyBoolean("ice.pilots.html4.traceFonts");
    private FontProvider[] fontProviders;

    public FontCache() {
        this.init("ice.pilots.html4.addonFontProviders");
    }

    public FontCache(String addOnProvider) {
        this.init(addOnProvider);
    }

    private void traceFonts(String[] families) {
        int N = families.length;
        StringBuffer sb = new StringBuffer();
        sb.append("Known families: " + N);
        for (int i = 0; i != N; ++i) {
            sb.append("\n\t");
            sb.append(families[i]);
        }
        if (Debug.trace) {
            Debug.trace(sb.toString());
        }
    }

    private void traceFontMetrics(FontMetrics fm) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\tfont: ");
        sb.append(fm.getFont().toString());
        sb.append("\n\tascent: ");
        sb.append(fm.getAscent());
        sb.append(", descent: ");
        sb.append(fm.getDescent());
        sb.append(", height: ");
        sb.append(fm.getHeight());
        sb.append(", max-ascent: ");
        sb.append(fm.getMaxAscent());
        sb.append(", max-descent: ");
        sb.append(fm.getMaxDescent());
        sb.append("\n\tmax-advance: ");
        sb.append(fm.getMaxAdvance());
        sb.append(", test-width: ");
        sb.append(fm.stringWidth("Hello, world!"));
        if (Debug.trace) {
            Debug.trace(sb.toString());
        }
    }

    protected void init(String addOnProviders) {
        FontProvider prov;
        try {
            int t = Toolkit.getDefaultToolkit().getScreenResolution();
            this.DPI = t;
        }
        catch (Exception ex) {
            this.DPI = 120.0f;
        }
        String temp = Defs.sysProperty(addOnProviders, "JavaVM");
        boolean javaAdded = false;
        Vector<JavaFontProvider> providers = new Vector<JavaFontProvider>();
        if (temp != null) {
            StringTokenizer st = new StringTokenizer(temp, ",");
            while (st.hasMoreTokens()) {
                temp = st.nextToken();
                if ("JavaVM".equalsIgnoreCase(temp)) {
                    prov = new JavaFontProvider();
                    providers.addElement((JavaFontProvider)prov);
                    javaAdded = true;
                    continue;
                }
                try {
                    prov = (FontProvider)Class.forName(temp).newInstance();
                    if (Debug.trace) {
                        Debug.trace("FontProvider instance loaded: " + temp);
                    }
                    providers.addElement((JavaFontProvider)prov);
                }
                catch (Exception e) {
                    if (!Debug.trace) continue;
                    Debug.trace("Exception loading FontProvider: " + temp + ", ex: " + e);
                }
            }
        }
        if (!javaAdded) {
            prov = new JavaFontProvider();
            providers.addElement((JavaFontProvider)prov);
        }
        this.fontProviders = new FontProvider[providers.size()];
        for (int idx = 0; idx < this.fontProviders.length; ++idx) {
            this.fontProviders[idx] = (FontProvider)providers.elementAt(idx);
        }
    }

    public Font getTestedFont(char[] text, int start, int limit, CSSAttribs css) {
        Font f = null;
        FontMetrics fm = null;
        if (css != null && this.canDisplay(f = (fm = this.getFontMetrics(css.font_family, css.font_style, css.font_size)).getFont(), text, start, limit)) {
            return f;
        }
        for (int fdx = 0; fdx < this.localCache.length; ++fdx) {
            f = this.localCache[fdx];
            if (f == null || !this.canDisplay(f, text, start, limit)) continue;
            css.font_family = f.getFamily();
            f = this.getFontMetrics(css.font_family, css.font_style, css.font_size).getFont();
            return f;
        }
        for (int idx = 0; idx < this.fontProviders.length; ++idx) {
            String[] families = this.fontProviders[idx].getFontFamilies();
            for (int i = 0; i < families.length; ++i) {
                f = this.fontProviders[idx].getFont(families[i], css.font_style, css.font_size);
                if (f == null || !this.canDisplay(f, text, start, limit)) continue;
                fm = this.fontProviders[idx].getFontMetrics(f);
                this.addToFontMetricsCache(families[i], css.font_style, css.font_size, fm);
                this.addToLocalFamilyCache(f);
                css.font_family = families[i];
                return f;
            }
        }
        if (this.fallbackFont == null) {
            f = this.loadFailureFont(css.font_family, css.font_size, css.font_style);
        } else {
            f = this.fallbackFont;
            css.font_family = defaultFontFamily;
        }
        if (Debug.trace) {
            // empty if block
        }
        return f;
    }

    public Font getTestedFont(String text, CSSAttribs css) {
        Font f = null;
        FontMetrics fm = this.getFontMetrics(css.font_family, css.font_style, css.font_size);
        f = fm.getFont();
        if (this.canDisplay(f, text)) {
            return f;
        }
        for (int fdx = 0; fdx < this.localCache.length; ++fdx) {
            f = this.localCache[fdx];
            if (f == null || !this.canDisplay(f, text)) continue;
            css.font_family = this.getSupportedFontFamily(f.getFamily());
            f = this.getFontMetrics(css.font_family, css.font_style, css.font_size).getFont();
            return f;
        }
        for (int idx = 0; idx < this.fontProviders.length; ++idx) {
            String[] families = this.fontProviders[idx].getFontFamilies();
            for (int i = 0; i < families.length; ++i) {
                f = this.fontProviders[idx].getFont(families[i], css.font_style, css.font_size);
                if (f == null || !this.canDisplay(f, text)) continue;
                fm = this.fontProviders[idx].getFontMetrics(f);
                this.addToFontMetricsCache(families[i], css.font_style, css.font_size, fm);
                this.addToLocalFamilyCache(f);
                css.font_family = families[i];
                return f;
            }
        }
        if (this.fallbackFont == null) {
            f = this.loadFailureFont(css.font_family, css.font_size, css.font_style);
        } else {
            f = this.fallbackFont;
            css.font_family = defaultFontFamily;
        }
        if (Debug.trace) {
            // empty if block
        }
        return f;
    }

    private Font loadFailureFont(String family, int size, int style) {
        Font returnVal = null;
        for (int idx = 0; idx < this.fontProviders.length; ++idx) {
            returnVal = this.fontProviders[idx].getFont(family, style, size);
            if (returnVal == null) continue;
            return returnVal;
        }
        Debug.trace("No FontProvider able to load the fallback font family: " + family);
        return null;
    }

    private boolean canDisplay(Font f, char[] text, int start, int length) {
        try {
            Class<?> c = f.getClass();
            Class[] classArray = new Class[]{text.getClass(), Integer.TYPE, Integer.TYPE};
            Method m = c.getMethod("canDisplayUpTo", classArray);
            Object[] objArray = new Object[]{text, new Integer(start), new Integer(length)};
            Object res = m.invoke((Object)f, objArray);
            int i = (Integer)res;
            if (i == -1) {
                return true;
            }
            if (i == length - start) {
                return true;
            }
            for (int idx = i; idx < length; ++idx) {
                if (text[idx] <= '\u00ff') continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            if (Debug.trace && !this.messageShown) {
                Debug.p("canDisplay Exception in char[] Introspection test, One warning only, continuing... ");
                this.messageShown = true;
            }
            return true;
        }
    }

    private boolean canDisplay(Font f, String text) {
        try {
            Class<?> c = f.getClass();
            Class[] classArray = new Class[]{text.getClass()};
            Method m = c.getMethod("canDisplayUpTo", classArray);
            Object[] objArray = new Object[]{text};
            Object res = m.invoke((Object)f, objArray);
            int i = (Integer)res;
            if (i == -1) {
                return true;
            }
            if (i == text.length()) {
                return true;
            }
            for (int idx = i; idx < text.length(); ++idx) {
                char chr = text.charAt(idx);
                if (chr <= '\u00ff') continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            if (Debug.trace && !this.messageShown) {
                Debug.p("canDisplay Exception in String introspection test, One warning only, continuing...  ");
                this.messageShown = true;
            }
            return true;
        }
    }

    private void addToLocalFamilyCache(Font f) {
        String fam = f.getFamily();
        for (int idx = 0; idx < this.localCache.length; ++idx) {
            if (this.localCache[idx] != null) {
                if (!fam.equals(this.localCache[idx].getFamily())) continue;
                return;
            }
            this.localCache[idx] = f;
            return;
        }
        ++this.localCacheResets;
        this.localCache = new Font[this.LOCAL_FONT_CACHE_SIZE];
        this.localCache[0] = f;
    }

    float getScreenResolution() {
        return this.DPI;
    }

    public String getDefaultFontFamily() {
        return defaultFontFamily;
    }

    String getSupportedFontFamily(String listOfNames) {
        if (listOfNames.equals("")) {
            return defaultFontFamily;
        }
        StringTokenizer st = new StringTokenizer(listOfNames, ",");
        while (st.hasMoreTokens()) {
            String fontFamily = st.nextToken().trim();
            if (fontFamily.startsWith("\"") || fontFamily.startsWith("'")) {
                fontFamily = fontFamily.substring(1, fontFamily.length());
            }
            if (fontFamily.endsWith("\"") || fontFamily.endsWith("'")) {
                fontFamily = fontFamily.substring(0, fontFamily.length() - 1);
            }
            if (!this.fontFamilySupported(fontFamily = fontFamily.trim())) continue;
            return fontFamily;
        }
        return defaultFontFamily;
    }

    private boolean fontFamilySupported(String fname) {
        for (int idx = 0; idx < this.fontProviders.length; ++idx) {
            if (!this.fontProviders[idx].isFamilySupported(fname)) continue;
            return true;
        }
        return false;
    }

    FontMetrics getFontMetrics(String fontFamily, int fontStyle, int fontSize) {
        FontMetrics fm = null;
        String key = this.getKey(fontFamily, fontStyle, fontSize);
        fm = (FontMetrics)this.fontMetricsCache.get(key);
        if (fm == null) {
            ++this.cacheFetches;
            this.loadNewFont(fontFamily, fontStyle, fontSize);
            fm = (FontMetrics)this.fontMetricsCache.get(key);
            ++this.fontCreations;
        } else {
            ++this.cacheFetches;
        }
        return fm;
    }

    private Font loadNewFont(String fontFamily, int fontStyle, int fontSize) {
        Font f = null;
        FontMetrics fm = null;
        for (int idx = 0; idx < this.fontProviders.length; ++idx) {
            if (!this.fontProviders[idx].isFamilySupported(fontFamily) || (f = this.fontProviders[idx].getFont(fontFamily, fontStyle, fontSize)) == null) continue;
            fm = this.fontProviders[idx].getFontMetrics(f);
            if (this.traceFonts) {
                this.traceFontMetrics(fm);
            }
            this.addToFontMetricsCache(fontFamily, fontStyle, fontSize, fm);
            return f;
        }
        return this.fallbackFont;
    }

    private void addToFontMetricsCache(String fontFamily, int fontStyle, int fontSize, FontMetrics fontMetrics) {
        String key = this.getKey(fontFamily, fontStyle, fontSize);
        this.fontMetricsCache.put(key, fontMetrics);
    }

    public void clear() {
        this.fontMetricsCache.clear();
    }

    void setBaseFontFamily(String fontFamily) {
        defaultFontFamily = new String(fontFamily);
        this.loadDefault();
    }

    void setBaseFontSize(int t) {
        baseFontSize = t;
        this.loadDefault();
    }

    void setMinFontSize(int t) {
        minFontSize = t;
        this.loadDefault();
    }

    private void loadDefault() {
        this.fallbackFont = new Font(defaultFontFamily, 0, baseFontSize);
    }

    int getFontSizeAbs(int fontLevel, int zoom) {
        if (fontLevel < 0) {
            fontLevel = 0;
        } else if (fontLevel > 7) {
            fontLevel = 7;
        }
        fontLevel = baseFontSize * this.fontMuls[fontLevel] >> 8;
        if (zoom != 256 && (fontLevel = fontLevel * zoom >> 8) < minFontSize) {
            fontLevel = minFontSize;
        }
        return fontLevel;
    }

    int getFontSizeRel(int fontLevel, int prevSize) {
        if (fontLevel == 0) {
            return prevSize;
        }
        if (fontLevel < 0) {
            while (fontLevel < 0) {
                prevSize = prevSize * 256 / 307;
                ++fontLevel;
            }
        } else if (fontLevel > 0) {
            while (fontLevel > 0) {
                prevSize = prevSize * 307 >> 8;
                --fontLevel;
            }
        }
        if (prevSize < minFontSize) {
            prevSize = minFontSize;
        }
        return prevSize;
    }

    private String getKey(String fontFamily, int fontStyle, int fontSize) {
        StringBuffer sb = new StringBuffer(CharKit.toLowerCase(fontFamily)).append("_").append(fontStyle).append("_").append(fontSize);
        return sb.toString();
    }

    public String toString() {
        return this.fontProviders[0].toString();
    }
}

