/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.AttributeSelector;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSLex;
import ice.pilots.html4.CSSLexCallback;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DRuleList;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.Names;
import ice.pilots.html4.Selector;
import ice.pilots.html4.SimpleSelector;
import ice.pilots.html4.StormData;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class CSSBuilder
implements CSSLexCallback {
    private String baseUrl;
    private DStyleSheet styleSheet;
    private Selector[] selectors = new Selector[32];
    private int numSelectors = 0;
    private Selector sel = null;
    private SimpleSelector simple = null;
    private CSSDecl firstDecl = null;
    private CSSDecl lastDecl = null;
    private DCSSRule mediaRule = null;
    private boolean importAllowed = true;
    private int defaultNamespace;
    private Hashtable nsPrefixes = new Hashtable();
    private StormData sdata;
    private Names names;
    private DDocument _doc;

    public CSSBuilder(DDocument doc) {
        this.sdata = doc.getDom().getStormData();
        this._doc = doc;
        this.names = doc.getNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(DStyleSheet ss, String url) throws IOException {
        Reader r = this._doc.openUrlReader(url);
        try {
            this.build(ss, r, url);
        }
        finally {
            r.close();
        }
    }

    public void build(DStyleSheet ss, Reader r, String baseUrl) throws IOException {
        this.baseUrl = baseUrl;
        this.styleSheet = ss;
        this.defaultNamespace = ss.defaultNamespace;
        CSSLex lex = new CSSLex();
        lex.setLexCallback(this);
        lex.setReader(r);
        lex.parse();
    }

    public void startStylesheet() {
    }

    public void endStylesheet() {
        this.baseUrl = null;
        this.styleSheet = null;
        this.numSelectors = 0;
        this.sel = null;
        this.simple = null;
        this.lastDecl = null;
        this.firstDecl = null;
        this.mediaRule = null;
        this.importAllowed = true;
    }

    public void atRule(char[] buf, int offset, int length) {
        char c = buf[offset];
        int offset2 = offset + length;
        if (!(!this.importAllowed || this.sdata.getLoadSingleOnly() || buf[offset] != 'i' && buf[offset] != 'I' || buf[offset + 1] != 'm' && buf[offset + 1] != 'M' || buf[offset + 2] != 'p' && buf[offset + 2] != 'P' || buf[offset + 3] != 'o' && buf[offset + 3] != 'O' || buf[offset + 4] != 'r' && buf[offset + 4] != 'R' || buf[offset + 5] != 't' && buf[offset + 5] != 'T')) {
            String loc;
            int _index1 = CSSUtil.findNonSpace(buf, offset += 6, --offset2);
            int _index2 = offset2;
            int _char = -1;
            boolean _inDoubleQuote = false;
            boolean _inSingleQuote = false;
            for (int i = _index1; i <= offset2; ++i) {
                if (buf[i] == '(' || buf[i] == '\"' || buf[i] == '\'') {
                    if (_char == -1) {
                        _char = buf[i];
                        continue;
                    }
                    if (buf[i] == '\"') {
                        if (_char == 34) {
                            _index2 = i;
                            break;
                        }
                        if (_inSingleQuote) continue;
                        _inDoubleQuote = !_inDoubleQuote;
                        continue;
                    }
                    if (buf[i] != '\'') continue;
                    if (_char == 39) {
                        _index2 = i;
                        break;
                    }
                    if (_inDoubleQuote) continue;
                    _inSingleQuote = !_inSingleQuote;
                    continue;
                }
                if (buf[i] != ')' || _char != 40 || _inDoubleQuote || _inSingleQuote) continue;
                _index2 = i;
                break;
            }
            if ((loc = CSSUtil.parseUrl(buf, _index1, _index2)) == null) {
                return;
            }
            String url = this._doc.resolveUrl(this.baseUrl, loc);
            if ((_index2 = CSSUtil.findWhitespace(buf, _index2, offset2)) < 0) {
                _index2 = offset2;
            }
            DCSSRule r = new DCSSRule(3, this.styleSheet, null);
            String m = new String(buf, _index2, offset2 - _index2);
            r.mediaList.setCssText(m);
            DStyleSheet ss = this._doc.getDom().createDStyleSheet(this.defaultNamespace, null, this.styleSheet, r);
            ss.getMedia().setMediaText(m);
            r.importedStyleSheet = ss;
            r.href = url;
            ss.setHref(r.href);
            ((DRuleList)this.styleSheet.getCssRules()).addRule(r);
            CSSBuilder b = new CSSBuilder(this._doc);
            try {
                b.build(ss, url);
            }
            catch (IOException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
            }
        } else if (c == 'm' || c == 'M') {
            this.mediaRule = new DCSSRule(4, this.styleSheet, null);
            this.mediaRule.mediaList.setCssText(new String(buf, offset += 5, offset2 - offset));
            ((DRuleList)this.styleSheet.getCssRules()).addRule(this.mediaRule);
        } else if (c == 'n' || c == 'N') {
            int nsId;
            String prefix = null;
            String url = null;
            int idx = CSSUtil.findNonSpace(buf, offset += 9, offset2);
            int idx2 = CSSUtil.findWhitespace(buf, idx, offset2);
            if (idx2 > idx) {
                int idx3 = CSSUtil.findNonSpace(buf, idx2, offset2);
                if (idx3 < 0) {
                    url = CSSUtil.parseUrl(buf, idx, idx2);
                } else {
                    int idx4 = CSSUtil.findWhitespace(buf, idx3, offset2);
                    if (idx4 < 0) {
                        idx4 = offset2;
                    }
                    prefix = new String(buf, idx, idx2 - idx);
                    url = CSSUtil.parseUrl(buf, idx3, idx4);
                }
            } else {
                url = CSSUtil.parseUrl(buf, idx, offset2);
            }
            if (url != null && (nsId = this.names.getNamespace(url)) >= 0) {
                if (prefix != null) {
                    this.nsPrefixes.put(prefix, new Integer(nsId));
                } else {
                    this.defaultNamespace = nsId;
                }
            }
        }
    }

    public void startBlock() {
        this.importAllowed = false;
    }

    public void endBlock() {
        if (this.mediaRule != null) {
            this.mediaRule = null;
        }
    }

    public void startSelector() {
        this.importAllowed = false;
        this.sel = new Selector();
    }

    public void endSelector() {
        if (this.simple != null) {
            this.sel.addSimpleSelector(this.simple);
        }
        this.sel.computeWeight();
        if (!this.sel.isEmpty()) {
            if (this.numSelectors >= this.selectors.length) {
                Selector[] tmp = new Selector[this.selectors.length * 2];
                System.arraycopy(this.selectors, 0, tmp, 0, this.selectors.length);
                this.selectors = tmp;
            }
            this.selectors[this.numSelectors++] = this.sel;
        }
        this.sel = null;
        this.simple = null;
    }

    public void selectorCombinator(char c) {
        if (this.simple != null) {
            this.simple.combinator = c;
            this.sel.addSimpleSelector(this.simple);
            this.simple = null;
        }
    }

    public void typeSelector(char[] buf, int offset, int length, int prefixLength) {
        int id = 0;
        if (buf[offset] != '*') {
            Integer i;
            int nsId = this.defaultNamespace;
            if (prefixLength > 0 && (i = (Integer)this.nsPrefixes.get(new String(buf, offset, prefixLength - 1))) != null) {
                nsId = i;
            }
            id = this.names.getTagId(nsId, buf, offset + prefixLength, length - prefixLength);
        }
        if (this.simple != null) {
            this.sel.addSimpleSelector(this.simple);
        }
        this.simple = new SimpleSelector(this.sdata.names, id);
    }

    public void attributeSelector(char[] buf, int offset, int length) {
        String str = new String(buf, offset, length);
        String name = null;
        String value = null;
        int type = 0;
        int i = str.indexOf(61);
        if (i > 0) {
            char c;
            value = str.substring(i + 1).trim();
            if (value.length() > 1 && ((c = value.charAt(0)) == '\'' || c == '\"')) {
                value = value.substring(1, value.length() - 1);
            }
            if ((c = str.charAt(i - 1)) == '~') {
                type = 1;
                --i;
            } else if (c == '|') {
                type = 2;
                --i;
            }
            name = str.substring(0, i).trim();
        } else {
            name = str.trim();
        }
        if (name != null && name.length() > 0) {
            if (this.simple == null) {
                this.simple = new SimpleSelector(this.sdata.names, 0);
            }
            int attrId = this.names.getAttrId(3, name);
            AttributeSelector s = new AttributeSelector(this.sdata.names, attrId, value, type);
            this.simple.addAttributeSelector(s);
        }
    }

    public void classSelector(char[] buf, int offset, int length) {
        if (this.simple == null) {
            this.simple = new SimpleSelector(this.sdata.names, 0);
        }
        String val = new String(buf, offset, length);
        AttributeSelector s = new AttributeSelector(this.sdata.names, 21, val, 1);
        this.simple.addAttributeSelector(s);
    }

    public void pseudoSelector(char[] buf, int offset, int length) {
        if (this.simple == null) {
            this.simple = new SimpleSelector(this.sdata.names, 0);
        }
        String val = new String(buf, offset, length);
        this.simple.addPseudoSelector(val);
    }

    public void idSelector(char[] buf, int offset, int length) {
        if (this.simple == null) {
            this.simple = new SimpleSelector(this.sdata.names, 0);
        }
        String val = new String(buf, offset, length);
        this.simple.setIDSelector(val);
    }

    public void startDeclBlock() {
    }

    public void endDeclBlock() {
        DRuleList rlist = null;
        DCSSRule parentRule = null;
        if (this.mediaRule != null) {
            rlist = this.mediaRule.ruleList;
            parentRule = this.mediaRule;
        } else {
            rlist = (DRuleList)this.styleSheet.getCssRules();
        }
        for (int i = 0; i < this.numSelectors; ++i) {
            DCSSRule r = new DCSSRule(1, this.styleSheet, parentRule);
            DStyleDeclaration d = this._doc.getDom().createDStyleDeclaration(r, null);
            d.setFirstDecl(this.firstDecl);
            r.setStyleRule(this.selectors[i], d);
            rlist.addRule(r);
            this.selectors[i] = null;
        }
        this.numSelectors = 0;
        this.lastDecl = null;
        this.firstDecl = null;
    }

    public void resetSelector() {
        this.sel = null;
        this.simple = null;
    }

    public void declaration(char[] buf, int propOffset, int propLength, int valueOffset, int valueLength) {
        String cssBaseUrl = this.styleSheet != null && this.styleSheet.getHref() != null ? this.styleSheet.getHref() : this._doc.getBaseUrl();
        CSSDecl d = CSSLookup.parseDeclaration(this.sdata.fontCache, buf, propOffset, propLength, valueOffset, valueLength, cssBaseUrl);
        if (d != null) {
            CSSDecl dd = d;
            while (dd.next != null) {
                dd = dd.next;
            }
            if (this.firstDecl == null) {
                this.firstDecl = d;
                this.lastDecl = dd;
            } else {
                this.lastDecl.next = d;
                this.lastDecl = dd;
            }
        }
    }
}

