/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.proxy;

public class ProxyMessage {
    static final int ACTION_ONCONNECT = 1;
    static final int ACTION_ONMESSAGE = 2;
    static final int ACTION_ONSEND = 3;
    static final int ACTION_ONCLOSE = 4;
    static String SEPARATOR = ";";
    private int type;
    private String _msg;
    private String clientId;

    public ProxyMessage(String wsMsg) throws Exception {
        this.parseMessage(wsMsg);
    }

    public int getType() {
        return this.type;
    }

    String getClientId() {
        return this.clientId;
    }

    String getMessage() {
        return this._msg;
    }

    void parseMessage(String message) throws Exception {
        int actionIdIndex = message.indexOf(SEPARATOR);
        String actionId = message.substring(0, actionIdIndex);
        if (actionIdIndex == -1) {
            throw new Exception();
        }
        switch (Integer.parseInt(actionId)) {
            case 1: {
                this.type = 1;
                break;
            }
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            case 4: {
                this.type = 4;
            }
        }
        message = message.substring(actionIdIndex + 1);
        if (this.type == 1 || this.type == 4) {
            this.clientId = message;
            return;
        }
        int clientIdIndex = message.indexOf(SEPARATOR);
        if (clientIdIndex == -1) {
            throw new Exception();
        }
        this.clientId = message.substring(0, clientIdIndex);
        if (this.type == 2) {
            int msgIndex = message.indexOf(SEPARATOR);
            if (msgIndex == -1) {
                throw new Exception();
            }
            this._msg = message.substring(msgIndex + 1);
        }
    }
}

