/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.proxy;

import coldfusion.log.CFLogs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class ProxyConnection {
    public static final int IDLE = 0;
    public static final int BUSY = 1;
    public static final int SELECTED = 2;
    public static final int DIRTY = -1;
    private AsynchronousSocketChannel connectionObj;
    private int connectionId;
    private Queue<Object[]> pendingMsgsFromClient;
    private AtomicInteger state;

    public ProxyConnection(AsynchronousSocketChannel connection) {
        this.connectionObj = connection;
        this.pendingMsgsFromClient = new ArrayDeque<Object[]>();
        this.state = new AtomicInteger(0);
        Random rand = new Random();
        this.connectionId = rand.nextInt(1000);
    }

    public void setState(int state) {
        this.state.set(state);
    }

    public int getState() {
        return this.state.get();
    }

    boolean isOpen() {
        return this.connectionObj.isOpen();
    }

    void write(ByteBuffer buffer) {
        Future<Integer> writeResult = this.connectionObj.write(buffer);
        try {
            writeResult.get();
            CFLogs.WEBSOCKETPROXY_LOG.info((Object)"Write Complete.");
            this.setState(0);
        }
        catch (InterruptedException e) {
            CFLogs.WEBSOCKETPROXY_LOG.info((Object)"Write operation is interrupted.");
            if (writeResult.isDone()) {
                this.setState(0);
            } else {
                this.setState(-1);
            }
        }
        catch (ExecutionException e) {
            CFLogs.WEBSOCKETPROXY_LOG.info((Object)"Error occurred while writing message to proxy.");
            this.setState(-1);
        }
    }

    void addToClientsPendingMessages(Object[] msg) {
        this.pendingMsgsFromClient.add(msg);
    }

    Object[] getClientPendingMessage() {
        return this.pendingMsgsFromClient.poll();
    }

    public void shutdown() {
        try {
            this.connectionObj.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void read(ByteBuffer readBuffer, CompletionHandler handler) {
        this.connectionObj.read(readBuffer, null, handler);
    }

    public int getConnectionId() {
        return this.connectionId;
    }
}

