/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.messaging;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.tagext.net.websocket.messaging.Channel;
import coldfusion.tagext.net.websocket.messaging.ChannelConstants;
import coldfusion.tagext.net.websocket.messaging.Subscriber;
import coldfusion.tagext.net.websocket.messaging.SubscriberData;
import coldfusion.util.CaseInsensitiveHashtable;
import jakarta.servlet.ServletContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelManager {
    private final Map<String, Channel> channelMap = new CaseInsensitiveHashtable();
    private final Map<String, SubscriberData> subscriberDataStore = new ConcurrentHashMap<String, SubscriberData>();
    private final Map<String, String> maskedKeyVsCFAuthMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> maskedKeyVsWebRootPath = new ConcurrentHashMap<String, String>();
    private static Map appNameVsChannelManager = new CaseInsensitiveHashtable();

    public static ChannelManager getInstance(String appName) {
        ChannelManager instance = (ChannelManager)appNameVsChannelManager.get(appName);
        if (instance == null) {
            instance = new ChannelManager();
            appNameVsChannelManager.put(appName, instance);
        }
        return instance;
    }

    public static Map getAppNameVsChannelManagerMap() {
        return appNameVsChannelManager;
    }

    public void initializeChannel(ServletContext servletContext, String appName, String channelName, TemplateProxy proxy) {
        if (!proxy.isInstanceOf(ChannelConstants.ListenerBaseComponent)) {
            throw new InvalidListenerException(proxy.getCfcFullyQualifiedName(), channelName);
        }
        Channel channel = new Channel(this, channelName, servletContext, appName, proxy);
        this.channelMap.put(channelName, channel);
    }

    public Channel getChannel(String channelName) {
        return this.getChannel(channelName, false, false);
    }

    public Channel getChannel(String channelName, boolean createSubChannel) {
        return this.getChannel(channelName, createSubChannel, false);
    }

    public Channel getChannel(String channelName, boolean createSubChannel, boolean returnParentIfNoChild) {
        String[] subChannels = channelName.split("\\.", 2);
        Channel channel = this.channelMap.get(subChannels[0]);
        if (channel != null && subChannels.length > 1) {
            channel = channel.getChildChannel(subChannels[1], createSubChannel, returnParentIfNoChild);
        }
        return channel;
    }

    public SubscriberData getSubscriberData(String aSubscriberId) {
        return this.subscriberDataStore.get(aSubscriberId);
    }

    public void addSubscriberData(SubscriberData aSubscriberData) {
        this.subscriberDataStore.put(aSubscriberData.getSubscriber().getId(), aSubscriberData);
    }

    public Subscriber getSubscriber(String aSubscriberId) {
        SubscriberData data = this.subscriberDataStore.get(aSubscriberId);
        return data == null ? null : data.getSubscriber();
    }

    public void removeSubscriber(Subscriber subscriber) {
        this.subscriberDataStore.remove(subscriber.getId());
    }

    public Map<String, Channel> getChannelMap() {
        return this.channelMap;
    }

    public void setMaskedKeyVsWebRootPath(String maskedKey, String webRootPath) {
        this.maskedKeyVsWebRootPath.put(maskedKey, webRootPath);
    }

    public String getWebRootPath(String maskedAuthkey) {
        return this.maskedKeyVsWebRootPath.get(maskedAuthkey);
    }

    public String clearWebRootPathEntry(String maskedKey) {
        return this.maskedKeyVsWebRootPath.remove(maskedKey);
    }

    public void setMaskedKeyVsCFAuth(String maskedAuthkey, String orgAuthKey) {
        this.maskedKeyVsCFAuthMap.put(maskedAuthkey, orgAuthKey);
    }

    public String getCFAuthKey(String maskedAuthkey) {
        return this.maskedKeyVsCFAuthMap.get(maskedAuthkey);
    }

    public String clearCFAuthKeyEntry(String maskedAuthkey) {
        return this.maskedKeyVsCFAuthMap.remove(maskedAuthkey);
    }

    public static void clearApplicationData(String appName) {
        ChannelManager managerInstance = (ChannelManager)appNameVsChannelManager.remove(appName);
        if (managerInstance != null) {
            managerInstance.subscriberDataStore.clear();
            managerInstance.maskedKeyVsCFAuthMap.clear();
            managerInstance.maskedKeyVsWebRootPath.clear();
            for (Map.Entry<String, Channel> channelEntry : managerInstance.channelMap.entrySet()) {
                Channel channel = channelEntry.getValue();
                channel.stop();
            }
            managerInstance.channelMap.clear();
        }
    }

    public static class InvalidListenerException
    extends ApplicationException {
        public String cfc;
        public String channel;

        public InvalidListenerException(String cfc, String channel) {
            this.cfc = cfc;
            this.channel = channel;
        }
    }
}

