/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.messaging;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cloner;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.WebSocketUtil;
import coldfusion.tagext.net.websocket.messaging.ChannelException;
import coldfusion.tagext.net.websocket.messaging.ChannelListener;
import coldfusion.tagext.net.websocket.messaging.ChannelManager;
import coldfusion.tagext.net.websocket.messaging.ChannelRequestHeader;
import coldfusion.tagext.net.websocket.messaging.Subscriber;
import coldfusion.tagext.net.websocket.messaging.SubscriberData;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.TokenMap;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import coldfusion.util.CaseInsensitiveHashtable;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Channel {
    private String name;
    private String appName;
    private ServletContext mServletContext;
    private List<Subscriber> subscriberList = Collections.synchronizedList(new LinkedList());
    private ChannelListener channelListener;
    private final Map childChannelMap = new CaseInsensitiveHashtable();
    private Channel parentChannel;
    private ChannelManager channelManager;
    private static Logger exceptionLogger = Logger.getLogger(Channel.class);
    private static WebSocketService webSocketService = ServiceFactory.getWebsocketService();

    private Channel(ChannelManager channelManager, String aName, ServletContext servletContext) {
        this.name = aName;
        this.channelManager = channelManager;
        this.mServletContext = servletContext;
        this.appName = FusionContext.getCurrent() != null ? FusionContext.getCurrent().getApplicationName() : "";
    }

    public Channel(ChannelManager channelManager, String aName, ServletContext servletContext, String appName, TemplateProxy listenerProxy) {
        this(channelManager, aName, servletContext);
        this.channelListener = new ChannelListener(this, appName, listenerProxy);
    }

    public String getName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.mServletContext;
    }

    public ChannelListener getChannelListener() {
        return this.channelListener;
    }

    public void setChannelListener(ChannelListener channelListener) {
        this.channelListener = channelListener;
    }

    public void setParentChannel(Channel mChannel) {
        this.parentChannel = mChannel;
    }

    public Channel addSubChannel(String channelName) {
        String[] subChannels = channelName.split("\\.", 2);
        if (subChannels.length == 1) {
            String fullyQualifiedChannelName = this.name + "." + channelName;
            Channel lChannel = new Channel(this.channelManager, fullyQualifiedChannelName, this.mServletContext);
            lChannel.setChannelListener(this.channelListener);
            this.childChannelMap.put(channelName, lChannel);
            lChannel.setParentChannel(this);
            return lChannel;
        }
        Channel mchannel = (Channel)this.childChannelMap.get(subChannels[0]);
        if (mchannel == null) {
            String fullyQualifiedChannelName = this.name + "." + subChannels[0];
            mchannel = new Channel(this.channelManager, fullyQualifiedChannelName, this.mServletContext);
            mchannel.setChannelListener(this.channelListener);
            mchannel.setParentChannel(this);
            this.childChannelMap.put(subChannels[0], mchannel);
        }
        mchannel = mchannel.addSubChannel(subChannels[1]);
        return mchannel;
    }

    public Channel getChannel(String subChannelId) {
        return (Channel)this.childChannelMap.get(subChannelId);
    }

    public List<String> getAllSubChannels() {
        ArrayList<String> subChannelList = new ArrayList<String>();
        for (Object obj : this.childChannelMap.keySet()) {
            String subChannelName = (String)obj;
            subChannelList.add(this.name + "." + subChannelName);
            Channel subChannel = (Channel)this.childChannelMap.get(subChannelName);
            if (subChannel == null) continue;
            subChannelList.addAll(subChannel.getAllSubChannels());
        }
        return subChannelList;
    }

    public Channel getChildChannel(String subChannelId, boolean createsubChannel, boolean returnParentIfNoChild) {
        String[] subChannels = subChannelId.split("\\.", 2);
        Channel channel = (Channel)this.childChannelMap.get(subChannels[0]);
        if (channel == null) {
            if (createsubChannel) {
                channel = this.addSubChannel(subChannelId);
            } else if (returnParentIfNoChild) {
                channel = this;
            }
        } else if (channel != null && subChannels.length > 1) {
            channel = channel.getChildChannel(subChannels[1], createsubChannel, returnParentIfNoChild);
        }
        return channel;
    }

    public List<Subscriber> getSubscribers() {
        ArrayList<Subscriber> subList = new ArrayList<Subscriber>();
        if (this.subscriberList != null) {
            subList.addAll(this.subscriberList);
        }
        if (this.parentChannel != null) {
            subList.addAll(this.parentChannel.getSubscribers());
        }
        return subList;
    }

    public void subscribe(Subscriber aSubscriber) {
        if (aSubscriber == null) {
            return;
        }
        if (this.subscriberList == null) {
            this.subscriberList = new LinkedList<Subscriber>();
        }
        if (!this.subscriberList.contains(aSubscriber)) {
            this.subscriberList.add(aSubscriber);
        }
    }

    public void unsubscribe(Subscriber aSubscriber) {
        if (this.subscriberList != null && this.subscriberList.remove(aSubscriber)) {
            ChannelRequestHeader subscriberReqHeader = this.getSubscriberInfo(aSubscriber);
            this.channelListener.afterUnsubscribe(aSubscriber.getConnector(), subscriberReqHeader);
        }
        for (Map.Entry entry : this.childChannelMap.entrySet()) {
            Channel mChannel = (Channel)entry.getValue();
            mChannel.unsubscribe(aSubscriber);
        }
    }

    public void broadcastToken(AbstractClientConnection aConnector, TokenMap aToken, ChannelRequestHeader aPublisherRequestHeader) {
        this.broadcastToken(aConnector, aToken, aPublisherRequestHeader, true);
    }

    public void broadcastToken(AbstractClientConnection aConnector, TokenMap aToken, ChannelRequestHeader aPublisherRequestHeader, boolean broadcastToClusterNodes) {
        List<Subscriber> mSubscriberList;
        Object lDataToPublish = this.invoke_BeforePublish_CallBack(aConnector, aToken, aPublisherRequestHeader);
        if (broadcastToClusterNodes && webSocketService.isEnterpriseClusterEnabled()) {
            WebSocketClusterManager clusterManager = WebSocketClusterManager.getInstance();
            String messageStr = WebSocketUtil.serializeMessage(lDataToPublish);
            clusterManager.delegatePublishMessage(this.appName, this.name, messageStr, (Map)aPublisherRequestHeader.getCustomOptionMap());
        }
        if ((mSubscriberList = this.getSubscribers()) != null && mSubscriberList.size() > 0) {
            for (Subscriber lSubscriber : mSubscriberList) {
                try {
                    Object mData;
                    AbstractClientConnection lConnector = ClientConnectionManager.getClientConnection(lSubscriber.getId());
                    ChannelRequestHeader subscriberReqHeader = this.getSubscriberInfo(lSubscriber);
                    TokenMap lToken = new TokenMap();
                    lToken.setMap(aToken.getMap());
                    if (lDataToPublish instanceof Cloneable) {
                        try {
                            mData = Cloner.clone((Cloneable)((Cloneable)lDataToPublish));
                        }
                        catch (Throwable throwable) {
                            mData = "";
                        }
                    } else {
                        mData = lDataToPublish.toString();
                    }
                    if (!this.channelListener.canSendMessage(lConnector, subscriberReqHeader, aConnector, aPublisherRequestHeader, mData)) continue;
                    if ((mData = this.channelListener.beforeSendMessage(lConnector, subscriberReqHeader, mData)) instanceof String) {
                        lToken.setString("data", (String)mData);
                    } else {
                        lToken.setString("data", JSONUtils.serializeJSON((Object)mData, (Object)false, (boolean)false, (boolean)false));
                    }
                    aToken.setString("channelname", (String)subscriberReqHeader.getCustomOptionMap().get((Object)"channelname"));
                    WSTaskProcessor.getTaskProcessor();
                    WSTaskProcessor.sendToken(lConnector, aToken);
                }
                catch (ChannelException ex) {
                    exceptionLogger.error((Object)"error while publishing message", (Throwable)ex);
                    throw ex;
                }
            }
        }
    }

    private Object invoke_BeforePublish_CallBack(AbstractClientConnection aConnector, TokenMap aToken, ChannelRequestHeader aPublisherRequestHeader) {
        Object lData = aToken.getString("data");
        if (((String)lData).length() > webSocketService.getMaxFrameSize() * 1024) {
            if (aConnector != null) {
                WSTaskProcessor.sendErrorToken(aConnector, aToken, 4001, "'Data being published exceeds the limit defined in the Administrator.'");
            }
            throw new PublishDataTooLongException();
        }
        try {
            lData = JSONUtils.deserializeJSON((Object)aToken.getString("data"), (Object)true, (boolean)false);
        }
        catch (JSONUtils.JSONParseException jSONParseException) {
            // empty catch block
        }
        Object lDataToPublish = this.channelListener.beforePublish(aConnector, aPublisherRequestHeader, lData);
        String publisherId = "0";
        if (aConnector != null) {
            publisherId = aConnector.getConnectionId();
        }
        aToken.setString("publisherid", publisherId);
        return lDataToPublish;
    }

    public void stop() {
        this.subscriberList = null;
        for (Map.Entry channelEntry : this.childChannelMap.entrySet()) {
            Channel channel = (Channel)channelEntry.getValue();
            channel.stop();
        }
    }

    public ChannelRequestHeader getSubscriberInfo(Subscriber aSubscriber) {
        SubscriberData sData = this.channelManager.getSubscriberData(aSubscriber.getId());
        if (sData == null) {
            return new ChannelRequestHeader();
        }
        String mChannelId = this.name;
        ChannelRequestHeader mHeader = sData.getWSRequestInfo(mChannelId);
        if (mHeader != null) {
            return mHeader;
        }
        Map msubscriberReqInfoMap = sData.getSubscriberRequestInfoMap();
        while (mChannelId.indexOf(".") > 0) {
            String superChannel = mChannelId.substring(0, mChannelId.lastIndexOf("."));
            if (msubscriberReqInfoMap.containsKey(superChannel)) {
                return (ChannelRequestHeader)msubscriberReqInfoMap.get(superChannel);
            }
            mChannelId = superChannel;
        }
        return new ChannelRequestHeader();
    }

    public static class PublishDataTooLongException
    extends ApplicationException {
        public int max_limit = webSocketService.getMaxFrameSize();
    }
}

