/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.MD5;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SecurityScopeTracker;
import coldfusion.runtime.SessionScope;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.net.websocket.messaging.Channel;
import coldfusion.tagext.net.websocket.messaging.ChannelManager;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.security.Permission;
import java.security.SecureRandom;
import java.util.StringTokenizer;

public class WebSocketTag
extends GenericTag
implements AjaxImport {
    private static final GenericTagPermission tp = new GenericTagPermission("cfwebsocket");
    public static final String IMPORT_TAGNAME = "CFWEBSOCKET";
    public static final String IMPORT_WEBSOCKET_CORE_JS = "/package/cfwebsocketCore.js";
    public static final String IMPORT_CFWEBSOCKET_JS = "/package/cfwebsocketChannel.js";
    private static final String INIT_PREFIX = " ColdFusion.WebSocket.init(";
    private static final String WEBSOCKETS = "websockets";
    private static final SecureRandom secureRandom = new SecureRandom();
    private HtmlAssembler htmlAssembler;
    private String onClose = null;
    private String onError = null;
    private String name = null;
    private String onMessage = null;
    private String onOpen = null;
    private String subscribeTo = null;
    private boolean useCFAuth = true;
    private boolean secure = false;
    private boolean secureAttributeNotSet = true;

    public void setOnClose(String onClose) {
        this.onClose = onClose;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOnMessage(String onMessage) {
        this.onMessage = onMessage;
    }

    public void setOnOpen(String onOpen) {
        this.onOpen = onOpen;
    }

    public void setUseCFAuth(boolean useCFAuth) {
        this.useCFAuth = useCFAuth;
    }

    public void setSubscribeTo(String subscribeTo) {
        this.subscribeTo = subscribeTo;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.secureAttributeNotSet = false;
    }

    protected Permission getPermission() {
        return tp;
    }

    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS(IMPORT_WEBSOCKET_CORE_JS);
        htmlAssembler.importJS(IMPORT_CFWEBSOCKET_JS);
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        WebSocketService wsService = ServiceFactory.getWebsocketService((boolean)true);
        if (!wsService.isWebSocketServiceEnabled() || !wsService.isNormalPortListenerEnabled() && !wsService.isSSLEnabled() && !wsService.isProxyEnabled()) {
            throw new WebSocketServerIsNotRunning();
        }
        this.validateAttribute();
        String maskedID = WebSocketTag.constructMaskedId();
        ChannelManager.getInstance(this.fContext.getApplicationName()).setMaskedKeyVsWebRootPath(maskedID, Utils.expandPath((String)"/", (PageContext)this.pageContext));
        if (this.useCFAuth) {
            String CFAuth;
            if (this.storeSecurityKeyInSession()) {
                Scope _sessionScope = (Scope)this.pageContext.findAttribute("session");
                CFAuth = (String)_sessionScope.get((Object)SecurityScopeTracker.getAppSecureCookieName());
            } else {
                CFAuth = SecurityScopeTracker.getSecurityCookie((PageContext)this.pageContext);
            }
            if (CFAuth != null) {
                ChannelManager.getInstance(this.fContext.getApplicationName()).setMaskedKeyVsCFAuth(maskedID, CFAuth);
            }
        }
        this.htmlAssembler = HtmlAssembler.getInstance((PageContext)this.pageContext, (boolean)false);
        AjaxImportTag.generateImports((String)IMPORT_TAGNAME, (HtmlAssembler)this.htmlAssembler);
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ").appendContent(this.name).appendContent(';');
        this.htmlAssembler.newLine();
        String functionName = this.htmlAssembler.openFunction(WEBSOCKETS, "init", true, true, null);
        this.htmlAssembler.appendContent(this.name).appendContent(" ").appendContent("=").appendContent(INIT_PREFIX).appendContent(this.name, true).appendContent(',').appendContent(this.fContext.getApplicationName(), true).appendContent(',').appendContent(this.secure ? "true" : "false", false).appendContent(',').appendContent(maskedID == null ? null : maskedID, true).appendContent(',').appendContent(this.subscribeTo, true).appendContent(',').appendContent(this.onMessage).appendContent(',').appendContent(this.onOpen).appendContent(',').appendContent(this.onClose).appendContent(',').appendContent(this.onError).appendContent(',').appendContent(Utils.getServletPath((HttpServletRequest)FusionContext.getCurrent().request), true).appendContent(',').appendContent(wsService.isProxyEnabled()).appendContent(')').appendContent(';');
        this.htmlAssembler.closeFunction();
        this.htmlAssembler.setEventOnLoad(functionName);
        this.htmlAssembler.closeScriptTag();
        return 6;
    }

    public int doEndTag() throws JspException {
        try {
            this.htmlAssembler.writeHead(this.out);
            this.htmlAssembler.writeHtml(this.out);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    private void validateAttribute() {
        if (this.subscribeTo != null) {
            ChannelManager channelManager = ChannelManager.getInstance(this.fContext.getApplicationName());
            StringTokenizer lTokenizer = new StringTokenizer(this.subscribeTo, ",");
            while (lTokenizer.hasMoreTokens()) {
                String channelName = lTokenizer.nextToken();
                Channel channel = channelManager.getChannel(channelName, true);
                if (channel != null) continue;
                throw new InvalidSubscribeToEntryException(channelName);
            }
        }
        WebSocketService webSocketService = ServiceFactory.getWebsocketService();
        if (this.secure && !webSocketService.isSSLEnabled()) {
            throw new WebSocketServerSecurePortIsNotRunning();
        }
        if (!(webSocketService.isNormalPortListenerEnabled() || this.secure || this.secureAttributeNotSet)) {
            throw new WebSocketNormalPortIsNotRunning();
        }
        if (this.secureAttributeNotSet && !webSocketService.isNormalPortListenerEnabled() && webSocketService.isSSLEnabled()) {
            this.secure = true;
        }
    }

    private boolean storeSecurityKeyInSession() {
        boolean rc = false;
        Scope _sessionScope = (Scope)this.pageContext.findAttribute("session");
        Scope _applicationScope = (Scope)this.pageContext.findAttribute("application");
        if (_sessionScope instanceof SessionScope && _applicationScope instanceof ApplicationScope && ((ApplicationScope)_applicationScope).getStoreloginCredentialInSession()) {
            rc = true;
        }
        return rc;
    }

    private static String constructMaskedId() {
        String urltoken = "" + secureRandom.nextDouble();
        String cid = null;
        if (urltoken != null) {
            MD5 md5 = new MD5(urltoken);
            try {
                md5.getDigest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            cid = md5.getStringDigest();
        }
        return cid;
    }

    public void release() {
        this.name = null;
        this.onClose = null;
        this.onError = null;
        this.onMessage = null;
        this.onOpen = null;
        this.useCFAuth = true;
        this.subscribeTo = null;
        this.secure = false;
    }

    public static class WebSocketServerIsNotRunning
    extends ApplicationException {
    }

    public static class InvalidSubscribeToEntryException
    extends ApplicationException {
        public String channelName;

        public InvalidSubscribeToEntryException(String channelName) {
            this.channelName = channelName;
        }
    }

    public static class WebSocketServerSecurePortIsNotRunning
    extends ApplicationException {
    }

    public static class WebSocketNormalPortIsNotRunning
    extends ApplicationException {
    }
}

