/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf.customfilters;

import coldfusion.util.IOUtils;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomEncodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jpedal.jbig2.JBIG2Data;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;

public class JBIG2CustomFilter
implements CustomDecodeFilter,
CustomEncodeFilter {
    public ASName getName() {
        return ASName.create((String)"JBIG2Decode");
    }

    public OutputStream encode(OutputStream dstStm, FilterParams filterParams, Object obj) throws CustomFilterException {
        throw new CustomFilterException("Encoding using JBIG2 unsupported");
    }

    public FilterParams updateFilterParams(FilterParams params) {
        return params;
    }

    public InputStream decode(InputStream in, FilterParams filterParams) throws CustomFilterException {
        JBIG2Decoder decoder = new JBIG2Decoder();
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            byte[] data;
            byte[] b = IOUtils.toByteArray((InputStream)in);
            if (filterParams != null && filterParams.containsKey((Object)"JBIG2Globals") && (data = (byte[])filterParams.get((Object)"JBIG2Globals")) != null) {
                decoder.setGlobalData(data);
            }
            JBIG2Data jBIG2Data = new JBIG2Data(b);
            decoder.decodeJBIG2(jBIG2Data);
            decoder.getPageAsJBIG2Bitmap(0).putWriteSafeDataIntoStream(true, (OutputStream)byteOutStream);
        }
        catch (IOException e) {
            throw new CustomFilterException("Could not decode using custom filter", (Throwable)e);
        }
        catch (JBIG2Exception e) {
            throw new CustomFilterException("Could not decode using custom filter", (Throwable)e);
        }
        return new ByteArrayInputStream(byteOutStream.toByteArray());
    }

    public OutputStream encode(OutputStream arg0, FilterParams arg1) throws CustomFilterException {
        return null;
    }
}

