/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.PDFFormException;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;

public class XFDFXMLtoCFStruct {
    private static final String FIELDS = "fields";
    private static final String XFDF = "xfdf";
    private static final String FIELD = "field";
    private static final String VALUE = "value";
    private static final String NAME = "name";

    public static Map parseXMLtoCF(String xml) {
        StringReader stringStream = new StringReader(xml);
        SAXBuilder builder = new SAXBuilder();
        Object returnMap = null;
        try {
            Document doc = builder.build((Reader)stringStream);
            returnMap = XFDFXMLtoCFStruct.visitNodes(doc);
        }
        catch (JDOMException jdomex) {
            throw new PDFException.InvalidDataXMLException();
        }
        catch (IOException ioex) {
            throw new PDFFormException(ioex);
        }
        return (Map)returnMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object visitNodes(Object o) {
        if (o instanceof Element) {
            Struct nodeValueMap = new Struct(5);
            Element element = (Element)o;
            String fieldName = null;
            if (element.getName().equalsIgnoreCase(FIELD)) {
                fieldName = element.getAttribute(NAME).getValue();
            }
            List children = element.getContent();
            Iterator iterator = children.iterator();
            Array translatedChildrenList = new Array(1);
            int i = 0;
            boolean valueNode = false;
            while (iterator.hasNext()) {
                valueNode = false;
                Object child = iterator.next();
                Object transformeChild = XFDFXMLtoCFStruct.visitNodes(child);
                if (transformeChild != null && transformeChild instanceof Map && ((Map)transformeChild).size() != 0) {
                    String valueText = (String)((Map)transformeChild).get(VALUE);
                    if (valueText != null) {
                        ((Map)transformeChild).remove(VALUE);
                        ((Map)transformeChild).put(fieldName, valueText);
                        valueNode = true;
                    }
                    translatedChildrenList.add(transformeChild);
                } else if (transformeChild instanceof String && transformeChild != null && !"".equals(transformeChild)) {
                    translatedChildrenList.add(transformeChild);
                }
                ++i;
            }
            if (i > 1) {
                Map allChildren = XFDFXMLtoCFStruct.convertToMap((List)translatedChildrenList);
                if (FIELDS.equalsIgnoreCase(element.getName()) || XFDF.equalsIgnoreCase(element.getName())) {
                    return allChildren;
                }
                if (allChildren == null || allChildren.size() == 0) return nodeValueMap;
                nodeValueMap.put((Object)element.getAttribute(NAME).getValue(), (Object)allChildren);
                return nodeValueMap;
            } else if (i == 1) {
                if (translatedChildrenList.size() == 0) return nodeValueMap;
                Object firstElement = translatedChildrenList.get(0);
                if (element.getName().equalsIgnoreCase(VALUE)) {
                    nodeValueMap.put((Object)VALUE, firstElement);
                    return nodeValueMap;
                } else {
                    if (firstElement instanceof Map && valueNode) {
                        return firstElement;
                    }
                    if (FIELDS.equalsIgnoreCase(element.getName()) || XFDF.equalsIgnoreCase(element.getName()) || fieldName == null) return firstElement;
                    nodeValueMap.put((Object)fieldName, firstElement);
                }
                return nodeValueMap;
            } else {
                if (i != 0) return nodeValueMap;
                if (fieldName != null && !"".equalsIgnoreCase(fieldName)) {
                    nodeValueMap.put((Object)fieldName, (Object)"");
                    return nodeValueMap;
                } else {
                    if (!"VALUE".equalsIgnoreCase(element.getName())) return nodeValueMap;
                    nodeValueMap.put((Object)VALUE, (Object)"");
                }
            }
            return nodeValueMap;
        }
        if (o instanceof Document) {
            Document doc = (Document)o;
            List children = doc.getContent();
            Iterator iterator = children.iterator();
            if (!iterator.hasNext()) return "";
            Object child = iterator.next();
            return XFDFXMLtoCFStruct.visitNodes(child);
        }
        if (!(o instanceof Text)) return "";
        Text t = (Text)o;
        return t.getText();
    }

    private static Map convertToMap(List elements) {
        Struct resultMap = new Struct();
        for (Object element : elements) {
            if (!(element instanceof Map)) continue;
            resultMap.putAll((Map)element);
        }
        return resultMap;
    }
}

