/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.DataXMLGenerator;
import coldfusion.pdf.FormParamDetail;
import coldfusion.pdf.MatchedNode;
import coldfusion.pdf.PDFFormException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.xfdf.XFDFService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Parent;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class XFDFDataXMLGenerator
extends DataXMLGenerator {
    private Document doc = null;
    private ArrayList subforms = new ArrayList();
    private PDFDocument PDFdoc = null;
    private static final String FIELDS = "fields";
    private static final String FIELD = "field";
    private static final String NAME = "name";
    private static final String XFDF = "xfdf";
    private static final String VALUE = "value";
    public static final String XFDF_START_NODE = "<xfdf xmlns=\"http://ns.adobe.com/xfdf/\" xml:space=\"preserve\">";
    public static final String FIELDS_START_NODE = "<fields>";
    public static final String FIELDS_END_NODE = "</fields>";
    public static final String XFDF_END_NODE = "</xfdf>";
    public static final String XFDF_NAMESPACE = "http://ns.adobe.com/xfdf/";

    public XFDFDataXMLGenerator(PDFDocument PDFdoc) {
        this.PDFdoc = PDFdoc;
    }

    @Override
    public void createFormXMLData(boolean overwritedata) throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException {
        Element fieldsNode = null;
        if (overwritedata) {
            Element xfdf = new Element(XFDF);
            this.doc = new Document(xfdf);
            fieldsNode = new Element(FIELDS);
            xfdf.addContent((Content)fieldsNode);
        } else {
            String previousDataXML = this.getOldDataXML();
            if (previousDataXML != null) {
                StringReader stringStream = new StringReader(previousDataXML);
                SAXBuilder builder = new SAXBuilder();
                try {
                    this.doc = builder.build((Reader)stringStream);
                    List nodes = this.doc.getContent();
                    Element rootNode = (Element)nodes.get(0);
                    boolean hasFieldsElement = false;
                    if (XFDF.equalsIgnoreCase(rootNode.getName())) {
                        List children = rootNode.getContent();
                        for (int i = 0; i < children.size(); ++i) {
                            fieldsNode = (Element)children.get(i);
                            if (!FIELDS.equalsIgnoreCase(fieldsNode.getName())) continue;
                            hasFieldsElement = true;
                            break;
                        }
                    } else {
                        throw new MissingXFDFInXMLException();
                    }
                    if (!hasFieldsElement) {
                        fieldsNode = new Element(FIELDS);
                        rootNode.addContent((Content)fieldsNode);
                    }
                }
                catch (IOException ioex) {
                    throw new PDFFormException(ioex);
                }
                catch (JDOMException jdomex) {
                    throw new PDFFormException(jdomex);
                }
            }
        }
        for (int i = 0; i < this.formParams.size(); ++i) {
            Object[] searchNodeDetail = (Object[])this.formParams.get(i);
            MatchedNode node = this.searchNodes(fieldsNode, searchNodeDetail);
            if (node.getDepth() == -1) {
                node.setNode(fieldsNode);
            }
            this.setNodeValues(node, searchNodeDetail);
        }
    }

    @Override
    public void addChildNode(String nodeName, Object obj, int sequence) {
        if (sequence > 1) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.indexNotValidInAcroform"));
        }
        Object[] navigationPath = new Object[this.subforms.size() + 1];
        for (int i = 0; i < this.subforms.size(); ++i) {
            FormParamDetail detail = (FormParamDetail)this.peekSubform(i);
            navigationPath[i] = detail;
        }
        navigationPath[this.subforms.size()] = obj instanceof List ? new FormParamDetail(nodeName, (List)obj, sequence) : new FormParamDetail(nodeName, Cast._String((Object)obj), sequence);
        this.formParams.add(navigationPath);
    }

    public void addChildNode(String nodeName, String text) {
        this.addChildNode(nodeName, text, 1);
    }

    @Override
    public String toString() {
        byte[] DOMBytes = this.getXML();
        return new String(DOMBytes);
    }

    @Override
    public void pushSubform(String subformName, int sequence) {
        if (sequence > 1) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.indexNotValidInAcroform"));
        }
        FormParamDetail detail = new FormParamDetail(subformName, sequence);
        this.subforms.add(detail);
    }

    @Override
    public Object popSubform() {
        return (FormParamDetail)this.subforms.remove(this.subforms.size() - 1);
    }

    private Object peekSubform(int i) {
        return (FormParamDetail)this.subforms.get(i);
    }

    private String getOldDataXML() throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XFDFService.exportFormData((PDFDocument)this.PDFdoc, (OutputStream)out);
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            throw new PDFFormException(ueex);
        }
    }

    private void setNodeValues(MatchedNode node, Object[] searchNodeDetail) {
        FormParamDetail pdfformParamDetail = (FormParamDetail)searchNodeDetail[searchNodeDetail.length - 1];
        String value = pdfformParamDetail.getValue();
        boolean listBox = pdfformParamDetail.isListBox();
        List listBoxSelection = pdfformParamDetail.getListBoxSelection();
        if (value == null && listBoxSelection == null) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.invalidUseofpdfformtags"));
        }
        Element currentNode = (Element)node.getNode();
        if (node.getDepth() != searchNodeDetail.length - 1) {
            for (int i = node.getDepth() + 1; i < searchNodeDetail.length; ++i) {
                FormParamDetail formParamDetail = (FormParamDetail)searchNodeDetail[i];
                Element newNode = new Element(FIELD);
                Attribute fieldName = new Attribute(NAME, formParamDetail.getName());
                newNode.setAttribute(fieldName);
                currentNode.addContent((Content)newNode);
                currentNode = newNode;
            }
        }
        if (value != null || listBoxSelection != null) {
            Element valueNode = null;
            List children = currentNode.getContent();
            if (children != null) {
                for (int j = 0; j < children.size(); ++j) {
                    Element child = (Element)children.get(j);
                    if (!VALUE.equalsIgnoreCase(child.getName())) continue;
                    valueNode = child;
                    break;
                }
            }
            if (valueNode != null) {
                if (listBox) {
                    currentNode.removeContent();
                    this.setText(currentNode, listBoxSelection);
                } else {
                    valueNode.setText(value);
                }
            } else if (listBox) {
                this.setText(currentNode, listBoxSelection);
            } else {
                currentNode.addContent((Content)new Element(VALUE).setText(value));
            }
        }
    }

    private MatchedNode searchNodes(Object o, Object[] searchDetail) {
        if (searchDetail == null) {
            throw new PDFFormException();
        }
        int depth = searchDetail.length;
        for (int i = 0; i < depth; ++i) {
            List children = null;
            boolean matched = false;
            if (o instanceof Parent) {
                children = ((Parent)o).getContent();
            }
            if (children == null) {
                return new MatchedNode(o, i - 1);
            }
            for (Object child : children) {
                if (!(child instanceof Element)) continue;
                Element childElem = (Element)child;
                String nodeName = childElem.getName();
                String fieldName = childElem.getAttributeValue(NAME);
                FormParamDetail formParamDetail = (FormParamDetail)searchDetail[i];
                if (!nodeName.equalsIgnoreCase(FIELD) || !fieldName.equalsIgnoreCase(formParamDetail.getName())) continue;
                o = childElem;
                matched = true;
                break;
            }
            if (!matched) {
                return new MatchedNode(o, i - 1);
            }
            if (i != depth - 1) continue;
            return new MatchedNode(o, i);
        }
        throw new PDFFormException();
    }

    @Override
    public byte[] getXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter();
        try {
            outputter.output(this.doc, (OutputStream)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    private void setText(Element elem, List listBoxSelection) {
        if (listBoxSelection == null) {
            return;
        }
        String selectedOption = null;
        Iterator iter = listBoxSelection.iterator();
        while (iter.hasNext()) {
            try {
                selectedOption = (String)iter.next();
            }
            catch (ClassCastException classcastex) {
                throw new DataXMLGenerator.ListBoxValueException(classcastex);
            }
            Element newChild = new Element(VALUE);
            newChild.setText(selectedOption);
            elem.addContent((Content)newChild);
        }
    }

    public static class MissingXFDFInXMLException
    extends ApplicationException {
    }
}

