/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.pdf.core.PDFDocException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDXHelper
implements EntityResolver,
ErrorHandler {
    private static final String DDX_SCHEMA_LOCATION = "coldfusion_ddx.xsd";
    private static final String XML_SCHEMA_LOCATION = "xml.xsd";
    private boolean ParseStatus = true;
    public String errorMesssage = null;
    private Logger logger = CFLogs.APPLICATION_LOG;

    public boolean isParseStatus() {
        return this.ParseStatus;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        URL resource;
        if (systemId.endsWith(DDX_SCHEMA_LOCATION)) {
            boolean isEnterpriseDDX = FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.restricted_ddx.intValue());
            URL resource2 = isEnterpriseDDX ? this.getClass().getClassLoader().getResource("coldfusion/pdf/coldfusion_ddx.xsd") : this.getClass().getClassLoader().getResource("coldfusion/pdf/coldfusion_standard_ddx.xsd");
            if (resource2 != null) {
                try {
                    InputStream is = resource2.openStream();
                    return new InputSource(is);
                }
                catch (IOException io) {
                    throw new PDFInvalidXSDException(DDX_SCHEMA_LOCATION, io);
                }
            }
        } else if (systemId.endsWith(XML_SCHEMA_LOCATION) && (resource = this.getClass().getClassLoader().getResource("coldfusion/pdf/xml.xsd")) != null) {
            try {
                InputStream is = resource.openStream();
                return new InputSource(is);
            }
            catch (IOException io) {
                throw new PDFInvalidXSDException(XML_SCHEMA_LOCATION, io);
            }
        }
        return null;
    }

    @Override
    public void error(SAXParseException ex) {
        this.ParseStatus = false;
        this.errorMesssage = ex.getLocalizedMessage();
        this.logger.info((Throwable)ex);
    }

    @Override
    public void warning(SAXParseException ex) {
        this.logger.info((Throwable)ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.ParseStatus = false;
        this.errorMesssage = ex.getLocalizedMessage();
        this.logger.info((Throwable)ex);
    }

    public static class PDFInvalidXSDException
    extends PDFDocException {
        public String attrValue = null;

        public PDFInvalidXSDException(String value, Exception ex) {
            super((Throwable)ex);
            this.attrValue = value;
        }
    }
}

