/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;

public final class PrintUtils {
    private PrintUtils() {
    }

    public static AffineTransform getPageTransform(Rectangle crop, int pageRotation, PageFormat format, boolean autoRotate, boolean centerOnScaling, boolean chooseSourceByPDFSize, int scalingMode) {
        AffineTransform result = new AffineTransform();
        double scalingFactor = 1.0;
        boolean shouldRotate = false;
        if (autoRotate || chooseSourceByPDFSize) {
            boolean isImageWidthLong;
            boolean isPageWidthLong = format.getImageableWidth() > format.getImageableHeight();
            boolean bl = isImageWidthLong = crop.width > crop.height;
            if (pageRotation == 90 || pageRotation == 270) {
                isImageWidthLong = crop.width < crop.height;
            }
            boolean bl2 = shouldRotate = isPageWidthLong != isImageWidthLong;
        }
        pageRotation = !shouldRotate ? (pageRotation += 180) : (pageRotation += 90);
        if (pageRotation > 360) {
            pageRotation -= 360;
        }
        double w = pageRotation % 180 == 0 ? (double)crop.width : (double)crop.height;
        double h = pageRotation % 180 == 0 ? (double)crop.height : (double)crop.width;
        double widthRatio = (format.getImageableWidth() - 1.0) / w;
        double heightRatio = (format.getImageableHeight() - 1.0) / h;
        if ((widthRatio < 1.0 || heightRatio < 1.0) && scalingMode == 2 || scalingMode == 1) {
            scalingFactor = Math.min(widthRatio, heightRatio);
        }
        if (pageRotation != 0 || shouldRotate) {
            PrintUtils.applyRotation(result, pageRotation, crop, scalingFactor);
        }
        if (crop.x != 0 || crop.y != 0) {
            PrintUtils.applyCrop(result, pageRotation, crop, scalingFactor);
        }
        PrintUtils.applyOffset(result, pageRotation, format);
        if (centerOnScaling) {
            PrintUtils.applyCentering(result, pageRotation, format, crop, scalingFactor);
        }
        if (scalingMode != 0) {
            result.scale(scalingFactor, scalingFactor);
        }
        result.scale(-1.0, 1.0);
        result.translate(-crop.width, 0.0);
        return result;
    }

    private static void applyRotation(AffineTransform result, int rotation, Rectangle crop, double scalingFactor) {
        int factor = rotation / 90;
        result.rotate((double)factor * Math.PI / 2.0);
        switch (factor) {
            case 1: {
                result.translate(0.0, -((double)crop.height * scalingFactor));
                break;
            }
            case 2: {
                result.translate(-((double)crop.width * scalingFactor), -((double)crop.height * scalingFactor));
                break;
            }
            case 3: {
                result.translate(-((double)crop.width * scalingFactor), 0.0);
            }
        }
    }

    private static void applyCrop(AffineTransform result, int rotation, Rectangle crop, double scalingFactor) {
        switch (rotation) {
            case 0: 
            case 90: 
            case 180: 
            case 270: {
                result.translate((double)crop.x * scalingFactor, (double)(-crop.y) * scalingFactor);
            }
        }
    }

    private static void applyOffset(AffineTransform result, int rotation, PageFormat format) {
        switch (rotation) {
            case 0: {
                result.translate(format.getImageableX(), format.getImageableY());
                break;
            }
            case 90: {
                result.translate(format.getImageableX(), -format.getImageableY());
                break;
            }
            case 180: {
                result.translate(-format.getImageableX(), -format.getImageableY());
                break;
            }
            case 270: {
                result.translate(-format.getImageableX(), format.getImageableY());
            }
        }
    }

    private static void applyCentering(AffineTransform result, int rotation, PageFormat format, Rectangle crop, double scalingFactor) {
        double centerOnX = 0.0;
        double centerOnY = 0.0;
        switch (rotation) {
            case 0: {
                centerOnX = (format.getImageableWidth() - (double)crop.width * scalingFactor) / 2.0;
                centerOnY = (format.getImageableHeight() - (double)crop.height * scalingFactor) / 2.0;
                break;
            }
            case 90: {
                centerOnX = (format.getImageableHeight() - (double)crop.width * scalingFactor) / 2.0;
                centerOnY = -((format.getImageableWidth() - (double)crop.height * scalingFactor) / 2.0);
                break;
            }
            case 180: {
                centerOnX = -(format.getImageableWidth() - (double)crop.width * scalingFactor) / 2.0;
                centerOnY = -(format.getImageableHeight() - (double)crop.height * scalingFactor) / 2.0;
                break;
            }
            case 270: {
                centerOnX = -(format.getImageableHeight() - (double)crop.width * scalingFactor) / 2.0;
                centerOnY = (format.getImageableWidth() - (double)crop.height * scalingFactor) / 2.0;
            }
        }
        result.translate(centerOnX, centerOnY);
    }
}

