/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

public final class NumberUtils {
    private static final int[] powers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    private NumberUtils() {
    }

    public static int parseInt(int i, int j, byte[] bytes) {
        int finalValue = 0;
        int power = 0;
        boolean isNegative = false;
        --i;
        for (int current = j - 1; current > i; --current) {
            if (bytes[current] == 45) {
                isNegative = true;
                continue;
            }
            if (bytes[current] != 48) {
                finalValue += (bytes[current] - 48) * powers[power];
            }
            ++power;
        }
        if (isNegative) {
            return -finalValue;
        }
        return finalValue;
    }

    public static float parseFloat(int start, int end, byte[] stream) {
        float d;
        int ptr = end;
        int intStart = start;
        boolean isMinus = false;
        for (int j = end - 1; j > start - 1; --j) {
            if (stream[j] != 46) continue;
            ptr = j;
            break;
        }
        int intChars = ptr;
        int decStart = ptr;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        int decNumbers = end - ptr;
        if (intNumbers > 4) {
            isMinus = false;
            int count = end - start;
            byte[] floatVal = new byte[count];
            System.arraycopy(stream, start, floatVal, 0, count);
            d = Float.parseFloat(new String(floatVal));
        } else {
            d = NumberUtils.convertFloatFromStream(stream, intStart, decStart, intNumbers, decNumbers);
        }
        if (isMinus) {
            return -d;
        }
        return d;
    }

    public static float convertFloatFromStream(byte[] stream, int intStart, int decStart, int intNumbers, int decNumbers) {
        float thous = 0.0f;
        float units = 0.0f;
        float tens = 0.0f;
        float hundreds = 0.0f;
        float tenths = 0.0f;
        float hundredths = 0.0f;
        float thousands = 0.0f;
        float tenthousands = 0.0f;
        float hunthousands = 0.0f;
        float millis = 0.0f;
        float tenmillis = 0.0f;
        float hunmillis = 0.0f;
        float billion = 0.0f;
        if (intNumbers > 3) {
            thous = NumberUtils.getThousands(stream, intStart);
            ++intStart;
        }
        if (intNumbers > 2) {
            hundreds = NumberUtils.getHundreds(stream, intStart);
            ++intStart;
        }
        if (intNumbers > 1) {
            tens = NumberUtils.getTens(stream, intStart);
            ++intStart;
        }
        if (intNumbers > 0) {
            units = NumberUtils.getUnits(stream, intStart);
        }
        if (decNumbers > 1) {
            tenths = NumberUtils.getTenths(stream, ++decStart);
        }
        if (decNumbers > 2) {
            hundredths = NumberUtils.getHundredths(stream, ++decStart);
        }
        if (decNumbers > 3) {
            thousands = NumberUtils.getThousandths(stream, ++decStart);
        }
        if (decNumbers > 4) {
            tenthousands = NumberUtils.getTenThousandths(stream, ++decStart);
        }
        if (decNumbers > 5) {
            hunthousands = NumberUtils.getHundredThousdandths(stream, ++decStart);
        }
        if (decNumbers > 6) {
            millis = NumberUtils.getMillionths(stream, ++decStart);
        }
        if (decNumbers > 7) {
            tenmillis = NumberUtils.gettenMillionths(stream, ++decStart);
        }
        if (decNumbers > 8) {
            hunmillis = NumberUtils.gethunMillionths(stream, ++decStart);
        }
        if (decNumbers > 9) {
            billion = NumberUtils.getbillionth(stream, ++decStart);
        }
        float dec = tenths + hundredths + thousands + tenthousands + hunthousands + millis + tenmillis + hunmillis + billion;
        float num = thous + hundreds + tens + units;
        float d = num + dec;
        return d;
    }

    private static float getMillionths(byte[] stream, int decStart) {
        float millis = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                millis = 1.0E-6f;
                break;
            }
            case 2: {
                millis = 2.0E-6f;
                break;
            }
            case 3: {
                millis = 3.0E-6f;
                break;
            }
            case 4: {
                millis = 4.0E-6f;
                break;
            }
            case 5: {
                millis = 5.0E-6f;
                break;
            }
            case 6: {
                millis = 6.0E-6f;
                break;
            }
            case 7: {
                millis = 7.0E-6f;
                break;
            }
            case 8: {
                millis = 8.0E-6f;
                break;
            }
            case 9: {
                millis = 9.0E-6f;
            }
        }
        return millis;
    }

    private static float gettenMillionths(byte[] stream, int decStart) {
        float tenmillis = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                tenmillis = 1.0E-7f;
                break;
            }
            case 2: {
                tenmillis = 2.0E-7f;
                break;
            }
            case 3: {
                tenmillis = 3.0E-7f;
                break;
            }
            case 4: {
                tenmillis = 4.0E-7f;
                break;
            }
            case 5: {
                tenmillis = 5.0E-7f;
                break;
            }
            case 6: {
                tenmillis = 6.0E-7f;
                break;
            }
            case 7: {
                tenmillis = 7.0E-7f;
                break;
            }
            case 8: {
                tenmillis = 8.0E-7f;
                break;
            }
            case 9: {
                tenmillis = 9.0E-7f;
            }
        }
        return tenmillis;
    }

    private static float gethunMillionths(byte[] stream, int decStart) {
        float hunmillis = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                hunmillis = 1.0E-8f;
                break;
            }
            case 2: {
                hunmillis = 2.0E-8f;
                break;
            }
            case 3: {
                hunmillis = 3.0E-8f;
                break;
            }
            case 4: {
                hunmillis = 4.0E-8f;
                break;
            }
            case 5: {
                hunmillis = 5.0E-8f;
                break;
            }
            case 6: {
                hunmillis = 6.0E-8f;
                break;
            }
            case 7: {
                hunmillis = 7.0E-8f;
                break;
            }
            case 8: {
                hunmillis = 8.0E-8f;
                break;
            }
            case 9: {
                hunmillis = 9.0E-8f;
            }
        }
        return hunmillis;
    }

    private static float getbillionth(byte[] stream, int decStart) {
        float billis = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                billis = 1.0E-9f;
                break;
            }
            case 2: {
                billis = 2.0E-9f;
                break;
            }
            case 3: {
                billis = 3.0E-9f;
                break;
            }
            case 4: {
                billis = 4.0E-9f;
                break;
            }
            case 5: {
                billis = 5.0E-9f;
                break;
            }
            case 6: {
                billis = 6.0E-9f;
                break;
            }
            case 7: {
                billis = 7.0E-9f;
                break;
            }
            case 8: {
                billis = 8.0E-9f;
                break;
            }
            case 9: {
                billis = 9.0E-9f;
            }
        }
        return billis;
    }

    private static float getHundredThousdandths(byte[] stream, int decStart) {
        float hunthousands = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                hunthousands = 1.0E-5f;
                break;
            }
            case 2: {
                hunthousands = 2.0E-5f;
                break;
            }
            case 3: {
                hunthousands = 3.0E-5f;
                break;
            }
            case 4: {
                hunthousands = 4.0E-5f;
                break;
            }
            case 5: {
                hunthousands = 5.0E-5f;
                break;
            }
            case 6: {
                hunthousands = 6.0E-5f;
                break;
            }
            case 7: {
                hunthousands = 7.0E-5f;
                break;
            }
            case 8: {
                hunthousands = 8.0E-5f;
                break;
            }
            case 9: {
                hunthousands = 9.0E-5f;
            }
        }
        return hunthousands;
    }

    private static float getTenThousandths(byte[] stream, int decStart) {
        float tenthousands = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                tenthousands = 1.0E-4f;
                break;
            }
            case 2: {
                tenthousands = 2.0E-4f;
                break;
            }
            case 3: {
                tenthousands = 3.0E-4f;
                break;
            }
            case 4: {
                tenthousands = 4.0E-4f;
                break;
            }
            case 5: {
                tenthousands = 5.0E-4f;
                break;
            }
            case 6: {
                tenthousands = 6.0E-4f;
                break;
            }
            case 7: {
                tenthousands = 7.0E-4f;
                break;
            }
            case 8: {
                tenthousands = 8.0E-4f;
                break;
            }
            case 9: {
                tenthousands = 9.0E-4f;
            }
        }
        return tenthousands;
    }

    private static float getThousandths(byte[] stream, int decStart) {
        float thousands = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                thousands = 0.001f;
                break;
            }
            case 2: {
                thousands = 0.002f;
                break;
            }
            case 3: {
                thousands = 0.003f;
                break;
            }
            case 4: {
                thousands = 0.004f;
                break;
            }
            case 5: {
                thousands = 0.005f;
                break;
            }
            case 6: {
                thousands = 0.006f;
                break;
            }
            case 7: {
                thousands = 0.007f;
                break;
            }
            case 8: {
                thousands = 0.008f;
                break;
            }
            case 9: {
                thousands = 0.009f;
            }
        }
        return thousands;
    }

    private static float getHundredths(byte[] stream, int decStart) {
        float hundredths = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                hundredths = 0.01f;
                break;
            }
            case 2: {
                hundredths = 0.02f;
                break;
            }
            case 3: {
                hundredths = 0.03f;
                break;
            }
            case 4: {
                hundredths = 0.04f;
                break;
            }
            case 5: {
                hundredths = 0.05f;
                break;
            }
            case 6: {
                hundredths = 0.06f;
                break;
            }
            case 7: {
                hundredths = 0.07f;
                break;
            }
            case 8: {
                hundredths = 0.08f;
                break;
            }
            case 9: {
                hundredths = 0.09f;
            }
        }
        return hundredths;
    }

    private static float getTenths(byte[] stream, int decStart) {
        float tenths = 0.0f;
        int c = stream[decStart] - 48;
        switch (c) {
            case 1: {
                tenths = 0.1f;
                break;
            }
            case 2: {
                tenths = 0.2f;
                break;
            }
            case 3: {
                tenths = 0.3f;
                break;
            }
            case 4: {
                tenths = 0.4f;
                break;
            }
            case 5: {
                tenths = 0.5f;
                break;
            }
            case 6: {
                tenths = 0.6f;
                break;
            }
            case 7: {
                tenths = 0.7f;
                break;
            }
            case 8: {
                tenths = 0.8f;
                break;
            }
            case 9: {
                tenths = 0.9f;
            }
        }
        return tenths;
    }

    private static float getUnits(byte[] stream, int intStart) {
        float units = 0.0f;
        int c = stream[intStart] - 48;
        switch (c) {
            case 1: {
                units = 1.0f;
                break;
            }
            case 2: {
                units = 2.0f;
                break;
            }
            case 3: {
                units = 3.0f;
                break;
            }
            case 4: {
                units = 4.0f;
                break;
            }
            case 5: {
                units = 5.0f;
                break;
            }
            case 6: {
                units = 6.0f;
                break;
            }
            case 7: {
                units = 7.0f;
                break;
            }
            case 8: {
                units = 8.0f;
                break;
            }
            case 9: {
                units = 9.0f;
            }
        }
        return units;
    }

    private static float getTens(byte[] stream, int intStart) {
        float tens = 0.0f;
        int c = stream[intStart] - 48;
        switch (c) {
            case 1: {
                tens = 10.0f;
                break;
            }
            case 2: {
                tens = 20.0f;
                break;
            }
            case 3: {
                tens = 30.0f;
                break;
            }
            case 4: {
                tens = 40.0f;
                break;
            }
            case 5: {
                tens = 50.0f;
                break;
            }
            case 6: {
                tens = 60.0f;
                break;
            }
            case 7: {
                tens = 70.0f;
                break;
            }
            case 8: {
                tens = 80.0f;
                break;
            }
            case 9: {
                tens = 90.0f;
            }
        }
        return tens;
    }

    private static float getHundreds(byte[] stream, int intStart) {
        float hundreds = 0.0f;
        int c = stream[intStart] - 48;
        switch (c) {
            case 1: {
                hundreds = 100.0f;
                break;
            }
            case 2: {
                hundreds = 200.0f;
                break;
            }
            case 3: {
                hundreds = 300.0f;
                break;
            }
            case 4: {
                hundreds = 400.0f;
                break;
            }
            case 5: {
                hundreds = 500.0f;
                break;
            }
            case 6: {
                hundreds = 600.0f;
                break;
            }
            case 7: {
                hundreds = 700.0f;
                break;
            }
            case 8: {
                hundreds = 800.0f;
                break;
            }
            case 9: {
                hundreds = 900.0f;
            }
        }
        return hundreds;
    }

    private static float getThousands(byte[] stream, int intStart) {
        float thous = 0.0f;
        int c = stream[intStart] - 48;
        switch (c) {
            case 1: {
                thous = 1000.0f;
                break;
            }
            case 2: {
                thous = 2000.0f;
                break;
            }
            case 3: {
                thous = 3000.0f;
                break;
            }
            case 4: {
                thous = 4000.0f;
                break;
            }
            case 5: {
                thous = 5000.0f;
                break;
            }
            case 6: {
                thous = 6000.0f;
                break;
            }
            case 7: {
                thous = 7000.0f;
                break;
            }
            case 8: {
                thous = 8000.0f;
                break;
            }
            case 9: {
                thous = 9000.0f;
            }
        }
        return thous;
    }
}

