/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class TextLines {
    private Map<Integer, ArrayList<int[]>> lineAreas = new HashMap<Integer, ArrayList<int[]>>();
    private Map<Integer, ArrayList<Integer>> lineWritingMode = new HashMap<Integer, ArrayList<Integer>>();
    private Map<Integer, int[][]> areas = new HashMap<Integer, int[][]>();
    private boolean hasHighlightAreasUpdated;

    public int[] setFoundParagraphAsArray(int x, int y, int page) {
        int[][] lines = this.getLineAreasAs2DArray(page);
        if (lines != null) {
            int[] point = new int[]{x, y, 1, 1};
            boolean lineFound = false;
            int selectedLine = 0;
            for (int i = 0; i != lines.length; ++i) {
                if (!TextLines.intersects(lines[i], point)) continue;
                selectedLine = i;
                lineFound = true;
                break;
            }
            if (lineFound) {
                int[] current = Arrays.copyOf(lines[selectedLine], lines[selectedLine].length);
                Vector_Rectangle_Int selected = new Vector_Rectangle_Int(0);
                selected.addElement(lines[selectedLine]);
                TextLines.expandAreaForParagraphContent(current, selected, lines, selectedLine, true);
                TextLines.expandAreaForParagraphContent(current, selected, lines, selectedLine, false);
                selected.trim();
                this.addHighlights(selected.get(), true, page);
                return current;
            }
            return null;
        }
        return null;
    }

    private static void expandAreaForParagraphContent(int[] area, Vector_Rectangle_Int selected, int[][] lines, int selectedLine, boolean ascending) {
        int left = lines[selectedLine][0];
        int cx = lines[selectedLine][0] + lines[selectedLine][2] / 2;
        int right = lines[selectedLine][0] + lines[selectedLine][2];
        int cy = lines[selectedLine][1] + lines[selectedLine][3] / 2;
        int h = lines[selectedLine][3];
        boolean found = true;
        block0: while (found) {
            found = false;
            for (int i = 0; i != lines.length; ++i) {
                int newPosition = ascending ? cy + h : cy - h;
                if (!TextLines.contains(left, newPosition, lines[i]) && !TextLines.contains(cx, newPosition, lines[i]) && !TextLines.contains(right, newPosition, lines[i])) continue;
                selected.addElement(lines[i]);
                found = true;
                cy = lines[i][1] + lines[i][3] / 2;
                h = lines[i][3];
                if (area[0] > lines[i][0]) {
                    area[2] = area[0] + area[2] - lines[i][0];
                    area[0] = lines[i][0];
                }
                if (area[0] + area[2] < lines[i][0] + lines[i][2]) {
                    area[2] = lines[i][0] + lines[i][2] - area[0];
                }
                if (area[1] > lines[i][1]) {
                    area[3] = area[1] + area[3] - lines[i][1];
                    area[1] = lines[i][1];
                }
                if (area[1] + area[3] >= lines[i][1] + lines[i][3]) continue block0;
                area[3] = lines[i][1] + lines[i][3] - area[1];
                continue block0;
            }
        }
    }

    public void addToLineAreas(int[] area, int writingMode, int page) {
        if (this.lineAreas == null) {
            this.lineAreas = new HashMap<Integer, ArrayList<int[]>>();
            this.lineWritingMode = new HashMap<Integer, ArrayList<Integer>>();
        }
        ArrayList<Object> lastAreas = this.lineAreas.get(page);
        ArrayList<Integer> lastWritingMode = this.lineWritingMode.get(page);
        if (lastAreas == null) {
            lastAreas = new ArrayList();
            this.lineAreas.put(page, lastAreas);
            lastWritingMode = new ArrayList();
            this.lineWritingMode.put(page, lastWritingMode);
        }
        if (area != null) {
            boolean addNew = true;
            for (int i = 0; i != lastAreas.size(); ++i) {
                if (writingMode != lastWritingMode.get(i) || !TextLines.mergeLineWithExisting(area, writingMode, lastAreas, i)) continue;
                addNew = false;
                break;
            }
            if (addNew) {
                lastAreas.add(area);
                lastWritingMode.add(writingMode);
            }
        }
    }

    private static boolean mergeLineWithExisting(int[] area, int writingMode, ArrayList<int[]> lastAreas, int i) {
        boolean merged = false;
        int[] lastArea = lastAreas.get(i);
        int cx = area[0];
        int cy = area[1];
        int cw = area[2];
        int ch = area[3];
        int lx = lastArea[0];
        int ly = lastArea[1];
        int lw = lastArea[2];
        int lh = lastArea[3];
        float heightMod = 5.0f;
        float widthMod = 1.1f;
        switch (writingMode) {
            case 0: {
                if (!((float)ly > (float)cy - (float)ch / 5.0f) || !((float)ly < (float)cy + (float)ch / 5.0f) || !((float)lh < (float)ch + (float)ch / 5.0f) || !((float)lh > (float)ch - (float)ch / 5.0f) || !((float)lx > (float)(cx + cw) - (float)ch * 1.1f && (float)lx < (float)(cx + cw) + (float)ch * 1.1f || (float)(lx + lw) > (float)cx - (float)ch * 1.1f && (float)(lx + lw) < (float)cx + (float)ch * 1.1f) && !TextLines.intersects(lastArea, area)) break;
                merged = true;
                lastAreas.set(i, TextLines.mergePartLines(lastArea, area));
                break;
            }
            case 1: {
                lx = lastArea[0];
                ly = lastArea[1];
                lw = lastArea[2];
                lh = lastArea[3];
                cx = area[0];
                cy = area[1];
                cw = area[2];
                ch = area[3];
                if (ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !TextLines.intersects(lastArea, area)) break;
                merged = true;
                lastAreas.set(i, TextLines.mergePartLines(lastArea, area));
                break;
            }
            case 2: {
                lx = lastArea[1];
                ly = lastArea[0];
                lw = lastArea[3];
                lh = lastArea[2];
                cx = area[1];
                cy = area[0];
                cw = area[3];
                ch = area[2];
                if (ly <= cy - 5 || ly >= cy + 5 || !((double)Math.abs(lh - ch) - (double)lh * 0.6 < 0.0) || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !TextLines.intersects(lastArea, area)) break;
                merged = true;
                lastAreas.set(i, TextLines.mergePartLines(lastArea, area));
                break;
            }
            case 3: {
                int currentBaseLine = cx + cw;
                int lastBaseLine = lx + lw;
                if (currentBaseLine < lastBaseLine - lw / 3 || currentBaseLine > lastBaseLine + lw / 3 || !((double)ly + ((double)lh + (double)lw * 0.6) > (double)cy && (double)ly + ((double)lh - (double)lw * 0.6) < (double)cy || (double)ly + (double)lw * 0.6 > (double)(cy + ch) && (double)ly - (double)lw * 0.6 < (double)(cy + ch)) && !TextLines.intersects(area, lastArea)) break;
                merged = true;
                lastAreas.set(i, TextLines.mergePartLines(lastArea, area));
            }
        }
        return merged;
    }

    public void clearHighlights() {
        this.areas = null;
        this.hasHighlightAreasUpdated = true;
    }

    public void addHighlights(int[][] highlights, boolean areaSelect, int page) {
        if (highlights != null) {
            this.hasHighlightAreasUpdated = true;
            for (int j = 0; j != highlights.length; ++j) {
                int[][] values = this.getHighlightableInArea(highlights[j], areaSelect, page);
                if (values == null) continue;
                this.areas.put(page, values);
            }
        }
    }

    public int[][] getHighlightableInArea(int[] highlights, boolean areaSelect, int page) {
        if (highlights != null) {
            if (!areaSelect) {
                int[] startPoint = new int[]{highlights[0] + 1, highlights[1] + 1};
                int[] endPoint = new int[]{highlights[0] + highlights[2] - 1, highlights[1] + highlights[3] - 1};
                if (this.areas == null) {
                    this.areas = new HashMap<Integer, int[][]>();
                }
                int[][] lines = this.getLineAreasAs2DArray(page);
                int[] writingMode = this.getLineWritingMode(page);
                if (writingMode == null) {
                    return null;
                }
                int start = -1;
                int finish = -1;
                boolean backward = false;
                if (lines != null) {
                    for (int i = 0; i != lines.length; ++i) {
                        if (TextLines.contains(startPoint[0], startPoint[1], lines[i])) {
                            start = i;
                        }
                        if (TextLines.contains(endPoint[0], endPoint[1], lines[i])) {
                            finish = i;
                        }
                        if (start != -1 && finish != -1) break;
                    }
                    if (start > finish) {
                        int temp = start;
                        start = finish;
                        finish = temp;
                        backward = true;
                    }
                    if (start == finish && startPoint[0] > endPoint[0]) {
                        int[] temp = startPoint;
                        startPoint = endPoint;
                        endPoint = temp;
                    }
                    if (start != -1) {
                        int[][] localAreas = new int[finish - start + 1][4];
                        System.arraycopy(lines, start, localAreas, 0, finish - start + 1);
                        if (localAreas[0] != null && localAreas[localAreas.length - 1] != null) {
                            TextLines.capHighlightStartToPoint(localAreas, writingMode[start], endPoint, startPoint, backward);
                            TextLines.capHighlightEndToPoint(localAreas, writingMode[finish], endPoint, startPoint, backward);
                        }
                        return localAreas;
                    }
                }
            } else {
                if (highlights[2] < 0) {
                    highlights[2] = -highlights[2];
                    highlights[0] = highlights[0] - highlights[2];
                }
                if (highlights[3] < 0) {
                    highlights[3] = -highlights[3];
                    highlights[1] = highlights[1] - highlights[3];
                }
                return this.getLineAreasIntersect(highlights, page);
            }
        }
        return null;
    }

    private static void capHighlightEndToPoint(int[][] localAreas, int writingMode, int[] endPoint, int[] startPoint, boolean backward) {
        int bottom = localAreas.length - 1;
        switch (writingMode) {
            case 0: {
                if (backward) {
                    if (startPoint[0] + 15 >= localAreas[bottom][0] + localAreas[bottom][2]) break;
                    localAreas[bottom][2] = startPoint[0] - localAreas[bottom][0];
                    break;
                }
                if (endPoint[0] + 15 >= localAreas[bottom][0] + localAreas[bottom][2]) break;
                localAreas[bottom][2] = endPoint[0] - localAreas[bottom][0];
                break;
            }
            case 1: {
                LogWriter.writeLog("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                break;
            }
            case 2: 
            case 3: {
                if (backward) {
                    if (startPoint[1] + 15 >= localAreas[bottom][1] + localAreas[bottom][3]) break;
                    localAreas[bottom][3] = startPoint[1] - localAreas[bottom][1];
                    break;
                }
                if (endPoint[1] + 15 >= localAreas[bottom][1] + localAreas[bottom][3]) break;
                localAreas[bottom][3] = endPoint[1] - localAreas[bottom][1];
            }
        }
    }

    private static void capHighlightStartToPoint(int[][] localAreas, int writingMode, int[] endPoint, int[] startPoint, boolean backward) {
        switch (writingMode) {
            case 0: {
                if (backward) {
                    if (endPoint[0] - 15 <= localAreas[0][0]) break;
                    int[] nArray = localAreas[0];
                    nArray[2] = nArray[2] - (endPoint[0] - localAreas[0][0]);
                    localAreas[0][0] = endPoint[0];
                    break;
                }
                if (startPoint[0] - 15 <= localAreas[0][0]) break;
                int[] nArray = localAreas[0];
                nArray[2] = nArray[2] - (startPoint[0] - localAreas[0][0]);
                localAreas[0][0] = startPoint[0];
                break;
            }
            case 1: {
                LogWriter.writeLog("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                break;
            }
            case 2: 
            case 3: {
                if (backward) {
                    if (endPoint[1] - 15 <= localAreas[0][1]) break;
                    int[] nArray = localAreas[0];
                    nArray[3] = nArray[3] - (endPoint[1] - localAreas[0][1]);
                    localAreas[0][1] = endPoint[1];
                    break;
                }
                if (startPoint[1] - 15 <= localAreas[0][1]) break;
                int[] nArray = localAreas[0];
                nArray[3] = nArray[3] - (startPoint[1] - localAreas[0][1]);
                localAreas[0][1] = startPoint[1];
            }
        }
    }

    private int[][] getLineAreasIntersect(int[] highlights, int p) {
        if (this.areas != null) {
            int[][] localAreas = this.areas.get(p);
            if (localAreas != null) {
                boolean matchFound = false;
                int size = localAreas.length;
                for (int i = 0; i < size; ++i) {
                    if (localAreas[i] == null || localAreas[i][0] != highlights[0] || localAreas[i][1] != highlights[1] || localAreas[i][2] != highlights[2] || localAreas[i][3] != highlights[3]) continue;
                    matchFound = true;
                    i = size;
                }
                if (!matchFound) {
                    int newSize = localAreas.length + 1;
                    int[][] newAreas = new int[newSize][4];
                    for (int i = 0; i < localAreas.length; ++i) {
                        if (localAreas[i] == null) continue;
                        newAreas[i] = new int[]{localAreas[i][0], localAreas[i][1], localAreas[i][2], localAreas[i][3]};
                    }
                    localAreas = newAreas;
                    localAreas[localAreas.length - 1] = highlights;
                }
                return localAreas;
            }
            return new int[][]{highlights};
        }
        this.areas = new HashMap<Integer, int[][]>();
        int[][] localAreas = new int[1][4];
        localAreas[0] = highlights;
        return localAreas;
    }

    public boolean hasHighlightAreasUpdated() {
        return this.hasHighlightAreasUpdated;
    }

    public Map<Integer, int[][]> getAllHighlights() {
        this.hasHighlightAreasUpdated = false;
        if (this.areas == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.areas);
    }

    public int[][] getHighlightedAreasAs2DArray(int page) {
        if (this.areas == null) {
            return null;
        }
        Integer p = page;
        int[][] localAreas = this.areas.get(p);
        if (localAreas != null) {
            int count = localAreas.length;
            int[][] returnValue = new int[count][4];
            for (int ii = 0; ii < count; ++ii) {
                returnValue[ii] = (int[])(localAreas[ii] == null ? null : new int[]{localAreas[ii][0], localAreas[ii][1], localAreas[ii][2], localAreas[ii][3]});
            }
            this.hasHighlightAreasUpdated = false;
            return returnValue;
        }
        return null;
    }

    public void setLineAreas(Map<Integer, int[][]> la) {
        if (la == null || la.keySet().isEmpty()) {
            this.lineAreas = null;
        } else {
            Set<Integer> keys = la.keySet();
            for (int i : keys) {
                int[][] values = la.get(i);
                ArrayList list = new ArrayList(Arrays.asList(values));
                this.lineAreas.put(i, list);
            }
        }
    }

    public int[][] getLineAreasAs2DArray(int page) {
        if (this.lineAreas == null || this.lineAreas.get(page) == null) {
            return null;
        }
        return TextLines.convertIntArrayListToArray(this.lineAreas.get(page));
    }

    private static int[][] convertIntArrayListToArray(ArrayList<int[]> localLineAreas) {
        if (localLineAreas == null) {
            return null;
        }
        int count = localLineAreas.size();
        int[][] returnValue = new int[count][4];
        for (int ii = 0; ii < count; ++ii) {
            returnValue[ii] = (int[])(localLineAreas.get(ii) == null ? null : new int[]{localLineAreas.get(ii)[0], localLineAreas.get(ii)[1], localLineAreas.get(ii)[2], localLineAreas.get(ii)[3]});
        }
        return returnValue;
    }

    private int[] getLineWritingMode(int page) {
        if (this.lineWritingMode == null) {
            return null;
        }
        ArrayList<Integer> localLineWritingMode = this.lineWritingMode.get(page);
        if (localLineWritingMode == null) {
            return null;
        }
        int count = localLineWritingMode.size();
        int[] returnValue = new int[count];
        for (int i = 0; i != count; ++i) {
            returnValue[i] = localLineWritingMode.get(i);
        }
        return returnValue;
    }

    private static int[] mergePartLines(int[] lastArea, int[] area) {
        int x1 = area[0];
        int x2 = area[0] + area[2];
        int y1 = area[1];
        int y2 = area[1] + area[3];
        int lx1 = lastArea[0];
        int lx2 = lastArea[0] + lastArea[2];
        int ly1 = lastArea[1];
        int ly2 = lastArea[1] + lastArea[3];
        if (x1 >= lx1) {
            area[0] = lx1;
        }
        if (y1 >= ly1) {
            area[1] = ly1;
        }
        area[3] = y2 > ly2 ? y2 - area[1] : ly2 - area[1];
        area[2] = x2 > lx2 ? x2 - area[0] : lx2 - area[0];
        return area;
    }

    public static boolean intersects(int[] paramsOne, int[] paramsTwo) {
        int X1 = paramsOne[0];
        int Y1 = paramsOne[1];
        int W1 = paramsOne[2];
        int H1 = paramsOne[3];
        int X2 = paramsTwo[0];
        int Y2 = paramsTwo[1];
        int W2 = paramsTwo[2];
        int H2 = paramsTwo[3];
        return X1 + W1 >= X2 && X2 + W2 >= X1 && Y1 + H1 >= Y2 && Y2 + H2 >= Y1;
    }

    private static boolean contains(int x, int y, int[] rectParams) {
        int minX = rectParams[0];
        int minY = rectParams[1];
        int maxX = rectParams[0] + rectParams[2];
        int maxY = rectParams[1] + rectParams[3];
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }
}

