/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.SwingDisplay;
import org.jpedal.render.T3ImageUtils;
import org.jpedal.render.T3Renderer;

public class T3Display
extends SwingDisplay
implements T3Renderer {
    public T3Display(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
        this.type = 9;
    }

    public T3Display(byte[] dvr, Map<Object, Object> map) {
        super(dvr, map);
        this.type = 9;
    }

    @Override
    public void setType3Glyph(String pKey) {
        this.rawKey = pKey;
        this.isType3Font = true;
    }

    @Override
    public void lockColors(PdfPaint strokePaint, PdfPaint nonstrokePaint, boolean lockColour) {
        this.colorsLocked = lockColour;
        PdfPaint strokeColor = new PdfColor(255, 255, 255);
        PdfPaint nonstrokeColor = new PdfColor(255, 255, 255);
        if (strokePaint != null && !strokePaint.isPattern()) {
            strokeColor = strokePaint;
        }
        this.strokeCol = new PdfColor(strokeColor.getRGB());
        if (!nonstrokePaint.isPattern()) {
            nonstrokeColor = nonstrokePaint;
        }
        this.fillCol = new PdfColor(nonstrokeColor.getRGB());
    }

    @Override
    void renderImage(AffineTransform imageAf, BufferedImage image, float alpha, GraphicsState currentGraphicsState, float x, float y) {
        if (image != null && this.fillCol != null) {
            image = T3ImageUtils.handleType3Image(image, this.fillCol);
        }
        super.renderImage(imageAf, image, alpha, currentGraphicsState, x, y);
    }
}

