/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.external.ErrorTracker;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDataToJavaImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.downsample.DownSampler;
import org.jpedal.parser.image.mask.MaskDataDecoder;
import org.jpedal.parser.image.mask.MaskDecoder;
import org.jpedal.parser.image.mask.SMaskDecoder;
import org.jpedal.utils.LogWriter;

public class ImageDecoder
extends BaseDecoder {
    private boolean cacheLargeImages;
    public static boolean allowPrintTransparency;
    ParserOptions parserOptions;
    private final PdfImageData pdfImages;
    private boolean getSamplingOnly;
    private boolean isMask = true;
    String imagesInFile;
    PdfObjectCache cache;
    private final PdfPageData pageData;
    private final ObjectStore objectStoreStreamRef;
    String currentImage = "";
    final ErrorTracker errorTracker;
    final PdfObjectReader currentPdfFile;
    private final int imageCount;

    ImageDecoder(int imageCount, PdfObjectReader currentPdfFile, ErrorTracker errorTracker, ObjectStore objectStoreStreamRef, PdfImageData pdfImages, PdfPageData pageData, String imagesInFile) {
        this.imageCount = imageCount;
        this.currentPdfFile = currentPdfFile;
        this.errorTracker = errorTracker;
        this.objectStoreStreamRef = objectStoreStreamRef;
        this.pdfImages = pdfImages;
        this.pageData = pageData;
        this.imagesInFile = imagesInFile;
    }

    private GenericColorSpace setupXObjectColorspace(PdfObject XObject2, ImageData imageData) {
        GenericColorSpace decodeColorData;
        PdfArrayIterator ColorSpace2 = XObject2.getMixedArray(2087749783);
        if (ColorSpace2.getTokenCount() > 0) {
            decodeColorData = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2);
        } else {
            int rawColorSpace = XObject2.getInt(-789460276);
            decodeColorData = new DeviceRGBColorSpace();
        }
        if (imageData.getDepth() == -1) {
            if (decodeColorData.getID() == 1785221209 && !XObject2.getBoolean(1516403337)) {
                imageData.setDepth(8);
            } else if (decodeColorData.getID() == 689115931) {
                imageData.setDepth(8);
            } else {
                imageData.setDepth(1);
            }
        }
        int width = imageData.getWidth();
        int height = imageData.getHeight();
        int depth = imageData.getDepth();
        this.cache.put(1, decodeColorData.getID(), (Object)"x");
        byte[] indexData = decodeColorData.getIndexedMap();
        if (depth == 8) {
            byte[] objectData = imageData.getObjectData();
            if (indexData != null && decodeColorData.getID() == 1785221209 && width * height == objectData.length) {
                PdfObject newMask = XObject2.getDictionary(489767739);
                int[] maskArray = XObject2.getIntArray(489767739);
                if (newMask != null || maskArray != null && maskArray.length == 2 && maskArray[0] == 255 && maskArray[0] == maskArray[1] && decodeColorData.getIndexedMap() != null && decodeColorData.getIndexedMap().length == 768) {
                    boolean isCorrupt = true;
                    for (int jj = 0; jj < 768; ++jj) {
                        if (indexData[jj] == 0) continue;
                        isCorrupt = false;
                        jj = 768;
                    }
                    if (isCorrupt) {
                        decodeColorData = new DeviceGrayColorSpace();
                    }
                }
            }
        }
        return decodeColorData;
    }

    public BufferedImage processImageXObject(PdfObject XObject2, String image_name, byte[] objectData, String details) {
        GenericColorSpace decodeColorData;
        ImageData imageData;
        image_name = this.parserOptions.getFileName() + '-' + image_name;
        PdfObject newSMask = XObject2.getDictionary(489767774);
        PdfObject newMask = XObject2.getDictionary(489767739);
        int[] maskArray = XObject2.getIntArray(489767739);
        byte[] convertedData = XObject2.getConvertedData();
        if (convertedData != null) {
            imageData = new ImageData(XObject2, convertedData);
            decodeColorData = new DeviceRGBColorSpace(true);
            imageData.setCompCount(4);
            newSMask = null;
        } else {
            imageData = new ImageData(XObject2, objectData);
            decodeColorData = this.setupXObjectColorspace(XObject2, imageData);
            imageData.setCompCount(decodeColorData.getColorSpace().getNumComponents());
        }
        if (newSMask != null || newMask != null || maskArray != null) {
            if (newSMask != null) {
                ImageData smaskImageData = new ImageData(newSMask, null);
                byte[] maskData = this.currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(this.currentPdfFile.getObjectReader()));
                objectData = SMaskDecoder.apply_Smask(imageData, smaskImageData, maskData, XObject2, newSMask, decodeColorData);
                XObject2.setConvertedData(objectData);
            } else {
                byte[] index = decodeColorData.getIndexedMap();
                if (index != null) {
                    index = decodeColorData.convertIndexToRGB(index);
                    if (maskArray != null) {
                        return ImageDecoder.getIndexedMaskImage(index, imageData, maskArray);
                    }
                    objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, imageData.getWidth(), imageData.getHeight(), imageData.getDepth(), objectData, false, false);
                    decodeColorData = new DeviceRGBColorSpace();
                    imageData.setObjectData(objectData);
                    decodeColorData.setIndex(null, 0);
                }
                if (maskArray != null) {
                    return MaskDataDecoder.applyMaskArray(imageData, maskArray);
                }
                byte[] maskData = this.currentPdfFile.readStream(newMask, true, true, false, false, false, newMask.getCacheName(this.currentPdfFile.getObjectReader()));
                objectData = MaskDecoder.applyMask(imageData, decodeColorData, newMask, XObject2, maskData);
                XObject2.setConvertedData(objectData);
                XObject2.setDictionary(489767739, null);
                XObject2.setIntArray(489767739, null);
            }
            imageData = new ImageData(XObject2, objectData);
            decodeColorData = new DeviceRGBColorSpace(true);
            imageData.setCompCount(4);
        }
        this.isMask = XObject2.getBoolean(1516403337);
        LogWriter.writeLog("Processing XObject: " + image_name + ' ' + XObject2.getObjectRefAsString() + " width=" + imageData.getWidth() + " Height=" + imageData.getHeight() + " Depth=" + imageData.getDepth() + " colorspace=" + decodeColorData);
        BufferedImage image = this.processImage(decodeColorData, imageData, this.isMask, XObject2);
        if (ImageCommands.trackImages && image != null && details != null) {
            this.setImageInfo(imageData, details, decodeColorData, image);
        }
        return image;
    }

    private static BufferedImage getIndexedMaskImage(byte[] index, ImageData imageData, int[] maskArray) {
        int d = imageData.getDepth();
        int p = 0;
        int c = 0;
        boolean[] invisible = new boolean[1 << d];
        for (int i = 0; i < maskArray.length; i += 2) {
            int start = maskArray[i];
            int end = maskArray[i + 1];
            if (start == end) {
                invisible[start] = true;
                continue;
            }
            for (int j = start; j < end; ++j) {
                invisible[j] = true;
            }
        }
        int[] indexColors = new int[index.length / 3];
        for (int i = 0; i < indexColors.length; ++i) {
            indexColors[i] = 0xFF000000 | (index[c++] & 0xFF) << 16 | (index[c++] & 0xFF) << 8 | index[c++] & 0xFF;
        }
        BitReader reader = new BitReader(imageData.getObjectData(), d < 8);
        BufferedImage img = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] output = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int imageDim = imageData.getWidth() * imageData.getHeight();
        int w = imageData.getWidth();
        int wc = 0;
        for (int i = 0; i < imageDim; ++i) {
            int v = reader.getPositive(d);
            if (!invisible[v]) {
                output[p++] = indexColors[v];
            } else {
                ++p;
            }
            if (++wc != w) continue;
            int balance = 8 - reader.getPointer() % 8;
            wc = 0;
            if (balance == 8) continue;
            reader.getPositive(balance);
        }
        return img;
    }

    private void setImageInfo(ImageData imageData, String details, GenericColorSpace decodeColorData, BufferedImage image) {
        int width = imageData.getWidth();
        int height = imageData.getHeight();
        float dpi = this.gs.CTM[0][0];
        if (dpi == 0.0f) {
            dpi = this.gs.CTM[0][1];
        }
        if (dpi < 0.0f) {
            dpi = -dpi;
        }
        dpi = (int)((float)width / dpi * 100.0f);
        StringBuilder imageInfo = new StringBuilder(details);
        imageInfo.append(" w=");
        imageInfo.append(width);
        imageInfo.append(" h=");
        imageInfo.append(height);
        imageInfo.append(' ');
        imageInfo.append((int)dpi);
        imageInfo.append(' ');
        imageInfo.append(ColorSpaces.IDtoString(decodeColorData.getID()));
        imageInfo.append(" (");
        imageInfo.append(image.getWidth());
        imageInfo.append(' ');
        imageInfo.append(image.getHeight());
        imageInfo.append(" type=");
        imageInfo.append(image.getType());
        imageInfo.append(')');
        if (!this.imagesInFile.isEmpty()) {
            imageInfo.append('\n');
            imageInfo.append(this.imagesInFile);
        }
        this.imagesInFile = imageInfo.toString();
    }

    public void setSamplingOnly(boolean getSamplingOnly) {
        this.getSamplingOnly = getSamplingOnly;
    }

    public String getImagesInFile() {
        return this.imagesInFile;
    }

    public void setParams(ParserOptions parserOptions) {
        this.parserOptions = parserOptions;
        String value = System.getProperty("org.jpedal.printTransparency");
        if (value != null) {
            boolean bl = allowPrintTransparency = parserOptions.isPrinting() && "true".equalsIgnoreCase(value);
        }
        if ((value = System.getProperty("org.jpedal.viewerLargeImageCaching")) != null) {
            this.cacheLargeImages = "true".equalsIgnoreCase(value);
        }
    }

    void generateClippedImage(BufferedImage image) {
        int pageRotation = this.pageData.getRotation(this.parserOptions.getPageNumber());
        ImageTransformerDouble image_transformation = new ImageTransformerDouble(this.gs, image, this.parserOptions.createScaledVersion(), 1.0f, pageRotation);
        image_transformation.doubleScaleTransformShear();
        image = image_transformation.getImage();
        if (this.isMask) {
            image = ImageDecoder.convertMaskToImage(image, this.gs.nonstrokeColorSpace.getColor().getRGB());
        }
        if (this.objectStoreStreamRef.saveStoredImageAsBytes("CLIP_" + this.currentImage, image, false)) {
            this.errorTracker.addPageFailureMessage("Problem saving " + image);
        }
        if ((image = image_transformation.getImage()) != null && this.parserOptions.imagesNeeded()) {
            float x = image_transformation.getImageX();
            float y = image_transformation.getImageY();
            float w = image_transformation.getImageW();
            float h = image_transformation.getImageH();
            this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), x, y, w, h);
        }
    }

    private static BufferedImage convertMaskToImage(BufferedImage outputImage, int foreground) {
        int[] maskCol = new int[]{foreground >> 16 & 0xFF, foreground >> 8 & 0xFF, foreground & 0xFF, 255};
        BufferedImage img = new BufferedImage(outputImage.getWidth(), outputImage.getHeight(), outputImage.getType());
        WritableRaster src = outputImage.getRaster();
        WritableRaster dest = img.getRaster();
        int[] values = new int[4];
        int w = outputImage.getWidth();
        int h = outputImage.getHeight();
        for (int yy = 0; yy < h; ++yy) {
            for (int xx = 0; xx < w; ++xx) {
                src.getPixel(xx, yy, values);
                if (values[3] <= 2) continue;
                dest.setPixel(xx, yy, maskCol);
            }
        }
        return img;
    }

    void generateTransformedImageSingle(BufferedImage image) {
        if (this.parserOptions.isRawImagesExtracted()) {
            this.objectStoreStreamRef.saveStoredImageAsBytes('R' + this.currentImage, image, false);
        }
        ImageTransformer image_transformation = new ImageTransformer(this.gs, image);
        float x = image_transformation.getImageX();
        float y = image_transformation.getImageY();
        float w = image_transformation.getImageW();
        float h = image_transformation.getImageH();
        image = image_transformation.getImage();
        if (image != null) {
            this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), x, y, w, h);
            if (this.parserOptions.isFinalImagesExtracted()) {
                this.objectStoreStreamRef.saveStoredImageAsBytes(this.currentImage, ImageCommands.addBackgroundToMask(image, this.isMask), false);
            }
        }
    }

    BufferedImage processImage(GenericColorSpace decodeColorData, ImageData imageData, boolean imageMask, PdfObject XObject2) {
        BufferedImage image;
        Object[] TRvalues;
        this.cache.put(1, decodeColorData.getID(), (Object)"x");
        int sampling = 1;
        byte[] maskCol = null;
        if (imageMask) {
            maskCol = ImageCommands.getMaskColor(this.gs);
        }
        if (this.parserOptions.isRenderPage() && this.streamType != 1) {
            this.setDownsampledImageSize(imageData, XObject2, decodeColorData);
        }
        if (this.parserOptions.isRenderPage() && decodeColorData.getID() != 1247168582 && imageData.getMode() != 0 && (imageData.getDepth() == 1 || imageData.getDepth() == 8) && imageData.getpX() > 0 && imageData.getpY() > 0 && (SamplingFactory.isPrintDownsampleEnabled || !this.parserOptions.isPrinting()) && (sampling = this.calculateSampling(imageData, decodeColorData)) > 1 && this.multiplyer > 1.0f) {
            sampling = (int)((float)sampling / this.multiplyer);
        }
        if (this.getSamplingOnly) {
            ImageDecoder.setSampling(imageData, this.parserOptions);
            return null;
        }
        float[] decodeArray = imageData.getDecodeArray();
        if (decodeArray != null && decodeArray.length > 0) {
            ImageCommands.applyDecodeArray(imageData.getObjectData(), imageData.getDepth(), decodeArray, decodeColorData.getID(), decodeColorData.getIndexedMap() != null);
        }
        if ((TRvalues = this.gs.getTR()) != null) {
            ImageCommands.applyTR(imageData, TRvalues, this.currentPdfFile);
        }
        if (sampling > 1) {
            decodeColorData = this.downSamppleAndSaveRawVersion(imageData, decodeColorData, sampling, maskCol);
        }
        if (maskCol != null) {
            image = ImageDataToJavaImage.makeMaskImage(this.parserOptions, this.gs, this.current, imageData, decodeColorData, maskCol);
        } else {
            LogWriter.writeLog(imageData.getWidth() + "W * " + imageData.getHeight() + "H BPC=" + imageData.getDepth() + ' ' + decodeColorData);
            image = ImageDataToJavaImage.makeImage(decodeColorData, imageData);
        }
        if (image == null && !imageData.isRemoved()) {
            this.parserOptions.imagesProcessedFully = false;
        }
        if (maskCol != null && this.gs.nonstrokeColorSpace.getColor().isTexture()) {
            this.convertTextureToImage(imageData, image);
        }
        return image;
    }

    private GenericColorSpace downSamppleAndSaveRawVersion(ImageData imageData, GenericColorSpace decodeColorData, int sampling, byte[] maskCol) {
        if (this.cacheLargeImages) {
            int componentCount = 3;
            int depth = 8;
            if (decodeColorData.getID() == 1785221209) {
                componentCount = decodeColorData.getColorComponentCount();
            }
            byte[] convertedData = imageData.getObjectData();
            if (!this.isMask) {
                if (decodeColorData.getIndexedMap() == null) {
                    if (imageData.getDepth() == 1) {
                        componentCount = imageData.getCompCount();
                        depth = imageData.getDepth();
                    } else if (decodeColorData.getID() != 1785221209) {
                        convertedData = decodeColorData.dataToRGBByteArray(imageData.getObjectDataAs8Bit(), imageData.getWidth(), imageData.getHeight());
                        decodeColorData = new DeviceRGBColorSpace();
                        imageData.setObjectData(convertedData);
                        imageData.setDepth(8);
                        imageData.setCompCount(3);
                    }
                } else {
                    byte[] index = decodeColorData.getIndexedMap();
                    if (index != null) {
                        index = decodeColorData.convertIndexToRGB(index);
                        convertedData = ColorSpaceConvertor.convertIndexToRGBByte(index, imageData.getWidth(), imageData.getHeight(), imageData.getDepth(), convertedData, false, false);
                        decodeColorData = new DeviceRGBColorSpace();
                        imageData.setObjectData(convertedData);
                        imageData.setDepth(8);
                        imageData.setCompCount(3);
                    }
                }
            }
            this.objectStoreStreamRef.saveRawImageData(this.parserOptions.getPageNumber() + String.valueOf(this.imageCount), convertedData, imageData.getWidth(), imageData.getHeight(), depth, imageData.getpX(), imageData.getpY(), maskCol, componentCount);
        }
        decodeColorData = DownSampler.downSampleImage(decodeColorData, imageData, maskCol, sampling);
        return decodeColorData;
    }

    private static void setSampling(ImageData imageData, ParserOptions parserOptions) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        if (imageData.getpX() > 0 && imageData.getpY() > 0) {
            float scaleX = (float)w / (float)imageData.getpX();
            float scaleY = (float)h / (float)imageData.getpY();
            if (!(scaleX > 100.0f) && !(scaleY > 100.0f)) {
                parserOptions.setSamplingUsed(Math.min(scaleX, scaleY));
            }
        }
    }

    private void convertTextureToImage(ImageData imageData, BufferedImage image) {
        float[][] mm = this.gs.CTM;
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        AffineTransform affine = new AffineTransform(mm[0][0], mm[0][1], mm[1][0], mm[1][1], mm[2][0], mm[2][1]);
        BufferedImage temp = ((PatternColorSpace)this.gs.nonstrokeColorSpace).getRawImage(affine);
        BufferedImage scrap = new BufferedImage(w, h, 2);
        if (temp != null) {
            TexturePaint tp = new TexturePaint(temp, new Rectangle(0, 0, temp.getWidth(), temp.getHeight()));
            Graphics2D g2 = scrap.createGraphics();
            g2.setPaint(tp);
            Rectangle rect = new Rectangle(0, 0, w, h);
            g2.fill(rect);
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (image.getRGB(x, y) != -16777216) continue;
                int pRGB = scrap.getRGB(x, y);
                image.setRGB(x, y, pRGB);
            }
        }
    }

    private int calculateSampling(ImageData imageData, GenericColorSpace decodeColorData) {
        int pX = imageData.getpX();
        int pY = imageData.getpY();
        if (this.multiplyer <= 1.0f && !this.parserOptions.isPrinting()) {
            int maxAllowed;
            int n = maxAllowed = decodeColorData.getID() == 1568372915 ? 4000 : 1000;
            if (pX > maxAllowed) {
                pX = maxAllowed;
                imageData.setpX(pX);
            }
            if (pY > maxAllowed) {
                pY = maxAllowed;
                imageData.setpY(pY);
            }
        }
        int newW = imageData.getWidth();
        int smallestH = pY << 2;
        int smallestW = pX << 2;
        int sampling = 1;
        for (int newH = imageData.getHeight(); newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
            sampling <<= 1;
        }
        return sampling;
    }

    private void setDownsampledImageSize(ImageData imageData, PdfObject XObject2, GenericColorSpace decodeColorData) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        if (this.parserOptions.isPrinting() && SamplingFactory.isPrintDownsampleEnabled && w < 4000) {
            imageData.setpX(this.pageData.getCropBoxWidth(this.parserOptions.getPageNumber()) * 4);
            imageData.setpY(this.pageData.getCropBoxHeight(this.parserOptions.getPageNumber()) * 4);
        } else if (SamplingFactory.downsampleLevel == 2 || SamplingFactory.downsampleLevel == 6 || this.getSamplingOnly) {
            float[][] CTM = new float[3][3];
            for (int ii = 0; ii < 3; ++ii) {
                for (int jj = 0; jj < 3; ++jj) {
                    CTM[ii][jj] = this.gs.CTM[ii][jj] < 0.0f ? -this.gs.CTM[ii][jj] : this.gs.CTM[ii][jj];
                }
            }
            if (CTM[0][0] == 0.0f || CTM[0][0] < CTM[0][1]) {
                imageData.setpX((int)CTM[0][1]);
            } else {
                imageData.setpX((int)CTM[0][0]);
            }
            if (CTM[1][1] == 0.0f || CTM[1][1] < CTM[1][0]) {
                imageData.setpY((int)CTM[1][0]);
            } else {
                imageData.setpY((int)CTM[1][1]);
            }
            if (!this.getSamplingOnly && (w < 500 || h < 600 && w < 1000)) {
                imageData.setpX(0);
                imageData.setpX(0);
            }
        } else if (SamplingFactory.downsampleLevel == 1 || SamplingFactory.downsampleLevel == 5) {
            imageData.setpX(this.pageData.getCropBoxWidth(this.parserOptions.getPageNumber()));
            imageData.setpY(this.pageData.getCropBoxHeight(this.parserOptions.getPageNumber()));
        }
        boolean hasMask = XObject2.getRawObjectType() == 489767739 || XObject2.getIntArray(489767739) != null;
        int maxHTMLImageSize = 4000;
        if (w < 4000 && h < 4000 && this.current.isHTMLorSVG() && (imageData.getDepth() != 1 || !hasMask)) {
            imageData.setpX(-1);
            imageData.setpY(1);
        }
        if (imageData.getDepth() == 1 && !hasMask && decodeColorData.getID() == 1568372915 && imageData.getHeight() < 300) {
            imageData.setpX(0);
            imageData.setpY(0);
        }
    }

    public void setRes(PdfObjectCache cache) {
        this.cache = cache;
    }

    public int processImage(String s, int dataPointer, PdfObject xObject) {
        return 0;
    }

    public int processImage(int dataPointer, int startInlineStream, byte[] stream, int tokenNumber) throws Exception {
        return 0;
    }
}

