/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Rectangle;
import java.awt.Shape;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.GlyphTracker;
import org.jpedal.external.ShapeTracker;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.DefaultErrorTracker;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.SwingShape;
import org.jpedal.objects.TextState;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.ExtGStateObject;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.objects.structuredtext.HTMLStructuredContentHandler;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FontResolver;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.T3Decoder;
import org.jpedal.parser.XFormDecoder;
import org.jpedal.parser.color.CS;
import org.jpedal.parser.color.G;
import org.jpedal.parser.color.K;
import org.jpedal.parser.color.RG;
import org.jpedal.parser.color.SCN;
import org.jpedal.parser.gs.CM;
import org.jpedal.parser.gs.Q;
import org.jpedal.parser.image.DO;
import org.jpedal.parser.image.ID;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.shape.B;
import org.jpedal.parser.shape.D;
import org.jpedal.parser.shape.F;
import org.jpedal.parser.shape.J;
import org.jpedal.parser.shape.N;
import org.jpedal.parser.shape.S;
import org.jpedal.parser.shape.SH;
import org.jpedal.parser.text.BDC;
import org.jpedal.parser.text.EMC;
import org.jpedal.parser.text.TD;
import org.jpedal.parser.text.TR;
import org.jpedal.parser.text.Tj;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PdfStreamDecoder
extends BaseDecoder {
    public static final boolean showCommands = false;
    private StructuredContentHandler contentHandler;
    private int startInlineStream;
    private int shapeCommandCount;
    int formLevel;
    PdfObjectCache cache;
    PdfPageData pageData;
    ErrorTracker errorTracker;
    PdfObjectReader currentPdfFile;
    GraphicsState newGS;
    byte[] pageStream;
    private PdfLayerList layers;
    boolean getSamplingOnly;
    private boolean isTTHintingRequired;
    final Vector_Int textDirections = new Vector_Int();
    final Vector_Rectangle_Int textAreas = new Vector_Rectangle_Int();
    public boolean ignoreColors;
    int imageCount;
    private String lastTextValue = "";
    private int lastDataPointer = -1;
    private T3Decoder t3Decoder;
    private boolean removeRenderImages;
    private boolean multipleTJs;
    private boolean textColorExtracted;
    private boolean textExtracted = true;
    private boolean renderText;
    private int tokenNumber;
    String imagesInFile;
    public static final float currentThreshold = 0.595f;
    private PdfFontFactory pdfFontFactory;
    boolean isXMLExtraction;
    private StatusBar statusBar;
    final PdfData pdfData = new PdfData();
    final PdfImageData pdfImages = new PdfImageData();
    static String indent = "";
    boolean isDataValid = true;
    private PdfFont currentFontData;
    ObjectStore objectStoreStreamRef;
    String formName = "";
    public static boolean useTextPrintingForNonEmbeddedFonts;
    private static final int maxShapesAllowed;
    private String testsDisableImages;
    boolean isPrinting;

    public PdfStreamDecoder(PdfObjectReader currentPdfFile) {
        this.init(currentPdfFile);
    }

    public PdfStreamDecoder(PdfObjectReader currentPdfFile, PdfLayerList layers) {
        if (layers != null) {
            this.layers = layers;
        }
        this.init(currentPdfFile);
    }

    private void init(PdfObjectReader currentPdfFile) {
        this.cache = new PdfObjectCache();
        this.gs = new GraphicsState();
        this.errorTracker = new DefaultErrorTracker();
        this.pageData = new PdfPageData();
        StandardFonts.checkLoaded(1);
        StandardFonts.checkLoaded(0);
        this.currentPdfFile = currentPdfFile;
        this.pdfFontFactory = new PdfFontFactory(currentPdfFile);
        this.testsDisableImages = System.getProperty("testsDisableImages");
    }

    public T3Size decodePageContent(PdfObject pdfObject) {
        try {
            this.objectStoreStreamRef.flushPageLevelCaches();
            this.parserOptions.imagesProcessedFully = true;
            this.parserOptions.tooManyShapes = false;
            this.imageCount = 0;
            this.parserOptions.setPdfLayerList(this.layers);
            this.imagesInFile = null;
            if (!this.parserOptions.renderDirectly() && this.statusBar != null) {
                this.statusBar.percentageDone = 0.0f;
            }
            this.gs = this.newGS != null ? this.newGS : new GraphicsState(0, 0);
            if (this.parserOptions.isRenderPage()) {
                this.current.drawClip(this.gs, null, false);
                int pageNum = this.parserOptions.getPageNumber();
                this.current.writeCustom(41, new Rectangle(this.pageData.getCropBoxX(pageNum), this.pageData.getCropBoxY(pageNum), this.pageData.getCropBoxWidth(pageNum), this.pageData.getCropBoxHeight(pageNum)));
            }
            byte[] b_data = null;
            byte[][] pageContents = null;
            if (pdfObject != null) {
                pageContents = pdfObject.getKeyArray(1216184967);
                this.isDataValid = pdfObject.streamMayBeCorrupt();
            }
            if (pdfObject != null && pageContents == null) {
                b_data = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader()));
            } else if (this.pageStream != null) {
                b_data = this.pageStream;
            } else if (pdfObject != null) {
                b_data = this.currentPdfFile.getObjectReader().readPageIntoStream(pdfObject);
            }
            this.lastDataPointer = -1;
            if (b_data != null && b_data.length > 0) {
                this.decodeStreamIntoObjects(b_data, false);
            }
            if (!this.parserOptions.isType3Font()) {
                this.cache.resetFonts();
            }
            T3Size t3 = new T3Size();
            if (this.t3Decoder != null) {
                t3.x = this.t3Decoder.T3maxWidth;
                t3.y = this.t3Decoder.T3maxHeight;
                this.ignoreColors = this.t3Decoder.ignoreColors;
                this.t3Decoder = null;
            }
            return t3;
        }
        catch (Error err) {
            LogWriter.writeLog("Error " + err);
            this.errorTracker.addPageFailureMessage("Problem decoding page " + err);
            return null;
        }
    }

    public void setObjectValue(int key, Object obj) {
        switch (key) {
            case -9: {
                this.parserOptions.setName((String)obj);
                break;
            }
            case -18: {
                this.pageData = (PdfPageData)obj;
                if (!this.textColorExtracted) break;
                this.pdfData.enableTextColorDataExtraction();
                break;
            }
            case -3: {
                this.statusBar = (StatusBar)obj;
                break;
            }
            case -4: {
                this.layers = (PdfLayerList)obj;
                break;
            }
            case -5: {
                this.contentHandler = this.isHTML ? new HTMLStructuredContentHandler(obj, this.current) : new StructuredContentHandler(obj);
                this.parserOptions.setContentHandler(this.contentHandler);
                break;
            }
            case 12: {
                this.parserOptions.setCustomGlyphTracker((GlyphTracker)obj);
                break;
            }
            case -7: {
                this.parserOptions.setRenderDirectly();
                break;
            }
            case -8: {
                this.objectStoreStreamRef = (ObjectStore)obj;
                break;
            }
            case 31: {
                this.errorTracker = (ErrorTracker)obj;
                break;
            }
            case 13: {
                this.parserOptions.setCustomShapeTracker((ShapeTracker)obj);
            }
        }
    }

    public void setBooleanValue(int key, boolean value) {
        if (key == 21) {
            this.parserOptions.setGenerateGlyphOnRender(value);
        }
    }

    public void setDefaultColors(PdfPaint strokeCol, PdfPaint nonstrokeCol) {
        this.gs.strokeColorSpace.setColor(strokeCol);
        this.gs.nonstrokeColorSpace.setColor(nonstrokeCol);
    }

    public Object getObjectValue(int key) {
        switch (key) {
            case -19: {
                if (DecoderOptions.embedWidthData) {
                    this.pdfData.widthIsEmbedded();
                }
                return this.pdfData;
            }
            case -20: {
                return this.pdfImages;
            }
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
            case 23: {
                return this.current;
            }
            case 373243460: {
                return this.pdfFontFactory.getFontsInFile();
            }
            case 1026635598: {
                return this.imagesInFile;
            }
            case 4: {
                return this.pdfFontFactory.getNonEmbeddedCIDFonts();
            }
            case 1: {
                return this.cache.iterator(1);
            }
        }
        return null;
    }

    public final void readResources(PdfObject Resources, boolean resetList) {
        if (resetList) {
            this.pdfFontFactory.resetFontsInFile();
        }
        this.currentPdfFile.checkResolved(Resources);
        this.cache.readResources(Resources, resetList, this.currentPdfFile.getObjectReader());
    }

    public String decodeStreamIntoObjects(byte[] stream, boolean returnText) {
        if (stream.length == 0) {
            return null;
        }
        this.startInlineStream = 0;
        CommandParser parser = new CommandParser(stream);
        int streamSize = stream.length;
        int dataPointer = 0;
        int startCommand = 0;
        this.shapeCommandCount = 0;
        SwingShape currentDrawShape = new SwingShape();
        Tj textDecoder = this.getTextDecoder(returnText);
        while (!this.errorTracker.checkForExitRequest(dataPointer, streamSize)) {
            if (this.statusBar != null && !this.parserOptions.renderDirectly()) {
                this.statusBar.percentageDone = 90 * dataPointer / streamSize;
            }
            dataPointer = parser.getCommandValues(dataPointer, this.tokenNumber);
            int commandID = parser.getCommandID();
            if (dataPointer < 0) {
                dataPointer = -dataPointer;
                try {
                    int commandType = Cmd.getCommandType(commandID);
                    switch (commandType) {
                        case 0: {
                            if (commandID != 4541763 && commandID != 0x424443 && !this.parserOptions.isLayerVisible() || this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            dataPointer = this.processTextToken(textDecoder, parser, commandID, startCommand, dataPointer);
                            break;
                        }
                        case 2: {
                            if (this.getSamplingOnly) break;
                            this.processShapeCommands(parser, currentDrawShape, commandID);
                            break;
                        }
                        case 3: {
                            if (this.getSamplingOnly || !this.parserOptions.isRenderPage() || this.testsDisableImages != null) break;
                            SH.execute(this.parserOptions, parser.generateOpAsString(0, true), this.cache, this.gs, this.currentPdfFile, this.current);
                            break;
                        }
                        case 1: {
                            if (!this.getSamplingOnly) {
                                this.processColor(parser, commandID);
                            }
                            this.gs.getTextState().setLastTdValue(0.0f);
                            break;
                        }
                        case 4: {
                            this.processGScommands(parser, commandID);
                            if (commandID != 25453) break;
                            this.multipleTJs = false;
                            break;
                        }
                        case 5: {
                            if (commandID == 16969) {
                                this.startInlineStream = dataPointer;
                                break;
                            }
                            dataPointer = this.processImageCommands(parser, commandID, dataPointer);
                            break;
                        }
                        case 6: {
                            if (this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            this.setT3Decoder(parser, commandID);
                        }
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("[PDF] " + e + " Processing token >" + Cmd.getCommandAsString(commandID) + "<>" + this.parserOptions.getFileName() + " <" + this.parserOptions.getPageNumber());
                    if (!this.isDataValid) {
                        dataPointer = streamSize;
                    }
                }
                catch (OutOfMemoryError ee) {
                    this.errorTracker.addPageFailureMessage("Memory error decoding token stream " + ee);
                    LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                }
                startCommand = dataPointer;
                parser.reset();
                this.incrementTokenNumber();
            }
            if (streamSize > dataPointer) continue;
            break;
        }
        if (!this.parserOptions.renderDirectly() && this.statusBar != null) {
            this.statusBar.percentageDone = 100.0f;
        }
        this.isTTHintingRequired = textDecoder.isTTHintingRequired();
        if (returnText) {
            return this.lastTextValue;
        }
        return "";
    }

    private void setT3Decoder(CommandParser parser, int commandID) {
        if (this.t3Decoder == null) {
            this.t3Decoder = new T3Decoder();
        }
        this.t3Decoder.setCommands(parser);
        this.t3Decoder.setCommands(parser);
        this.t3Decoder.processToken(commandID);
    }

    private Tj getTextDecoder(boolean returnText) {
        Tj textDecoder;
        if (this.parserOptions.hasContentHandler()) {
            textDecoder = new Tj(this.parserOptions, this.textAreas, this.textDirections, this.current, this.errorTracker);
        } else {
            textDecoder = new Tj(this.parserOptions, this.pdfData, this.isXMLExtraction, this.textAreas, this.textDirections, this.current, this.errorTracker);
            textDecoder.setReturnText(returnText);
        }
        textDecoder.setStreamType(this.streamType);
        if (this.statusBar != null && !this.parserOptions.renderDirectly()) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        return textDecoder;
    }

    private int processImageCommands(CommandParser parser, int commandID, int dataPointer) throws Exception {
        PdfObject XObject2 = null;
        int subtype = 1;
        if (commandID == 17519) {
            String name = parser.generateOpAsString(0, true);
            byte[] XObjectData = this.cache.getXObjects(name);
            if (XObjectData != null) {
                XObject2 = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new XObject("1 0 R"), this.currentPdfFile.getObjectReader(), XObjectData, 979194486);
                subtype = XObject2.getParameterConstant(1147962727);
            }
            if (subtype == 373244477 && (this.formLevel <= 100 || dataPointer != this.lastDataPointer)) {
                this.lastDataPointer = dataPointer;
                if (this.parserOptions.isLayerVisible() && (this.layers == null || this.layers.isVisible(XObject2))) {
                    this.currentPdfFile.xobjectStartTM = this.gs.CTM;
                    XFormDecoder.processXForm(this, XObject2, parser);
                    this.currentPdfFile.xobjectStartTM = null;
                }
            }
        }
        if (subtype != 373244477) {
            ImageDecoder imageDecoder = commandID != 17519 ? new ID(this.imageCount, this.currentPdfFile, this.errorTracker, this.objectStoreStreamRef, this.pdfImages, this.pageData, this.imagesInFile) : new DO(this.imageCount, this.currentPdfFile, this.errorTracker, this.objectStoreStreamRef, this.pdfImages, this.pageData, this.imagesInFile);
            imageDecoder.setRes(this.cache);
            imageDecoder.setGS(this.gs);
            imageDecoder.setSamplingOnly(this.getSamplingOnly);
            imageDecoder.setStreamType(this.streamType);
            imageDecoder.setMultiplyer(this.multiplyer);
            imageDecoder.setRenderer(this.current);
            this.parserOptions.isPrinting(this.isPrinting);
            imageDecoder.setParams(this.parserOptions);
            if (commandID == 17519) {
                if (XObject2 != null && this.parserOptions.isLayerVisible() && (this.layers == null || this.layers.isVisible(XObject2))) {
                    String name = parser.generateOpAsString(0, true);
                    if (this.formLevel > 0) {
                        name = this.formName + '_' + this.formLevel + '_' + name;
                    }
                    dataPointer = imageDecoder.processImage(name, dataPointer, XObject2);
                }
            } else if (this.parserOptions.isLayerVisible()) {
                dataPointer = imageDecoder.processImage(dataPointer, this.startInlineStream, parser.getStream(), this.tokenNumber);
            }
            ++this.imageCount;
            this.imagesInFile = imageDecoder.getImagesInFile();
        }
        return dataPointer;
    }

    private void processColor(CommandParser parser, int commandID) {
        if (commandID != 5456718 && commandID != 7562094 && commandID != 21315 && commandID != 29539) {
            this.current.writeCustom(18, null);
        }
        switch (commandID) {
            case 25459: {
                CS.execute(true, parser.generateOpAsString(0, true), this.gs, this.cache, this.currentPdfFile);
                break;
            }
            case 17235: {
                CS.execute(false, parser.generateOpAsString(0, true), this.gs, this.cache, this.currentPdfFile);
                break;
            }
            case 29287: {
                RG.execute(true, this.gs, parser.getValuesAsFloat(), this.cache);
                break;
            }
            case 21063: {
                RG.execute(false, this.gs, parser.getValuesAsFloat(), this.cache);
                break;
            }
            case 21315: 
            case 5456718: {
                SCN.execute(false, this.gs, parser, this.cache);
                break;
            }
            case 29539: 
            case 7562094: {
                SCN.execute(true, this.gs, parser, this.cache);
                break;
            }
            case 103: {
                G.execute(true, this.gs, parser, this.cache);
                break;
            }
            case 71: {
                G.execute(false, this.gs, parser, this.cache);
                break;
            }
            case 107: {
                K.execute(true, this.gs, parser, this.cache);
                break;
            }
            case 75: {
                K.execute(false, this.gs, parser, this.cache);
            }
        }
    }

    private void processGScommands(CommandParser parser, int commandID) {
        switch (commandID) {
            case 25453: {
                CM.execute(this.gs, parser);
                break;
            }
            case 113: {
                this.gs = Q.execute(this.gs, true, this.graphicsStates, this.current);
                break;
            }
            case 81: {
                this.gs = Q.execute(this.gs, false, this.graphicsStates, this.current);
                break;
            }
            case 26483: {
                String key;
                byte[] data;
                if (this.getSamplingOnly || (data = this.cache.GraphicsStates.get(key = parser.generateOpAsString(0, true))) == null) break;
                ExtGStateObject GS = PdfStreamDecoder.getExtStateObjectFromRefOrDirect(this.currentPdfFile, data);
                this.gs.setMode(GS);
                int blendMode = this.gs.getBMValue();
                this.current.setGraphicsState(2, this.gs.getAlpha(2), blendMode);
                this.current.setGraphicsState(1, this.gs.getAlpha(1), blendMode);
            }
        }
    }

    private void processShapeCommands(CommandParser parser, PdfShape currentDrawShape, int commandID) throws PdfException {
        switch (commandID) {
            case 66: {
                if (this.removeRenderImages) break;
                Shape currentShape = B.execute(false, false, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions);
                this.trackShape(currentShape, 66);
                break;
            }
            case 98: {
                if (this.removeRenderImages) break;
                Shape currentShape = B.execute(false, true, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions);
                this.trackShape(currentShape, 98);
                break;
            }
            case 25130: {
                if (this.removeRenderImages) break;
                Shape currentShape = B.execute(true, true, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions);
                this.trackShape(currentShape, 25130);
                break;
            }
            case 16938: {
                if (this.removeRenderImages) break;
                Shape currentShape = B.execute(true, false, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions);
                this.trackShape(currentShape, 16938);
                break;
            }
            case 99: {
                PdfStreamDecoder.C(parser, currentDrawShape);
                break;
            }
            case 100: {
                D.execute(parser, this.gs);
                break;
            }
            case 70: 
            case 102: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, false, this.formLevel, currentDrawShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 17962: 
            case 26154: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, true, this.formLevel, currentDrawShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 104: {
                currentDrawShape.closeShape();
                break;
            }
            case 74: {
                J.execute(false, parser.parseInt(), this.gs);
                break;
            }
            case 106: {
                J.execute(true, parser.parseInt(), this.gs);
                break;
            }
            case 108: {
                currentDrawShape.lineTo(parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 77: {
                this.gs.setMitreLimit((int)parser.parseFloat(0));
                break;
            }
            case 109: {
                currentDrawShape.setClip(false);
                currentDrawShape.moveTo(parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 110: {
                N.execute(currentDrawShape, this.gs, this.formLevel, this.parserOptions, this.current, this.pageData);
                break;
            }
            case 29285: {
                currentDrawShape.appendRectangle(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 83: {
                if (this.removeRenderImages) break;
                Shape currentShape = S.execute(false, this.gs, currentDrawShape, this.current, this.parserOptions);
                this.trackShape(currentShape, 83);
                break;
            }
            case 115: {
                if (this.removeRenderImages) break;
                Shape currentShape = S.execute(true, this.gs, currentDrawShape, this.current, this.parserOptions);
                this.trackShape(currentShape, 115);
                break;
            }
            case 118: {
                currentDrawShape.addBezierCurveV(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 119: {
                this.gs.setLineWidth(parser.parseFloat(0));
                break;
            }
            case 22314: {
                currentDrawShape.setEVENODDWindingRule();
                currentDrawShape.setClip(true);
                break;
            }
            case 87: {
                currentDrawShape.setNONZEROWindingRule();
                currentDrawShape.setClip(true);
                break;
            }
            case 121: {
                currentDrawShape.addBezierCurveY(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
            }
        }
        ++this.shapeCommandCount;
        if (maxShapesAllowed > 0 && this.shapeCommandCount > maxShapesAllowed) {
            String errMessage = "[PDF] Shapes on page exceed limit set by JVM flag org.jpedal.maxShapeCount - value " + maxShapesAllowed;
            this.parserOptions.tooManyShapes = true;
            throw new PdfException(errMessage);
        }
    }

    private static void C(CommandParser parser, PdfShape currentDrawShape) {
        float x3 = parser.parseFloat(1);
        float y3 = parser.parseFloat(0);
        float x2 = parser.parseFloat(3);
        float y2 = parser.parseFloat(2);
        float x = parser.parseFloat(5);
        float y = parser.parseFloat(4);
        currentDrawShape.addBezierCurveC(x, y, x2, y2, x3, y3);
    }

    private void trackShape(Shape currentShape, int bstar) {
        ShapeTracker customShapeTracker;
        if (currentShape != null && (customShapeTracker = this.parserOptions.getCustomShapeTraker()) != null) {
            customShapeTracker.addShape(this.tokenNumber, bstar, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
        }
    }

    public boolean getBooleanValue(int key) {
        switch (key) {
            case -1: {
                return this.pdfFontFactory.hasEmbeddedFonts();
            }
            case -2: {
                return this.contentHandler != null && this.contentHandler.hasContent();
            }
            case 1: {
                return this.errorTracker.ispageSuccessful();
            }
            case 4: {
                return this.pdfFontFactory.hasNonEmbeddedCIDFonts();
            }
            case 2: {
                return this.parserOptions.imagesProcessedFully;
            }
            case 64: {
                return this.parserOptions.tooManyShapes;
            }
            case 32: {
                return this.isTTHintingRequired;
            }
        }
        throw new RuntimeException("Unknown value " + key);
    }

    public void dispose() {
        this.pdfData.dispose();
    }

    public void setIntValue(int key, int value) {
        switch (key) {
            case -10: {
                this.parserOptions.setPageNumber(value);
                break;
            }
            case -15: {
                this.parserOptions.setTextPrint(value);
            }
        }
    }

    public void setXMLExtraction(boolean isXMLExtraction) {
        this.isXMLExtraction = isXMLExtraction;
    }

    public void setParameters(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, boolean isPrinting) {
        this.parserOptions.init(isPageContent, renderPage, renderMode, extractionMode, isPrinting);
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.textExtracted = (extractionMode & 1) == 1;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
        this.removeRenderImages = renderPage && (renderMode & 0x10) == 16;
    }

    public void setFormLevel(int value) {
        this.formLevel = value;
    }

    private int processTextToken(Tj textDecoder, CommandParser parser, int commandID, int startCommand, int dataPointer) {
        textDecoder.setGS(this.gs);
        TextState currentTextState = this.gs.getTextState();
        switch (commandID) {
            case 4345155: {
                this.BMC(parser);
                break;
            }
            case 0x424443: {
                this.BDC(textDecoder, parser, startCommand, dataPointer);
                break;
            }
            case 16980: {
                this.BT(currentTextState);
                break;
            }
            case 4541763: {
                this.EMC(textDecoder);
                currentTextState.setLastTdValue(0.0f);
                break;
            }
            case 17748: {
                this.ET();
                currentTextState.setLastTdValue(0.0f);
                break;
            }
            case 17488: {
                this.DP(parser);
                break;
            }
            case 21606: {
                currentTextState.TF(parser.parseFloat(0), parser.generateOpAsString(1, true));
                break;
            }
            case 21603: {
                currentTextState.setCharacterSpacing(parser.parseFloat(0));
                break;
            }
            case 21572: {
                TD.execute(false, parser.parseFloat(1), parser.parseFloat(0), currentTextState);
                this.multipleTJs = false;
                break;
            }
            case 21604: {
                TD.execute(true, parser.parseFloat(1), parser.parseFloat(0), currentTextState);
                this.multipleTJs = false;
                break;
            }
            case 21610: {
                this.handleTextToken(currentTextState);
                if (currentTextState.getTfs() != 0.0f) {
                    this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, parser.getStream(), startCommand, dataPointer, this.multipleTJs);
                }
                this.multipleTJs = true;
                break;
            }
            case 21578: {
                this.handleTextToken(currentTextState);
                this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, parser.getStream(), startCommand, dataPointer, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 39: {
                this.quote(textDecoder, parser, startCommand, dataPointer, currentTextState);
                break;
            }
            case 34: {
                this.handleTextToken(currentTextState);
                this.doubleQuote(textDecoder, parser, startCommand, dataPointer, currentTextState);
                break;
            }
            case 21613: {
                this.Tm(parser, currentTextState);
                currentTextState.setLastTdValue(0.0f);
                break;
            }
            case 21546: {
                float moveValue = -currentTextState.getLeading();
                TD.relativeMove(0.0f, moveValue, currentTextState);
                this.multipleTJs = false;
                break;
            }
            case 21618: {
                int value = TR.execute(parser.parseInt(), this.gs);
                if (this.parserOptions.isRenderPage() && !this.parserOptions.renderDirectly()) {
                    this.current.drawTR(value);
                }
                currentTextState.setLastTdValue(0.0f);
                break;
            }
            case 21619: {
                currentTextState.setTextRise(parser.parseFloat(0));
                break;
            }
            case 21623: {
                currentTextState.setWordSpacing(parser.parseFloat(0));
                break;
            }
            case 21626: {
                currentTextState.setHorizontalScaling(parser.parseFloat(0) / 100.0f);
                break;
            }
            case 21580: {
                currentTextState.setLeading(parser.parseFloat(0));
            }
        }
        return dataPointer;
    }

    private void quote(Tj textDecoder, CommandParser parser, int startCommand, int dataPointer, TextState currentTextState) {
        this.handleTextToken(currentTextState);
        TD.relativeMove(0.0f, -currentTextState.getLeading(), currentTextState);
        this.multipleTJs = false;
        this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, parser.getStream(), startCommand, dataPointer, this.multipleTJs);
        this.multipleTJs = true;
    }

    private void Tm(CommandParser parser, TextState currentTextState) {
        currentTextState.Tm[0][0] = parser.parseFloat(5);
        currentTextState.Tm[0][1] = parser.parseFloat(4);
        currentTextState.Tm[0][2] = 0.0f;
        currentTextState.Tm[1][0] = parser.parseFloat(3);
        currentTextState.Tm[1][1] = parser.parseFloat(2);
        currentTextState.Tm[1][2] = 0.0f;
        currentTextState.Tm[2][0] = parser.parseFloat(1);
        currentTextState.Tm[2][1] = parser.parseFloat(0);
        currentTextState.Tm[2][2] = 1.0f;
        currentTextState.setTMAtLineStart();
        this.multipleTJs = false;
    }

    private void ET() {
        this.current.writeCustom(18, null);
        if (this.gs.getTextRenderType() == 7) {
            this.current.drawClip(this.gs, null, false);
        }
        this.multipleTJs = false;
    }

    private void DP(CommandParser parser) {
        if (this.contentHandler != null) {
            MCObject obj = new MCObject(parser.generateOpAsString(0, false));
            this.currentPdfFile.readObject(obj);
            this.contentHandler.DP(obj);
        }
    }

    private void BT(TextState currentTextState) {
        if (this.parserOptions.isRenderPage()) {
            this.current.drawClip(this.gs, null, true);
            this.current.drawTR(this.gs.getTextRenderType());
        }
        currentTextState.resetTm();
    }

    private void handleTextToken(TextState currentTextState) {
        if (currentTextState.hasFontChanged() && currentTextState.getTfs() != 0.0f || this.currentFontData != null && this.currentFontData.getFontType() == 1228944679) {
            this.setFontToUse(currentTextState);
        }
        if (this.currentFontData == null) {
            this.currentFontData = new PdfFont(this.currentPdfFile);
            this.currentFontData.getGlyphData().logicalfontName = StandardFonts.expandName(currentTextState.getFontID());
        }
        if (currentTextState.hasFontChanged()) {
            currentTextState.setFontChanged(false);
        }
    }

    private void BMC(CommandParser parser) {
        this.parserOptions.setLayerLevel(this.parserOptions.getLayerLevel() + 1);
        if (this.parserOptions.isLayerVisible()) {
            this.parserOptions.getLayerVisibility().add(this.parserOptions.getLayerLevel());
        }
        if (this.contentHandler != null) {
            this.contentHandler.BMC(parser.generateOpAsString(0, false));
        }
    }

    private void BDC(Tj textDecoder, CommandParser parser, int startCommand, int dataPointer) {
        PdfObject BDCobj = BDC.execute(startCommand, dataPointer, parser.getStream(), parser.generateOpAsString(0, false), this.gs, this.currentPdfFile, this.current, this.parserOptions, this.cache);
        textDecoder.setActualText(BDCobj.getTextStreamValue(1752861363));
        if (this.contentHandler != null) {
            this.contentHandler.BDC(BDCobj);
        }
    }

    private void EMC(Tj textDecoder) {
        textDecoder.setActualText(null);
        if (this.contentHandler != null) {
            this.contentHandler.EMC();
        }
        EMC.execute(this.current, this.gs, this.parserOptions);
    }

    private void doubleQuote(Tj textDecoder, CommandParser parser, int startCommand, int dataPointer, TextState currentTextState) {
        byte[] characterStream = parser.getStream();
        currentTextState.setCharacterSpacing(parser.parseFloat(1));
        currentTextState.setWordSpacing(parser.parseFloat(2));
        TD.relativeMove(0.0f, -currentTextState.getLeading(), currentTextState);
        this.multipleTJs = false;
        while (characterStream[startCommand] != 40 && characterStream[startCommand] != 60 && characterStream[startCommand] != 91) {
            ++startCommand;
        }
        this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, characterStream, startCommand, dataPointer, false);
        this.multipleTJs = true;
    }

    private void setFontToUse(TextState currentTextState) {
        String fontID = currentTextState.getFontID();
        PdfFont restoredFont = FontResolver.resolveFont(this.gs, this, fontID, this.pdfFontFactory, this.cache);
        if (restoredFont != null) {
            this.currentFontData = restoredFont;
        }
    }

    public PdfObjectCache getObjectCache() {
        return this.cache;
    }

    public void incrementTokenNumber() {
        ++this.tokenNumber;
        this.current.setValue(6, this.tokenNumber);
    }

    private static ExtGStateObject getExtStateObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        ExtGStateObject obj = new ExtGStateObject(new String(data));
        if (data[0] == 60) {
            obj.setStatus(2);
        } else {
            obj.setStatus(1);
        }
        obj.setUnresolvedData(data, -1938465939);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(obj);
        return obj;
    }

    static {
        SamplingFactory.setDownsampleMode(null);
        String maxShapes = System.getProperty("org.jpedal.maxShapeCount");
        if (maxShapes != null) {
            try {
                maxShapesAllowed = Integer.parseInt(maxShapes);
            }
            catch (Exception e) {
                throw new RuntimeException("Your setting (" + maxShapes + ")for org.jpedal.maxShapeCount is not a valid number " + e);
            }
        } else {
            maxShapesAllowed = -1;
        }
    }
}

