/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.fonts.CIDFontType0;
import org.jpedal.fonts.CIDFontType2;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.Type3;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FallbackFont;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfFontFactory {
    private boolean hasEmbeddedFonts;
    private String fontsInFile;
    private final ArrayList<String> nonEmbeddedCIDFonts = new ArrayList();
    private final HashMap<String, PdfJavaGlyphs> fontsLoaded = new HashMap(50);
    private final PdfObjectReader currentPdfFile;

    public PdfFontFactory(PdfObjectReader currentPdfFile) {
        this.currentPdfFile = currentPdfFile;
    }

    public PdfFont createFont(PdfObject pdfObject, String font_id, ObjectStore objectStoreStreamRef, boolean renderPage, ErrorTracker errorTracker, boolean isHTML) throws PdfException {
        PdfObject fontDescriptor;
        PdfObject descendantFont = pdfObject.getDictionary(-1547306032);
        int fontType = pdfObject.getParameterConstant(1147962727);
        int origFontType = -1;
        if (fontType == 1228944676 && descendantFont != null) {
            origFontType = fontType = descendantFont.getParameterConstant(1147962727);
        }
        boolean isEmbedded = PdfFontFactory.isFontEmbedded(pdfObject);
        FallbackFont fallbackFont = null;
        if (isHTML && !isEmbedded && pdfObject.getParameterConstant(1147962727) != 1228944679 && (fontDescriptor = PdfFontFactory.getFontDescriptor(pdfObject, descendantFont)) != null) {
            fallbackFont = PdfFontFactory.calculateFallbackFontAndWriteToDisk(pdfObject, font_id, descendantFont, fontDescriptor.getInt(1009858393));
            PdfFontFactory.spoofFontFileInFontDescriptor(fontDescriptor, pdfObject.getObjectRefAsString(), fallbackFont.getName());
            fontType = descendantFont == null ? 1217103210 : -1684566724;
            isEmbedded = true;
        }
        PdfFont currentFontData = null;
        if (isEmbedded) {
            fontType = PdfFontFactory.reassignTypeIfOpenType(pdfObject, this.currentPdfFile, fontType);
            currentFontData = PdfFontFactory.createFont(fontType, this.currentPdfFile, null, objectStoreStreamRef, this.fontsLoaded);
            isEmbedded = PdfFontFactory.loadFont(currentFontData, fontType, pdfObject, font_id, renderPage, errorTracker);
        }
        String subFont = null;
        String rawFont = "";
        if (!isEmbedded) {
            if (FontMappings.fontSubstitutionTable != null && pdfObject.getParameterConstant(1147962727) != 1228944679) {
                String fontName;
                rawFont = PdfFontFactory.getFontName(pdfObject, font_id, descendantFont);
                if (rawFont.indexOf(35) != -1) {
                    rawFont = StringUtils.convertHexChars(rawFont);
                }
                if (!(FontMappings.fontSubstitutionTable.get(fontName = PdfFontFactory.stripPostscript(rawFont).toLowerCase()) != null || DecoderOptions.isRunningOnMac && "zapfdingbats".equals(fontName))) {
                    fontName = PdfFontFactory.getAliasedFontName(fontName);
                }
                if (FontMappings.fontSubstitutionTable.get(fontName) == null && rawFont.startsWith("Wingdings") && FontMappings.fontSubstitutionTable.get(fontName = (rawFont = DecoderOptions.isRunningOnMac ? "WingDings" : "WingDing").toLowerCase()) == null) {
                    fontName = PdfFontFactory.getAliasedFontName(fontName);
                }
                String newSubtype = FontMappings.fontSubstitutionTable.get(fontName);
                subFont = FontMappings.fontSubstitutionLocation.get(fontName);
                if (newSubtype != null && descendantFont == null) {
                    fontType = PdfFontFactory.convertStringToFontType(newSubtype);
                    origFontType = pdfObject.getParameterConstant(1147962727);
                }
            }
            if (isHTML && subFont == null && fontType != 1228944679) {
                String subFontName = PdfFontFactory.calculateFallbackFontAndWriteToDisk(pdfObject, font_id, descendantFont, 0).getName();
                subFont = FontMappings.fontSubstitutionLocation.get(subFontName);
                fontType = PdfFontFactory.convertStringToFontType(FontMappings.fontSubstitutionTable.get(subFontName));
            }
            fontType = PdfFontFactory.reassignTypeIfOpenType(pdfObject, this.currentPdfFile, fontType);
            currentFontData = PdfFontFactory.createFont(fontType, this.currentPdfFile, subFont, objectStoreStreamRef, this.fontsLoaded);
            PdfFontFactory.loadFont(currentFontData, fontType, pdfObject, font_id, renderPage, errorTracker);
        }
        if (!(fontType != -1684566726 && fontType != -1684566724 || isEmbedded || subFont != null)) {
            this.nonEmbeddedCIDFonts.add(PdfFontFactory.stripPostscript(rawFont).toLowerCase());
        }
        if (currentFontData != null) {
            currentFontData.setRawFontName(rawFont);
            if (fallbackFont != null) {
                currentFontData.setFallbackFont(fallbackFont);
            }
            if (this.fontsInFile == null || !this.fontsInFile.contains(font_id + "  ")) {
                this.setDetails(font_id, currentFontData, fontType, descendantFont, origFontType, subFont);
            }
        }
        return currentFontData;
    }

    private static boolean loadFont(PdfFont currentFontData, int fontType, PdfObject pdfObject, String font_id, boolean renderPage, ErrorTracker errorTracker) {
        try {
            currentFontData.createFont(pdfObject, font_id, renderPage);
            return currentFontData.isFontEmbedded;
        }
        catch (Exception e) {
            String error = "Problem " + e + " reading Font type " + StandardFonts.getFontTypeAsString(fontType);
            LogWriter.writeLog("[PDF] " + error);
            errorTracker.addPageFailureMessage(error);
            return true;
        }
    }

    private static PdfFont createFont(int fontType, PdfObjectReader currentPdfFile, String subFont, ObjectStore objectStore, Map<String, PdfJavaGlyphs> substitutedFonts) {
        PdfFont currentFontData;
        switch (fontType) {
            case 1217103210: {
                currentFontData = new TrueType(currentPdfFile, subFont, substitutedFonts);
                break;
            }
            case 1228944679: {
                currentFontData = new Type3(currentPdfFile, objectStore);
                break;
            }
            case -1684566726: {
                currentFontData = new CIDFontType0(currentPdfFile, subFont);
                break;
            }
            case -1684566724: {
                currentFontData = new CIDFontType2(currentPdfFile, subFont);
                break;
            }
            default: {
                currentFontData = new Type1C(currentPdfFile, subFont);
            }
        }
        if (FontMappings.defaultFont != null) {
            currentFontData.setDefaultDisplayFont(FontMappings.defaultFont);
        }
        return currentFontData;
    }

    private static FallbackFont calculateFallbackFontAndWriteToDisk(PdfObject pdfObject, String font_id, PdfObject descendantFont, int flags) {
        String fontName = PdfFontFactory.getFontName(pdfObject, font_id, descendantFont).toLowerCase();
        FallbackFont.BaseType baseType = PdfFontFactory.calculateFallbackBaseType(fontName, flags, pdfObject, descendantFont);
        FallbackFont.FontStyle fontStyle = PdfFontFactory.calculateFallbackFontStyle(fontName, flags, baseType);
        FallbackFont fallbackFont = new FallbackFont(baseType, fontStyle);
        FontMappings.addFallBackFont(fallbackFont);
        return fallbackFont;
    }

    private static boolean isJapaneseOrKoreanCIDFont(PdfObject descendantFont) {
        if (descendantFont == null) {
            return false;
        }
        PdfObject systemInfo = descendantFont.getDictionary(1972801240);
        if (systemInfo == null) {
            return false;
        }
        String ordering = systemInfo.getTextStreamValue(1635480172);
        return "Japan1".equals(ordering) || "Adobe-Korea1".equals(ordering) || "Adobe-KR".equals(ordering);
    }

    private static boolean hasNarrowWidths(PdfObject pdfObject) {
        float[] floatWidthValues = pdfObject.getFloatArray(876896124);
        if (floatWidthValues != null && floatWidthValues.length != 0) {
            float total = 0.0f;
            int count = 0;
            for (float width : floatWidthValues) {
                if (width == 0.0f) continue;
                total += width;
                ++count;
            }
            return count > 0 && total / (float)count < 450.0f;
        }
        return false;
    }

    private static FallbackFont.BaseType calculateFallbackBaseType(String fontName, int flags, PdfObject pdfObject, PdfObject descendantFont) {
        if (fontName.contains("times")) {
            return FallbackFont.BaseType.LiberationSerif;
        }
        if (fontName.contains("courier")) {
            return FallbackFont.BaseType.Texgyrecursor;
        }
        if (fontName.contains("narrow") || fontName.contains("light")) {
            if ((flags >> 1 & 1) == 1) {
                return FallbackFont.BaseType.LiberationSerif;
            }
            return FallbackFont.BaseType.NotoSansCondensed;
        }
        if (PdfFontFactory.isJapaneseOrKoreanCIDFont(descendantFont)) {
            return FallbackFont.BaseType.Unifont;
        }
        if (fontName.contains("arial")) {
            return FallbackFont.BaseType.LiberationSans;
        }
        if ((flags >> 1 & 1) == 1) {
            return FallbackFont.BaseType.LiberationSerif;
        }
        if (fontName.contains("zapf")) {
            return FallbackFont.BaseType.NotoSansSymbols2;
        }
        if ((flags & 1) == 1) {
            return FallbackFont.BaseType.Texgyrecursor;
        }
        if (PdfFontFactory.hasNarrowWidths(pdfObject)) {
            return FallbackFont.BaseType.NotoSansCondensed;
        }
        return FallbackFont.BaseType.LiberationSans;
    }

    private static FallbackFont.FontStyle calculateFallbackFontStyle(String fontName, int flags, FallbackFont.BaseType baseType) {
        boolean isBold;
        if (baseType == FallbackFont.BaseType.Unifont || baseType == FallbackFont.BaseType.NotoSansSymbols2) {
            return FallbackFont.FontStyle.Regular;
        }
        boolean isItalic = (flags >> 6 & 1) == 1;
        boolean bl = isBold = (flags >> 18 & 1) == 1;
        if (fontName == null) {
            fontName = "";
        }
        FallbackFont.FontStyle fontStyle = fontName.contains("bolditalic") || isBold && isItalic ? FallbackFont.FontStyle.BoldItalic : (fontName.contains("italic") || isItalic ? FallbackFont.FontStyle.Italic : (fontName.contains("bold") || fontName.contains("black") || fontName.contains("medium") || isBold ? FallbackFont.FontStyle.Bold : FallbackFont.FontStyle.Regular));
        return fontStyle;
    }

    private static PdfObject getFontDescriptor(PdfObject pdfObject, PdfObject descendantFont) {
        if (descendantFont == null) {
            return pdfObject.getDictionary(-1044665361);
        }
        return descendantFont.getDictionary(-1044665361);
    }

    private static void spoofFontFileInFontDescriptor(PdfObject fontDescriptor, String fontObjRef, String fallbackFontName) {
        byte[] stream;
        String location = FontMappings.fontSubstitutionLocation.get(fallbackFontName);
        if (location == null) {
            LogWriter.writeLog("Failed to spoof fallback font " + fallbackFontName + ". Could not find inside FontMappings?");
            return;
        }
        try (RandomAccessFile f = new RandomAccessFile(location, "r");){
            stream = new byte[(int)f.length()];
            f.readFully(stream);
        }
        catch (Exception e) {
            LogWriter.writeLog("[PDF] Exception reading fallback font " + e);
            return;
        }
        FontObject fontObj = new FontObject(fontObjRef);
        fontObj.setDecodedStream(stream);
        fontDescriptor.setDictionary(2021292334, fontObj);
    }

    private void setDetails(String font_id, PdfFont currentFontData, int fontType, PdfObject descendantFont, int origFontType, String subFont) {
        String details;
        String name = currentFontData.getFontName();
        if (name.indexOf(35) != -1) {
            name = StringUtils.convertHexChars(name);
        }
        if (currentFontData.isFontSubstituted()) {
            details = font_id + "  " + name + "  " + StandardFonts.getFontTypeAsString(origFontType) + "  Substituted (" + subFont + ' ' + StandardFonts.getFontTypeAsString(fontType) + ')';
        } else if (currentFontData.isFontEmbedded) {
            this.hasEmbeddedFonts = true;
            details = currentFontData.is1C() && descendantFont == null ? font_id + "  " + name + " Type1C  Embedded" : font_id + "  " + name + "  " + StandardFonts.getFontTypeAsString(fontType) + "  Embedded";
        } else {
            details = font_id + "  " + name + "  " + StandardFonts.getFontTypeAsString(fontType);
        }
        this.fontsInFile = this.fontsInFile == null ? details : details + '\n' + this.fontsInFile;
    }

    private static int reassignTypeIfOpenType(PdfObject pdfObject, PdfObjectReader currentPdfFile, int fontType) {
        if (fontType != 1228944677 && fontType != -1684566726) {
            return fontType;
        }
        if (fontType == -1684566726) {
            PdfObject desc = pdfObject.getDictionary(-1547306032);
            PdfObject FontDescriptor = desc.getDictionary(-1044665361);
            if (FontDescriptor != null) {
                byte[] stream;
                PdfObject FontFile22 = FontDescriptor.getDictionary(2021292334);
                if (FontFile22 == null) {
                    FontFile22 = FontDescriptor.getDictionary(2021292335);
                }
                if (FontFile22 != null && (stream = currentPdfFile.readStream(FontFile22, true, true, false, false, false, FontFile22.getCacheName(currentPdfFile.getObjectReader()))) != null && stream.length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                    fontType = -1684566724;
                }
            }
        } else {
            byte[] stream;
            PdfObject FontFile3;
            PdfObject FontDescriptor = pdfObject.getDictionary(-1044665361);
            if (FontDescriptor != null && (FontFile3 = FontDescriptor.getDictionary(2021292335)) != null && (stream = currentPdfFile.readStream(FontFile3, true, true, false, false, false, FontFile3.getCacheName(currentPdfFile.getObjectReader()))) != null && stream.length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                fontType = 1217103210;
            }
        }
        return fontType;
    }

    private static int convertStringToFontType(String newSubtype) {
        switch (newSubtype) {
            case "/Type1": 
            case "/Type1C": 
            case "/MMType1": {
                return 1228944677;
            }
            case "/TrueType": {
                return 1217103210;
            }
            case "/Type3": {
                return 1228944679;
            }
        }
        throw new RuntimeException("Unknown font type " + newSubtype + " used for font substitution");
    }

    private static String getFontName(PdfObject pdfObject, String font_id, PdfObject descendantFont) {
        String rawFont = descendantFont == null ? pdfObject.getName(678461817) : descendantFont.getName(678461817);
        if (rawFont == null) {
            rawFont = pdfObject.getName(506543413);
        }
        if (rawFont == null) {
            rawFont = font_id;
        }
        return rawFont;
    }

    private static String stripPostscript(String name) {
        return name.indexOf(43) == 6 ? name.substring(7) : name;
    }

    private static String getAliasedFontName(String rawFont) throws PdfException {
        String nextFont;
        String testFont = rawFont;
        String result = "";
        HashSet<String> fontsMapped = new HashSet<String>(50);
        while ((nextFont = FontMappings.fontSubstitutionAliasTable.get(testFont)) != null) {
            testFont = nextFont;
            if (FontMappings.fontSubstitutionTable.get(testFont) != null) {
                result = testFont;
            }
            if (fontsMapped.contains(testFont)) {
                StringBuilder errorMessage = new StringBuilder("[PDF] Circular font mapping for fonts");
                for (Object o : fontsMapped.toArray()) {
                    errorMessage.append(' ');
                    errorMessage.append(o);
                }
                throw new PdfException(errorMessage.toString());
            }
            fontsMapped.add(nextFont);
        }
        return result;
    }

    public static boolean isFontEmbedded(PdfObject pdfObject) {
        PdfObject descFontObj;
        int fontType = pdfObject.getParameterConstant(1147962727);
        if (fontType == 1228944676) {
            pdfObject = pdfObject.getDictionary(-1547306032);
        }
        return (descFontObj = pdfObject.getDictionary(-1044665361)) != null && descFontObj.hasStream();
    }

    public String getNonEmbeddedCIDFonts() {
        if (this.nonEmbeddedCIDFonts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.nonEmbeddedCIDFonts.get(0));
        for (int i = 1; i < this.nonEmbeddedCIDFonts.size(); ++i) {
            sb.append(',').append(this.nonEmbeddedCIDFonts.get(i));
        }
        return sb.toString();
    }

    public String getFontsInFile() {
        return this.fontsInFile;
    }

    public void resetFontsInFile() {
        this.fontsInFile = "";
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public boolean hasNonEmbeddedCIDFonts() {
        return !this.nonEmbeddedCIDFonts.isEmpty();
    }
}

