/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PdfStreamDecoderForSampling;
import org.jpedal.parser.swing.PDFtoImageConvertorSwing;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;

public abstract class PDFtoImageConvertor {
    private final Integer instance_bestQualityMaxScaling;
    private final Boolean instance_allowPagesSmallerThanPageSize;
    private final DecoderOptions options;
    protected float multiplyer;
    public static Boolean allowPagesSmallerThanPageSize = Boolean.FALSE;
    public static Integer bestQualityMaxScaling;
    protected DynamicVectorRenderer imageDisplay;
    protected AffineTransform imageScaling;
    protected int mediaH;
    protected int w;
    protected int h;
    protected int rotation;
    protected double crw;
    protected double crh;
    protected double crx;
    protected double cry;
    protected boolean rotated;

    protected PDFtoImageConvertor(float multiplyer, DecoderOptions options) {
        this.multiplyer = multiplyer;
        this.instance_allowPagesSmallerThanPageSize = options.getInstance_allowPagesSmallerThanPageSize();
        this.instance_bestQualityMaxScaling = options.getInstance_bestQualityMaxScaling();
        this.options = options;
    }

    public BufferedImage convert(DecoderResults resultsFromDecode, PdfResources res, ExternalHandlers externalHandlers, int renderMode, PdfPageData pageData, AcroRenderer formRenderer, float scaling, PdfObjectReader currentPdfFile, int pageIndex, boolean imageIsTransparent, String currentPageOffset) throws PdfException {
        ObjectStore localStore = currentPdfFile.getObjectStore();
        PageObject pdfObject = new PageObject(currentPageOffset);
        currentPdfFile.readObject(pdfObject);
        currentPdfFile.checkParentForResources(pdfObject);
        pdfObject.setPageNumber(pageIndex);
        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
        this.imageDisplay = this.getDisplay(pageIndex, localStore, imageIsTransparent);
        RenderUtils.setDisplayOptions(this.imageDisplay, this.options);
        PdfStreamDecoder currentImageDecoder = formRenderer.getStreamDecoder(currentPdfFile, null, true);
        currentImageDecoder.setParameters(true, true, renderMode, 1, false);
        externalHandlers.addHandlers(currentImageDecoder);
        currentImageDecoder.setObjectValue(-8, localStore);
        currentImageDecoder.setMultiplyer(this.multiplyer);
        currentImageDecoder.setObjectValue(-18, pageData);
        currentImageDecoder.setIntValue(-10, pageIndex);
        currentImageDecoder.setRenderer(this.imageDisplay);
        externalHandlers.addHandlers(currentImageDecoder);
        res.setupResources(currentImageDecoder, true, Resources, pageIndex, currentPdfFile);
        if (this.multiplyer == -2.0f) {
            this.multiplyer = -1.0f;
            currentImageDecoder.setMultiplyer(this.multiplyer);
            PdfStreamDecoderForSampling currentImageDecoder2 = new PdfStreamDecoderForSampling(currentPdfFile);
            currentImageDecoder2.setParameters(true, true, renderMode, 0, false);
            currentImageDecoder2.setObjectValue(-8, localStore);
            currentImageDecoder2.setMultiplyer(this.multiplyer);
            currentImageDecoder2.setObjectValue(-18, pageData);
            currentImageDecoder2.setIntValue(-10, pageIndex);
            currentImageDecoder2.setRenderer(this.imageDisplay);
            res.setupResources(currentImageDecoder2, true, Resources, pageIndex, currentPdfFile);
            externalHandlers.addHandlers(currentImageDecoder2);
            this.multiplyer = currentImageDecoder2.decodePageContentForImageSampling(pdfObject);
            int bestQualityMaxScalingToUse = 0;
            if (this.instance_bestQualityMaxScaling != null) {
                bestQualityMaxScalingToUse = this.instance_bestQualityMaxScaling;
            } else if (bestQualityMaxScaling != null) {
                bestQualityMaxScalingToUse = bestQualityMaxScaling;
            }
            if (bestQualityMaxScalingToUse > 0 && this.multiplyer > (float)bestQualityMaxScalingToUse) {
                this.multiplyer = bestQualityMaxScalingToUse;
            }
            currentImageDecoder2.setMultiplyer(this.multiplyer);
            currentImageDecoder.setMultiplyer(this.multiplyer);
        }
        if (!allowPagesSmallerThanPageSize.booleanValue() && !this.instance_allowPagesSmallerThanPageSize.booleanValue() && this.multiplyer < 1.0f && this.multiplyer > 0.0f) {
            this.multiplyer = 1.0f;
        }
        if (this.multiplyer == -1.0f) {
            this.multiplyer = 1.0f;
        }
        this.imageScaling = PDFtoImageConvertorSwing.setPageParametersForImage(scaling * this.multiplyer, pageIndex, pageData);
        this.setParams(scaling, pageData, pageIndex);
        BufferedImage image = this.pageToImage(imageIsTransparent, currentImageDecoder, scaling, pdfObject, formRenderer);
        boolean isRasterized = formRenderer.getCompData().formsRasterizedForDisplay();
        resultsFromDecode.update(currentImageDecoder, false);
        if (formRenderer.hasFormsOnPage(pageIndex) && !formRenderer.ignoreForms()) {
            resultsFromDecode.resetColorSpaces();
            if (isRasterized || !formRenderer.getCompData().hasformsOnPageDecoded(pageIndex)) {
                formRenderer.createDisplayComponentsForPage(pageIndex, currentImageDecoder);
            }
            if (!isRasterized) {
                List<FormObject>[] formsOrdered = formRenderer.getCompData().getFormList(true);
                for (FormObject nextVal : formsOrdered[pageIndex]) {
                    if (nextVal == null) continue;
                    formRenderer.getFormFlattener().drawFlattenedForm(currentImageDecoder, nextVal, false, (PdfObject)formRenderer.getFormResources()[0]);
                }
            }
        }
        currentImageDecoder.dispose();
        return image;
    }

    public float getMultiplyer() {
        return this.multiplyer;
    }

    protected DynamicVectorRenderer getDisplay(int pageIndex, ObjectStore localStore, boolean isTransparent) {
        throw new UnsupportedOperationException(this + " Code should never be called ");
    }

    protected BufferedImage pageToImage(boolean imageIsTransparent, PdfStreamDecoder currentImageDecoder, float scaling, PdfObject pdfObject, AcroRenderer formRenderer) {
        throw new UnsupportedOperationException(this + " Code should never be called ");
    }

    private void setParams(float scaling, PdfPageData pageData, int pageIndex) {
        this.mediaH = (int)(scaling * (float)pageData.getMediaBoxHeight(pageIndex));
        this.rotation = pageData.getRotation(pageIndex);
        this.crw = scaling * pageData.getCropBoxWidth2D(pageIndex);
        this.crh = scaling * pageData.getCropBoxHeight2D(pageIndex);
        this.crx = scaling * (float)pageData.getCropBoxX(pageIndex);
        this.cry = scaling * (float)pageData.getCropBoxY(pageIndex);
        if (this.rotation == 90 || this.rotation == 270) {
            this.h = (int)(this.crw * (double)this.multiplyer);
            this.w = (int)(this.crh * (double)this.multiplyer);
            this.rotated = true;
        } else {
            this.w = (int)(this.crw * (double)this.multiplyer);
            this.h = (int)(this.crh * (double)this.multiplyer);
        }
    }
}

