/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.io;

import org.jpedal.jbig2.JBIG2Data;

public class StreamReader {
    private final JBIG2Data jBIG2Data;
    private int bitPointer = 7;
    private int bytePointer;

    public StreamReader(JBIG2Data jBIG2Data) {
        this.jBIG2Data = jBIG2Data;
    }

    public short readByte() {
        short bite = 0;
        if (this.jBIG2Data.getDataLength() > this.bytePointer) {
            bite = (short)(this.jBIG2Data.getItemAt(this.bytePointer++) & 0xFF);
        }
        return bite;
    }

    public void readByte(short[] buf) {
        if (this.bytePointer + buf.length >= this.jBIG2Data.getDataLength()) {
            this.bytePointer = this.jBIG2Data.getDataLength();
            return;
        }
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (short)(this.jBIG2Data.getItemAt(this.bytePointer++) & 0xFF);
        }
    }

    public int readBit() {
        short buf = this.readByte();
        short mask = (short)(1 << this.bitPointer);
        int bit = (buf & mask) >> this.bitPointer;
        --this.bitPointer;
        if (this.bitPointer == -1) {
            this.bitPointer = 7;
        } else {
            this.movePointer(-1);
        }
        return bit;
    }

    public int readBits(int num) {
        int result = 0;
        for (int i = 0; i < num; ++i) {
            result = result << 1 | this.readBit();
        }
        return result;
    }

    public void movePointer(int amount) {
        this.bytePointer += amount;
    }

    public void consumeRemainingBits() {
        if (this.bitPointer != 7) {
            this.readBits(this.bitPointer + 1);
        }
    }

    public boolean bytesRemaining() {
        return this.bytePointer != this.jBIG2Data.getDataLength();
    }
}

