/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jpedal.utils.LogWriter;

public final class Predictor {
    private Predictor() {
    }

    public static void applyPredictor(int mainPred, InputStream bis, OutputStream stream, int colors, int bitsPerComponent, int columns) throws Exception {
        int bytesAvailable = bis.available();
        int bpp = (colors * bitsPerComponent + 7) / 8;
        int rowLength = (columns * colors * bitsPerComponent + 7) / 8 + bpp;
        byte[] thisLine = new byte[rowLength];
        byte[] lastLine = new byte[rowLength];
        byte[] outputBytes = new byte[rowLength];
        try {
            int byteCount = 0;
            while (bytesAvailable > byteCount) {
                int bytesWritten = 0;
                int predictor = mainPred;
                int curPred = Predictor.getCurPred(bis, predictor);
                if (curPred != -1 && (byteCount = Predictor.getByteCount(bis, bpp, rowLength, thisLine, byteCount)) != -1) {
                    switch (curPred) {
                        case 2: {
                            bytesWritten = Predictor.getCountCase2(bitsPerComponent, colors, outputBytes, bpp, rowLength, thisLine, bytesWritten);
                            break;
                        }
                        case 10: {
                            bytesWritten = Predictor.getCountCase10(outputBytes, bpp, rowLength, thisLine, bytesWritten);
                            break;
                        }
                        case 11: {
                            bytesWritten = Predictor.getCountCase11(outputBytes, bpp, rowLength, thisLine, bytesWritten);
                            break;
                        }
                        case 12: {
                            bytesWritten = Predictor.getCountCase12(outputBytes, bpp, rowLength, thisLine, lastLine, bytesWritten);
                            break;
                        }
                        case 13: {
                            bytesWritten = Predictor.getCountCase13(outputBytes, bpp, rowLength, thisLine, lastLine, bytesWritten);
                            break;
                        }
                        case 14: {
                            bytesWritten = Predictor.getCountCase14(outputBytes, bpp, rowLength, thisLine, lastLine, bytesWritten);
                            break;
                        }
                    }
                    stream.write(outputBytes, 0, bytesWritten);
                    System.arraycopy(thisLine, 0, lastLine, 0, lastLine.length);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing Predictor");
        }
    }

    private static int getCurPred(InputStream bis, int predictor) throws IOException {
        int curPred;
        if (predictor >= 10) {
            curPred = bis.read();
            if (curPred != -1) {
                curPred += 10;
            }
        } else {
            curPred = predictor;
        }
        return curPred;
    }

    private static int getByteCount(InputStream bis, int bpp, int rowLength, byte[] thisLine, int byteCount) throws IOException {
        int i = 0;
        int offset = bpp;
        while (offset < rowLength && (i = bis.read(thisLine, offset, rowLength - offset)) != -1) {
            offset += i;
            byteCount += i;
        }
        if (i == -1) {
            byteCount = -1;
        }
        return byteCount;
    }

    private static int getCountCase2(int bitsPerComponent, int colors, byte[] bos, int bpp, int rowLength, byte[] thisLine, int count) {
        if (bitsPerComponent == 1 && colors == 1) {
            int k = 0;
            for (int i = 1; i < rowLength; ++i) {
                int c = thisLine[i] & 0xFF ^ k;
                c ^= c >> 1;
                c ^= c >> 2;
                c ^= c >> 4;
                k = (c & 1) << 7;
                if (bos != null) {
                    bos[count] = (byte)c;
                }
                ++count;
            }
        } else {
            for (int i1 = bpp; i1 < rowLength; ++i1) {
                int sub = thisLine[i1] & 0xFF;
                int raw = thisLine[i1 - bpp] & 0xFF;
                thisLine[i1] = (byte)(sub + raw & 0xFF);
                if (bos != null) {
                    bos[count] = thisLine[i1];
                }
                ++count;
            }
        }
        return count;
    }

    private static int getCountCase10(byte[] bos, int bpp, int rowLength, byte[] thisLine, int count) {
        for (int i1 = bpp; i1 < rowLength; ++i1) {
            if (bos != null) {
                bos[count] = thisLine[i1];
            }
            ++count;
        }
        return count;
    }

    private static int getCountCase11(byte[] bos, int bpp, int rowLength, byte[] thisLine, int count) {
        for (int i1 = bpp; i1 < rowLength; ++i1) {
            int sub = thisLine[i1] & 0xFF;
            int raw = thisLine[i1 - bpp] & 0xFF;
            thisLine[i1] = (byte)(sub + raw);
            if (bos != null) {
                bos[count] = thisLine[i1];
            }
            ++count;
        }
        return count;
    }

    private static int getCountCase12(byte[] bos, int bpp, int rowLength, byte[] thisLine, byte[] lastLine, int count) {
        for (int i1 = bpp; i1 < rowLength; ++i1) {
            int sub = (lastLine[i1] & 0xFF) + (thisLine[i1] & 0xFF);
            thisLine[i1] = (byte)sub;
            if (bos != null) {
                bos[count] = thisLine[i1];
            }
            ++count;
        }
        return count;
    }

    private static int getCountCase13(byte[] bos, int bpp, int rowLength, byte[] thisLine, byte[] lastLine, int count) {
        for (int i1 = bpp; i1 < rowLength; ++i1) {
            int av = thisLine[i1] & 0xFF;
            int ff = (thisLine[i1 - bpp] & 0xFF) + (lastLine[i1] & 0xFF) >> 1;
            thisLine[i1] = (byte)(av + ff);
            if (bos != null) {
                bos[count] = thisLine[i1];
            }
            ++count;
        }
        return count;
    }

    private static int getCountCase14(byte[] bos, int bpp, int rowLength, byte[] thisLine, byte[] lastLine, int count) {
        for (int i1 = bpp; i1 < rowLength; ++i1) {
            int a = thisLine[i1 - bpp] & 0xFF;
            int b = lastLine[i1] & 0xFF;
            int c = lastLine[i1 - bpp] & 0xFF;
            int p = a + b - c;
            int pa = p - a;
            int pb = p - b;
            int pc = p - c;
            pa = pa < 0 ? -pa : pa;
            pb = pb < 0 ? -pb : pb;
            int n = pc = pc < 0 ? -pc : pc;
            if (pa <= pb && pa <= pc) {
                int n2 = i1;
                thisLine[n2] = (byte)(thisLine[n2] + a);
            } else if (pb <= pc) {
                int n3 = i1;
                thisLine[n3] = (byte)(thisLine[n3] + b);
            } else {
                int n4 = i1;
                thisLine[n4] = (byte)(thisLine[n4] + c);
            }
            if (bos != null) {
                bos[count] = thisLine[i1];
            }
            ++count;
        }
        return count;
    }
}

