/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.idrsolutions.image.tiff.TiffDecoder;
import java.awt.image.BufferedImage;
import java.io.RandomAccessFile;
import org.jpedal.utils.LogWriter;

public class TiffHelper {
    private final int pageCount;
    private final String file;

    public TiffHelper(String file) {
        this.file = file;
        this.pageCount = TiffHelper.getTiffPageCount(file);
    }

    public int getTiffPageCount() {
        return this.pageCount;
    }

    public BufferedImage getImage(int tiffImageToLoad) {
        return TiffHelper.getTiffImage(tiffImageToLoad, this.file);
    }

    private static int getTiffPageCount(String file) {
        int pageCount = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            TiffDecoder decoder = new TiffDecoder();
            decoder.read(raf);
            pageCount = decoder.getPageCount();
            raf.close();
        }
        catch (Exception ex) {
            LogWriter.writeLog(ex);
        }
        return pageCount;
    }

    private static BufferedImage getTiffImage(int tiffImageToLoad, String file) {
        BufferedImage image = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            TiffDecoder decoder = new TiffDecoder();
            decoder.read(raf);
            image = decoder.read(tiffImageToLoad + 1);
            raf.close();
        }
        catch (Exception ex) {
            LogWriter.writeLog(ex);
        }
        return image;
    }
}

