/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

public class IdrInputStream
extends FilterInputStream {
    private final CryptoIDR crypto;

    public IdrInputStream(InputStream in, CryptoIDR crypto) {
        super(in);
        this.in = in;
        this.crypto = crypto;
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog(in + " " + this.crypto);
        }
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Please use IdrInputStream::read(byte[]) method instead of read()");
    }

    @Override
    public long skip(long n) throws IOException {
        long returnN = super.skip(n);
        this.crypto.skip(n);
        return returnN;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        this.in.read(bytes);
        byte[] decryptedBytes = this.crypto.decrypt(bytes);
        System.arraycopy(decryptedBytes, 0, bytes, 0, bytes.length);
        return this.crypto.getBytesProcessed();
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int i = this.in.read(bytes, off, len);
        byte[] decryptedBytes = this.crypto.decrypt(bytes, off, len);
        System.arraycopy(decryptedBytes, 0, bytes, 0, bytes.length);
        return i;
    }
}

