/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.cmap;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.cmap.Format;

public class Format12
implements Format {
    private int nGroups;
    private int[] startCharCode;
    private int[] endCharCode;
    private int[] startGlyphCode;

    @Override
    public boolean readTable(FontFile2 currentFontFile, int j, int[] cmaPlength, int[] cmaPlang) {
        currentFontFile.getNextUint16();
        currentFontFile.getNextUint32();
        currentFontFile.getNextUint32();
        this.nGroups = currentFontFile.getNextUint32();
        this.startCharCode = new int[this.nGroups];
        this.endCharCode = new int[this.nGroups];
        this.startGlyphCode = new int[this.nGroups];
        for (int ii = 0; ii < this.nGroups; ++ii) {
            this.startCharCode[ii] = currentFontFile.getNextUint32();
            this.endCharCode[ii] = currentFontFile.getNextUint32();
            this.startGlyphCode[ii] = currentFontFile.getNextUint32();
        }
        return true;
    }

    @Override
    public int getValue(int index, int value) {
        for (int i = 0; i < this.nGroups; ++i) {
            if (this.endCharCode[i] < index || this.startCharCode[i] > index) continue;
            value = this.startGlyphCode[i] + index - this.startCharCode[i];
            i = this.nGroups;
        }
        return value;
    }
}

