/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.parser.text.HexTextUtils;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class Type1
extends PdfFont {
    boolean isCID;
    boolean isCIDROS;
    private static final String rd = "rd";
    private static final String nd = "nd";
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    private int skipBytes = 4;
    protected int[] blueValues;
    protected int[] otherBlues;
    protected int[] familyBlues;
    protected int[] familyOtherBlues;
    protected Double blueScale;
    protected Integer blueShift;
    protected Integer blueFuzz;
    protected Double stdHW;
    protected Double stdVW;
    protected int[] stemSnapH;
    protected int[] stemSnapV;
    protected Boolean forceBold;
    protected Integer languageGroup;
    boolean trackIndices;
    private static final char[] DEF_CHARS = "def".toCharArray();
    private static final char[] charstringsChars = "/CharStrings".toCharArray();
    private static final char[] subrsChars = "/Subrs".toCharArray();
    private static final char[] blueValuesChars = "/BlueValues".toCharArray();
    private static final char[] otherBluesChars = "/OtherBlues".toCharArray();
    private static final char[] familyBluesChars = "/FamilyBlues".toCharArray();
    private static final char[] familyOtherBluesChars = "/FamilyOtherBlues".toCharArray();
    private static final char[] blueScaleChars = "/BlueScale".toCharArray();
    private static final char[] blueShiftChars = "/BlueShift".toCharArray();
    private static final char[] blueFuzzChars = "/BlueFuzz".toCharArray();
    private static final char[] stdHWChars = "/StdHW".toCharArray();
    private static final char[] stdVWChars = "/StdVW".toCharArray();
    private static final char[] stemSnapHChars = "/StemSnapH".toCharArray();
    private static final char[] stemSnapVChars = "/StemSnapV".toCharArray();
    private static final char[] forceBoldChars = "/ForceBold".toCharArray();
    private static final char[] languageGroupChars = "/LanguageGroup".toCharArray();

    protected Type1() {
    }

    protected final void readType1FontFile(byte[] content) throws Exception {
        LogWriter.writeLog("Embedded Type1 font used " + this.getBaseFontName());
        this.readT1FontData(content);
        int glyphCount = 0;
        if (this.renderPage) {
            glyphCount = this.readEncodedContent(content);
        }
        this.glyphs.setGlyphCount(glyphCount);
        if (!this.renderPage || glyphCount > 0) {
            this.isFontEmbedded = true;
        }
        this.glyphs.setFontEmbedded(true);
    }

    private void readT1FontData(byte[] content) throws Exception {
        try (BufferedReader br = new BufferedReader(new StringReader(new String(content)));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("/Encoding") && line.contains("array")) {
                    this.readDiffEncoding(br);
                    continue;
                }
                if (line.startsWith("/lenIV")) {
                    StringTokenizer vals = new StringTokenizer(line);
                    vals.nextToken();
                    this.skipBytes = Integer.parseInt(vals.nextToken());
                    continue;
                }
                if (!line.contains("/FontMatrix")) continue;
                Type1.readFontMatrix(line, this.FontMatrix);
            }
        }
    }

    private static void readFontMatrix(String line, double[] fontMatrix) {
        String values = "";
        int startP = line.indexOf(91);
        if (startP != -1) {
            values = line.substring(startP + 1, line.indexOf(93));
        } else {
            startP = line.indexOf(123);
            if (startP != -1) {
                values = line.substring(startP + 1, line.indexOf(125));
            }
        }
        StringTokenizer matrixValues = new StringTokenizer(values);
        for (int i = 0; i < 6; ++i) {
            fontMatrix[i] = Double.parseDouble(matrixValues.nextToken());
        }
    }

    private void readDiffEncoding(BufferedReader br) throws Exception {
        String line;
        int count = 0;
        while ((line = br.readLine()) != null && !(line = line.trim()).startsWith("readonly") && !line.startsWith("def") && count != 256) {
            int code;
            if (!line.startsWith("dup") || !line.contains("/")) continue;
            ++count;
            StringTokenizer info = new StringTokenizer(line, " /");
            if (info.countTokens() < 3) continue;
            info.nextToken();
            String rawVal = info.nextToken();
            int ptr = rawVal.indexOf(35);
            if (ptr == -1) {
                code = Integer.parseInt(rawVal);
            } else {
                String base = rawVal.substring(0, ptr);
                String val = rawVal.substring(ptr + 1);
                code = Integer.parseInt(val, Integer.parseInt(base));
            }
            String name = info.nextToken();
            this.putChar(code, name);
            char c = name.charAt(0);
            if (c != 'B' && c != 'C' && c != 'c' && c != 'G') continue;
            int i = 1;
            int l = name.length();
            while (!this.isHex && i < l) {
                this.isHex = Character.isLetter(name.charAt(i++));
            }
        }
    }

    final void putChar(int charInt, String mappedChar) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[charInt] = mappedChar;
        if (!this.hasEncoding && !this.isCIDROS && StandardFonts.getUnicodeName(mappedChar) != null) {
            this.putMappedChar(charInt, mappedChar);
        }
    }

    private void setForceBold(byte[] cont, int l, int forceBoldStart) {
        int forceBoldEnd = -1;
        for (int j = forceBoldStart; j < l && forceBoldEnd == -1; ++j) {
            if (!Type1.checkForString(cont, j, DEF_CHARS)) continue;
            forceBoldEnd = j;
        }
        String val = new String(cont, forceBoldStart, forceBoldEnd - forceBoldStart);
        try {
            this.forceBold = Boolean.parseBoolean(val);
        }
        catch (NumberFormatException e) {
            LogWriter.writeLog("Exception " + e);
        }
    }

    private static int scanKeysForLenIV(byte[] cont, int skipBytes) throws IOException {
        try (BufferedReader br = new BufferedReader(new StringReader(new String(cont)));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("/lenIV")) continue;
                StringTokenizer vals = new StringTokenizer(line);
                vals.nextToken();
                skipBytes = Integer.parseInt(vals.nextToken());
            }
        }
        return skipBytes;
    }

    private int readEncodedContent(byte[] cont) throws Exception {
        int size = cont.length;
        int charstringStart = Type1.findStart(cont, size);
        int end = Type1.findEnd(cont, size, charstringStart);
        if (Type1.isAscii(cont, charstringStart)) {
            cont = Type1.getAsciiBytes(cont, charstringStart, end);
        } else {
            if (this.isFontSubstituted) {
                charstringStart += 2 + this.skipBytes;
            }
            cont = Type1.getBinBytes(cont, charstringStart, end);
        }
        this.skipBytes = Type1.scanKeysForLenIV(cont, this.skipBytes);
        return this.setDictValues(cont);
    }

    private int setDictValues(byte[] cont) {
        int glyphCount = 0;
        int l = cont.length;
        int charstringStart = -1;
        for (int p = 4; p < l; ++p) {
            if (charstringStart == -1 && p + 11 < l && Type1.checkForString(cont, p, charstringsChars)) {
                charstringStart = p + 11;
                glyphCount = this.extractFontData(this.skipBytes, cont, charstringStart, l);
                continue;
            }
            if (Type1.checkForString(cont, p, subrsChars)) {
                this.extractSubroutineData(this.skipBytes, cont, p + 6, charstringStart, l);
                continue;
            }
            if (Type1.checkForString(cont, p, blueValuesChars)) {
                this.blueValues = Type1.readIntArray(cont, p + 11);
                continue;
            }
            if (Type1.checkForString(cont, p, otherBluesChars)) {
                this.otherBlues = Type1.readIntArray(cont, p + 11);
                continue;
            }
            if (Type1.checkForString(cont, p, familyBluesChars)) {
                this.familyBlues = Type1.readIntArray(cont, p + 12);
                continue;
            }
            if (Type1.checkForString(cont, p, familyOtherBluesChars)) {
                this.familyOtherBlues = Type1.readIntArray(cont, p + 17);
                continue;
            }
            if (Type1.checkForString(cont, p, blueScaleChars)) {
                this.blueScale = Type1.readReal(cont, p + 10);
                continue;
            }
            if (Type1.checkForString(cont, p, blueShiftChars)) {
                this.blueShift = Type1.readInteger(cont, p + 10);
                continue;
            }
            if (Type1.checkForString(cont, p, blueFuzzChars)) {
                this.blueFuzz = Type1.readInteger(cont, p + 9);
                continue;
            }
            if (Type1.checkForString(cont, p, stdHWChars)) {
                this.stdHW = Type1.readReal(cont, p + 6);
                continue;
            }
            if (Type1.checkForString(cont, p, stdVWChars)) {
                this.stdVW = Type1.readReal(cont, p + 6);
                continue;
            }
            if (Type1.checkForString(cont, p, stemSnapHChars)) {
                this.stemSnapH = Type1.readIntArray(cont, p + 10);
                continue;
            }
            if (Type1.checkForString(cont, p, stemSnapVChars)) {
                this.stemSnapV = Type1.readIntArray(cont, p + 10);
                continue;
            }
            if (Type1.checkForString(cont, p, forceBoldChars)) {
                this.setForceBold(cont, l, p + 10);
                continue;
            }
            if (!Type1.checkForString(cont, p, languageGroupChars)) continue;
            this.languageGroup = Type1.readInteger(cont, p + 14);
        }
        return glyphCount;
    }

    private static byte[] getAsciiBytes(byte[] cont, int charstringStart, int end) {
        int r = 55665;
        int ptr = 0;
        byte[] bytes = new byte[end - charstringStart];
        for (int i = charstringStart; i < end; ++i) {
            int charCount = HexTextUtils.getHexCharCount(i, cont, 2);
            i += charCount;
            int cipher = HexTextUtils.getHexValue(--i, charCount, cont);
            int plain = cipher ^ r >> 8;
            r = (cipher + r) * 52845 + 22719 & 0xFFFF;
            bytes[ptr++] = (byte)plain;
        }
        return bytes;
    }

    private static byte[] getBinBytes(byte[] cont, int charstringStart, int end) {
        int r = 55665;
        int ptr = 0;
        byte[] bytes = new byte[end - charstringStart];
        for (int i = charstringStart; i < end; ++i) {
            int cipher = cont[i] & 0xFF;
            int plain = cipher ^ r >> 8;
            r = (cipher + r) * 52845 + 22719 & 0xFFFF;
            bytes[ptr++] = (byte)plain;
        }
        return bytes;
    }

    private static boolean isAscii(byte[] cont, int charstringStart) {
        for (int i = charstringStart; i < charstringStart + 8; ++i) {
            char c = (char)cont[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    private static int findEnd(byte[] cont, int rawSize, int charstringStart) {
        int end = -1;
        int size = rawSize - 10;
        if (charstringStart != -1) {
            for (int i = charstringStart; i < size; ++i) {
                if (cont[i] != 99 || cont[i + 1] != 108 || cont[i + 2] != 101 || cont[i + 3] != 97 || cont[i + 4] != 114 || cont[i + 5] != 116 || cont[i + 6] != 111 || cont[i + 7] != 109 || cont[i + 8] != 97 || cont[i + 9] != 114 || cont[i + 10] != 107) continue;
                end = i - 1;
                while (cont[end] == 10 || cont[end] == 13) {
                    --end;
                }
                i = size;
            }
        }
        if (end == -1) {
            return rawSize;
        }
        return end;
    }

    private static int findStart(byte[] cont, int size) {
        int charstringStart = -1;
        for (int i = 4; i < size; ++i) {
            if (cont[i - 3] != 101 || cont[i - 2] != 120 || cont[i - 1] != 101 || cont[i] != 99) continue;
            charstringStart = i + 1;
            while (cont[charstringStart] == 10 || cont[charstringStart] == 13 || cont[charstringStart] == 32) {
                ++charstringStart;
            }
            i = size;
        }
        return charstringStart;
    }

    private static Integer readInteger(byte[] data, int offset) {
        int l = data.length;
        int end = -1;
        for (int j = offset; j < l && end == -1; ++j) {
            if (!Type1.checkForString(data, j, DEF_CHARS)) continue;
            end = j;
        }
        String val = new String(data, offset, end - offset);
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            Double result = Type1.readReal(data, offset);
            if (result == null) {
                LogWriter.writeLog("Exception in handling Integer in Type1 " + e);
                return null;
            }
            return (int)Math.round(result);
        }
    }

    private static Double readReal(byte[] data, int offset) {
        int l = data.length;
        int end = -1;
        for (int j = offset; j < l && end == -1; ++j) {
            if (!Type1.checkForString(data, j, DEF_CHARS) && data[j] != 93 && data[j] != 10) continue;
            end = j;
        }
        String val = new String(data, offset, end - offset);
        if (val.contains("[")) {
            String[] stringParts = val.split("\\[");
            if (stringParts.length < 2) {
                return null;
            }
            val = stringParts[1];
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            LogWriter.writeLog("Exception in handling real in Type1 " + e);
            return null;
        }
    }

    private static int[] readIntArray(byte[] data, int start) {
        int j;
        int[] result = null;
        int l = data.length;
        int end = -1;
        for (j = start; j < l && end == -1; ++j) {
            if (data[j] != 93 && data[j] != 47 && data[j] != 10) continue;
            end = j;
        }
        if (end != -1) {
            String values = new String(data, start, end - start);
            if (values.contains("[")) {
                String[] stringParts = values.split("\\[");
                if (stringParts.length < 2) {
                    return null;
                }
                values = stringParts[1];
            }
            if ((values = values.trim()).isEmpty()) {
                return null;
            }
            String[] stringValues = values.split(" ");
            result = new int[stringValues.length];
            for (j = 0; j < stringValues.length; ++j) {
                try {
                    result[j] = Integer.parseInt(stringValues[j].split("\\.")[0]);
                    continue;
                }
                catch (NumberFormatException e) {
                    LogWriter.writeLog("Exception in handling IntArray " + e);
                    result[j] = -1;
                }
            }
        }
        return result;
    }

    private static boolean checkForString(byte[] data, int offset, char[] chars) {
        int length = chars.length;
        if (offset + length > data.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (data[offset + i] == chars[i]) continue;
            return false;
        }
        return true;
    }

    private void extractSubroutineData(int skipBytes, byte[] cont, int start, int charStart, int l) {
        char c;
        start = StreamReaderUtils.skipSpaces(cont, start);
        StringBuilder tmp = new StringBuilder();
        while ((c = (char)cont[start]) != ' ') {
            tmp.append(c);
            ++start;
        }
        int count = Integer.parseInt(tmp.toString());
        for (int i = 0; i < count; ++i) {
            char c2;
            char c3;
            while (start < l && !((cont[start - 2] == 100 && cont[start - 1] == 117 && cont[start] == 112) | start == charStart)) {
                ++start;
            }
            if (start == charStart) {
                i = count;
                continue;
            }
            while (cont[start + 1] == 32) {
                ++start;
            }
            StringBuilder glyph = new StringBuilder("subrs");
            while ((c3 = (char)cont[++start]) != ' ') {
                glyph.append(c3);
            }
            tmp = new StringBuilder();
            boolean isANumber = true;
            while ((c2 = (char)cont[++start]) != ' ') {
                if (c2 >= '0' && c2 <= '9') {
                    tmp.append(c2);
                    continue;
                }
                isANumber = false;
                break;
            }
            if (!isANumber) {
                return;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            byte[] stream = Type1.getStream(skipBytes, start += rd.length() + 1, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, i);
            start += byteCount + nd.length();
        }
    }

    private int extractFontData(int skipBytes, byte[] cont, int start, int l) {
        int total = cont.length;
        int glyphCount = 0;
        while (start < total && cont[start] != 47) {
            ++start;
        }
        int end = start;
        if (start < l) {
            while (true) {
                if (cont[end] == 47) {
                    end += 2;
                    while (end < total && (cont[end - 1] != 124 || cont[end] != 45 && cont[end] != 48 || cont[end + 1] != 10 && cont[end + 1] != 13) && (cont[end - 1] != 78 || cont[end] != 68)) {
                        ++end;
                    }
                }
                if (total - end < 3 || cont[end - 1] != 47 && cont[end] == 101 && cont[end + 1] == 110 && cont[end + 2] == 100) break;
                ++end;
            }
        }
        while (start <= end) {
            char c;
            char c2;
            StringBuilder glyph = new StringBuilder(20);
            while ((c2 = (char)cont[++start]) != ' ') {
                glyph.append(c2);
            }
            if (this.trackIndices) {
                this.glyphs.setNameForGlyphIndex(glyphCount, glyph.toString());
            }
            ++start;
            StringBuilder tmp = new StringBuilder();
            while ((c = (char)cont[start]) != ' ') {
                tmp.append(c);
                ++start;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            byte[] stream = Type1.getStream(skipBytes, start += rd.length() + 1, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, glyphCount);
            ++glyphCount;
            start += byteCount + nd.length();
            while (start <= end && cont[start] != 47) {
                ++start;
            }
        }
        return glyphCount;
    }

    private static byte[] getStream(int skipBytes, int start, int byteCount, byte[] cont) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        int r = 4330;
        for (int i = 0; i < byteCount; ++i) {
            int cipher = cont[start + i] & 0xFF;
            int plain = cipher ^ r >> 8;
            r = (cipher + r) * 52845 + 22719 & 0xFFFF;
            if (i < skipBytes) continue;
            bos.write(plain);
        }
        return bos.toByteArray();
    }
}

