/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.printing;

import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.PdfBook;

public class PrintPdfPages {
    private PdfDecoder decode_pdf;
    private String password;
    private String fileName;
    private byte[] byteArray;
    private DocPrintJob printJob;

    public static void main(String[] args) {
        if (args != null && args.length > 1) {
            if (args.length < 3) {
                try {
                    PrintPdfPages print = new PrintPdfPages(args[0]);
                    if (print.openPDFFile()) {
                        print.printAllPages(args[1]);
                    }
                    print.closePDFfile(DecoderOptions.isRunningOnWindows);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception " + e.getMessage() + " printing all pages from " + args[0]);
                }
            } else {
                try {
                    PrintPdfPages print = new PrintPdfPages(args[0]);
                    if (print.openPDFFile()) {
                        int pageNumber = Integer.parseInt(args[2]);
                        print.printPage(args[1], pageNumber);
                    }
                    print.closePDFfile(DecoderOptions.isRunningOnWindows);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception " + e.getMessage() + " printing page " + args[2] + " from " + args[0]);
                }
            }
        } else if (args == null) {
            System.out.println("no arguments entered");
        } else {
            System.out.println("wrong arguments entered");
            StringBuilder arguments = new StringBuilder();
            for (String arg : args) {
                arguments.append(arg).append('\n');
            }
            System.out.println("you entered:\n" + arguments + "as the arguments");
        }
    }

    public PrintPdfPages(String fileName) {
        this.fileName = fileName;
        this.init();
    }

    public PrintPdfPages(byte[] byteArray) {
        this.byteArray = byteArray;
        this.init();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void init() {
        FontMappings.setFontReplacements();
        this.decode_pdf = new PdfDecoder();
    }

    public boolean openPDFFile() throws PdfException {
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            } else {
                return false;
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
            }
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage());
        }
        return true;
    }

    public void printAllPages(String printerName) throws PrintException {
        this.validatePrinter(printerName);
        PrintRequestAttributeSet attributes = this.getPrintRequestAttributeSet(1, this.decode_pdf.getPageCount());
        this.decode_pdf.setPrintAutoRotateAndCenter(true);
        this.decode_pdf.setPrintPageScalingMode(2);
        PdfBook pdfBook = new PdfBook(this.decode_pdf, this.printJob.getPrintService(), attributes);
        pdfBook.setChooseSourceByPdfPageSize(false);
        SimpleDoc doc = new SimpleDoc(pdfBook, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        this.printJob.print(doc, attributes);
        if (!this.decode_pdf.getPageFailureMessage().isEmpty()) {
            LogWriter.writeLog("Errors reported from JPedal=" + this.decode_pdf.getPageFailureMessage());
        }
    }

    public void printPage(String printerName, int page) throws PrintException {
        this.validatePrinter(printerName);
        PrintRequestAttributeSet attributes = this.getPrintRequestAttributeSet(page, page);
        this.decode_pdf.setPrintAutoRotateAndCenter(true);
        this.decode_pdf.setPrintPageScalingMode(2);
        PdfBook pdfBook = new PdfBook(this.decode_pdf, this.printJob.getPrintService(), attributes);
        pdfBook.setChooseSourceByPdfPageSize(false);
        SimpleDoc doc = new SimpleDoc(pdfBook, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        this.printJob.print(doc, attributes);
        if (!this.decode_pdf.getPageFailureMessage().isEmpty()) {
            LogWriter.writeLog("Errors reported from JPedal=" + this.decode_pdf.getPageFailureMessage());
        }
    }

    private PrintRequestAttributeSet getPrintRequestAttributeSet(int rangeStart, int rangeEnd) {
        PageRanges range;
        HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
        String[] jobString = this.decode_pdf.getFileName().split("/");
        JobName jobName = new JobName(jobString[jobString.length - 1], null);
        if (this.validateAttribute(jobName, attributeSet)) {
            attributeSet.add(jobName);
        }
        if (rangeStart < 1) {
            rangeStart = 1;
        }
        if (rangeEnd < 1) {
            rangeEnd = 1;
        }
        if (rangeStart > this.decode_pdf.getPageCount()) {
            rangeStart = this.decode_pdf.getPageCount();
        }
        if (rangeEnd > this.decode_pdf.getPageCount()) {
            rangeEnd = this.decode_pdf.getPageCount();
        }
        if (rangeStart > rangeEnd) {
            int temp = rangeStart;
            rangeStart = rangeEnd;
            rangeEnd = temp;
        }
        if (this.validateAttribute(range = new PageRanges(rangeStart, rangeEnd), attributeSet)) {
            attributeSet.add(range);
        }
        return attributeSet;
    }

    private boolean validateAttribute(Attribute att, PrintRequestAttributeSet attributeSet) {
        return this.printJob.getPrintService().isAttributeValueSupported(att, DocFlavor.SERVICE_FORMATTED.PAGEABLE, attributeSet);
    }

    private void validatePrinter(String newPrinter) {
        boolean matchFound = false;
        PrintService[] service = PrinterJob.lookupPrintServices();
        int count = service.length;
        for (int i = 0; i < count; ++i) {
            if (!service[i].getName().contains(newPrinter)) continue;
            this.printJob = service[i].createPrintJob();
            i = count;
            matchFound = true;
        }
        if (!matchFound) {
            StringBuilder list = new StringBuilder();
            for (PrintService aService : service) {
                list.append('\"').append(aService.getName()).append("\",");
            }
            System.err.println("Printer " + newPrinter + " not supported. Options=" + list);
        }
    }

    public void closePDFfile(boolean closeAllThreads) {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
        if (closeAllThreads) {
            System.exit(0);
        }
    }
}

