/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class DeviceRGBColorSpace
extends GenericColorSpace {
    public DeviceRGBColorSpace(boolean isARGB) {
        this.setType(1785221209);
        if (isARGB) {
            this.componentCount = 4;
        }
    }

    public DeviceRGBColorSpace() {
        this.setType(1785221209);
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image;
        if (width * height == data.length) {
            image = DeviceRGBColorSpace.makeIndexImage(width, height, data);
        } else {
            LogWriter.writeLog("Converting data to sRGB " + data.length);
            image = DeviceRGBColorSpace.makeImage(data, width, height);
        }
        return image;
    }

    private static BufferedImage makeImage(byte[] data, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        data = DeviceRGBColorSpace.checkSize(data, w, h);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w, h);
        image.setData(raster);
        return image;
    }

    private static BufferedImage makeIndexImage(int w, int h, byte[] data) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0};
        BufferedImage image = new BufferedImage(w, h, 10);
        WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w, 1, bands, null);
        image.setData(raster);
        return image;
    }

    private static byte[] checkSize(byte[] data, int w, int h) {
        int correctSize = w * h * 3;
        if (data.length < correctSize) {
            byte[] newData = new byte[correctSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            return newData;
        }
        return data;
    }

    @Override
    public final void setColor(int[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        int r = DeviceRGBColorSpace.checkRange(operand[0]);
        int g = DeviceRGBColorSpace.checkRange(operand[1]);
        int b = DeviceRGBColorSpace.checkRange(operand[2]);
        this.currentColor = new PdfColor(r, g, b);
    }

    private static int checkRange(int r) {
        return r > 255 ? 255 : Math.max(r, 0);
    }

    @Override
    public final void setColor(float[] operand) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
        }
        float r = DeviceRGBColorSpace.checkRange(operand[0]);
        float g = DeviceRGBColorSpace.checkRange(operand[1]);
        float b = DeviceRGBColorSpace.checkRange(operand[2]);
        this.currentColor = new PdfColor(r, g, b);
    }

    private static float checkRange(float r) {
        return r > 1.0f ? 1.0f : (r < 0.0f ? 0.0f : r);
    }
}

