/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import com.idrsolutions.pdf.color.shading.Shape67;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class TensorContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final int bitsPerCoordinate;
    private final int bitsPerComponent;
    private final int bitsPerFlag;
    private int colCompCount;
    private final float[] decodeArr;
    private final ArrayList<Point2D> pp;
    private final ArrayList<Color> pc;
    private final ArrayList<Shape67> shapes;
    private BitReader reader;
    private final PDFFunction[] function;
    private final float[][] toShadeSpace;
    private float[][] inversed = Matrix.getIdentity();

    TensorContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        this.background = background;
        this.bitsPerComponent = shadingObject.getInt(-1344207655);
        this.bitsPerFlag = shadingObject.getInt(1500422077);
        this.bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        boolean hasSmallBits = this.bitsPerFlag < 8 || this.bitsPerComponent < 8 || this.bitsPerCoordinate < 8;
        this.reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        this.colCompCount = shadingColorSpace.getColorComponentCount();
        if (this.decodeArr != null) {
            this.colCompCount = (this.decodeArr.length - 4) / 2;
        }
        float[][] caller = mm != null ? mm : Matrix.getIdentity();
        Object shadeMatrix = Matrix.getIdentity();
        float[] inputs = shadingObject.getFloatArray(1145198201);
        if (inputs != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        this.function = function;
        this.pp = new ArrayList();
        this.pc = new ArrayList();
        this.shapes = new ArrayList();
        this.process();
        this.adjustPoints();
        Collections.reverse(this.shapes);
    }

    private void process() {
        while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int flag = this.reader.getPositive(this.bitsPerFlag);
            switch (flag) {
                case 0: {
                    this.handleCase0();
                    break;
                }
                case 1: {
                    this.handleCase1();
                    break;
                }
                case 2: {
                    this.handleCase2();
                    break;
                }
                case 3: {
                    this.handleCase3();
                }
            }
        }
    }

    void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.inversed = Matrix.concatenate(this.toShadeSpace, Matrix.inverse(xm));
    }

    private void handleCase3() {
        int i;
        Point2D[] a4 = new Point2D[4];
        Color[] a2 = new Color[2];
        float[] cc = new float[this.colCompCount];
        a4[0] = this.pp.get(this.pp.size() - 3);
        a4[1] = this.pp.get(this.pp.size() - 2);
        a4[2] = this.pp.get(this.pp.size() - 1);
        a4[3] = this.pp.get(this.pp.size() - 12);
        this.pp.addAll(Arrays.asList(a4).subList(0, 4));
        for (i = 0; i < 8; ++i) {
            this.pp.add(this.getPointCoords());
        }
        for (i = 0; i < 4; ++i) {
            this.getPointCoords();
        }
        a2[0] = this.pc.get(this.pc.size() - 1);
        a2[1] = this.pc.get(this.pc.size() - 4);
        this.pc.addAll(Arrays.asList(a2));
        for (i = 0; i < 2; ++i) {
            for (int z = 0; z < this.colCompCount; ++z) {
                cc[z] = this.reader.getFloat(this.bitsPerComponent);
            }
            this.pc.add(this.calculateColor(cc));
        }
    }

    private void handleCase2() {
        int i;
        Point2D[] a4 = new Point2D[4];
        Color[] a2 = new Color[2];
        float[] cc = new float[this.colCompCount];
        a4[0] = this.pp.get(this.pp.size() - 6);
        a4[1] = this.pp.get(this.pp.size() - 5);
        a4[2] = this.pp.get(this.pp.size() - 4);
        a4[3] = this.pp.get(this.pp.size() - 3);
        this.pp.addAll(Arrays.asList(a4).subList(0, 4));
        for (i = 0; i < 8; ++i) {
            this.pp.add(this.getPointCoords());
        }
        for (i = 0; i < 4; ++i) {
            this.getPointCoords();
        }
        a2[0] = this.pc.get(this.pc.size() - 2);
        a2[1] = this.pc.get(this.pc.size() - 1);
        this.pc.addAll(Arrays.asList(a2));
        for (i = 0; i < 2; ++i) {
            for (int z = 0; z < this.colCompCount; ++z) {
                cc[z] = this.reader.getFloat(this.bitsPerComponent);
            }
            this.pc.add(this.calculateColor(cc));
        }
    }

    private void handleCase1() {
        int i;
        Point2D[] a4 = new Point2D[4];
        Color[] a2 = new Color[2];
        float[] cc = new float[this.colCompCount];
        a4[0] = this.pp.get(this.pp.size() - 9);
        a4[1] = this.pp.get(this.pp.size() - 8);
        a4[2] = this.pp.get(this.pp.size() - 7);
        a4[3] = this.pp.get(this.pp.size() - 6);
        this.pp.addAll(Arrays.asList(a4).subList(0, 4));
        for (i = 0; i < 8; ++i) {
            this.pp.add(this.getPointCoords());
        }
        for (i = 0; i < 4; ++i) {
            this.getPointCoords();
        }
        a2[0] = this.pc.get(this.pc.size() - 3);
        a2[1] = this.pc.get(this.pc.size() - 2);
        this.pc.addAll(Arrays.asList(a2));
        for (i = 0; i < 2; ++i) {
            for (int z = 0; z < this.colCompCount; ++z) {
                cc[z] = this.reader.getFloat(this.bitsPerComponent);
            }
            this.pc.add(this.calculateColor(cc));
        }
    }

    private void handleCase0() {
        int i;
        float[] cc = new float[this.colCompCount];
        for (i = 0; i < 12; ++i) {
            this.pp.add(this.getPointCoords());
        }
        for (i = 0; i < 4; ++i) {
            this.getPointCoords();
        }
        for (i = 0; i < 4; ++i) {
            for (int z = 0; z < this.colCompCount; ++z) {
                cc[z] = this.reader.getFloat(this.bitsPerComponent);
            }
            this.pc.add(this.calculateColor(cc));
        }
    }

    private void adjustPoints() {
        if (this.decodeArr != null) {
            float xMin = this.decodeArr[0];
            float xMax = this.decodeArr[1];
            float yMin = this.decodeArr[2];
            float yMax = this.decodeArr[3];
            float xw = xMax - xMin;
            float yw = yMax - yMin;
            ArrayList<Point2D.Float> tempPoints = new ArrayList<Point2D.Float>();
            for (Point2D p : this.pp) {
                float xx = (float)p.getX();
                float yy = (float)p.getY();
                xx = xw * xx + xMin;
                yy = yw * yy + yMin;
                tempPoints.add(new Point2D.Float(xx, yy));
            }
            this.pp.clear();
            this.pp.addAll(tempPoints);
        }
        Point2D[] pArr = new Point2D[this.pp.size()];
        for (int i = 0; i < pArr.length; ++i) {
            pArr[i] = this.pp.get(i);
        }
        int totalPatches = this.pp.size() / 12;
        int offset = 0;
        int nSteps = totalPatches > 10 ? 10 : 16;
        for (int i = 0; i < totalPatches; ++i) {
            Point2D[] pointArr = new Point2D[12];
            Color[] colors = new Color[]{this.pc.get(i * 4), this.pc.get(i * 4 + 1), this.pc.get(i * 4 + 2), this.pc.get(i * 4 + 3)};
            System.arraycopy(pArr, offset, pointArr, 0, 12);
            Shape67 sh = new Shape67(pointArr, colors, nSteps);
            this.shapes.add(sh);
            offset += 12;
        }
    }

    private Point2D getPointCoords() {
        float x = 0.0f;
        float y = 0.0f;
        block4: for (int z = 0; z < 2; ++z) {
            switch (z) {
                case 0: {
                    x = this.reader.getFloat(this.bitsPerCoordinate);
                    continue block4;
                }
                case 1: {
                    y = this.reader.getFloat(this.bitsPerCoordinate);
                }
            }
        }
        return new Point2D.Float(x, y);
    }

    @Override
    public void dispose() {
        this.reader = null;
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xStart, int yStart, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w, h, data, this.shadingColorSpace, this.background);
        }
        float x2 = xStart + w;
        float y2 = yStart + h;
        float[] src1 = new float[]{xStart, yStart};
        float[] src2 = new float[]{x2, y2};
        Matrix.transformPixel(this.inversed, src1);
        Matrix.transformPixel(this.inversed, src2);
        float rMinX = Math.min(src1[0], src2[0]);
        float rMinY = Math.min(src1[1], src2[1]);
        float rMaxX = Math.max(src1[0], src2[0]);
        float rMaxY = Math.max(src1[1], src2[1]);
        ArrayList<Shape67> foundList = new ArrayList<Shape67>();
        Rectangle2D.Float rect = new Rectangle2D.Float(rMinX, rMinY, rMaxX - rMinX, rMaxY - rMinY);
        for (Shape67 sh : this.shapes) {
            if (!(sh.minX < rMaxX) || !(sh.minY < rMaxY) || !(rMinX < sh.maxX) || !(rMinY < sh.maxY) || !sh.getShape().intersects(rect)) continue;
            foundList.add(sh);
        }
        float[] src = new float[2];
        for (int y = 0; y < h; ++y) {
            block2: for (int x = 0; x < w; ++x) {
                src[0] = x + xStart;
                src[1] = y + yStart;
                Matrix.transformPixel(this.inversed, src);
                float xx = src[0];
                float yy = src[1];
                for (Shape67 sh : foundList) {
                    if (data[y * w + x] != 0) continue block2;
                    int result = sh.findPointColor(xx, yy);
                    if (result == 0) continue;
                    data[y * w + x] = result;
                }
            }
        }
        return raster;
    }

    private Color calculateColor(float[] val) {
        if (this.function == null) {
            this.shadingColorSpace.setColor(val);
        } else {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues);
        }
        Color col = new Color(this.shadingColorSpace.getColor().getRGB());
        return col;
    }

    public ArrayList<Shape67> getShapes() {
        return this.shapes;
    }
}

