/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.PaintContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class RadialContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final PDFFunction[] function;
    private boolean[] extended = new boolean[]{false, false};
    private float t0;
    private float t1 = 1.0f;
    private final float x0;
    private final float y0;
    private final float r0;
    private final float r1;
    private final float deltaX;
    private final float deltaY;
    private final float deltaR;
    private final float deltaC;
    private final float powerR0;
    private final int colorT0;
    private final int colorT1;
    private float[][] toUserSpace = Matrix.getIdentity();
    private final float[][] toShadeSpace;
    private int lumX;
    private int lumY;
    private int lumW;
    private int[] lumPixels;
    private final int[] colorsArr = new int[256];

    RadialContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shading, float[][] mm, PDFFunction[] function) {
        float[] domain;
        this.shadingColorSpace = shadingColorSpace;
        this.background = background;
        this.function = function;
        float[] src = shading.getFloatArray(1061308290);
        boolean[] extension = shading.getBooleanArray(1144345468);
        if (extension != null) {
            this.extended = extension;
        }
        if ((domain = shading.getFloatArray(1026641277)) != null) {
            this.t0 = domain[0];
            this.t1 = domain[1];
        }
        float[] coords = new float[src.length];
        System.arraycopy(src, 0, coords, 0, src.length);
        float[][] shadeAffine = Matrix.getIdentity();
        if (mm != null) {
            shadeAffine = mm;
        }
        this.toShadeSpace = Matrix.inverse(shadeAffine);
        this.x0 = coords[0];
        this.y0 = coords[1];
        this.r0 = coords[2];
        float x1 = coords[3];
        float y1 = coords[4];
        this.r1 = coords[5];
        this.colorT0 = this.calculateColor(new float[]{this.t0});
        this.colorT1 = this.calculateColor(new float[]{this.t1});
        this.deltaX = x1 - this.x0;
        this.deltaY = y1 - this.y0;
        this.deltaR = this.r1 - this.r0;
        this.deltaC = this.deltaX * this.deltaX + this.deltaY * this.deltaY - this.deltaR * this.deltaR;
        this.powerR0 = this.r0 * this.r0;
        float[] tv = new float[]{0.0f};
        for (int i = 0; i <= 255; ++i) {
            tv[0] = this.getTfromS((float)i * 1.0f / 255.0f);
            this.colorsArr[i] = this.calculateColor(tv);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private int calculateColor(float[] val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, val);
        this.shadingColorSpace.setColor(colValues);
        return this.shadingColorSpace.getColor().getRGB();
    }

    public void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.toUserSpace = Matrix.inverse(xm);
    }

    public void setLuminosityMask(BufferedImage image, int x, int y) {
        this.lumPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        this.lumX = x;
        this.lumY = y;
        this.lumW = image.getWidth();
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w, h, data, this.shadingColorSpace, this.background);
        }
        float[] xy = new float[2];
        int lum = 0;
        float[] tv = new float[1];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int yy;
                xy[0] = startX + x;
                xy[1] = startY + y;
                Matrix.transformPixel(this.toUserSpace, xy);
                boolean hasLum = false;
                if (this.lumPixels != null) {
                    int xx = (int)xy[0];
                    yy = (int)xy[1];
                    int loc = (xx -= this.lumX) + (yy -= this.lumY) * this.lumW;
                    if (xx >= 0 && yy >= 0 && loc < this.lumPixels.length) {
                        lum = this.lumPixels[loc];
                        hasLum = true;
                    }
                }
                Matrix.transformPixel(this.toShadeSpace, xy);
                int result = 0;
                this.quadraticEquate(xy);
                float c0 = xy[0];
                float c1 = xy[1];
                if (c1 >= 0.0f && c1 <= 1.0f) {
                    result = this.colorsArr[(int)(c1 * 255.0f)];
                } else if (this.extended[1] && c1 >= 0.0f && this.r1 + c1 * this.deltaR >= 0.0f) {
                    result = this.colorT1;
                } else if (c0 >= 0.0f && c0 <= 1.0f) {
                    result = this.colorsArr[(int)(c0 * 255.0f)];
                } else if (this.extended[0] && c1 <= 0.0f && this.r1 + c1 * this.deltaR >= 0.0f) {
                    tv[0] = this.getTfromS(c1);
                    result = this.calculateColor(tv);
                } else if (this.extended[0] && c0 <= 1.0f && this.r1 + c0 * this.deltaR >= 0.0f) {
                    result = this.colorT0;
                }
                if (result == 0) continue;
                data[y * w + x] = result;
                if (!hasLum) continue;
                int r = lum >> 16 & 0xFF;
                int g = lum >> 8 & 0xFF;
                int b = lum & 0xFF;
                yy = r * 77 + g * 152 + b * 28;
                int ip = data[y * w + x];
                int resA = ip >> 24 & 0xFF;
                resA = resA * yy >> 16;
                data[y * w + x] = resA << 24 | ip & 0xFFFFFF;
            }
        }
        return raster;
    }

    private float getTfromS(float s) {
        return s * (this.t1 - this.t0) + this.t0;
    }

    private void quadraticEquate(float[] xy) {
        float xDiff = xy[0] - this.x0;
        float yDiff = xy[1] - this.y0;
        float p = -xDiff * this.deltaX - yDiff * this.deltaY - this.r0 * this.deltaR;
        float q = xDiff * xDiff + yDiff * yDiff - this.powerR0;
        float sqrt = (float)Math.sqrt(p * p - this.deltaC * q);
        float sA = (sqrt - p) / this.deltaC;
        float sB = (-p - sqrt) / this.deltaC;
        if (this.deltaC < 0.0f) {
            xy[0] = sA;
            xy[1] = sB;
        } else {
            xy[0] = sB;
            xy[1] = sA;
        }
    }
}

