/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.shadings;

import com.idrsolutions.pdf.acroforms.xfa.shadings.LinearShadeContext;
import com.idrsolutions.pdf.acroforms.xfa.shadings.RadialShadeContext;
import com.idrsolutions.pdf.acroforms.xfa.shadings.XFAPatternContext;
import com.idrsolutions.pdf.acroforms.xfa.shadings.XFAShadeContext;
import com.idrsolutions.pdf.color.shading.ShadedPaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.jpedal.color.PdfPaint;

class XFAShadedPaint
extends ShadedPaint {
    private final boolean xfaShade;
    private PaintContext xfaShadeCont;

    XFAShadedPaint(float[] coords, int xDir, int yDir, PdfPaint startColor, PdfPaint endColor, int type) {
        this.xfaShade = true;
        if (type == 0) {
            this.xfaShadeCont = new LinearShadeContext(coords, xDir, yDir, startColor, endColor);
        } else if (type == 1) {
            this.xfaShadeCont = new RadialShadeContext(coords, xDir, startColor, endColor);
        } else if (type >= 2 && type <= 7) {
            this.xfaShadeCont = new XFAPatternContext(coords, type, startColor, endColor);
        }
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        int offX = (int)xform.getTranslateX();
        int offY = (int)xform.getTranslateY();
        this.scaling = (float)xform.getScaleY();
        if (this.xfaShade) {
            ((XFAShadeContext)this.xfaShadeCont).setValues(offX, offY, this.scaling, this.cropH);
            return this.xfaShadeCont;
        }
        return super.createContext(cm, db, ub, xform, hints);
    }
}

