/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.shadings;

import com.idrsolutions.pdf.acroforms.xfa.shadings.XFAShadeContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.PdfPaint;

public class XFAPatternContext
extends XFAShadeContext {
    final int patternType;
    static final int spacing = 8;
    final int[] backColor;
    final int[] lineColor;

    public XFAPatternContext(float[] coords, int patternType, PdfPaint startColor, PdfPaint endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.coords = coords;
        this.patternType = patternType;
        this.backColor = XFAPatternContext.getColor(startColor);
        this.lineColor = XFAPatternContext.getColor(endColor);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        int rastSize = w * h * 4;
        int[] data = new int[rastSize];
        int spacingVal = (int)(8.0f * this.scaling);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int[] fCol = this.getColor(x + xstart, y + ystart, spacingVal);
                int base = (y * w + x) * 4;
                data[base] = fCol[0];
                data[base + 1] = fCol[1];
                data[base + 2] = fCol[2];
                data[base + 3] = 255;
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private static int[] getColor(PdfPaint color) {
        int endCol = color.getRGB();
        int r = endCol >> 16 & 0xFF;
        int g = endCol >> 8 & 0xFF;
        int b = endCol & 0xFF;
        return new int[]{r, g, b};
    }

    private int[] getColor(int x, int y, int spacingVal) {
        int[] result = this.backColor;
        switch (this.patternType) {
            case 7: {
                x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX));
                if (x == 0 || x % spacingVal != 0) break;
                result = this.lineColor;
                break;
            }
            case 6: {
                y = (int)((float)y - ((float)this.pHeight - this.coords[3] * this.scaling + (float)this.offY));
                if (y == 0 || y % spacingVal != 0) break;
                result = this.lineColor;
                break;
            }
            case 4: {
                x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX));
                y = (int)((float)y - ((float)this.pHeight - this.coords[3] * this.scaling + (float)this.offY));
                if (x % spacingVal != y % spacingVal) break;
                result = this.lineColor;
                break;
            }
            case 5: {
                x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX));
                y = (int)((float)y - (this.coords[3] * this.scaling + (float)this.offY));
                int modx = x % spacingVal;
                int mody = y % spacingVal;
                if (spacingVal - modx != mody && (mody != 0 || modx != 0)) break;
                result = this.lineColor;
                break;
            }
            case 3: {
                x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX));
                y = (int)((float)y - (this.coords[3] * this.scaling + (float)this.offY));
                int modx = x % spacingVal;
                int mody = y % spacingVal;
                if (modx != mody && spacingVal - modx != mody && (mody != 0 || modx != 0)) break;
                result = this.lineColor;
                break;
            }
            case 2: {
                x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX));
                y = (int)((float)y - (this.coords[3] * this.scaling + (float)this.offY));
                if ((x == 0 || x % spacingVal != 0) && (y == 0 || y % spacingVal != 0)) break;
                result = this.lineColor;
                break;
            }
        }
        return result;
    }
}

