/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.options;

import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.png.options.PngCompressionFormat;

public class PngEncoderOptions
implements EncoderOptions {
    private boolean optimizeBasedOnColors;
    private PngCompressionFormat pngCompression = PngCompressionFormat.ZLIB_BETTER_COMPRESSION;
    private static final boolean ALWAYS_USE_ZLIB_SPEED = "true".equals(System.getProperty("ALWAYS_USE_ZLIB_SPEED"));

    @Override
    public OutputFormat getOutputFormat() {
        return OutputFormat.PNG;
    }

    public void setCompressionFormat(PngCompressionFormat pngCompression) {
        this.pngCompression = pngCompression;
    }

    public PngCompressionFormat getCompressionFormat() {
        return ALWAYS_USE_ZLIB_SPEED ? PngCompressionFormat.ZLIB_BETTER_SPEED : this.pngCompression;
    }

    public boolean isOptimizeBasedOnColors() {
        return this.optimizeBasedOnColors;
    }

    public void setOptimizeBasedOnColors(boolean optimizeBasedOnColors) {
        this.optimizeBasedOnColors = optimizeBasedOnColors;
    }
}

