/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.EntropyDecoder;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.LUT;
import com.idrsolutions.image.jpeg2000.data.TileBand;

public class Tier1Decoder {
    private static final byte UNIFORM = 17;
    private static final byte RUNLENGTH = 18;
    private final int width;
    private final int height;
    private EntropyDecoder decoder;
    private final byte[] contextLableTable;
    private final byte[] nbrSign;
    public final byte[] coefSign;
    public final int[] magnitude;
    private final byte[] curFlag;
    public final byte[] bitsDecoded;
    private final byte[] cx;

    public Tier1Decoder(int width, int height, TileBand subband, int zeroBitPlanes, Info info) {
        int i;
        this.width = width;
        this.height = height;
        this.contextLableTable = subband.type == 3 ? LUT.ContextHH : (subband.type == 2 ? LUT.ContextHL : LUT.ContextLL);
        int cc = width * height;
        this.nbrSign = info.nbrArray;
        this.coefSign = info.signArray;
        this.magnitude = info.magnArray;
        this.curFlag = info.curFlagArray;
        this.bitsDecoded = info.bitsDecArray;
        for (i = 0; i < cc; ++i) {
            this.magnitude[i] = 0;
            this.nbrSign[i] = 0;
            this.coefSign[i] = 0;
            this.curFlag[i] = 0;
            this.bitsDecoded[i] = 0;
        }
        if (zeroBitPlanes != 0) {
            for (i = 0; i < cc; ++i) {
                this.bitsDecoded[i] = (byte)zeroBitPlanes;
            }
        }
        this.cx = new byte[19];
        this.cx[0] = 8;
        this.cx[17] = 92;
        this.cx[18] = 6;
    }

    public void setDecoder(EntropyDecoder decoder) {
        this.decoder = decoder;
    }

    private void setNeighborSigns(int y, int x, int index) {
        int i;
        boolean right;
        boolean left = x > 0;
        boolean bl = right = x + 1 < this.width;
        if (y > 0) {
            i = index - this.width;
            if (left) {
                this.nbrSign[i - 1] = (byte)((this.nbrSign[i - 1] & 0xFF) + 16);
            }
            if (right) {
                this.nbrSign[i + 1] = (byte)((this.nbrSign[i + 1] & 0xFF) + 16);
            }
            this.nbrSign[i] = (byte)((this.nbrSign[i] & 0xFF) + 4);
        }
        if (y + 1 < this.height) {
            i = index + this.width;
            if (left) {
                this.nbrSign[i - 1] = (byte)((this.nbrSign[i - 1] & 0xFF) + 16);
            }
            if (right) {
                this.nbrSign[i + 1] = (byte)((this.nbrSign[i + 1] & 0xFF) + 16);
            }
            this.nbrSign[i] = (byte)((this.nbrSign[i] & 0xFF) + 4);
        }
        if (left) {
            this.nbrSign[index - 1] = (byte)((this.nbrSign[index - 1] & 0xFF) + 1);
        }
        if (right) {
            this.nbrSign[index + 1] = (byte)((this.nbrSign[index + 1] & 0xFF) + 1);
        }
        this.nbrSign[index] = (byte)(this.nbrSign[index] & 0xFF | 0x80);
    }

    public void runSPP() {
        int processedInverseMask = -2;
        boolean processedMask = true;
        int firstMagnitudeBitMask = 2;
        for (int i0 = 0; i0 < this.height; i0 += 4) {
            for (int j = 0; j < this.width; ++j) {
                int i;
                int index = i0 * this.width + j;
                int i1 = 0;
                while (i1 < 4 && (i = i0 + i1) < this.height) {
                    this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF & 0xFFFFFFFE);
                    if (this.magnitude[index] == 0 && this.nbrSign[index] != 0) {
                        byte contextLabel = this.contextLableTable[this.nbrSign[index] & 0xFF];
                        int decision = this.decoder.decodeBit(this.cx, contextLabel);
                        if (decision != 0) {
                            int sign = this.decodeSignBit(i, j, index);
                            this.coefSign[index] = (byte)sign;
                            this.magnitude[index] = 1;
                            this.setNeighborSigns(i, j, index);
                            this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF | 2);
                        }
                        int n = index;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                        this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF | 1);
                    }
                    ++i1;
                    index += this.width;
                }
            }
        }
    }

    private int decodeSignBit(int y, int x, int index) {
        int decoded;
        int contribution;
        int sign0;
        int sign1;
        boolean significance1;
        boolean bl = significance1 = x > 0 && this.magnitude[index - 1] != 0;
        if (x + 1 < this.width && this.magnitude[index + 1] != 0) {
            sign1 = this.coefSign[index + 1] & 0xFF;
            if (significance1) {
                sign0 = this.coefSign[index - 1] & 0xFF;
                contribution = 1 - sign1 - sign0;
            } else {
                contribution = 1 - sign1 - sign1;
            }
        } else if (significance1) {
            sign0 = this.coefSign[index - 1] & 0xFF;
            contribution = 1 - sign0 - sign0;
        } else {
            contribution = 0;
        }
        int horizontalContribution = 3 * contribution;
        boolean bl2 = significance1 = y > 0 && this.magnitude[index - this.width] != 0;
        if (y + 1 < this.height && this.magnitude[index + this.width] != 0) {
            sign1 = this.coefSign[index + this.width] & 0xFF;
            if (significance1) {
                sign0 = this.coefSign[index - this.width] & 0xFF;
                contribution = 1 - sign1 - sign0 + horizontalContribution;
            } else {
                contribution = 1 - sign1 - sign1 + horizontalContribution;
            }
        } else if (significance1) {
            sign0 = this.coefSign[index - this.width] & 0xFF;
            contribution = 1 - sign0 - sign0 + horizontalContribution;
        } else {
            contribution = horizontalContribution;
        }
        if (contribution >= 0) {
            int contextLabel = 9 + contribution;
            decoded = this.decoder.decodeBit(this.cx, contextLabel);
        } else {
            int contextLabel = 9 - contribution;
            decoded = this.decoder.decodeBit(this.cx, contextLabel) ^ 1;
        }
        return decoded;
    }

    public void runMRP() {
        boolean processedMask = true;
        int msbMask = 2;
        int dim = this.width * this.height;
        int width4 = this.width * 4;
        int idx0 = 0;
        while (idx0 < dim) {
            int indexNext = Math.min(dim, idx0 + width4);
            for (int j = 0; j < this.width; ++j) {
                for (int index = idx0 + j; index < indexNext; index += this.width) {
                    int cmIndex = this.magnitude[index];
                    if (cmIndex == 0 || (this.curFlag[index] & 0xFF & 1) != 0) continue;
                    int contextLabel = 16;
                    if ((this.curFlag[index] & 0xFF & 2) != 0) {
                        this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF ^ 2);
                        int significance = this.nbrSign[index] & 0xFF & 0x7F;
                        contextLabel = significance == 0 ? 15 : 14;
                    }
                    int bit = this.decoder.decodeBit(this.cx, contextLabel);
                    this.magnitude[index] = cmIndex << 1 | bit;
                    int n = index;
                    this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                    this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF | 1);
                }
            }
            idx0 = indexNext;
        }
    }

    public void runCP() {
        boolean processedMask = true;
        int firstMagnitudeBitMask = 2;
        int w1 = this.width;
        int w2 = this.width << 1;
        int w3 = this.width * 3;
        int nextBit = 0;
        while (nextBit < this.height) {
            int i0 = nextBit;
            nextBit = Math.min(i0 + 4, this.height);
            int indexBase = i0 * this.width;
            boolean checkAllEmpty = i0 + 3 < this.height;
            for (int j = 0; j < this.width; ++j) {
                int index0 = indexBase + j;
                boolean allEmpty = checkAllEmpty && this.curFlag[index0] == 0 && this.curFlag[index0 + w1] == 0 && this.curFlag[index0 + w2] == 0 && this.curFlag[index0 + w3] == 0 && this.nbrSign[index0] == 0 && this.nbrSign[index0 + w1] == 0 && this.nbrSign[index0 + w2] == 0 && this.nbrSign[index0 + w3] == 0;
                int i1 = 0;
                int index = index0;
                int i = i0;
                if (allEmpty) {
                    if (this.decoder.decodeBit(this.cx, 18) == 0) {
                        int n = index0;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                        int n2 = index0 + w1;
                        this.bitsDecoded[n2] = (byte)(this.bitsDecoded[n2] + 1);
                        int n3 = index0 + w2;
                        this.bitsDecoded[n3] = (byte)(this.bitsDecoded[n3] + 1);
                        int n4 = index0 + w3;
                        this.bitsDecoded[n4] = (byte)(this.bitsDecoded[n4] + 1);
                        continue;
                    }
                    i1 = this.decoder.decodeBit(this.cx, 17) << 1 | this.decoder.decodeBit(this.cx, 17);
                    if (i1 != 0) {
                        i = i0 + i1;
                        index += i1 * this.width;
                    }
                    this.coefSign[index] = (byte)this.decodeSignBit(i, j, index);
                    this.magnitude[index] = 1;
                    this.setNeighborSigns(i, j, index);
                    this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF | 2);
                    index = index0;
                    for (int i2 = i0; i2 <= i; ++i2) {
                        int n = index;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                        index += this.width;
                    }
                    ++i1;
                }
                i = i0 + i1;
                while (i < nextBit) {
                    int coefIndex = this.magnitude[index];
                    if (coefIndex == 0 && (this.curFlag[index] & 0xFF & 1) == 0) {
                        int decision = this.decoder.decodeBit(this.cx, this.contextLableTable[this.nbrSign[index] & 0xFF]);
                        if (decision == 1) {
                            this.coefSign[index] = (byte)this.decodeSignBit(i, j, index);
                            this.magnitude[index] = 1;
                            this.setNeighborSigns(i, j, index);
                            this.curFlag[index] = (byte)(this.curFlag[index] & 0xFF | 2);
                        }
                        int n = index;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                    }
                    ++i;
                    index += this.width;
                }
            }
        }
    }

    public void runSegmentCheck() {
        int symbol = this.decoder.decodeBit(this.cx, 17) << 3 | this.decoder.decodeBit(this.cx, 17) << 2 | this.decoder.decodeBit(this.cx, 17) << 1 | this.decoder.decodeBit(this.cx, 17);
        if (symbol != 10) {
            System.err.println("invalid segmentation symbol found in jpeg2000");
        }
    }
}

