/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.JpxBitWriter;

public class TagTree {
    private final int w;
    private final int h;
    private int lvls;
    private final int[][] treeV;
    private final int[][] treeS;

    public TagTree(int h, int w, int[] val) {
        this.w = w;
        this.h = h;
        int w2 = this.w;
        int h2 = this.h;
        if (w == 0 || h == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (h2 != 1 || w2 != 1) {
                w2 = w2 + 1 >> 1;
                h2 = h2 + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        w2 = this.w;
        for (int i = 0; i < this.lvls; ++i) {
            this.treeV[i] = new int[h * w2];
            this.treeS[i] = new int[h * w2];
            w2 = w + 1 >> 1;
        }
        for (int k = w * h - 1; k >= 0; --k) {
            this.treeV[0][k] = val[k];
        }
        this.recalculate();
    }

    private void recalculate() {
        for (int k = 0; k < this.lvls - 1; ++k) {
            int bi;
            int n;
            int m;
            int lw = this.w + (1 << k) - 1 >> k;
            int lh = this.h + (1 << k) - 1 >> k;
            for (m = (lh >> 1 << 1) - 2; m >= 0; m -= 2) {
                for (n = (lw >> 1 << 1) - 2; n >= 0; n -= 2) {
                    bi = m * lw + n;
                    int tm1 = this.treeV[k][bi] < this.treeV[k][bi + 1] ? this.treeV[k][bi] : this.treeV[k][bi + 1];
                    int tm2 = this.treeV[k][bi + lw] < this.treeV[k][bi + lw + 1] ? this.treeV[k][bi + lw] : this.treeV[k][bi + lw + 1];
                    this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = tm1 < tm2 ? tm1 : tm2;
                }
                if (lw % 2 == 0) continue;
                n = lw >> 1 << 1;
                bi = m * lw + n;
                this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = this.treeV[k][bi] < this.treeV[k][bi + lw] ? this.treeV[k][bi] : this.treeV[k][bi + lw];
            }
            if (lh % 2 == 0) continue;
            m = lh >> 1 << 1;
            for (n = (lw >> 1 << 1) - 2; n >= 0; n -= 2) {
                bi = m * lw + n;
                this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = this.treeV[k][bi] < this.treeV[k][bi + 1] ? this.treeV[k][bi] : this.treeV[k][bi + 1];
            }
            if (lw % 2 == 0) continue;
            n = lw >> 1 << 1;
            this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = this.treeV[k][m * lw + n];
        }
    }

    public void encode(int m, int n, JpxBitWriter out) {
        int t = 1028;
        int k = this.lvls - 1;
        int tmin = this.treeS[k][0];
        while (true) {
            int idx;
            int ts;
            if ((ts = this.treeS[k][idx = (m >> k) * (this.w + (1 << k) - 1 >> k) + (n >> k)]) < tmin) {
                ts = tmin;
            }
            while (1028 > ts) {
                if (this.treeV[k][idx] > ts) {
                    out.putBit(0);
                } else if (this.treeV[k][idx] == ts) {
                    out.putBit(1);
                } else {
                    ts = 1028;
                    break;
                }
                ++ts;
            }
            this.treeS[k][idx] = ts;
            if (k <= 0) break;
            tmin = ts < this.treeV[k][idx] ? ts : this.treeV[k][idx];
            --k;
        }
    }
}

