/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.HImg;

class Scan {
    private static final int[] QP_4_YCBCR_INTRA_INTER = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] QP_8_YCBCR_INTRA = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 16, 17, 16, 17, 18, 17, 18, 18, 17, 18, 21, 19, 20, 21, 20, 19, 21, 24, 22, 22, 24, 24, 22, 22, 24, 25, 25, 27, 30, 27, 25, 25, 29, 31, 35, 35, 31, 29, 36, 41, 44, 41, 36, 47, 54, 54, 47, 65, 70, 65, 88, 88, 115};
    private static final int[] QP_8_YCBCR_INTER = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28, 28, 33, 33, 33, 33, 33, 41, 41, 41, 41, 54, 54, 54, 71, 71, 91};
    private static final int[][] SCANH = new int[6][];
    private static final int[][] SCANV = new int[6][];
    private static final int[][] SCAND = new int[6][];
    private static final int[][][] SCANPOS = new int[3][4][];
    int[][] scaling0;
    int[][] scaling1;
    int[][] scaling2;
    int[][] scaling3;

    Scan() {
    }

    private static void initScanH(int[] scan, int blkSize) {
        int i = 0;
        for (int y = 0; y < blkSize; ++y) {
            for (int x = 0; x < blkSize; ++x) {
                scan[i] = x << 16 | y;
                ++i;
            }
        }
    }

    private static void initScanV(int[] scan, int blkSize) {
        int i = 0;
        for (int x = 0; x < blkSize; ++x) {
            for (int y = 0; y < blkSize; ++y) {
                scan[i] = x << 16 | y;
                ++i;
            }
        }
    }

    private static void initScanD(int[] scan, int blkSize) {
        int i = 0;
        int x = 0;
        int y = 0;
        while (true) {
            if (y >= 0) {
                if (x < blkSize && y < blkSize) {
                    scan[i] = x << 16 | y;
                    ++i;
                }
                --y;
                ++x;
                continue;
            }
            y = x;
            x = 0;
            if (i >= blkSize * blkSize) break;
        }
    }

    static int[] get_scan_order(int log2BlockSize, int scanIdx) {
        switch (scanIdx) {
            case 0: {
                return SCAND[log2BlockSize];
            }
            case 1: {
                return SCANH[log2BlockSize];
            }
            case 2: {
                return SCANV[log2BlockSize];
            }
        }
        return new int[0];
    }

    static void fillScanPos(int[] pos, int loc, int x, int y, int scanIdx, int log2TrafoSize) {
        int yC;
        int xC;
        int lastScanPos = 16;
        int lastSubBlock = (1 << log2TrafoSize - 2) * (1 << log2TrafoSize - 2) - 1;
        int[] ScanOrderSub = Scan.get_scan_order(log2TrafoSize - 2, scanIdx);
        int[] ScanOrderPos = Scan.get_scan_order(2, scanIdx);
        do {
            if (lastScanPos == 0) {
                lastScanPos = 16;
                --lastSubBlock;
            }
            int S2 = ScanOrderSub[lastSubBlock];
            xC = (S2 >> 16 << 2) + (ScanOrderPos[--lastScanPos] >> 16);
            yC = ((S2 & 0xFFFF) << 2) + (ScanOrderPos[lastScanPos] & 0xFFFF);
        } while (xC != x || yC != y);
        pos[loc] = lastSubBlock << 16 | lastScanPos;
    }

    int getScanPos(int x, int y, int scanIdx, int log2BlkSize) {
        return SCANPOS[scanIdx][log2BlkSize - 2][y * (1 << log2BlkSize) + x];
    }

    void initScalingFactor() {
        int matrixId;
        this.scaling0 = new int[6][16];
        this.scaling1 = new int[6][64];
        this.scaling2 = new int[6][256];
        this.scaling3 = new int[6][1024];
        for (matrixId = 0; matrixId < 6; ++matrixId) {
            this.fillScalingFactor(this.scaling0[matrixId], QP_4_YCBCR_INTRA_INTER, 0);
        }
        for (matrixId = 0; matrixId < 3; ++matrixId) {
            this.fillScalingFactor(this.scaling1[matrixId + 0], QP_8_YCBCR_INTRA, 1);
            this.fillScalingFactor(this.scaling1[matrixId + 3], QP_8_YCBCR_INTER, 1);
        }
        for (matrixId = 0; matrixId < 3; ++matrixId) {
            this.fillScalingFactor(this.scaling2[matrixId + 0], QP_8_YCBCR_INTRA, 2);
            this.fillScalingFactor(this.scaling2[matrixId + 3], QP_8_YCBCR_INTER, 2);
        }
        this.fillScalingFactor(this.scaling3[0], QP_8_YCBCR_INTRA, 3);
        this.fillScalingFactor(this.scaling3[1], QP_8_YCBCR_INTER, 3);
    }

    void fillScalingFactor(int[] scalingFactors, int[] sclist, int sizeId) {
        switch (sizeId) {
            case 0: {
                int width = 4;
                int[] scan = Scan.get_scan_order(2, 0);
                for (int i = 0; i < 16; ++i) {
                    int x = scan[i] >> 16;
                    int y = scan[i] & 0xFFFF;
                    scalingFactors[x + width * y] = sclist[i];
                }
                break;
            }
            case 1: {
                int width = 8;
                int[] scan = Scan.get_scan_order(3, 0);
                for (int i = 0; i < 64; ++i) {
                    int x = scan[i] >> 16;
                    int y = scan[i] & 0xFFFF;
                    scalingFactors[x + width * y] = sclist[i];
                }
                break;
            }
            case 2: {
                int width = 8;
                int subWidth = 2;
                int[] scan = Scan.get_scan_order(3, 0);
                for (int i = 0; i < 64; ++i) {
                    for (int dy = 0; dy < 2; ++dy) {
                        for (int dx = 0; dx < 2; ++dx) {
                            int x = scan[i] >> 16;
                            int y = scan[i] & 0xFFFF;
                            x = 2 * x + dx;
                            y = 2 * y + dy;
                            scalingFactors[x + width * subWidth * y] = sclist[i];
                        }
                    }
                }
                break;
            }
            case 3: {
                int width = 8;
                int subWidth = 4;
                int[] scan = Scan.get_scan_order(3, 0);
                for (int i = 0; i < 64; ++i) {
                    for (int dy = 0; dy < 4; ++dy) {
                        for (int dx = 0; dx < 4; ++dx) {
                            int x = scan[i] >> 16;
                            int y = scan[i] & 0xFFFF;
                            x = 4 * x + dx;
                            y = 4 * y + dy;
                            scalingFactors[x + width * subWidth * y] = sclist[i];
                        }
                    }
                }
                break;
            }
        }
    }

    static void scale(Bitstream reader, HImg d) {
        int[][] dc_coeff = new int[4][6];
        for (int sizeId = 0; sizeId < 4; ++sizeId) {
            int[][] scaling_list = new int[6][1024];
            block7: for (int matrixId = 0; matrixId < 6; matrixId += sizeId == 3 ? 3 : 1) {
                int scaling_list_dc;
                int len;
                int canonicalId = matrixId;
                if (sizeId == 3 && matrixId == 1) {
                    canonicalId = 3;
                }
                int n = len = sizeId == 0 ? 16 : 64;
                int[] factor = sizeId == 0 ? QP_4_YCBCR_INTRA_INTER : (canonicalId < 3 ? QP_8_YCBCR_INTRA : QP_8_YCBCR_INTER);
                int[] curList = scaling_list[matrixId];
                byte scaling_list_pred_mode_flag = reader.readBit();
                if (scaling_list_pred_mode_flag == 0) {
                    int scaling_list_pred_matrix_id_delta = reader.ue();
                    dc_coeff[sizeId][matrixId] = 16;
                    scaling_list_dc = 16;
                    if (scaling_list_pred_matrix_id_delta == 0) {
                        if (sizeId == 0) {
                            System.arraycopy(QP_4_YCBCR_INTRA_INTER, 0, curList, 0, 16);
                        } else {
                            if (canonicalId < 3) {
                                System.arraycopy(QP_8_YCBCR_INTRA, 0, curList, 0, 64);
                            } else {
                                System.arraycopy(QP_8_YCBCR_INTER, 0, curList, 0, 64);
                            }
                            System.arraycopy(factor, 0, curList, 0, len);
                        }
                    } else {
                        int mID = matrixId - scaling_list_pred_matrix_id_delta;
                        System.arraycopy(scaling_list[mID], 0, curList, 0, len);
                        scaling_list_dc = dc_coeff[sizeId][mID];
                        dc_coeff[sizeId][matrixId] = dc_coeff[sizeId][mID];
                    }
                } else {
                    int coefNum;
                    int nextCoef = 8;
                    int n2 = coefNum = sizeId == 0 ? 16 : 64;
                    if (sizeId > 1) {
                        scaling_list_dc = reader.se();
                        nextCoef = scaling_list_dc += 8;
                        dc_coeff[sizeId][matrixId] = scaling_list_dc;
                    } else {
                        scaling_list_dc = 16;
                    }
                    for (int i = 0; i < coefNum; ++i) {
                        int slist_delta_coef = reader.se();
                        curList[i] = nextCoef = (nextCoef + slist_delta_coef + 256) % 256;
                    }
                }
                switch (sizeId) {
                    case 0: {
                        d.scan.fillScalingFactor(d.scan.scaling0[matrixId], curList, 0);
                        continue block7;
                    }
                    case 1: {
                        d.scan.fillScalingFactor(d.scan.scaling1[matrixId], curList, 1);
                        continue block7;
                    }
                    case 2: {
                        d.scan.fillScalingFactor(d.scan.scaling2[matrixId], curList, 2);
                        d.scan.scaling2[matrixId][0] = scaling_list_dc;
                        continue block7;
                    }
                    case 3: {
                        d.scan.fillScalingFactor(d.scan.scaling3[matrixId], curList, 3);
                        d.scan.scaling3[matrixId][0] = scaling_list_dc;
                    }
                }
            }
        }
    }

    static {
        Scan.SCANH[0] = new int[16];
        Scan.SCANV[0] = new int[16];
        Scan.SCAND[0] = new int[16];
        for (int log2size = 1; log2size <= 5; ++log2size) {
            int blk = 1 << log2size;
            Scan.SCANH[log2size] = new int[blk * blk];
            Scan.SCANV[log2size] = new int[blk * blk];
            Scan.SCAND[log2size] = new int[blk * blk];
            Scan.initScanH(SCANH[log2size], blk);
            Scan.initScanV(SCANV[log2size], blk);
            Scan.initScanD(SCAND[log2size], blk);
        }
        for (int log2size = 2; log2size <= 5; ++log2size) {
            int tt = 1 << log2size;
            for (int scanIdx = 0; scanIdx < 3; ++scanIdx) {
                if (SCANPOS[scanIdx][log2size - 2] == null) {
                    Scan.SCANPOS[scanIdx][log2size - 2] = new int[tt * tt];
                }
                int[] ff = SCANPOS[scanIdx][log2size - 2];
                for (int y = 0; y < tt; ++y) {
                    for (int x = 0; x < tt; ++x) {
                        Scan.fillScanPos(ff, y * tt + x, x, y, scanIdx, log2size);
                    }
                }
            }
        }
    }
}

