/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.ECabac;

class ProfileData {
    byte profile_present_flag;
    int profile_space;
    byte tier_flag;
    int profile_idc;
    private final byte[] profile_compatibility_flag = new byte[32];
    byte progressive_source_flag;
    byte interlaced_source_flag;
    byte non_packed_constraint_flag;
    byte frame_only_constraint_flag;
    byte level_present_flag;
    int level_idc;

    ProfileData() {
    }

    void setDefaults(int profile, int level_major, int level_minor) {
        this.profile_present_flag = 1;
        this.profile_space = 0;
        this.tier_flag = 0;
        this.profile_idc = profile;
        for (int i = 0; i < 32; ++i) {
            this.profile_compatibility_flag[i] = 0;
        }
        switch (profile) {
            case 0: {
                this.profile_compatibility_flag[0] = 1;
                this.profile_compatibility_flag[1] = 1;
                break;
            }
            case 1: {
                this.profile_compatibility_flag[1] = 1;
            }
        }
        this.progressive_source_flag = 0;
        this.interlaced_source_flag = 0;
        this.non_packed_constraint_flag = 0;
        this.frame_only_constraint_flag = 0;
        this.level_present_flag = 1;
        this.level_idc = level_major * 30 + level_minor * 3;
    }

    void read(Bitstream reader) {
        if (this.profile_present_flag != 0) {
            int i;
            this.profile_space = reader.readBits(2);
            this.tier_flag = reader.readBit();
            this.profile_idc = reader.readBits(5);
            for (i = 0; i < 32; ++i) {
                this.profile_compatibility_flag[i] = reader.readBit();
            }
            this.progressive_source_flag = reader.readBit();
            this.interlaced_source_flag = reader.readBit();
            this.non_packed_constraint_flag = reader.readBit();
            this.frame_only_constraint_flag = reader.readBit();
            for (i = 0; i < 44; ++i) {
                reader.readBits(1);
            }
        }
        if (this.level_present_flag != 0) {
            this.level_idc = reader.readU8();
        }
    }

    void write(ECabac out) {
        if (this.profile_present_flag != 0) {
            out.write_bits(this.profile_space, 2);
            out.write_bit(this.tier_flag);
            out.write_bits(this.profile_idc, 5);
            for (int j = 0; j < 32; ++j) {
                out.write_bit(this.profile_compatibility_flag[j]);
            }
            out.write_bit(this.progressive_source_flag);
            out.write_bit(this.interlaced_source_flag);
            out.write_bit(this.non_packed_constraint_flag);
            out.write_bit(this.frame_only_constraint_flag);
            out.skip_bits(44);
        }
        if (this.level_present_flag != 0) {
            out.write_bits(this.level_idc, 8);
        }
    }
}

