/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.builder.types;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import macromedia.graphics.g2d.GraphicContext;
import macromedia.swf.builder.types.FillStyleBuilder;
import macromedia.swf.builder.types.LineStyleBuilder;
import macromedia.swf.builder.types.PathIteratorWrapper;
import macromedia.swf.builder.types.Point;
import macromedia.swf.builder.types.ShapeBuilder;
import macromedia.swf.types.FillStyle;
import macromedia.swf.types.LineStyle;
import macromedia.swf.types.ShapeWithStyle;

public final class ShapeWithStyleBuilder {
    private ShapeBuilder builder;
    private List linestyles;
    private List fillstyles;

    public ShapeWithStyleBuilder(Shape shape, GraphicContext graphicContext, boolean outline, boolean fill) {
        Point origin = new Point(graphicContext.getPen().getX(), graphicContext.getPen().getY());
        Paint paint = graphicContext.getPaint();
        Stroke stroke = graphicContext.getStroke();
        FillStyle fs = null;
        LineStyle ls = null;
        if (fill && paint != null) {
            fs = FillStyleBuilder.build(paint, shape.getBounds2D(), graphicContext.getTransform());
        }
        if (outline && stroke != null) {
            ls = LineStyleBuilder.build(paint, stroke);
        }
        this.init(shape, origin, fs, ls, fill);
    }

    public ShapeWithStyleBuilder(Shape shape, Point origin, FillStyle fs, LineStyle ls, boolean fill) {
        this.init(shape, origin, fs, ls, fill);
    }

    private void init(Shape shape, Point origin, FillStyle fs, LineStyle ls, boolean fill) {
        this.builder = new ShapeBuilder(origin);
        this.linestyles = new ArrayList(2);
        this.fillstyles = new ArrayList(2);
        if (fill && fs != null) {
            this.builder.setUseFillStyle0(true);
            this.builder.setCurrentFillStyle0(this.addFillStyle(fs));
        }
        if (ls != null) {
            this.builder.setCurrentLineStyle(this.addLineStyle(ls));
        }
        this.builder.processShape(new PathIteratorWrapper(shape.getPathIterator(null)));
    }

    public ShapeWithStyle build() {
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.shapeRecords = this.builder.build().shapeRecords;
        sws.fillstyles = (ArrayList)this.fillstyles;
        sws.linestyles = (ArrayList)this.linestyles;
        return sws;
    }

    public void join(Shape shape) {
        this.builder.processShape(new PathIteratorWrapper(shape.getPathIterator(null)));
    }

    public int addFillStyle(FillStyle fs) {
        return this.fillstyles.add(fs) ? this.fillstyles.lastIndexOf(fs) + 1 : 0;
    }

    public int addLineStyle(LineStyle ls) {
        return this.linestyles.add(ls) ? this.linestyles.lastIndexOf(ls) + 1 : 0;
    }
}

