/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import macromedia.swf.ActionEncoder;
import macromedia.swf.DebugEncoder;
import macromedia.swf.Dictionary;
import macromedia.swf.Header;
import macromedia.swf.SwfEncoder;
import macromedia.swf.Tag;
import macromedia.swf.TagHandler;
import macromedia.swf.TagValues;
import macromedia.swf.tags.DebugID;
import macromedia.swf.tags.DefineBits;
import macromedia.swf.tags.DefineBitsJPEG3;
import macromedia.swf.tags.DefineBitsLossless;
import macromedia.swf.tags.DefineButton;
import macromedia.swf.tags.DefineButtonCxform;
import macromedia.swf.tags.DefineButtonSound;
import macromedia.swf.tags.DefineEditText;
import macromedia.swf.tags.DefineFont;
import macromedia.swf.tags.DefineFontInfo;
import macromedia.swf.tags.DefineMorphShape;
import macromedia.swf.tags.DefineShape;
import macromedia.swf.tags.DefineSound;
import macromedia.swf.tags.DefineSprite;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.tags.DefineText;
import macromedia.swf.tags.DefineVideoStream;
import macromedia.swf.tags.DoAction;
import macromedia.swf.tags.DoInitAction;
import macromedia.swf.tags.EnableDebugger;
import macromedia.swf.tags.ExportAssets;
import macromedia.swf.tags.FrameLabel;
import macromedia.swf.tags.GenericTag;
import macromedia.swf.tags.ImportAssets;
import macromedia.swf.tags.PlaceObject;
import macromedia.swf.tags.ProductInfo;
import macromedia.swf.tags.RemoveObject;
import macromedia.swf.tags.ScriptLimits;
import macromedia.swf.tags.SetBackgroundColor;
import macromedia.swf.tags.SetTabIndex;
import macromedia.swf.tags.ShowFrame;
import macromedia.swf.tags.SoundStreamHead;
import macromedia.swf.tags.StartSound;
import macromedia.swf.tags.VideoFrame;
import macromedia.swf.types.ButtonCondAction;
import macromedia.swf.types.ButtonRecord;
import macromedia.swf.types.CXForm;
import macromedia.swf.types.CXFormWithAlpha;
import macromedia.swf.types.CurvedEdgeRecord;
import macromedia.swf.types.EdgeRecord;
import macromedia.swf.types.FillStyle;
import macromedia.swf.types.GlyphEntry;
import macromedia.swf.types.GradRecord;
import macromedia.swf.types.ImportRecord;
import macromedia.swf.types.KerningRecord;
import macromedia.swf.types.LineStyle;
import macromedia.swf.types.MD5;
import macromedia.swf.types.Matrix;
import macromedia.swf.types.MorphFillStyle;
import macromedia.swf.types.MorphGradRecord;
import macromedia.swf.types.MorphLineStyle;
import macromedia.swf.types.Rect;
import macromedia.swf.types.Shape;
import macromedia.swf.types.ShapeRecord;
import macromedia.swf.types.ShapeWithStyle;
import macromedia.swf.types.SoundInfo;
import macromedia.swf.types.StraightEdgeRecord;
import macromedia.swf.types.StyleChangeRecord;
import macromedia.swf.types.TextRecord;
import macromedia.util.Assert;

public class TagEncoder
extends TagHandler
implements TagValues {
    private SwfEncoder writer;
    private SwfEncoder tagw;
    private int width;
    private int height;
    private int frames;
    private int framecountPos;
    private DebugEncoder debug;
    private Header header;
    protected Dictionary dict;
    private int uuidOffset;

    public TagEncoder() {
        this.dict = new Dictionary();
    }

    public TagEncoder(Dictionary dict) {
        this.dict = dict;
    }

    public void productInfo(ProductInfo tag) {
        this.tagw.write32(tag.getProduct());
        this.tagw.write32(tag.getEdition());
        this.tagw.write(new byte[]{tag.getMajorVersion(), tag.getMinorVersion()});
        this.tagw.write64(tag.getBuild());
        this.tagw.write64(tag.getCompileDate());
        this.encodeTag(tag);
    }

    public int getPos() {
        return this.writer.getPos();
    }

    protected int getSwfVersion() {
        return this.header.version;
    }

    protected int getFrameRate() {
        return this.header.rate;
    }

    public void setEncoderDictionary(Dictionary dict) {
        Assert.testAssertion((this.dict == null || this.dict.ids.size() == 0 ? 1 : 0) != 0);
        this.dict = dict;
    }

    public Dictionary getDictionary() {
        return this.dict;
    }

    protected SwfEncoder createEncoder(int swfVersion) {
        return new SwfEncoder(swfVersion);
    }

    public boolean isDebug() {
        return this.debug != null;
    }

    public void header(Header header) {
        int swfVersion = header.version;
        this.header = header;
        this.writer = this.createEncoder(swfVersion);
        this.tagw = this.createEncoder(swfVersion);
        this.width = header.size.getWidth();
        this.height = header.size.getHeight();
        this.frames = 0;
        this.writer.writeUI8(header.compressed ? 67 : 70);
        this.writer.writeUI8(87);
        this.writer.writeUI8(83);
        this.writer.writeUI8(header.version);
        this.writer.write32((int)header.length);
        if (header.compressed) {
            this.writer.markComp();
        }
        this.encodeRect(header.size, this.writer);
        this.writer.writeUI8(header.rate >> 8);
        this.writer.writeUI8(header.rate & 0xFF);
        this.framecountPos = this.writer.getPos();
        this.writer.writeUI16(header.framecount);
    }

    public int getWidth() {
        return this.width / 20;
    }

    public int getHeight() {
        return this.height / 20;
    }

    public void finish() {
        this.writer.writeUI16(0);
        this.writer.write32at(4, this.writer.getPos());
        this.writer.writeUI16at(this.framecountPos, this.frames);
        if (this.debug != null) {
            byte[] md5 = MD5.getDigest(this.writer.getByteArray(), this.writer.size());
            this.writer.writeAt(this.uuidOffset, md5);
            this.debug.updateUUID(md5);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writer.writeTo(out);
    }

    public void writeDebugTo(OutputStream out) throws IOException {
        this.debug.writeTo(out);
    }

    public void setMainDebugScript(String path) {
        this.debug.setMainDebugScript(path);
    }

    public void encodeRect(Rect r, SwfEncoder w) {
        int nBits = r.nbits();
        w.writeUBits(nBits, 5);
        w.writeSBits(r.xMin, nBits);
        w.writeSBits(r.xMax, nBits);
        w.writeSBits(r.yMin, nBits);
        w.writeSBits(r.yMax, nBits);
        w.flushBits();
    }

    public void debugID(DebugID tag) {
        this.encodeTagHeader(tag.code, tag.uuid.bytes.length, false);
        this.uuidOffset = this.writer.getPos();
        this.writer.write(tag.uuid.bytes);
        this.debug = new DebugEncoder();
        this.debug.header(this.getSwfVersion());
        this.debug.uuid(tag.uuid);
    }

    private void encodeTag(Tag tag) {
        try {
            this.tagw.compress();
            this.encodeTagHeader(tag.code, this.tagw.getPos(), this.isLongHeader(tag));
            this.tagw.writeTo(this.writer);
            this.tagw.reset();
        }
        catch (IOException e) {
            Assert.testAssertion((boolean)false);
        }
    }

    private boolean isLongHeader(Tag t) {
        switch (t.code) {
            case 6: 
            case 20: 
            case 21: 
            case 35: 
            case 36: {
                return true;
            }
            case 19: {
                return true;
            }
            case 7: 
            case 12: 
            case 34: 
            case 39: 
            case 59: {
                return this.isDebug();
            }
            case 26: {
                return this.isDebug() && ((PlaceObject)t).hasClipAction();
            }
        }
        return false;
    }

    private void encodeTagHeader(int code, int length, boolean longHeader) {
        if (longHeader || length >= 63) {
            this.writer.writeUI16(code << 6 | 0x3F);
            this.writer.write32(length);
        } else {
            this.writer.writeUI16(code << 6 | length);
        }
    }

    public void defineBits(DefineBits tag) {
        this.encodeTagHeader(tag.code, 2 + tag.data.length, true);
        int id = this.dict.add(tag);
        this.writer.writeUI16(id);
        this.writer.write(tag.data);
    }

    public void defineBitsJPEG2(DefineBits tag) {
        this.defineBits(tag);
    }

    public void defineBitsJPEG3(DefineBitsJPEG3 tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.write32(tag.data.length);
        this.tagw.write(tag.data);
        this.tagw.markComp();
        this.tagw.write(tag.alphaData);
        this.encodeTag(tag);
    }

    public void defineBitsLossless(DefineBitsLossless tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.writeUI8(tag.format);
        this.tagw.writeUI16(tag.width);
        this.tagw.writeUI16(tag.height);
        switch (tag.format) {
            case 3: {
                this.tagw.writeUI8(tag.colorData.length - 1);
                this.tagw.markComp();
                this.encodeColorMapData(tag.colorData, tag.data, this.tagw);
                break;
            }
            case 4: 
            case 5: {
                this.tagw.markComp();
                this.encodeBitmapData(tag.data, this.tagw);
            }
        }
        this.encodeTag(tag);
    }

    private void encodeBitmapData(byte[] data, SwfEncoder w) {
        int i = 0;
        while (i < data.length) {
            w.writeUI8(data[i] & 0xFF);
            ++i;
        }
    }

    private void encodeColorMapData(int[] colorData, byte[] pixelData, SwfEncoder w) {
        int i = 0;
        while (i < colorData.length) {
            this.encodeRGB(colorData[i], w);
            ++i;
        }
        w.write(pixelData);
    }

    private void encodeRGB(int rgb, SwfEncoder w) {
        w.writeUI8(rgb >>> 16);
        w.writeUI8(rgb >>> 8 & 0xFF);
        w.writeUI8(rgb & 0xFF);
    }

    public void defineBitsLossless2(DefineBitsLossless tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.writeUI8(tag.format);
        this.tagw.writeUI16(tag.width);
        this.tagw.writeUI16(tag.height);
        switch (tag.format) {
            case 3: {
                this.tagw.writeUI8(tag.colorData.length - 1);
                this.tagw.markComp();
                this.encodeAlphaColorMapData(tag.colorData, tag.data, this.tagw);
                break;
            }
            case 4: 
            case 5: {
                this.tagw.markComp();
                this.encodeBitmapData(tag.data, this.tagw);
            }
        }
        this.encodeTag(tag);
    }

    private void encodeAlphaColorMapData(int[] colorData, byte[] pixelData, SwfEncoder w) {
        int i = 0;
        while (i < colorData.length) {
            this.encodeRGBA(colorData[i], w);
            ++i;
        }
        w.write(pixelData);
    }

    private void encodeRGBA(int rgba, SwfEncoder w) {
        w.writeUI8(rgba >>> 16 & 0xFF);
        w.writeUI8(rgba >>> 8 & 0xFF);
        w.writeUI8(rgba & 0xFF);
        w.writeUI8(rgba >>> 24);
    }

    public void defineButton(DefineButton tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        if (this.isDebug()) {
            this.debug.adjust = this.writer.getPos() + 6;
        }
        int i = 0;
        while (i < tag.buttonRecords.length) {
            this.encodeButtonRecord(tag.buttonRecords[i], this.tagw, tag.code);
            ++i;
        }
        this.tagw.writeUI8(0);
        new ActionEncoder(this.tagw, this.debug).encode(tag.condActions[0].actionList);
        this.tagw.writeUI8(0);
        this.encodeTag(tag);
        if (this.isDebug()) {
            this.debug.adjust = 0;
        }
    }

    private void encodeButtonRecord(ButtonRecord record, SwfEncoder w, int defineButton) {
        w.writeUBits(0, 4);
        w.writeBit(record.hitTest);
        w.writeBit(record.down);
        w.writeBit(record.over);
        w.writeBit(record.up);
        w.writeUI16(this.dict.getId(record.characterRef));
        w.writeUI16(record.placeDepth);
        this.encodeMatrix(record.placeMatrix, w);
        if (defineButton == 34) {
            this.encodeCxforma(record.colorTransform, w);
        }
    }

    private void encodeCxforma(CXFormWithAlpha cxforma, SwfEncoder w) {
        w.writeBit(cxforma.hasAdd);
        w.writeBit(cxforma.hasMult);
        int nbits = cxforma.nbits();
        w.writeUBits(nbits, 4);
        if (cxforma.hasMult) {
            w.writeSBits(cxforma.redMultTerm, nbits);
            w.writeSBits(cxforma.greenMultTerm, nbits);
            w.writeSBits(cxforma.blueMultTerm, nbits);
            w.writeSBits(cxforma.alphaMultTerm, nbits);
        }
        if (cxforma.hasAdd) {
            w.writeSBits(cxforma.redAddTerm, nbits);
            w.writeSBits(cxforma.greenAddTerm, nbits);
            w.writeSBits(cxforma.blueAddTerm, nbits);
            w.writeSBits(cxforma.alphaAddTerm, nbits);
        }
        w.flushBits();
    }

    private void encodeMatrix(Matrix matrix, SwfEncoder w) {
        w.writeBit(matrix.hasScale);
        if (matrix.hasScale) {
            int nScaleBits = matrix.nScaleBits();
            w.writeUBits(nScaleBits, 5);
            w.writeSBits(matrix.scaleX, nScaleBits);
            w.writeSBits(matrix.scaleY, nScaleBits);
        }
        w.writeBit(matrix.hasRotate);
        if (matrix.hasRotate) {
            int nRotateBits = matrix.nRotateBits();
            w.writeUBits(nRotateBits, 5);
            w.writeSBits(matrix.rotateSkew0, nRotateBits);
            w.writeSBits(matrix.rotateSkew1, nRotateBits);
        }
        int nTranslateBits = matrix.nTranslateBits();
        w.writeUBits(nTranslateBits, 5);
        w.writeSBits(matrix.translateX, nTranslateBits);
        w.writeSBits(matrix.translateY, nTranslateBits);
        w.flushBits();
    }

    public void defineButton2(DefineButton tag) {
        if (this.isDebug()) {
            this.debug.adjust = this.writer.getPos() + 6;
        }
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.writeUBits(0, 7);
        this.tagw.writeBit(tag.trackAsMenu);
        int offsetPos = this.tagw.getPos();
        this.tagw.writeUI16(0);
        int i = 0;
        while (i < tag.buttonRecords.length) {
            this.encodeButtonRecord(tag.buttonRecords[i], this.tagw, tag.code);
            ++i;
        }
        this.tagw.writeUI8(0);
        if (tag.condActions.length > 0) {
            this.tagw.writeUI16at(offsetPos, this.tagw.getPos() - offsetPos);
            int i2 = 0;
            while (i2 < tag.condActions.length) {
                boolean isLast = i2 + 1 == tag.condActions.length;
                this.encodeButtonCondAction(tag.condActions[i2], this.tagw, isLast);
                ++i2;
            }
        }
        this.encodeTag(tag);
        if (this.isDebug()) {
            this.debug.adjust = 0;
        }
    }

    private void encodeButtonCondAction(ButtonCondAction condAction, SwfEncoder w, boolean last) {
        int pos = w.getPos();
        w.writeUI16(0);
        w.writeUBits(condAction.keyPress, 7);
        w.writeBit(condAction.overDownToIdle);
        w.writeBit(condAction.idleToOverDown);
        w.writeBit(condAction.outDownToIdle);
        w.writeBit(condAction.outDownToOverDown);
        w.writeBit(condAction.overDownToOutDown);
        w.writeBit(condAction.overDownToOverUp);
        w.writeBit(condAction.overUpToOverDown);
        w.writeBit(condAction.overUpToIdle);
        w.writeBit(condAction.idleToOverUp);
        new ActionEncoder(w, this.debug).encode(condAction.actionList);
        w.writeUI8(0);
        if (!last) {
            w.writeUI16at(pos, w.getPos() - pos);
        }
    }

    public void defineButtonCxform(DefineButtonCxform tag) {
        int idref = this.dict.getId(tag.button);
        this.tagw.writeUI16(idref);
        this.encodeCxform(tag.colorTransform, this.tagw);
        this.encodeTag(tag);
    }

    private void encodeCxform(CXForm cxform, SwfEncoder w) {
        w.writeBit(cxform.hasAdd);
        w.writeBit(cxform.hasMult);
        int nbits = cxform.nbits();
        w.writeUBits(nbits, 4);
        if (cxform.hasMult) {
            w.writeSBits(cxform.redMultTerm, nbits);
            w.writeSBits(cxform.greenMultTerm, nbits);
            w.writeSBits(cxform.blueMultTerm, nbits);
        }
        if (cxform.hasAdd) {
            w.writeSBits(cxform.redAddTerm, nbits);
            w.writeSBits(cxform.greenAddTerm, nbits);
            w.writeSBits(cxform.blueAddTerm, nbits);
        }
        w.flushBits();
    }

    public void defineButtonSound(DefineButtonSound tag) {
        int idref = this.dict.getId(tag.button);
        this.tagw.writeUI16(idref);
        if (tag.sound0 != null) {
            this.tagw.writeUI16(this.dict.getId(tag.sound0));
            this.encodeSoundInfo(tag.info0, this.tagw);
        } else {
            this.tagw.writeUI16(0);
        }
        if (tag.sound1 != null) {
            this.tagw.writeUI16(this.dict.getId(tag.sound1));
            this.encodeSoundInfo(tag.info1, this.tagw);
        } else {
            this.tagw.writeUI16(0);
        }
        if (tag.sound2 != null) {
            this.tagw.writeUI16(this.dict.getId(tag.sound2));
            this.encodeSoundInfo(tag.info2, this.tagw);
        } else {
            this.tagw.writeUI16(0);
        }
        if (tag.sound3 != null) {
            this.tagw.writeUI16(this.dict.getId(tag.sound3));
            this.encodeSoundInfo(tag.info3, this.tagw);
        } else {
            this.tagw.writeUI16(0);
        }
        this.encodeTag(tag);
    }

    private void encodeSoundInfo(SoundInfo info, SwfEncoder w) {
        w.writeUBits(0, 2);
        w.writeBit(info.syncStop);
        w.writeBit(info.syncNoMultiple);
        w.writeBit(info.records != null);
        w.writeBit(info.loopCount != -1);
        w.writeBit(info.outPoint != -1L);
        w.writeBit(info.inPoint != -1L);
        if (info.inPoint != -1L) {
            w.write32((int)info.inPoint);
        }
        if (info.outPoint != -1L) {
            w.write32((int)info.outPoint);
        }
        if (info.loopCount != -1) {
            w.writeUI16(info.loopCount);
        }
        if (info.records != null) {
            w.writeUI8(info.records.length);
            int k = 0;
            while (k < info.records.length) {
                w.write64(info.records[k]);
                ++k;
            }
        }
    }

    public void defineEditText(DefineEditText tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.encodeRect(tag.bounds, this.tagw);
        this.tagw.writeBit(tag.hasText);
        this.tagw.writeBit(tag.wordWrap);
        this.tagw.writeBit(tag.multiline);
        this.tagw.writeBit(tag.password);
        this.tagw.writeBit(tag.readOnly);
        this.tagw.writeBit(tag.hasTextColor);
        this.tagw.writeBit(tag.hasMaxLength);
        this.tagw.writeBit(tag.hasFont);
        this.tagw.writeBit(false);
        this.tagw.writeBit(tag.autoSize);
        this.tagw.writeBit(tag.hasLayout);
        this.tagw.writeBit(tag.noSelect);
        this.tagw.writeBit(tag.border);
        this.tagw.writeBit(false);
        this.tagw.writeBit(tag.html);
        this.tagw.writeBit(tag.useOutlines);
        this.tagw.flushBits();
        if (tag.hasFont) {
            int idref = this.dict.getId(tag.font);
            this.tagw.writeUI16(idref);
            this.tagw.writeUI16(tag.height);
        }
        if (tag.hasTextColor) {
            this.encodeRGBA(tag.color, this.tagw);
        }
        if (tag.hasMaxLength) {
            this.tagw.writeUI16(tag.maxLength);
        }
        if (tag.hasLayout) {
            this.tagw.writeUI8(tag.align);
            this.tagw.writeUI16(tag.leftMargin);
            this.tagw.writeUI16(tag.rightMargin);
            this.tagw.writeUI16(tag.ident);
            this.tagw.writeSI16(tag.leading);
        }
        this.tagw.writeString(tag.varName);
        if (tag.hasText) {
            this.tagw.writeString(tag.initialText);
        }
        this.encodeTag(tag);
    }

    public void defineFont(DefineFont tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        int count = tag.glyphShapeTable.length;
        int offsetPos = this.tagw.getPos();
        int i = 0;
        while (i < count) {
            this.tagw.writeUI16(0);
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            this.tagw.writeUI16at(offsetPos + 2 * i2, this.tagw.getPos() - offsetPos);
            this.encodeShape(tag.glyphShapeTable[i2], this.tagw, 32, 1, 0);
            ++i2;
        }
        this.encodeTag(tag);
    }

    public void encodeShape(Shape s, SwfEncoder w, int shape, int nFillStyles, int nLineStyles) {
        int[] numFillBits = new int[]{SwfEncoder.minBits(nFillStyles, 0)};
        int[] numLineBits = new int[]{SwfEncoder.minBits(nLineStyles, 0)};
        w.writeUBits(numFillBits[0], 4);
        w.writeUBits(numLineBits[0], 4);
        Iterator it = s.shapeRecords.iterator();
        while (it.hasNext()) {
            int nbits;
            ShapeRecord record = (ShapeRecord)it.next();
            if (record instanceof StyleChangeRecord) {
                w.writeBit(false);
                StyleChangeRecord change = (StyleChangeRecord)record;
                this.encodeStyleChangeRecord(w, change, numFillBits, numLineBits, shape);
                continue;
            }
            w.writeBit(true);
            EdgeRecord e = (EdgeRecord)record;
            boolean straight = e instanceof StraightEdgeRecord;
            w.writeBit(straight);
            int n = nbits = straight ? this.calcBits((StraightEdgeRecord)e) : this.calcBits((CurvedEdgeRecord)e);
            if (nbits < 2) {
                nbits = 2;
            }
            w.writeUBits(nbits - 2, 4);
            if (straight) {
                StraightEdgeRecord line = (StraightEdgeRecord)e;
                this.encodeStraightEdgeRecord(line, w, nbits);
                continue;
            }
            CurvedEdgeRecord curve = (CurvedEdgeRecord)e;
            w.writeSBits(curve.controlDeltaX, nbits);
            w.writeSBits(curve.controlDeltaY, nbits);
            w.writeSBits(curve.anchorDeltaX, nbits);
            w.writeSBits(curve.anchorDeltaY, nbits);
        }
        w.writeUBits(0, 6);
        w.flushBits();
    }

    private int calcBits(StraightEdgeRecord edge) {
        return SwfEncoder.minBits(SwfEncoder.maxNum(edge.deltaX, edge.deltaY, 0, 0), 1);
    }

    private int calcBits(CurvedEdgeRecord edge) {
        return SwfEncoder.minBits(SwfEncoder.maxNum(edge.controlDeltaX, edge.controlDeltaY, edge.anchorDeltaX, edge.anchorDeltaY), 1);
    }

    private void encodeStraightEdgeRecord(StraightEdgeRecord line, SwfEncoder w, int nbits) {
        if (line.deltaX == 0) {
            w.writeUBits(1, 2);
            w.writeSBits(line.deltaY, nbits);
        } else if (line.deltaY == 0) {
            w.writeUBits(0, 2);
            w.writeSBits(line.deltaX, nbits);
        } else {
            w.writeBit(true);
            w.writeSBits(line.deltaX, nbits);
            w.writeSBits(line.deltaY, nbits);
        }
    }

    private void encodeStyleChangeRecord(SwfEncoder w, StyleChangeRecord s, int[] numFillBits, int[] numLineBits, int shape) {
        w.writeBit(s.stateNewStyles);
        w.writeBit(s.stateLineStyle);
        w.writeBit(s.stateFillStyle1);
        w.writeBit(s.stateFillStyle0);
        w.writeBit(s.stateMoveTo);
        if (s.stateMoveTo) {
            int moveBits = s.nMoveBits();
            w.writeUBits(moveBits, 5);
            w.writeSBits(s.moveDeltaX, moveBits);
            w.writeSBits(s.moveDeltaY, moveBits);
        }
        if (s.stateFillStyle0) {
            w.writeUBits(s.fillstyle0, numFillBits[0]);
        }
        if (s.stateFillStyle1) {
            w.writeUBits(s.fillstyle1, numFillBits[0]);
        }
        if (s.stateLineStyle) {
            w.writeUBits(s.linestyle, numLineBits[0]);
        }
        if (s.stateNewStyles) {
            w.flushBits();
            this.encodeFillstyles(s.fillstyles, w, shape);
            this.encodeLinestyles(s.linestyles, w, shape);
            numFillBits[0] = SwfEncoder.minBits(s.fillstyles.size(), 0);
            numLineBits[0] = SwfEncoder.minBits(s.linestyles.size(), 0);
            w.writeUBits(numFillBits[0], 4);
            w.writeUBits(numLineBits[0], 4);
        }
    }

    private void encodeLinestyles(ArrayList linestyles, SwfEncoder w, int shape) {
        int count = linestyles.size();
        if (count > 255) {
            w.writeUI8(255);
            w.writeUI16(count);
        } else {
            w.writeUI8(count);
        }
        int i = 0;
        while (i < count) {
            this.encodeLineStyle((LineStyle)linestyles.get(i), w, shape);
            ++i;
        }
    }

    private void encodeLineStyle(LineStyle lineStyle, SwfEncoder w, int shape) {
        w.writeUI16(lineStyle.width);
        if (shape == 32) {
            this.encodeRGBA(lineStyle.color, w);
        } else {
            this.encodeRGB(lineStyle.color, w);
        }
    }

    private void encodeFillstyles(ArrayList fillstyles, SwfEncoder w, int shape) {
        int count = fillstyles.size();
        if (count >= 255) {
            w.writeUI8(255);
            w.writeUI16(count);
        } else {
            w.writeUI8(count);
        }
        Iterator it = ((AbstractList)fillstyles).iterator();
        while (it.hasNext()) {
            FillStyle style = (FillStyle)it.next();
            this.encodeFillStyle(style, w, shape);
        }
    }

    private void encodeFillStyle(FillStyle style, SwfEncoder w, int shape) {
        w.writeUI8(style.type);
        switch (style.type) {
            case 0: {
                if (shape == 32) {
                    this.encodeRGBA(style.color, w);
                    break;
                }
                this.encodeRGB(style.color, w);
                break;
            }
            case 16: 
            case 18: {
                this.encodeMatrix(style.matrix, w);
                this.encodeGradient(style.gradient, w, shape);
                break;
            }
            case 64: 
            case 65: {
                w.writeUI16(this.dict.getId(style.bitmap));
                this.encodeMatrix(style.matrix, w);
            }
        }
    }

    private void encodeGradient(GradRecord[] records, SwfEncoder w, int shape) {
        w.writeUI8(records.length);
        int i = 0;
        while (i < records.length) {
            this.encodeGradRecord(records[i], w, shape);
            ++i;
        }
    }

    private void encodeGradRecord(GradRecord record, SwfEncoder w, int shape) {
        w.writeUI8(record.ratio);
        if (shape == 32) {
            this.encodeRGBA(record.color, w);
        } else {
            this.encodeRGB(record.color, w);
        }
    }

    public void defineFont2(DefineFont tag) {
        boolean again;
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        boolean wideOffsets = false;
        int startPos = this.tagw.getPos();
        boolean wideCodes = false;
        int i = 0;
        while (i < tag.codeTable.length) {
            if (tag.codeTable[i] > '\u00ff') {
                wideCodes = true;
                break;
            }
            ++i;
        }
        block1: do {
            int i2;
            int offset;
            int i3;
            again = false;
            this.tagw.writeBit(tag.hasLayout);
            this.tagw.writeBit(tag.shiftJIS);
            this.tagw.writeBit(false);
            this.tagw.writeBit(tag.ansi);
            this.tagw.writeBit(wideOffsets);
            this.tagw.writeBit(wideCodes);
            this.tagw.writeBit(tag.italic);
            this.tagw.writeBit(tag.bold);
            this.tagw.flushBits();
            this.tagw.writeUI8(tag.langCode);
            this.tagw.writeLengthString(tag.fontName);
            int count = tag.glyphShapeTable.length;
            this.tagw.writeUI16(count);
            int offsetPos = this.tagw.getPos();
            if (wideOffsets) {
                i3 = 0;
                while (i3 < count) {
                    this.tagw.write32(0);
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < count) {
                    this.tagw.writeUI16(0);
                    ++i3;
                }
            }
            if (wideOffsets) {
                this.tagw.write32(0);
            } else {
                this.tagw.writeUI16(0);
            }
            i3 = 0;
            while (i3 < count) {
                offset = this.tagw.getPos() - offsetPos;
                if (!wideOffsets && offset > 65535) {
                    again = true;
                    wideOffsets = true;
                    this.tagw.setPos(startPos);
                    continue block1;
                }
                if (wideOffsets) {
                    this.tagw.write32at(offsetPos + 4 * i3, offset);
                } else {
                    this.tagw.writeUI16at(offsetPos + 2 * i3, offset);
                }
                this.encodeShape(tag.glyphShapeTable[i3], this.tagw, 32, 1, 0);
                ++i3;
            }
            offset = this.tagw.getPos() - offsetPos;
            if (!wideOffsets && offset > 65535) {
                again = true;
                wideOffsets = true;
                this.tagw.setPos(startPos);
                continue;
            }
            if (wideOffsets) {
                this.tagw.write32at(offsetPos + 4 * count, offset);
            } else {
                this.tagw.writeUI16at(offsetPos + 2 * count, offset);
            }
            if (wideCodes) {
                i2 = 0;
                while (i2 < tag.codeTable.length) {
                    this.tagw.writeUI16(tag.codeTable[i2]);
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < tag.codeTable.length) {
                    this.tagw.writeUI8(tag.codeTable[i2]);
                    ++i2;
                }
            }
            if (!tag.hasLayout) continue;
            this.tagw.writeSI16(tag.ascent);
            this.tagw.writeSI16(tag.descent);
            this.tagw.writeSI16(tag.leading);
            i2 = 0;
            while (i2 < tag.advanceTable.length) {
                this.tagw.writeSI16(tag.advanceTable[i2]);
                ++i2;
            }
            int i4 = 0;
            while (i4 < tag.boundsTable.length) {
                this.encodeRect(tag.boundsTable[i4], this.tagw);
                ++i4;
            }
            this.tagw.writeUI16(tag.kerningTable.length);
            int i5 = 0;
            while (i5 < tag.kerningTable.length) {
                if (!(wideCodes || tag.kerningTable[i5].code1 <= 255 && tag.kerningTable[i5].code2 <= 255)) {
                    again = true;
                    wideCodes = true;
                    this.tagw.setPos(startPos);
                    continue block1;
                }
                this.encodeKerningRecord(tag.kerningTable[i5], this.tagw, wideCodes);
                ++i5;
            }
        } while (again);
        this.encodeTag(tag);
    }

    private void encodeKerningRecord(KerningRecord kerningRecord, SwfEncoder w, boolean wideCodes) {
        if (wideCodes) {
            w.writeUI16(kerningRecord.code1);
            w.writeUI16(kerningRecord.code2);
        } else {
            w.writeUI8(kerningRecord.code1);
            w.writeUI8(kerningRecord.code2);
        }
        w.writeUI16(kerningRecord.adjustment);
    }

    public void defineFontInfo(DefineFontInfo tag) {
        int i;
        int idref = this.dict.getId(tag.font);
        this.tagw.writeUI16(idref);
        this.tagw.writeLengthString(tag.name);
        this.tagw.writeUBits(0, 3);
        this.tagw.writeBit(tag.shiftJIS);
        this.tagw.writeBit(tag.ansi);
        this.tagw.writeBit(tag.italic);
        this.tagw.writeBit(tag.bold);
        boolean widecodes = false;
        if (tag.code == 62) {
            widecodes = true;
            this.tagw.writeBit(true);
            this.tagw.writeUI8(tag.langCode);
        } else {
            i = 0;
            while (i < tag.codeTable.length) {
                if (tag.codeTable[i] > '\u00ff') {
                    widecodes = true;
                    break;
                }
                ++i;
            }
            this.tagw.writeBit(widecodes);
        }
        if (widecodes) {
            i = 0;
            while (i < tag.codeTable.length) {
                this.tagw.writeUI16(tag.codeTable[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < tag.codeTable.length) {
                this.tagw.writeUI8(tag.codeTable[i]);
                ++i;
            }
        }
        this.encodeTag(tag);
    }

    public void defineFontInfo2(DefineFontInfo tag) {
        this.defineFontInfo(tag);
    }

    public void defineMorphShape(DefineMorphShape tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.encodeRect(tag.startBounds, this.tagw);
        this.encodeRect(tag.endBounds, this.tagw);
        this.tagw.write32(0);
        int pos = this.tagw.getPos();
        this.encodeMorphFillstyles(tag.fillStyles, this.tagw);
        this.encodeMorphLinestyles(tag.lineStyles, this.tagw);
        this.encodeShape(tag.startEdges, this.tagw, 32, tag.fillStyles.length, tag.lineStyles.length);
        this.tagw.write32at(pos - 4, this.tagw.getPos() - pos);
        this.encodeShape(tag.endEdges, this.tagw, 32, 0, 0);
        this.encodeTag(tag);
    }

    private void encodeMorphFillstyles(MorphFillStyle[] fillStyles, SwfEncoder w) {
        int count = fillStyles.length;
        if (count >= 255) {
            w.writeUI8(255);
            w.writeUI16(count);
        } else {
            w.writeUI8(count);
        }
        int i = 0;
        while (i < count) {
            MorphFillStyle style = fillStyles[i];
            w.writeUI8(style.type);
            switch (style.type) {
                case 0: {
                    this.encodeRGBA(style.startColor, w);
                    this.encodeRGBA(style.endColor, w);
                    break;
                }
                case 16: 
                case 18: {
                    this.encodeMatrix(style.startGradientMatrix, w);
                    this.encodeMatrix(style.endGradientMatrix, w);
                    this.encodeMorphGradient(style.gradRecords, w);
                    break;
                }
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    w.writeUI16(this.dict.getId(style.bitmap));
                    this.encodeMatrix(style.startBitmapMatrix, w);
                    this.encodeMatrix(style.endBitmapMatrix, w);
                    break;
                }
                default: {
                    Assert.testAssertion((boolean)false);
                }
            }
            ++i;
        }
    }

    private void encodeMorphGradient(MorphGradRecord[] gradRecords, SwfEncoder w) {
        w.writeUI8(gradRecords.length);
        int i = 0;
        while (i < gradRecords.length) {
            MorphGradRecord record = gradRecords[i];
            w.writeUI8(record.startRatio);
            this.encodeRGBA(record.startColor, w);
            w.writeUI8(record.endRatio);
            this.encodeRGBA(record.endColor, w);
            ++i;
        }
    }

    private void encodeMorphLinestyles(MorphLineStyle[] lineStyles, SwfEncoder w) {
        if (lineStyles.length >= 255) {
            w.writeUI8(255);
            w.writeUI16(lineStyles.length);
        } else {
            w.writeUI8(lineStyles.length);
        }
        int i = 0;
        while (i < lineStyles.length) {
            MorphLineStyle style = lineStyles[i];
            w.writeUI16(style.startWidth);
            w.writeUI16(style.endWidth);
            this.encodeRGBA(style.startColor, w);
            this.encodeRGBA(style.endColor, w);
            ++i;
        }
    }

    public void defineShape(DefineShape tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.encodeRect(tag.bounds, this.tagw);
        this.encodeShapeWithStyle(tag.shapeWithStyle, this.tagw, tag.code);
        this.encodeTag(tag);
    }

    private void encodeShapeWithStyle(ShapeWithStyle shapeWithStyle, SwfEncoder w, int shape) {
        this.encodeFillstyles(shapeWithStyle.fillstyles, w, shape);
        this.encodeLinestyles(shapeWithStyle.linestyles, w, shape);
        this.encodeShape(shapeWithStyle, w, shape, shapeWithStyle.fillstyles.size(), shapeWithStyle.linestyles.size());
    }

    public void defineShape2(DefineShape tag) {
        this.defineShape(tag);
    }

    public void defineShape3(DefineShape tag) {
        this.defineShape(tag);
    }

    public void defineSound(DefineSound tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.writeUBits(tag.format, 4);
        this.tagw.writeUBits(tag.rate, 2);
        this.tagw.writeUBits(tag.size, 1);
        this.tagw.writeUBits(tag.type, 1);
        this.tagw.write32((int)tag.sampleCount);
        this.tagw.write(tag.data);
        this.encodeTag(tag);
    }

    public void defineSprite(DefineSprite tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.writeUI16(tag.framecount);
        if (this.isDebug()) {
            this.debug.adjust = this.writer.getPos() + 6;
        }
        int oldFrames = this.frames;
        this.frames = 0;
        SwfEncoder oldWriter = this.writer;
        this.writer = this.tagw;
        this.tagw = this.createEncoder(this.getSwfVersion());
        List tags = tag.tagList.tags;
        int size = tags.size();
        int i = 0;
        while (i < size) {
            Tag t = (Tag)tags.get(i);
            if (!(t instanceof DefineTag)) {
                t.visit(this);
            }
            ++i;
        }
        this.writer.writeUI16(0);
        this.writer.writeUI16at(2, this.frames);
        this.tagw = this.writer;
        this.writer = oldWriter;
        this.frames = oldFrames;
        if (this.isDebug()) {
            this.debug.adjust = 0;
        }
        this.encodeTag(tag);
    }

    public void defineText(DefineText tag) {
        this.encodeDefineText(tag, this.tagw, tag.code);
        this.encodeTag(tag);
    }

    private void encodeDefineText(DefineText tag, SwfEncoder w, int type) {
        int id = this.dict.add(tag);
        w.writeUI16(id);
        this.encodeRect(tag.bounds, w);
        this.encodeMatrix(tag.matrix, w);
        int length = tag.records.size();
        int glyphBits = 0;
        int advanceBits = 0;
        int i = 0;
        while (i < length) {
            TextRecord tr = (TextRecord)tag.records.get(i);
            int j = 0;
            while (j < tr.entries.length) {
                GlyphEntry entry = tr.entries[j];
                while (entry.getIndex() > 1 << glyphBits) {
                    ++glyphBits;
                }
                while (Math.abs(entry.advance) > 1 << advanceBits) {
                    ++advanceBits;
                }
                ++j;
            }
            ++i;
        }
        ++advanceBits;
        w.writeUI8(++glyphBits);
        w.writeUI8(++advanceBits);
        int i2 = 0;
        while (i2 < length) {
            TextRecord record = (TextRecord)tag.records.get(i2);
            this.encodeTextRecord(record, w, type, glyphBits, advanceBits);
            ++i2;
        }
        w.writeUI8(0);
    }

    private void encodeTextRecord(TextRecord record, SwfEncoder w, int type, int glyphBits, int advanceBits) {
        w.writeUI8(record.flags);
        if (record.hasFont()) {
            w.writeUI16(this.dict.getId(record.font));
        }
        if (record.hasColor()) {
            if (type == 33) {
                this.encodeRGBA(record.color, w);
            } else {
                this.encodeRGB(record.color, w);
            }
        }
        if (record.hasX()) {
            w.writeSI16(record.xOffset);
        }
        if (record.hasY()) {
            w.writeSI16(record.yOffset);
        }
        if (record.hasHeight()) {
            w.writeUI16(record.height);
        }
        w.writeUI8(record.entries.length);
        int i = 0;
        while (i < record.entries.length) {
            w.writeUBits(record.entries[i].getIndex(), glyphBits);
            w.writeSBits(record.entries[i].advance, advanceBits);
            ++i;
        }
        w.flushBits();
    }

    public void defineText2(DefineText tag) {
        this.defineText(tag);
    }

    public void defineVideoStream(DefineVideoStream tag) {
        int id = this.dict.add(tag);
        this.tagw.writeUI16(id);
        this.tagw.writeUI16(tag.numFrames);
        this.tagw.writeUI16(tag.width);
        this.tagw.writeUI16(tag.height);
        this.tagw.writeUBits(0, 5);
        this.tagw.writeUBits(tag.deblocking, 2);
        this.tagw.writeBit(tag.smoothing);
        this.tagw.writeUI8(tag.codecID);
        this.encodeTag(tag);
    }

    public void doAction(DoAction tag) {
        int adjust = 0;
        if (this.isDebug()) {
            adjust = this.writer.getPos() + 6;
            this.debug.adjust += adjust;
        }
        new ActionEncoder(this.tagw, this.debug).encode(tag.actionList);
        this.tagw.writeUI8(0);
        this.encodeTag(tag);
        if (this.isDebug()) {
            this.debug.adjust -= adjust;
        }
    }

    public void doInitAction(DoInitAction tag) {
        int adjust = 0;
        if (this.isDebug()) {
            adjust = this.writer.getPos() + 6;
            this.debug.adjust += adjust;
        }
        int idref = this.dict.getId(tag.sprite);
        this.tagw.writeUI16(idref);
        new ActionEncoder(this.tagw, this.debug).encode(tag.actionList);
        this.tagw.writeUI8(0);
        this.encodeTag(tag);
        if (this.isDebug()) {
            this.debug.adjust -= adjust;
        }
    }

    public void enableDebugger(EnableDebugger tag) {
        this.tagw.writeString(tag.password);
        this.encodeTag(tag);
    }

    public void enableDebugger2(EnableDebugger tag) {
        this.tagw.writeUI16(6517);
        this.tagw.writeString(tag.password);
        this.encodeTag(tag);
    }

    public void exportAssets(ExportAssets tag) {
        this.tagw.writeUI16(tag.exports.size());
        Iterator it = tag.exports.iterator();
        while (it.hasNext()) {
            DefineTag ref = (DefineTag)it.next();
            int idref = this.dict.getId(ref);
            this.tagw.writeUI16(idref);
            Assert.testAssertion((ref.name != null ? 1 : 0) != 0);
            this.tagw.writeString(ref.name);
            this.dict.addName(ref, ref.name);
        }
        this.encodeTag(tag);
    }

    public void frameLabel(FrameLabel tag) {
        this.tagw.writeString(tag.label);
        if (tag.anchor && this.getSwfVersion() >= 6) {
            this.tagw.writeUI8(1);
        }
        this.encodeTag(tag);
    }

    public void importAssets(ImportAssets tag) {
        this.tagw.writeString(tag.url);
        this.tagw.writeUI16(tag.importRecords.size());
        Iterator it = tag.importRecords.iterator();
        while (it.hasNext()) {
            ImportRecord record = (ImportRecord)it.next();
            int id = this.dict.add(record);
            this.tagw.writeUI16(id);
            this.tagw.writeString(record.name);
        }
        this.encodeTag(tag);
    }

    public void jpegTables(GenericTag tag) {
        this.encodeTagHeader(tag.code, tag.data.length, false);
        this.writer.write(tag.data);
    }

    public void placeObject(PlaceObject tag) {
        int idref = this.dict.getId(tag.ref);
        this.tagw.writeUI16(idref);
        this.tagw.writeUI16(tag.depth);
        this.encodeMatrix(tag.matrix, this.tagw);
        if (tag.colorTransform != null) {
            this.encodeCxform(tag.colorTransform, this.tagw);
        }
        this.encodeTag(tag);
    }

    public void placeObject2(PlaceObject tag) {
        this.tagw.writeUI8(tag.flags);
        this.tagw.writeUI16(tag.depth);
        if (tag.hasCharID()) {
            int idref = this.dict.getId(tag.ref);
            this.tagw.writeUI16(idref);
        }
        if (tag.hasMatrix()) {
            this.encodeMatrix(tag.matrix, this.tagw);
        }
        if (tag.hasCxform()) {
            this.encodeCxforma((CXFormWithAlpha)tag.colorTransform, this.tagw);
        }
        if (tag.hasRatio()) {
            this.tagw.writeUI16(tag.ratio);
        }
        if (tag.hasName()) {
            this.tagw.writeString(tag.name);
        }
        if (tag.hasClipDepth()) {
            this.tagw.writeUI16(tag.clipDepth);
        }
        if (tag.hasClipAction()) {
            int adjust = 0;
            if (this.isDebug()) {
                adjust = this.writer.getPos() + 6;
                this.debug.adjust += adjust;
            }
            new ActionEncoder(this.tagw, this.debug).encodeClipActions(tag.clipActions);
            if (this.isDebug()) {
                this.debug.adjust -= adjust;
            }
        }
        this.encodeTag(tag);
    }

    public void protect(GenericTag tag) {
        if (tag.data != null) {
            this.encodeTagHeader(tag.code, tag.data.length, false);
            this.writer.write(tag.data);
        } else {
            this.encodeTagHeader(tag.code, 0, false);
        }
    }

    public void removeObject(RemoveObject tag) {
        this.encodeTagHeader(tag.code, 4, false);
        int idref = this.dict.getId(tag.ref);
        this.writer.writeUI16(idref);
        this.writer.writeUI16(tag.depth);
    }

    public void removeObject2(RemoveObject tag) {
        this.encodeTagHeader(tag.code, 2, false);
        this.writer.writeUI16(tag.depth);
    }

    public void setBackgroundColor(SetBackgroundColor tag) {
        this.encodeTagHeader(tag.code, 3, false);
        this.encodeRGB(tag.color, this.writer);
    }

    public void showFrame(ShowFrame tag) {
        this.encodeTagHeader(tag.code, 0, false);
        ++this.frames;
    }

    public void soundStreamBlock(GenericTag tag) {
        this.encodeTagHeader(tag.code, tag.data.length, false);
        this.writer.write(tag.data);
    }

    public void soundStreamHead(SoundStreamHead tag) {
        this.encodeTagHeader(tag.code, 4, false);
        this.writer.writeUBits(0, 4);
        this.writer.writeUBits(tag.playbackRate, 2);
        this.writer.writeUBits(tag.playbackSize, 1);
        this.writer.writeUBits(tag.playbackType, 1);
        this.writer.writeUBits(tag.compression, 4);
        this.writer.writeUBits(tag.streamRate, 2);
        this.writer.writeUBits(tag.streamSize, 1);
        this.writer.writeUBits(tag.streamType, 1);
        this.writer.writeUI16(tag.streamSampleCount);
        if (tag.compression == 2) {
            this.writer.writeSI16(tag.latencySeek);
        }
    }

    public void soundStreamHead2(SoundStreamHead tag) {
        this.soundStreamHead(tag);
    }

    public void startSound(StartSound tag) {
        int idref = this.dict.getId(tag.sound);
        this.tagw.writeUI16(idref);
        this.encodeSoundInfo(tag.soundInfo, this.tagw);
        this.encodeTag(tag);
    }

    public void videoFrame(VideoFrame tag) {
        this.encodeTagHeader(tag.code, 4 + tag.videoData.length, false);
        int idref = this.dict.getId(tag.stream);
        this.writer.writeUI16(idref);
        this.writer.writeUI16(tag.frameNum);
        this.writer.write(tag.videoData);
    }

    public void unknown(GenericTag tag) {
        this.encodeTagHeader(tag.code, tag.data.length, false);
        this.writer.write(tag.data);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(out);
        return out.toByteArray();
    }

    public void scriptLimits(ScriptLimits tag) {
        this.tagw.writeUI16(tag.scriptRecursionLimit);
        this.tagw.writeUI16(tag.scriptTimeLimit);
        this.encodeTag(tag);
    }

    public void setTabIndex(SetTabIndex tag) {
        this.tagw.writeUI16(tag.depth);
        this.tagw.writeUI16(tag.index);
        this.encodeTag(tag);
    }
}

