/*
 * Decompiled with CFR 0.152.
 */
package macromedia.fonts;

import java.util.Properties;
import macromedia.fonts.FontManager;
import macromedia.fonts.FontSet;
import macromedia.util.LRUCache;

public abstract class CachedFontManager
extends FontManager {
    public static final short PURGE_SIZE = 2;
    public static final float DEFAULT_FONT_SIZE = 240.0f;
    public static final String MAX_CACHED_FONTS_KEY = "max-cached-fonts";
    public static final String MAX_GLYPHS_PER_FACE_KEY = "max-glyphs-per-face";
    public short maxEntries = (short)20;
    public short maxGlyphsPerFace = (short)1000;
    public short maxFacesPerFont = (short)4;
    private FontCache fontCache;
    private FontFileCache fontFileCache;

    protected CachedFontManager() {
    }

    public void initialize(Properties properties) {
        if (properties != null) {
            String prop = properties.getProperty(MAX_CACHED_FONTS_KEY);
            if (prop != null) {
                try {
                    this.maxEntries = Short.parseShort(prop);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if ((prop = properties.getProperty(MAX_GLYPHS_PER_FACE_KEY)) != null) {
                try {
                    this.maxGlyphsPerFace = Short.parseShort(prop);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.fontCache = new FontCache(this);
        this.fontFileCache = new FontFileCache(this);
    }

    protected FontCache getFontCache() {
        if (this.fontCache == null) {
            this.initialize(null);
        }
        return this.fontCache;
    }

    protected FontFileCache getFontFileCache() {
        if (this.fontFileCache == null) {
            this.initialize(null);
        }
        return this.fontFileCache;
    }

    protected abstract FontSet createSetForSystemFont(String var1);

    protected abstract String createFontFromLocation(Object var1);

    static class FontFileCache
    extends LRUCache {
        private CachedFontManager manager;

        FontFileCache(CachedFontManager manager) {
            super((int)manager.maxEntries, 2);
            this.manager = manager;
        }

        protected Object fetch(Object key) {
            String family = null;
            family = this.manager.createFontFromLocation(key);
            return family;
        }
    }

    static class FontCache
    extends LRUCache {
        private CachedFontManager manager;

        FontCache(CachedFontManager manager) {
            super(manager.maxEntries / 2, (int)manager.maxEntries, 2);
            this.manager = manager;
        }

        protected Object fetch(Object key) {
            FontSet fontSet = null;
            if (key != null) {
                String family = key.toString();
                fontSet = this.manager.createSetForSystemFont(family);
            }
            return fontSet;
        }
    }
}

