/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient.metadata;

import coldfusion.filter.FusionContext;
import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.graphql.graphqlClient.CFGraphQLClientImpl;
import coldfusion.graphql.graphqlClient.CFGraphQLUtils;
import coldfusion.graphql.graphqlClient.GraphQLCall;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Closure;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.runtime.async.Executor;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;

public class CFGraphQLCallHandler {
    private Closure onResponse;
    private Closure onFailure;
    private ApolloCall.Callback callback;
    private NeoPageContext pageContext;
    private FusionContext fusionContext;
    private GraphQLCall graphQLCall;
    private RequestMonitorData rmd;
    private long requestTime;

    public CFGraphQLCallHandler(final Closure onResponse, Closure onFailure, final FusionContext fusionContext, final GraphQLCall graphQLCall, final NeoPageContext pageContext, final RequestMonitorData rmd) {
        this.onFailure = onFailure;
        this.onResponse = onResponse;
        this.graphQLCall = graphQLCall;
        this.rmd = rmd;
        final Calendar calendar = DateUtils.getDefaultCalendar();
        this.requestTime = calendar.getTimeInMillis();
        try {
            this.pageContext = (NeoPageContext)pageContext.clone();
            this.fusionContext = (FusionContext)fusionContext.clone();
            this.fusionContext.hiddenScope = (Scope)fusionContext.hiddenScope.clone();
            this.pageContext.setFusionContext(this.fusionContext);
        }
        catch (Exception e) {
            this.pageContext = pageContext;
            this.fusionContext = fusionContext;
        }
        this.callback = new ApolloCall.Callback(){

            public void onResponse(@NotNull Response response) {
                try {
                    Object[] args = new Object[2];
                    long responseTime = calendar.getTimeInMillis();
                    args[0] = CFGraphQLUtils.populateResponseStruct(response, CFGraphQLCallHandler.this.requestTime, responseTime);
                    args[1] = graphQLCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onResponse, args, fusionContext, pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"GRAPHQL_CALL_ERROR", (Object)"[onResponse]"), ex);
                }
            }

            public void onFailure(@NotNull ApolloException apolloException) {
                try {
                    Object[] args = new Object[2];
                    long responseTime = calendar.getTimeInMillis();
                    args[0] = CFGraphQLUtils.populateExceptionDetails(apolloException, CFGraphQLCallHandler.this.requestTime, responseTime);
                    args[1] = graphQLCall;
                    CallableUDFMethod callableUDFMethod = new CallableUDFMethod((UDFMethod)onResponse, args, fusionContext, pageContext, rmd);
                    Executor.getInstance().submit(callableUDFMethod);
                }
                catch (Throwable ex) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"GRAPHQL_CALL_ERROR", (Object)"[onFailure]"), ex);
                }
            }
        };
    }

    public GraphQLCall getGraphQLCall() {
        return this.graphQLCall;
    }

    public ApolloCall.Callback getCallback() {
        return this.callback;
    }
}

