/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient;

import coldfusion.graphql.client.CustomScalar;
import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CFBigInteger;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.util.OrderedHashMap;
import coldfusion.util.RB;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationDataJsonSerializer;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.batch.BatchConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CFGraphQLUtils {
    public static final String INPUT_TYPE = "com.apollographql.apollo.api.Input<";
    public static final String CUSTOM_SCALAR_TYPE = "coldfusion.graphql.client.CustomScalar>";

    public static TimeUnit getSubscriptionHeartBeatTimeUnit(String heartBeat) {
        switch (heartBeat) {
            case "nano": {
                return TimeUnit.NANOSECONDS;
            }
            case "milli": {
                return TimeUnit.MILLISECONDS;
            }
            case "micro": {
                return TimeUnit.MICROSECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new CFGraphQLClientException(RB.getString(CFGraphQLUtils.class, (String)("Invalid Subscription HeartBeat TimeUnit Parameter <" + heartBeat + "> specified in Server Config")));
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static BatchConfig prepareBatchConfigFromClientConfig(Struct clientConfig) {
        if (!(clientConfig.containsKey((Object)"enabled") || clientConfig.containsKey((Object)"batch_interval_ms") || clientConfig.containsKey((Object)"max_batch_size"))) {
            throw new CFGraphQLClientException(RB.getString(CFGraphQLUtils.class, (String)"Incorrect Configuration for Batching Config. Batching Configuration should provide <enable, batch_interval_ms,max_batch_size> as parameters"));
        }
        boolean batchingEnabled = Cast._boolean((Object)clientConfig.get((Object)"enabled"));
        long batchInterval = Cast._long((Object)clientConfig.get((Object)"batch_interval_ms"));
        int batchSize = Cast._int((Object)clientConfig.get((Object)"max_batch_size"));
        return new BatchConfig(batchingEnabled, batchInterval, batchSize);
    }

    public static ArrayList<ScalarType> getScalarTypes(final Struct scalarType) {
        ArrayList<ScalarType> scalarTypes = new ArrayList<ScalarType>();
        for (final Object iter : scalarType.entrySet()) {
            scalarTypes.add(new ScalarType(){
                final String typeName;
                {
                    this.typeName = iter.toString();
                }

                @NotNull
                public String typeName() {
                    return this.typeName;
                }

                @NotNull
                public String className() {
                    return scalarType.get((Object)this.typeName).toString();
                }
            });
        }
        return scalarTypes;
    }

    public static Object invokeParameterizedConstructor(Map paramValues, Constructor constructorIter) throws InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, SecurityException, ClassNotFoundException {
        Parameter[] constructorParams = constructorIter.getParameters();
        Object[] constructorParamsResult = new Object[constructorParams.length];
        paramValues = CFGraphQLUtils.serializeStruct(paramValues);
        Object[] values = paramValues.values().toArray();
        Object[] key = paramValues.keySet().toArray();
        if (values.length != constructorParams.length) {
            throw new CFGraphQLClientException(RB.getString(CFGraphQLUtils.class, (String)"PARAMETER_COUNT_MISMATCH"));
        }
        for (int i = 0; i < constructorParams.length; ++i) {
            if (constructorParams[i].getType().equals(Input.class)) {
                ParameterizedType pt = (ParameterizedType)constructorParams[i].getParameterizedType();
                Type parameterizedType = pt.getActualTypeArguments()[0];
                if (parameterizedType.equals(CustomScalar.class)) {
                    Object value = null;
                    if (i < values.length) {
                        value = values[i];
                    }
                    constructorParamsResult[i] = Class.forName(Input.class.getName()).getDeclaredConstructors()[0].newInstance(value, true);
                    continue;
                }
                if (!parameterizedType.equals(values[i].getClass()) && !(values[i] instanceof List)) {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLUtils.class, (String)"DATA_TYPE_MISMATCH_EXCEPTION", (Object)key[i].toString()));
                }
                constructorParamsResult[i] = Class.forName(Input.class.getName()).getDeclaredConstructors()[0].newInstance(values[i], true);
                continue;
            }
            constructorParamsResult[i] = values[i];
        }
        return constructorIter.newInstance(constructorParamsResult);
    }

    public static Map<String, Object> serializeStruct(Map<String, Object> fields) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        fields.forEach((key, value) -> resultMap.put((String)key, CFGraphQLUtils.serializeCFTypes(value)));
        return resultMap;
    }

    public static List<Object> serializeList(List<Object> objectList) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        objectList.forEach(value -> itemList.add(CFGraphQLUtils.serializeCFTypes(value)));
        return itemList;
    }

    public static Object serializeCFTypes(Object value) {
        if (value instanceof CFBigDecimal) {
            return Cast._cast((Object)value, BigDecimal.class);
        }
        if (value instanceof CFBigInteger) {
            return Cast._cast((Object)value, BigInteger.class);
        }
        if (value instanceof CFInteger) {
            return Cast._cast((Object)value, Integer.class);
        }
        if (value instanceof CFLong) {
            return Cast._cast((Object)value, Long.class);
        }
        if (value instanceof CFDouble) {
            return Cast._cast((Object)value, Double.class);
        }
        if (value instanceof CFBoolean) {
            return Cast._cast((Object)value, Boolean.class);
        }
        if (value instanceof List) {
            return CFGraphQLUtils.serializeList((List)value);
        }
        if (value instanceof Struct) {
            return CFGraphQLUtils.serializeStruct((Map<String, Object>)((Struct)value));
        }
        return value;
    }

    public static void checkNotNull(String key, Object value) {
        if (value == null) {
            throw new CFGraphQLClientException(RB.getString(CFGraphQLUtils.class, (String)"NON_NULL_VALUE_REQUIRED_EXCEPTION", (Object)key));
        }
    }

    public static Map populateResponseStruct(Response response, long requestTime, long responseTime) {
        HashMap<String, Object> cfGraphQLResponse = new HashMap<String, Object>();
        if (response.getData() != null) {
            Operation.Data responseData = (Operation.Data)response.getData();
            cfGraphQLResponse.put("Data", OperationDataJsonSerializer.serialize((Operation.Data)responseData, (String)"  "));
            cfGraphQLResponse.put("ResponseSize (Bytes)", response.toString().getBytes().length);
        }
        cfGraphQLResponse.put("hasErrors", response.hasErrors());
        if (response.hasErrors()) {
            Error error = (Error)response.getErrors().get(0);
            cfGraphQLResponse.put("Error", error.getMessage());
        }
        cfGraphQLResponse.put("isCachedResponse", response.isFromCache());
        cfGraphQLResponse.put("variables", response.getOperation().variables().valueMap());
        cfGraphQLResponse.put("QueryDocument", response.getOperation().queryDocument());
        cfGraphQLResponse.put("Operation", response.getOperation().name().name());
        cfGraphQLResponse.put("OperationId", response.getOperation().operationId());
        cfGraphQLResponse.put("SentRequestAtMillis", requestTime);
        cfGraphQLResponse.put("ReceivedResponseAtMillis", responseTime);
        return cfGraphQLResponse;
    }

    public static Map populateExceptionDetails(ApolloException apolloException, long requestTime, long responseTime) {
        HashMap<String, Object> cfGraphQLResponse = new HashMap<String, Object>();
        cfGraphQLResponse.put("Error", apolloException.getMessage());
        cfGraphQLResponse.put("hasErrors", true);
        cfGraphQLResponse.put("ReceivedResponseAtMillis", responseTime);
        cfGraphQLResponse.put("SentRequestAtMillis", requestTime);
        cfGraphQLResponse.put("StackTrace", apolloException.getStackTrace());
        return cfGraphQLResponse;
    }

    public static Map validateParameters(Object params) {
        if (params instanceof Map) {
            return (Map)params;
        }
        if (params instanceof List && ((List)params).size() == 0) {
            return new OrderedHashMap();
        }
        throw new CFGraphQLClientException(RB.getString(CFGraphQLUtils.class, (String)"Invalid Parameter Type Exception"));
    }
}

